# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZoneStageDnssecKeyVersionArgs', 'ZoneStageDnssecKeyVersion']

@pulumi.input_type
class ZoneStageDnssecKeyVersionArgs:
    def __init__(__self__, *,
                 predecessor_dnssec_key_version_uuid: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZoneStageDnssecKeyVersion resource.
        :param pulumi.Input[builtins.str] predecessor_dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        """
        pulumi.set(__self__, "predecessor_dnssec_key_version_uuid", predecessor_dnssec_key_version_uuid)
        pulumi.set(__self__, "zone_id", zone_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="predecessorDnssecKeyVersionUuid")
    def predecessor_dnssec_key_version_uuid(self) -> pulumi.Input[builtins.str]:
        """
        The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        """
        return pulumi.get(self, "predecessor_dnssec_key_version_uuid")

    @predecessor_dnssec_key_version_uuid.setter
    def predecessor_dnssec_key_version_uuid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "predecessor_dnssec_key_version_uuid", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _ZoneStageDnssecKeyVersionState:
    def __init__(__self__, *,
                 predecessor_dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneStageDnssecKeyVersion resources.
        :param pulumi.Input[builtins.str] predecessor_dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if predecessor_dnssec_key_version_uuid is not None:
            pulumi.set(__self__, "predecessor_dnssec_key_version_uuid", predecessor_dnssec_key_version_uuid)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="predecessorDnssecKeyVersionUuid")
    def predecessor_dnssec_key_version_uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        """
        return pulumi.get(self, "predecessor_dnssec_key_version_uuid")

    @predecessor_dnssec_key_version_uuid.setter
    def predecessor_dnssec_key_version_uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "predecessor_dnssec_key_version_uuid", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("oci:Dns/zoneStageDnssecKeyVersion:ZoneStageDnssecKeyVersion")
class ZoneStageDnssecKeyVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 predecessor_dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Zone Stage Dnssec Key Version resource in Oracle Cloud Infrastructure DNS service.

        Stages a new `DnssecKeyVersion` on the zone. Staging is a process that generates a new "successor" key version
        that replaces an existing "predecessor" key version.
        **Note:** A new key-signing key (KSK) version is inert until you update the parent zone DS records.

        For more information, see the [DNSSEC](https://docs.cloud.oracle.com/iaas/Content/DNS/Concepts/dnssec.htm) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_zone_stage_dnssec_key_version = oci.dns.ZoneStageDnssecKeyVersion("test_zone_stage_dnssec_key_version",
            predecessor_dnssec_key_version_uuid=zone_stage_dnssec_key_version_predecessor_dnssec_key_version_uuid,
            zone_id=test_zone["id"],
            scope=zone_stage_dnssec_key_version_scope)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] predecessor_dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneStageDnssecKeyVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Zone Stage Dnssec Key Version resource in Oracle Cloud Infrastructure DNS service.

        Stages a new `DnssecKeyVersion` on the zone. Staging is a process that generates a new "successor" key version
        that replaces an existing "predecessor" key version.
        **Note:** A new key-signing key (KSK) version is inert until you update the parent zone DS records.

        For more information, see the [DNSSEC](https://docs.cloud.oracle.com/iaas/Content/DNS/Concepts/dnssec.htm) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_zone_stage_dnssec_key_version = oci.dns.ZoneStageDnssecKeyVersion("test_zone_stage_dnssec_key_version",
            predecessor_dnssec_key_version_uuid=zone_stage_dnssec_key_version_predecessor_dnssec_key_version_uuid,
            zone_id=test_zone["id"],
            scope=zone_stage_dnssec_key_version_scope)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ZoneStageDnssecKeyVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneStageDnssecKeyVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 predecessor_dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneStageDnssecKeyVersionArgs.__new__(ZoneStageDnssecKeyVersionArgs)

            if predecessor_dnssec_key_version_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'predecessor_dnssec_key_version_uuid'")
            __props__.__dict__["predecessor_dnssec_key_version_uuid"] = predecessor_dnssec_key_version_uuid
            __props__.__dict__["scope"] = scope
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ZoneStageDnssecKeyVersion, __self__).__init__(
            'oci:Dns/zoneStageDnssecKeyVersion:ZoneStageDnssecKeyVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            predecessor_dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZoneStageDnssecKeyVersion':
        """
        Get an existing ZoneStageDnssecKeyVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] predecessor_dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneStageDnssecKeyVersionState.__new__(_ZoneStageDnssecKeyVersionState)

        __props__.__dict__["predecessor_dnssec_key_version_uuid"] = predecessor_dnssec_key_version_uuid
        __props__.__dict__["scope"] = scope
        __props__.__dict__["zone_id"] = zone_id
        return ZoneStageDnssecKeyVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="predecessorDnssecKeyVersionUuid")
    def predecessor_dnssec_key_version_uuid(self) -> pulumi.Output[builtins.str]:
        """
        The UUID of the `DnssecKeyVersion` for which a new successor should be generated.
        """
        return pulumi.get(self, "predecessor_dnssec_key_version_uuid")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_id")

