# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEmailReturnPathResult',
    'AwaitableGetEmailReturnPathResult',
    'get_email_return_path',
    'get_email_return_path_output',
]

@pulumi.output_type
class GetEmailReturnPathResult:
    """
    A collection of values returned by getEmailReturnPath.
    """
    def __init__(__self__, cname_record_value=None, compartment_id=None, defined_tags=None, description=None, dns_subdomain_name=None, email_return_path_id=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, parent_resource_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if cname_record_value and not isinstance(cname_record_value, str):
            raise TypeError("Expected argument 'cname_record_value' to be a str")
        pulumi.set(__self__, "cname_record_value", cname_record_value)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_subdomain_name and not isinstance(dns_subdomain_name, str):
            raise TypeError("Expected argument 'dns_subdomain_name' to be a str")
        pulumi.set(__self__, "dns_subdomain_name", dns_subdomain_name)
        if email_return_path_id and not isinstance(email_return_path_id, str):
            raise TypeError("Expected argument 'email_return_path_id' to be a str")
        pulumi.set(__self__, "email_return_path_id", email_return_path_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="cnameRecordValue")
    def cname_record_value(self) -> builtins.str:
        """
        The DNS CNAME record value to provision to the Return Patn DNS subdomain, when using the CNAME method for Email Return Path setup (preferred).
        """
        return pulumi.get(self, "cname_record_value")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains this email return path.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the email return path. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsSubdomainName")
    def dns_subdomain_name(self) -> builtins.str:
        """
        The name of the DNS subdomain that must be provisioned to enable email recipients to verify Email Return Path. It is usually created with a CNAME record set to the cnameRecordValue.
        """
        return pulumi.get(self, "dns_subdomain_name")

    @property
    @pulumi.getter(name="emailReturnPathId")
    def email_return_path_id(self) -> builtins.str:
        return pulumi.get(self, "email_return_path_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the email return path.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The email return path domain in the Internet Domain Name System (DNS).  Example: `iad1.rp.example.com`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the EmailDomain that this email return path belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the email return path.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the email return path was created. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time of the last change to the Email Return Path configuration, due to a state change or an update operation. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetEmailReturnPathResult(GetEmailReturnPathResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailReturnPathResult(
            cname_record_value=self.cname_record_value,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            dns_subdomain_name=self.dns_subdomain_name,
            email_return_path_id=self.email_return_path_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            parent_resource_id=self.parent_resource_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_email_return_path(email_return_path_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailReturnPathResult:
    """
    This data source provides details about a specific Email Return Path resource in Oracle Cloud Infrastructure Email service.

    Retrieves the specified email return path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_email_return_path = oci.Email.get_email_return_path(email_return_path_id=test_email_return_path_oci_email_email_return_path["id"])
    ```


    :param builtins.str email_return_path_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this email return path.
    """
    __args__ = dict()
    __args__['emailReturnPathId'] = email_return_path_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Email/getEmailReturnPath:getEmailReturnPath', __args__, opts=opts, typ=GetEmailReturnPathResult).value

    return AwaitableGetEmailReturnPathResult(
        cname_record_value=pulumi.get(__ret__, 'cname_record_value'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        dns_subdomain_name=pulumi.get(__ret__, 'dns_subdomain_name'),
        email_return_path_id=pulumi.get(__ret__, 'email_return_path_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_email_return_path_output(email_return_path_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailReturnPathResult]:
    """
    This data source provides details about a specific Email Return Path resource in Oracle Cloud Infrastructure Email service.

    Retrieves the specified email return path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_email_return_path = oci.Email.get_email_return_path(email_return_path_id=test_email_return_path_oci_email_email_return_path["id"])
    ```


    :param builtins.str email_return_path_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this email return path.
    """
    __args__ = dict()
    __args__['emailReturnPathId'] = email_return_path_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Email/getEmailReturnPath:getEmailReturnPath', __args__, opts=opts, typ=GetEmailReturnPathResult)
    return __ret__.apply(lambda __response__: GetEmailReturnPathResult(
        cname_record_value=pulumi.get(__response__, 'cname_record_value'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        dns_subdomain_name=pulumi.get(__response__, 'dns_subdomain_name'),
        email_return_path_id=pulumi.get(__response__, 'email_return_path_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        parent_resource_id=pulumi.get(__response__, 'parent_resource_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
