# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPropertiesResult',
    'AwaitableGetPropertiesResult',
    'get_properties',
    'get_properties_output',
]

@pulumi.output_type
class GetPropertiesResult:
    """
    A collection of values returned by getProperties.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, property_collections=None, scope=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if property_collections and not isinstance(property_collections, list):
            raise TypeError("Expected argument 'property_collections' to be a list")
        pulumi.set(__self__, "property_collections", property_collections)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPropertiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="propertyCollections")
    def property_collections(self) -> Sequence['outputs.GetPropertiesPropertyCollectionResult']:
        """
        The list of property_collection.
        """
        return pulumi.get(self, "property_collections")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        The scope of the property.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Property.
        """
        return pulumi.get(self, "state")


class AwaitableGetPropertiesResult(GetPropertiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPropertiesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            property_collections=self.property_collections,
            scope=self.scope,
            state=self.state)


def get_properties(compartment_id: Optional[builtins.str] = None,
                   display_name: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetPropertiesFilterArgs', 'GetPropertiesFilterArgsDict']]] = None,
                   id: Optional[builtins.str] = None,
                   scope: Optional[builtins.str] = None,
                   state: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPropertiesResult:
    """
    This data source provides the list of Properties in Oracle Cloud Infrastructure Fleet Apps Management service.

    List properties and their values for a tenancy in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_properties = oci.FleetAppsManagement.get_properties(compartment_id=compartment_id,
        display_name=property_display_name,
        id=property_id,
        scope=property_scope,
        state=property_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: A filter to return only resources whose Property identifier matches the given identifier.
    :param builtins.str scope: A filter to return only resources their scope matches the given scope.
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['scope'] = scope
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getProperties:getProperties', __args__, opts=opts, typ=GetPropertiesResult).value

    return AwaitableGetPropertiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        property_collections=pulumi.get(__ret__, 'property_collections'),
        scope=pulumi.get(__ret__, 'scope'),
        state=pulumi.get(__ret__, 'state'))
def get_properties_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPropertiesFilterArgs', 'GetPropertiesFilterArgsDict']]]]] = None,
                          id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          scope: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPropertiesResult]:
    """
    This data source provides the list of Properties in Oracle Cloud Infrastructure Fleet Apps Management service.

    List properties and their values for a tenancy in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_properties = oci.FleetAppsManagement.get_properties(compartment_id=compartment_id,
        display_name=property_display_name,
        id=property_id,
        scope=property_scope,
        state=property_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: A filter to return only resources whose Property identifier matches the given identifier.
    :param builtins.str scope: A filter to return only resources their scope matches the given scope.
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['scope'] = scope
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getProperties:getProperties', __args__, opts=opts, typ=GetPropertiesResult)
    return __ret__.apply(lambda __response__: GetPropertiesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        property_collections=pulumi.get(__response__, 'property_collections'),
        scope=pulumi.get(__response__, 'scope'),
        state=pulumi.get(__response__, 'state')))
