# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPropertyResult',
    'AwaitableGetPropertyResult',
    'get_property',
    'get_property_output',
]

@pulumi.output_type
class GetPropertyResult:
    """
    A collection of values returned by getProperty.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, property_id=None, resource_region=None, scope=None, selection=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None, value_type=None, values=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if property_id and not isinstance(property_id, str):
            raise TypeError("Expected argument 'property_id' to be a str")
        pulumi.set(__self__, "property_id", property_id)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if selection and not isinstance(selection, str):
            raise TypeError("Expected argument 'selection' to be a str")
        pulumi.set(__self__, "selection", selection)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if value_type and not isinstance(value_type, str):
            raise TypeError("Expected argument 'value_type' to be a str")
        pulumi.set(__self__, "value_type", value_type)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> builtins.str:
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> builtins.str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def scope(self) -> builtins.str:
        """
        The scope of the property.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def selection(self) -> builtins.str:
        """
        Text selection of the property.
        """
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Property.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the property.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> builtins.str:
        """
        Format of the value.
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Values of the property (must be a single value if selection = 'SINGLE_CHOICE').
        """
        return pulumi.get(self, "values")


class AwaitableGetPropertyResult(GetPropertyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPropertyResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            property_id=self.property_id,
            resource_region=self.resource_region,
            scope=self.scope,
            selection=self.selection,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            value_type=self.value_type,
            values=self.values)


def get_property(property_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPropertyResult:
    """
    This data source provides details about a specific Property resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Property by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_property = oci.FleetAppsManagement.get_property(property_id=test_property_oci_fleet_apps_management_property["id"])
    ```


    :param builtins.str property_id: unique Property identifier
    """
    __args__ = dict()
    __args__['propertyId'] = property_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getProperty:getProperty', __args__, opts=opts, typ=GetPropertyResult).value

    return AwaitableGetPropertyResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        property_id=pulumi.get(__ret__, 'property_id'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        scope=pulumi.get(__ret__, 'scope'),
        selection=pulumi.get(__ret__, 'selection'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        value_type=pulumi.get(__ret__, 'value_type'),
        values=pulumi.get(__ret__, 'values'))
def get_property_output(property_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPropertyResult]:
    """
    This data source provides details about a specific Property resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Property by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_property = oci.FleetAppsManagement.get_property(property_id=test_property_oci_fleet_apps_management_property["id"])
    ```


    :param builtins.str property_id: unique Property identifier
    """
    __args__ = dict()
    __args__['propertyId'] = property_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getProperty:getProperty', __args__, opts=opts, typ=GetPropertyResult)
    return __ret__.apply(lambda __response__: GetPropertyResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        property_id=pulumi.get(__response__, 'property_id'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        scope=pulumi.get(__response__, 'scope'),
        selection=pulumi.get(__response__, 'selection'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type'),
        value_type=pulumi.get(__response__, 'value_type'),
        values=pulumi.get(__response__, 'values')))
