# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeploymentCertificatesResult',
    'AwaitableGetDeploymentCertificatesResult',
    'get_deployment_certificates',
    'get_deployment_certificates_output',
]

@pulumi.output_type
class GetDeploymentCertificatesResult:
    """
    A collection of values returned by getDeploymentCertificates.
    """
    def __init__(__self__, certificate_collections=None, deployment_id=None, filters=None, id=None, state=None):
        if certificate_collections and not isinstance(certificate_collections, list):
            raise TypeError("Expected argument 'certificate_collections' to be a list")
        pulumi.set(__self__, "certificate_collections", certificate_collections)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="certificateCollections")
    def certificate_collections(self) -> Sequence['outputs.GetDeploymentCertificatesCertificateCollectionResult']:
        """
        The list of certificate_collection.
        """
        return pulumi.get(self, "certificate_collections")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDeploymentCertificatesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Possible certificate lifecycle states.
        """
        return pulumi.get(self, "state")


class AwaitableGetDeploymentCertificatesResult(GetDeploymentCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentCertificatesResult(
            certificate_collections=self.certificate_collections,
            deployment_id=self.deployment_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_deployment_certificates(deployment_id: Optional[builtins.str] = None,
                                filters: Optional[Sequence[Union['GetDeploymentCertificatesFilterArgs', 'GetDeploymentCertificatesFilterArgsDict']]] = None,
                                state: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentCertificatesResult:
    """
    This data source provides the list of Deployment Certificates in Oracle Cloud Infrastructure Golden Gate service.

    Returns a list of certificates from truststore.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_certificates = oci.GoldenGate.get_deployment_certificates(deployment_id=test_deployment["id"],
        state=deployment_certificate_state)
    ```


    :param builtins.str deployment_id: A unique Deployment identifier.
    :param builtins.str state: A filter to return only connections having the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeploymentCertificates:getDeploymentCertificates', __args__, opts=opts, typ=GetDeploymentCertificatesResult).value

    return AwaitableGetDeploymentCertificatesResult(
        certificate_collections=pulumi.get(__ret__, 'certificate_collections'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_deployment_certificates_output(deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDeploymentCertificatesFilterArgs', 'GetDeploymentCertificatesFilterArgsDict']]]]] = None,
                                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentCertificatesResult]:
    """
    This data source provides the list of Deployment Certificates in Oracle Cloud Infrastructure Golden Gate service.

    Returns a list of certificates from truststore.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_certificates = oci.GoldenGate.get_deployment_certificates(deployment_id=test_deployment["id"],
        state=deployment_certificate_state)
    ```


    :param builtins.str deployment_id: A unique Deployment identifier.
    :param builtins.str state: A filter to return only connections having the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getDeploymentCertificates:getDeploymentCertificates', __args__, opts=opts, typ=GetDeploymentCertificatesResult)
    return __ret__.apply(lambda __response__: GetDeploymentCertificatesResult(
        certificate_collections=pulumi.get(__response__, 'certificate_collections'),
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
