# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPipelineSchemasResult',
    'AwaitableGetPipelineSchemasResult',
    'get_pipeline_schemas',
    'get_pipeline_schemas_output',
]

@pulumi.output_type
class GetPipelineSchemasResult:
    """
    A collection of values returned by getPipelineSchemas.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, pipeline_id=None, pipeline_schema_collections=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pipeline_id and not isinstance(pipeline_id, str):
            raise TypeError("Expected argument 'pipeline_id' to be a str")
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_schema_collections and not isinstance(pipeline_schema_collections, list):
            raise TypeError("Expected argument 'pipeline_schema_collections' to be a list")
        pulumi.set(__self__, "pipeline_schema_collections", pipeline_schema_collections)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPipelineSchemasFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> builtins.str:
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="pipelineSchemaCollections")
    def pipeline_schema_collections(self) -> Sequence['outputs.GetPipelineSchemasPipelineSchemaCollectionResult']:
        """
        The list of pipeline_schema_collection.
        """
        return pulumi.get(self, "pipeline_schema_collections")


class AwaitableGetPipelineSchemasResult(GetPipelineSchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineSchemasResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            pipeline_id=self.pipeline_id,
            pipeline_schema_collections=self.pipeline_schema_collections)


def get_pipeline_schemas(display_name: Optional[builtins.str] = None,
                         filters: Optional[Sequence[Union['GetPipelineSchemasFilterArgs', 'GetPipelineSchemasFilterArgsDict']]] = None,
                         pipeline_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineSchemasResult:
    """
    This data source provides the list of Pipeline Schemas in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of schemas based on mapping rules for a pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_schemas = oci.GoldenGate.get_pipeline_schemas(pipeline_id=test_pipeline["id"],
        display_name=pipeline_schema_display_name)
    ```


    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param builtins.str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getPipelineSchemas:getPipelineSchemas', __args__, opts=opts, typ=GetPipelineSchemasResult).value

    return AwaitableGetPipelineSchemasResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        pipeline_id=pulumi.get(__ret__, 'pipeline_id'),
        pipeline_schema_collections=pulumi.get(__ret__, 'pipeline_schema_collections'))
def get_pipeline_schemas_output(display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPipelineSchemasFilterArgs', 'GetPipelineSchemasFilterArgsDict']]]]] = None,
                                pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineSchemasResult]:
    """
    This data source provides the list of Pipeline Schemas in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of schemas based on mapping rules for a pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_schemas = oci.GoldenGate.get_pipeline_schemas(pipeline_id=test_pipeline["id"],
        display_name=pipeline_schema_display_name)
    ```


    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param builtins.str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getPipelineSchemas:getPipelineSchemas', __args__, opts=opts, typ=GetPipelineSchemasResult)
    return __ret__.apply(lambda __response__: GetPipelineSchemasResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        pipeline_id=pulumi.get(__response__, 'pipeline_id'),
        pipeline_schema_collections=pulumi.get(__response__, 'pipeline_schema_collections')))
