# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHttpMonitorsFilterResult',
    'GetHttpMonitorsHttpMonitorResult',
    'GetHttpProbeResultsFilterResult',
    'GetHttpProbeResultsHttpProbeResultResult',
    'GetHttpProbeResultsHttpProbeResultConnectionResult',
    'GetHttpProbeResultsHttpProbeResultDnResult',
    'GetPingMonitorsFilterResult',
    'GetPingMonitorsPingMonitorResult',
    'GetPingProbeResultsFilterResult',
    'GetPingProbeResultsPingProbeResultResult',
    'GetPingProbeResultsPingProbeResultConnectionResult',
    'GetPingProbeResultsPingProbeResultDnResult',
    'GetVantagePointsFilterResult',
    'GetVantagePointsHealthChecksVantagePointResult',
    'GetVantagePointsHealthChecksVantagePointGeoResult',
    'GetVantagePointsHealthChecksVantagePointRoutingResult',
]

@pulumi.output_type
class GetHttpMonitorsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHttpMonitorsHttpMonitorResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 headers: Mapping[str, builtins.str],
                 home_region: builtins.str,
                 id: builtins.str,
                 interval_in_seconds: builtins.int,
                 is_enabled: builtins.bool,
                 method: builtins.str,
                 path: builtins.str,
                 port: builtins.int,
                 protocol: builtins.str,
                 results_url: builtins.str,
                 targets: Sequence[builtins.str],
                 time_created: builtins.str,
                 timeout_in_seconds: builtins.int,
                 vantage_point_names: Sequence[builtins.str]):
        """
        :param builtins.str compartment_id: Filters results by compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: Filters results that exactly match the `displayName` field.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param Mapping[str, builtins.str] headers: A dictionary of HTTP request headers.
        :param builtins.str home_region: Filters results that match the `homeRegion`.
        :param builtins.str id: The OCID of the resource.
        :param builtins.int interval_in_seconds: The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param builtins.bool is_enabled: Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param builtins.str method: The supported HTTP methods available for probes.
        :param builtins.str path: The optional URL path to probe, including query parameters.
        :param builtins.int port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param builtins.str protocol: The supported protocols available for HTTP probes.
        :param builtins.str results_url: A URL for fetching the probe results.
        :param Sequence[builtins.str] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param builtins.str time_created: The RFC 3339-formatted creation date and time of the probe.
        :param builtins.int timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param Sequence[builtins.str] vantage_point_names: A list of names of vantage points from which to execute the probe.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "home_region", home_region)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "results_url", results_url)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        pulumi.set(__self__, "vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Filters results by compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, builtins.str]:
        """
        A dictionary of HTTP request headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> builtins.str:
        """
        Filters results that match the `homeRegion`.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> builtins.int:
        """
        The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def method(self) -> builtins.str:
        """
        The supported HTTP methods available for probes.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The optional URL path to probe, including query parameters.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> builtins.str:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[builtins.str]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> builtins.int:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Sequence[builtins.str]:
        """
        A list of names of vantage points from which to execute the probe.
        """
        return pulumi.get(self, "vantage_point_names")


@pulumi.output_type
class GetHttpProbeResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultResult(dict):
    def __init__(__self__, *,
                 connect_end: builtins.float,
                 connect_start: builtins.float,
                 connections: Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult'],
                 dns: Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult'],
                 domain_lookup_end: builtins.float,
                 domain_lookup_start: builtins.float,
                 duration: builtins.float,
                 encoded_body_size: builtins.int,
                 error_category: builtins.str,
                 error_message: builtins.str,
                 fetch_start: builtins.float,
                 is_healthy: builtins.bool,
                 is_timed_out: builtins.bool,
                 key: builtins.str,
                 probe_configuration_id: builtins.str,
                 protocol: builtins.str,
                 request_start: builtins.float,
                 response_end: builtins.float,
                 response_start: builtins.float,
                 secure_connection_start: builtins.float,
                 start_time: builtins.float,
                 status_code: builtins.int,
                 target: builtins.str,
                 vantage_point_name: builtins.str):
        """
        :param builtins.float connect_end: The time immediately after the vantage point finishes establishing the connection to the server to retrieve the resource.
        :param builtins.float connect_start: The time immediately before the vantage point starts establishing the connection to the server to retrieve the resource.
        :param Sequence['GetHttpProbeResultsHttpProbeResultConnectionArgs'] connections: TCP connection results.  All durations are in milliseconds.
        :param Sequence['GetHttpProbeResultsHttpProbeResultDnArgs'] dns: The DNS resolution results.
        :param builtins.float domain_lookup_end: The time immediately before the vantage point finishes the domain name lookup for the resource.
        :param builtins.float domain_lookup_start: The time immediately before the vantage point starts the domain name lookup for the resource.
        :param builtins.float duration: The total duration from start of request until response is fully consumed or the connection is closed.
        :param builtins.int encoded_body_size: The size, in octets, of the payload body prior to removing any applied content-codings.
        :param builtins.str error_category: The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
               * NONE - No error
               * DNS - DNS errors
               * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
               * NETWORK - Network-related errors, for example a "network unreachable" error.
               * SYSTEM - Internal system errors.
        :param builtins.str error_message: The error information indicating why a probe execution failed.
        :param builtins.float fetch_start: The time immediately before the vantage point starts to fetch the resource.
        :param builtins.bool is_healthy: True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        :param builtins.bool is_timed_out: True if the probe did not complete before the configured `timeoutInSeconds` value.
        :param builtins.str key: A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        :param builtins.str probe_configuration_id: The OCID of a monitor or on-demand probe.
        :param builtins.str protocol: The supported protocols available for HTTP probes.
        :param builtins.float request_start: The time immediately before the vantage point starts requesting the resource from the server.
        :param builtins.float response_end: The time immediately after the vantage point receives the last byte of the response or immediately before the transport connection is closed, whichever comes first.
        :param builtins.float response_start: The time immediately after the vantage point's HTTP parser receives the first byte of the response.
        :param builtins.float secure_connection_start: The time immediately before the vantage point starts the handshake process to secure the current connection.
        :param builtins.float start_time: The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        :param builtins.int status_code: The HTTP response status code.
        :param builtins.str target: Filters results that match the `target`.
        :param builtins.str vantage_point_name: The name of the vantage point that executed the probe.
        """
        pulumi.set(__self__, "connect_end", connect_end)
        pulumi.set(__self__, "connect_start", connect_start)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "domain_lookup_end", domain_lookup_end)
        pulumi.set(__self__, "domain_lookup_start", domain_lookup_start)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "encoded_body_size", encoded_body_size)
        pulumi.set(__self__, "error_category", error_category)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "fetch_start", fetch_start)
        pulumi.set(__self__, "is_healthy", is_healthy)
        pulumi.set(__self__, "is_timed_out", is_timed_out)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "probe_configuration_id", probe_configuration_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "request_start", request_start)
        pulumi.set(__self__, "response_end", response_end)
        pulumi.set(__self__, "response_start", response_start)
        pulumi.set(__self__, "secure_connection_start", secure_connection_start)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "vantage_point_name", vantage_point_name)

    @property
    @pulumi.getter(name="connectEnd")
    def connect_end(self) -> builtins.float:
        """
        The time immediately after the vantage point finishes establishing the connection to the server to retrieve the resource.
        """
        return pulumi.get(self, "connect_end")

    @property
    @pulumi.getter(name="connectStart")
    def connect_start(self) -> builtins.float:
        """
        The time immediately before the vantage point starts establishing the connection to the server to retrieve the resource.
        """
        return pulumi.get(self, "connect_start")

    @property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult']:
        """
        TCP connection results.  All durations are in milliseconds.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult']:
        """
        The DNS resolution results.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="domainLookupEnd")
    def domain_lookup_end(self) -> builtins.float:
        """
        The time immediately before the vantage point finishes the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_end")

    @property
    @pulumi.getter(name="domainLookupStart")
    def domain_lookup_start(self) -> builtins.float:
        """
        The time immediately before the vantage point starts the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_start")

    @property
    @pulumi.getter
    def duration(self) -> builtins.float:
        """
        The total duration from start of request until response is fully consumed or the connection is closed.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="encodedBodySize")
    def encoded_body_size(self) -> builtins.int:
        """
        The size, in octets, of the payload body prior to removing any applied content-codings.
        """
        return pulumi.get(self, "encoded_body_size")

    @property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> builtins.str:
        """
        The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
        * NONE - No error
        * DNS - DNS errors
        * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
        * NETWORK - Network-related errors, for example a "network unreachable" error.
        * SYSTEM - Internal system errors.
        """
        return pulumi.get(self, "error_category")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> builtins.str:
        """
        The error information indicating why a probe execution failed.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="fetchStart")
    def fetch_start(self) -> builtins.float:
        """
        The time immediately before the vantage point starts to fetch the resource.
        """
        return pulumi.get(self, "fetch_start")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> builtins.bool:
        """
        True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isTimedOut")
    def is_timed_out(self) -> builtins.bool:
        """
        True if the probe did not complete before the configured `timeoutInSeconds` value.
        """
        return pulumi.get(self, "is_timed_out")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> builtins.str:
        """
        The OCID of a monitor or on-demand probe.
        """
        return pulumi.get(self, "probe_configuration_id")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="requestStart")
    def request_start(self) -> builtins.float:
        """
        The time immediately before the vantage point starts requesting the resource from the server.
        """
        return pulumi.get(self, "request_start")

    @property
    @pulumi.getter(name="responseEnd")
    def response_end(self) -> builtins.float:
        """
        The time immediately after the vantage point receives the last byte of the response or immediately before the transport connection is closed, whichever comes first.
        """
        return pulumi.get(self, "response_end")

    @property
    @pulumi.getter(name="responseStart")
    def response_start(self) -> builtins.float:
        """
        The time immediately after the vantage point's HTTP parser receives the first byte of the response.
        """
        return pulumi.get(self, "response_start")

    @property
    @pulumi.getter(name="secureConnectionStart")
    def secure_connection_start(self) -> builtins.float:
        """
        The time immediately before the vantage point starts the handshake process to secure the current connection.
        """
        return pulumi.get(self, "secure_connection_start")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.float:
        """
        The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> builtins.int:
        """
        The HTTP response status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        """
        Filters results that match the `target`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="vantagePointName")
    def vantage_point_name(self) -> builtins.str:
        """
        The name of the vantage point that executed the probe.
        """
        return pulumi.get(self, "vantage_point_name")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultConnectionResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 connect_duration: builtins.float,
                 port: builtins.int,
                 secure_connect_duration: builtins.float):
        """
        :param builtins.str address: The connection IP address.
        :param builtins.float connect_duration: Total connect duration, calculated using `connectEnd` minus `connectStart`.
        :param builtins.int port: The port.
        :param builtins.float secure_connect_duration: The duration to secure the connection.  This value will be zero for insecure connections.  Calculated using `connectEnd` minus `secureConnectionStart`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "connect_duration", connect_duration)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "secure_connect_duration", secure_connect_duration)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The connection IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="connectDuration")
    def connect_duration(self) -> builtins.float:
        """
        Total connect duration, calculated using `connectEnd` minus `connectStart`.
        """
        return pulumi.get(self, "connect_duration")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="secureConnectDuration")
    def secure_connect_duration(self) -> builtins.float:
        """
        The duration to secure the connection.  This value will be zero for insecure connections.  Calculated using `connectEnd` minus `secureConnectionStart`.
        """
        return pulumi.get(self, "secure_connect_duration")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultDnResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[builtins.str],
                 domain_lookup_duration: builtins.float):
        """
        :param Sequence[builtins.str] addresses: The addresses returned by DNS resolution.
        :param builtins.float domain_lookup_duration: Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "domain_lookup_duration", domain_lookup_duration)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[builtins.str]:
        """
        The addresses returned by DNS resolution.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="domainLookupDuration")
    def domain_lookup_duration(self) -> builtins.float:
        """
        Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        return pulumi.get(self, "domain_lookup_duration")


@pulumi.output_type
class GetPingMonitorsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPingMonitorsPingMonitorResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 home_region: builtins.str,
                 id: builtins.str,
                 interval_in_seconds: builtins.int,
                 is_enabled: builtins.bool,
                 port: builtins.int,
                 protocol: builtins.str,
                 results_url: builtins.str,
                 targets: Sequence[builtins.str],
                 time_created: builtins.str,
                 timeout_in_seconds: builtins.int,
                 vantage_point_names: Sequence[builtins.str]):
        """
        :param builtins.str compartment_id: Filters results by compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: Filters results that exactly match the `displayName` field.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str home_region: Filters results that match the `homeRegion`.
        :param builtins.str id: The OCID of the resource.
        :param builtins.int interval_in_seconds: The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param builtins.bool is_enabled: Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param builtins.int port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param builtins.str protocol: The protocols for ping probes.
        :param builtins.str results_url: A URL for fetching the probe results.
        :param Sequence[builtins.str] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param builtins.str time_created: The RFC 3339-formatted creation date and time of the probe.
        :param builtins.int timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param Sequence[builtins.str] vantage_point_names: A list of names of vantage points from which to execute the probe.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "home_region", home_region)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "results_url", results_url)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        pulumi.set(__self__, "vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Filters results by compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> builtins.str:
        """
        Filters results that match the `homeRegion`.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> builtins.int:
        """
        The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> builtins.str:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[builtins.str]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> builtins.int:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Sequence[builtins.str]:
        """
        A list of names of vantage points from which to execute the probe.
        """
        return pulumi.get(self, "vantage_point_names")


@pulumi.output_type
class GetPingProbeResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultResult(dict):
    def __init__(__self__, *,
                 connections: Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult'],
                 dns: Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult'],
                 domain_lookup_end: builtins.float,
                 domain_lookup_start: builtins.float,
                 error_category: builtins.str,
                 error_message: builtins.str,
                 icmp_code: builtins.int,
                 is_healthy: builtins.bool,
                 is_timed_out: builtins.bool,
                 key: builtins.str,
                 latency_in_ms: builtins.float,
                 probe_configuration_id: builtins.str,
                 protocol: builtins.str,
                 start_time: builtins.float,
                 target: builtins.str,
                 vantage_point_name: builtins.str):
        """
        :param Sequence['GetPingProbeResultsPingProbeResultConnectionArgs'] connections: The network connection results.
        :param Sequence['GetPingProbeResultsPingProbeResultDnArgs'] dns: The DNS resolution results.
        :param builtins.float domain_lookup_end: The time immediately before the vantage point finishes the domain name lookup for the resource.
        :param builtins.float domain_lookup_start: The time immediately before the vantage point starts the domain name lookup for the resource.
        :param builtins.str error_category: The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
               * NONE - No error
               * DNS - DNS errors
               * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
               * NETWORK - Network-related errors, for example a "network unreachable" error.
               * SYSTEM - Internal system errors.
        :param builtins.str error_message: The error information indicating why a probe execution failed.
        :param builtins.int icmp_code: The ICMP code of the response message.  This field is not used when the protocol is set to TCP.  For more information on ICMP codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
        :param builtins.bool is_healthy: True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        :param builtins.bool is_timed_out: True if the probe did not complete before the configured `timeoutInSeconds` value.
        :param builtins.str key: A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        :param builtins.float latency_in_ms: The latency of the probe execution, in milliseconds.
        :param builtins.str probe_configuration_id: The OCID of a monitor or on-demand probe.
        :param builtins.str protocol: The protocols for ping probes.
        :param builtins.float start_time: The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        :param builtins.str target: Filters results that match the `target`.
        :param builtins.str vantage_point_name: The name of the vantage point that executed the probe.
        """
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "domain_lookup_end", domain_lookup_end)
        pulumi.set(__self__, "domain_lookup_start", domain_lookup_start)
        pulumi.set(__self__, "error_category", error_category)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "icmp_code", icmp_code)
        pulumi.set(__self__, "is_healthy", is_healthy)
        pulumi.set(__self__, "is_timed_out", is_timed_out)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "latency_in_ms", latency_in_ms)
        pulumi.set(__self__, "probe_configuration_id", probe_configuration_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "vantage_point_name", vantage_point_name)

    @property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult']:
        """
        The network connection results.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult']:
        """
        The DNS resolution results.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="domainLookupEnd")
    def domain_lookup_end(self) -> builtins.float:
        """
        The time immediately before the vantage point finishes the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_end")

    @property
    @pulumi.getter(name="domainLookupStart")
    def domain_lookup_start(self) -> builtins.float:
        """
        The time immediately before the vantage point starts the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_start")

    @property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> builtins.str:
        """
        The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
        * NONE - No error
        * DNS - DNS errors
        * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
        * NETWORK - Network-related errors, for example a "network unreachable" error.
        * SYSTEM - Internal system errors.
        """
        return pulumi.get(self, "error_category")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> builtins.str:
        """
        The error information indicating why a probe execution failed.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> builtins.int:
        """
        The ICMP code of the response message.  This field is not used when the protocol is set to TCP.  For more information on ICMP codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> builtins.bool:
        """
        True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isTimedOut")
    def is_timed_out(self) -> builtins.bool:
        """
        True if the probe did not complete before the configured `timeoutInSeconds` value.
        """
        return pulumi.get(self, "is_timed_out")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="latencyInMs")
    def latency_in_ms(self) -> builtins.float:
        """
        The latency of the probe execution, in milliseconds.
        """
        return pulumi.get(self, "latency_in_ms")

    @property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> builtins.str:
        """
        The OCID of a monitor or on-demand probe.
        """
        return pulumi.get(self, "probe_configuration_id")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.float:
        """
        The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        """
        Filters results that match the `target`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="vantagePointName")
    def vantage_point_name(self) -> builtins.str:
        """
        The name of the vantage point that executed the probe.
        """
        return pulumi.get(self, "vantage_point_name")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultConnectionResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: The connection IP address.
        :param builtins.int port: The port.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The connection IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultDnResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[builtins.str],
                 domain_lookup_duration: builtins.float):
        """
        :param Sequence[builtins.str] addresses: The addresses returned by DNS resolution.
        :param builtins.float domain_lookup_duration: Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "domain_lookup_duration", domain_lookup_duration)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[builtins.str]:
        """
        The addresses returned by DNS resolution.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="domainLookupDuration")
    def domain_lookup_duration(self) -> builtins.float:
        """
        Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        return pulumi.get(self, "domain_lookup_duration")


@pulumi.output_type
class GetVantagePointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Filters results that exactly match the `name` field.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Filters results that exactly match the `name` field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 geos: Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult'],
                 name: builtins.str,
                 provider_name: builtins.str,
                 routings: Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult']):
        """
        :param builtins.str display_name: Filters results that exactly match the `displayName` field.
        :param Sequence['GetVantagePointsHealthChecksVantagePointGeoArgs'] geos: Geographic information about a vantage point.
        :param builtins.str name: Filters results that exactly match the `name` field.
        :param builtins.str provider_name: The organization on whose infrastructure this vantage point resides. Provider names are not unique, as Oracle Cloud Infrastructure maintains many vantage points in each major provider.
        :param Sequence['GetVantagePointsHealthChecksVantagePointRoutingArgs'] routings: An array of objects that describe how traffic to this vantage point is routed, including which prefixes and ASNs connect it to the internet.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "geos", geos)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "routings", routings)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def geos(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult']:
        """
        Geographic information about a vantage point.
        """
        return pulumi.get(self, "geos")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Filters results that exactly match the `name` field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> builtins.str:
        """
        The organization on whose infrastructure this vantage point resides. Provider names are not unique, as Oracle Cloud Infrastructure maintains many vantage points in each major provider.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter
    def routings(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult']:
        """
        An array of objects that describe how traffic to this vantage point is routed, including which prefixes and ASNs connect it to the internet.
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointGeoResult(dict):
    def __init__(__self__, *,
                 admin_div_code: builtins.str,
                 city_name: builtins.str,
                 country_code: builtins.str,
                 country_name: builtins.str,
                 geo_key: builtins.str,
                 latitude: builtins.float,
                 longitude: builtins.float):
        """
        :param builtins.str admin_div_code: The ISO 3166-2 code for this location's first-level administrative division, either a US state or Canadian province. Only included for locations in the US or Canada. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        :param builtins.str city_name: Common English-language name for the city.
        :param builtins.str country_code: The ISO 3166-1 alpha-2 country code. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        :param builtins.str country_name: The common English-language name for the country.
        :param builtins.str geo_key: An opaque identifier for the geographic location of the vantage point.
        :param builtins.float latitude: Degrees north of the Equator.
        :param builtins.float longitude: Degrees east of the prime meridian.
        """
        pulumi.set(__self__, "admin_div_code", admin_div_code)
        pulumi.set(__self__, "city_name", city_name)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "country_name", country_name)
        pulumi.set(__self__, "geo_key", geo_key)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter(name="adminDivCode")
    def admin_div_code(self) -> builtins.str:
        """
        The ISO 3166-2 code for this location's first-level administrative division, either a US state or Canadian province. Only included for locations in the US or Canada. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        """
        return pulumi.get(self, "admin_div_code")

    @property
    @pulumi.getter(name="cityName")
    def city_name(self) -> builtins.str:
        """
        Common English-language name for the city.
        """
        return pulumi.get(self, "city_name")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        The ISO 3166-1 alpha-2 country code. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> builtins.str:
        """
        The common English-language name for the country.
        """
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="geoKey")
    def geo_key(self) -> builtins.str:
        """
        An opaque identifier for the geographic location of the vantage point.
        """
        return pulumi.get(self, "geo_key")

    @property
    @pulumi.getter
    def latitude(self) -> builtins.float:
        """
        Degrees north of the Equator.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> builtins.float:
        """
        Degrees east of the prime meridian.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointRoutingResult(dict):
    def __init__(__self__, *,
                 as_label: builtins.str,
                 asn: builtins.int,
                 prefix: builtins.str,
                 weight: builtins.int):
        """
        :param builtins.str as_label: The registry label for `asn`, usually the name of the organization that owns the ASN. May be omitted or null.
        :param builtins.int asn: The Autonomous System Number (ASN) identifying the organization responsible for routing packets to `prefix`.
        :param builtins.str prefix: An IP prefix (CIDR syntax) that is less specific than `address`, through which `address` is routed.
        :param builtins.int weight: An integer between 0 and 100 used to select between multiple origin ASNs when routing to `prefix`. Most prefixes have exactly one origin ASN, in which case `weight` will be 100.
        """
        pulumi.set(__self__, "as_label", as_label)
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="asLabel")
    def as_label(self) -> builtins.str:
        """
        The registry label for `asn`, usually the name of the organization that owns the ASN. May be omitted or null.
        """
        return pulumi.get(self, "as_label")

    @property
    @pulumi.getter
    def asn(self) -> builtins.int:
        """
        The Autonomous System Number (ASN) identifying the organization responsible for routing packets to `prefix`.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        An IP prefix (CIDR syntax) that is less specific than `address`, through which `address` is routed.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def weight(self) -> builtins.int:
        """
        An integer between 0 and 100 used to select between multiple origin ASNs when routing to `prefix`. Most prefixes have exactly one origin ASN, in which case `weight` will be 100.
        """
        return pulumi.get(self, "weight")


