# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsGrantArgs', 'DomainsGrant']

@pulumi.input_type
class DomainsGrantArgs:
    def __init__(__self__, *,
                 grant_mechanism: pulumi.Input[builtins.str],
                 grantee: pulumi.Input['DomainsGrantGranteeArgs'],
                 idcs_endpoint: pulumi.Input[builtins.str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 app: Optional[pulumi.Input['DomainsGrantAppArgs']] = None,
                 app_entitlement_collection: Optional[pulumi.Input['DomainsGrantAppEntitlementCollectionArgs']] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 entitlement: Optional[pulumi.Input['DomainsGrantEntitlementArgs']] = None,
                 granted_attribute_values_json: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsGrant resource.
        :param pulumi.Input[builtins.str] grant_mechanism: Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
               * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
               * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
               * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsGrantGranteeArgs'] grantee: Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsGrantAppArgs'] app: Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsGrantAppEntitlementCollectionArgs'] app_entitlement_collection: Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input['DomainsGrantEntitlementArgs'] entitlement: The entitlement or privilege that is being granted
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] granted_attribute_values_json: Store granted attribute-values as a string in Javascript Object Notation (JSON) format.
               
               **Added In:** 18.3.4
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "grant_mechanism", grant_mechanism)
        pulumi.set(__self__, "grantee", grantee)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_entitlement_collection is not None:
            pulumi.set(__self__, "app_entitlement_collection", app_entitlement_collection)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if entitlement is not None:
            pulumi.set(__self__, "entitlement", entitlement)
        if granted_attribute_values_json is not None:
            pulumi.set(__self__, "granted_attribute_values_json", granted_attribute_values_json)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="grantMechanism")
    def grant_mechanism(self) -> pulumi.Input[builtins.str]:
        """
        Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
        * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
        * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
        * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "grant_mechanism")

    @grant_mechanism.setter
    def grant_mechanism(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "grant_mechanism", value)

    @property
    @pulumi.getter
    def grantee(self) -> pulumi.Input['DomainsGrantGranteeArgs']:
        """
        Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: pulumi.Input['DomainsGrantGranteeArgs']):
        pulumi.set(self, "grantee", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input['DomainsGrantAppArgs']]:
        """
        Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input['DomainsGrantAppArgs']]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appEntitlementCollection")
    def app_entitlement_collection(self) -> Optional[pulumi.Input['DomainsGrantAppEntitlementCollectionArgs']]:
        """
        Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "app_entitlement_collection")

    @app_entitlement_collection.setter
    def app_entitlement_collection(self, value: Optional[pulumi.Input['DomainsGrantAppEntitlementCollectionArgs']]):
        pulumi.set(self, "app_entitlement_collection", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def entitlement(self) -> Optional[pulumi.Input['DomainsGrantEntitlementArgs']]:
        """
        The entitlement or privilege that is being granted

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "entitlement")

    @entitlement.setter
    def entitlement(self, value: Optional[pulumi.Input['DomainsGrantEntitlementArgs']]):
        pulumi.set(self, "entitlement", value)

    @property
    @pulumi.getter(name="grantedAttributeValuesJson")
    def granted_attribute_values_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Store granted attribute-values as a string in Javascript Object Notation (JSON) format.

        **Added In:** 18.3.4

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "granted_attribute_values_json")

    @granted_attribute_values_json.setter
    def granted_attribute_values_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "granted_attribute_values_json", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]]]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainsGrantState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input['DomainsGrantAppArgs']] = None,
                 app_entitlement_collection: Optional[pulumi.Input['DomainsGrantAppEntitlementCollectionArgs']] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 composite_key: Optional[pulumi.Input[builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 entitlement: Optional[pulumi.Input['DomainsGrantEntitlementArgs']] = None,
                 grant_mechanism: Optional[pulumi.Input[builtins.str]] = None,
                 granted_attribute_values_json: Optional[pulumi.Input[builtins.str]] = None,
                 grantee: Optional[pulumi.Input['DomainsGrantGranteeArgs']] = None,
                 grantors: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantGrantorArgs']]]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_fulfilled: Optional[pulumi.Input[builtins.bool]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantMetaArgs']]]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainsGrant resources.
        :param pulumi.Input['DomainsGrantAppArgs'] app: Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsGrantAppEntitlementCollectionArgs'] app_entitlement_collection: Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] composite_key: (Updatable) Unique key of grant, composed by combining a subset of app, entitlement, grantee, grantor and grantMechanism.  Used to prevent duplicate Grants.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: server
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsGrantEntitlementArgs'] entitlement: The entitlement or privilege that is being granted
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] grant_mechanism: Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
               * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
               * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
               * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] granted_attribute_values_json: Store granted attribute-values as a string in Javascript Object Notation (JSON) format.
               
               **Added In:** 18.3.4
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsGrantGranteeArgs'] grantee: Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGrantGrantorArgs']]] grantors: (Updatable) User conferring the grant to the beneficiary
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * idcsIgnoreReadOnlyAndImmutableRefAttrsDuringForceDelete: true
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] is_fulfilled: (Updatable) If true, this Grant has been fulfilled successfully.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGrantMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_entitlement_collection is not None:
            pulumi.set(__self__, "app_entitlement_collection", app_entitlement_collection)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if composite_key is not None:
            pulumi.set(__self__, "composite_key", composite_key)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if entitlement is not None:
            pulumi.set(__self__, "entitlement", entitlement)
        if grant_mechanism is not None:
            pulumi.set(__self__, "grant_mechanism", grant_mechanism)
        if granted_attribute_values_json is not None:
            pulumi.set(__self__, "granted_attribute_values_json", granted_attribute_values_json)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)
        if grantors is not None:
            pulumi.set(__self__, "grantors", grantors)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if is_fulfilled is not None:
            pulumi.set(__self__, "is_fulfilled", is_fulfilled)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input['DomainsGrantAppArgs']]:
        """
        Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input['DomainsGrantAppArgs']]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appEntitlementCollection")
    def app_entitlement_collection(self) -> Optional[pulumi.Input['DomainsGrantAppEntitlementCollectionArgs']]:
        """
        Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "app_entitlement_collection")

    @app_entitlement_collection.setter
    def app_entitlement_collection(self, value: Optional[pulumi.Input['DomainsGrantAppEntitlementCollectionArgs']]):
        pulumi.set(self, "app_entitlement_collection", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="compositeKey")
    def composite_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique key of grant, composed by combining a subset of app, entitlement, grantee, grantor and grantMechanism.  Used to prevent duplicate Grants.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "composite_key")

    @composite_key.setter
    def composite_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "composite_key", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter
    def entitlement(self) -> Optional[pulumi.Input['DomainsGrantEntitlementArgs']]:
        """
        The entitlement or privilege that is being granted

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "entitlement")

    @entitlement.setter
    def entitlement(self, value: Optional[pulumi.Input['DomainsGrantEntitlementArgs']]):
        pulumi.set(self, "entitlement", value)

    @property
    @pulumi.getter(name="grantMechanism")
    def grant_mechanism(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
        * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
        * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
        * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "grant_mechanism")

    @grant_mechanism.setter
    def grant_mechanism(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grant_mechanism", value)

    @property
    @pulumi.getter(name="grantedAttributeValuesJson")
    def granted_attribute_values_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Store granted attribute-values as a string in Javascript Object Notation (JSON) format.

        **Added In:** 18.3.4

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "granted_attribute_values_json")

    @granted_attribute_values_json.setter
    def granted_attribute_values_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "granted_attribute_values_json", value)

    @property
    @pulumi.getter
    def grantee(self) -> Optional[pulumi.Input['DomainsGrantGranteeArgs']]:
        """
        Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: Optional[pulumi.Input['DomainsGrantGranteeArgs']]):
        pulumi.set(self, "grantee", value)

    @property
    @pulumi.getter
    def grantors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantGrantorArgs']]]]:
        """
        (Updatable) User conferring the grant to the beneficiary

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * idcsIgnoreReadOnlyAndImmutableRefAttrsDuringForceDelete: true
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "grantors")

    @grantors.setter
    def grantors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantGrantorArgs']]]]):
        pulumi.set(self, "grantors", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="isFulfilled")
    def is_fulfilled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) If true, this Grant has been fulfilled successfully.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_fulfilled")

    @is_fulfilled.setter
    def is_fulfilled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_fulfilled", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]]]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGrantTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)


@pulumi.type_token("oci:Identity/domainsGrant:DomainsGrant")
class DomainsGrant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[Union['DomainsGrantAppArgs', 'DomainsGrantAppArgsDict']]] = None,
                 app_entitlement_collection: Optional[pulumi.Input[Union['DomainsGrantAppEntitlementCollectionArgs', 'DomainsGrantAppEntitlementCollectionArgsDict']]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 entitlement: Optional[pulumi.Input[Union['DomainsGrantEntitlementArgs', 'DomainsGrantEntitlementArgsDict']]] = None,
                 grant_mechanism: Optional[pulumi.Input[builtins.str]] = None,
                 granted_attribute_values_json: Optional[pulumi.Input[builtins.str]] = None,
                 grantee: Optional[pulumi.Input[Union['DomainsGrantGranteeArgs', 'DomainsGrantGranteeArgsDict']]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantTagArgs', 'DomainsGrantTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Grant resource in Oracle Cloud Infrastructure Identity Domains service.

        Add a Grantee to an AppRole

        ## Import

        Grants can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsGrant:DomainsGrant test_grant "idcsEndpoint/{idcsEndpoint}/grants/{grantId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DomainsGrantAppArgs', 'DomainsGrantAppArgsDict']] app: Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGrantAppEntitlementCollectionArgs', 'DomainsGrantAppEntitlementCollectionArgsDict']] app_entitlement_collection: Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[Union['DomainsGrantEntitlementArgs', 'DomainsGrantEntitlementArgsDict']] entitlement: The entitlement or privilege that is being granted
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] grant_mechanism: Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
               * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
               * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
               * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] granted_attribute_values_json: Store granted attribute-values as a string in Javascript Object Notation (JSON) format.
               
               **Added In:** 18.3.4
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGrantGranteeArgs', 'DomainsGrantGranteeArgsDict']] grantee: Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantTagArgs', 'DomainsGrantTagArgsDict']]]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsGrantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Grant resource in Oracle Cloud Infrastructure Identity Domains service.

        Add a Grantee to an AppRole

        ## Import

        Grants can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsGrant:DomainsGrant test_grant "idcsEndpoint/{idcsEndpoint}/grants/{grantId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsGrantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsGrantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[Union['DomainsGrantAppArgs', 'DomainsGrantAppArgsDict']]] = None,
                 app_entitlement_collection: Optional[pulumi.Input[Union['DomainsGrantAppEntitlementCollectionArgs', 'DomainsGrantAppEntitlementCollectionArgsDict']]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 entitlement: Optional[pulumi.Input[Union['DomainsGrantEntitlementArgs', 'DomainsGrantEntitlementArgsDict']]] = None,
                 grant_mechanism: Optional[pulumi.Input[builtins.str]] = None,
                 granted_attribute_values_json: Optional[pulumi.Input[builtins.str]] = None,
                 grantee: Optional[pulumi.Input[Union['DomainsGrantGranteeArgs', 'DomainsGrantGranteeArgsDict']]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantTagArgs', 'DomainsGrantTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsGrantArgs.__new__(DomainsGrantArgs)

            __props__.__dict__["app"] = app
            __props__.__dict__["app_entitlement_collection"] = app_entitlement_collection
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["entitlement"] = entitlement
            if grant_mechanism is None and not opts.urn:
                raise TypeError("Missing required property 'grant_mechanism'")
            __props__.__dict__["grant_mechanism"] = grant_mechanism
            __props__.__dict__["granted_attribute_values_json"] = granted_attribute_values_json
            if grantee is None and not opts.urn:
                raise TypeError("Missing required property 'grantee'")
            __props__.__dict__["grantee"] = grantee
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["composite_key"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["grantors"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["is_fulfilled"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsGrant, __self__).__init__(
            'oci:Identity/domainsGrant:DomainsGrant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[Union['DomainsGrantAppArgs', 'DomainsGrantAppArgsDict']]] = None,
            app_entitlement_collection: Optional[pulumi.Input[Union['DomainsGrantAppEntitlementCollectionArgs', 'DomainsGrantAppEntitlementCollectionArgsDict']]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            attributes: Optional[pulumi.Input[builtins.str]] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            composite_key: Optional[pulumi.Input[builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            entitlement: Optional[pulumi.Input[Union['DomainsGrantEntitlementArgs', 'DomainsGrantEntitlementArgsDict']]] = None,
            grant_mechanism: Optional[pulumi.Input[builtins.str]] = None,
            granted_attribute_values_json: Optional[pulumi.Input[builtins.str]] = None,
            grantee: Optional[pulumi.Input[Union['DomainsGrantGranteeArgs', 'DomainsGrantGranteeArgsDict']]] = None,
            grantors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantGrantorArgs', 'DomainsGrantGrantorArgsDict']]]]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantIdcsCreatedByArgs', 'DomainsGrantIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantIdcsLastModifiedByArgs', 'DomainsGrantIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            is_fulfilled: Optional[pulumi.Input[builtins.bool]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantMetaArgs', 'DomainsGrantMetaArgsDict']]]]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantTagArgs', 'DomainsGrantTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainsGrant':
        """
        Get an existing DomainsGrant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DomainsGrantAppArgs', 'DomainsGrantAppArgsDict']] app: Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGrantAppEntitlementCollectionArgs', 'DomainsGrantAppEntitlementCollectionArgsDict']] app_entitlement_collection: Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] composite_key: (Updatable) Unique key of grant, composed by combining a subset of app, entitlement, grantee, grantor and grantMechanism.  Used to prevent duplicate Grants.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: server
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGrantEntitlementArgs', 'DomainsGrantEntitlementArgsDict']] entitlement: The entitlement or privilege that is being granted
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] grant_mechanism: Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
               * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
               * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
               * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] granted_attribute_values_json: Store granted attribute-values as a string in Javascript Object Notation (JSON) format.
               
               **Added In:** 18.3.4
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGrantGranteeArgs', 'DomainsGrantGranteeArgsDict']] grantee: Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantGrantorArgs', 'DomainsGrantGrantorArgsDict']]]] grantors: (Updatable) User conferring the grant to the beneficiary
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * idcsIgnoreReadOnlyAndImmutableRefAttrsDuringForceDelete: true
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantIdcsCreatedByArgs', 'DomainsGrantIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantIdcsLastModifiedByArgs', 'DomainsGrantIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] is_fulfilled: (Updatable) If true, this Grant has been fulfilled successfully.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantMetaArgs', 'DomainsGrantMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGrantTagArgs', 'DomainsGrantTagArgsDict']]]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsGrantState.__new__(_DomainsGrantState)

        __props__.__dict__["app"] = app
        __props__.__dict__["app_entitlement_collection"] = app_entitlement_collection
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["composite_key"] = composite_key
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["entitlement"] = entitlement
        __props__.__dict__["grant_mechanism"] = grant_mechanism
        __props__.__dict__["granted_attribute_values_json"] = granted_attribute_values_json
        __props__.__dict__["grantee"] = grantee
        __props__.__dict__["grantors"] = grantors
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["is_fulfilled"] = is_fulfilled
        __props__.__dict__["metas"] = metas
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        return DomainsGrant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def app(self) -> pulumi.Output['outputs.DomainsGrantApp']:
        """
        Application that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:App Name, defaultValue:jobParam:appDisplayName, mapsTo:app.value]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter(name="appEntitlementCollection")
    def app_entitlement_collection(self) -> pulumi.Output['outputs.DomainsGrantAppEntitlementCollection']:
        """
        Application-Entitlement-Collection that is being granted. Each Grant must grant either an App or an App-Entitlement-Collection.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "app_entitlement_collection")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="compositeKey")
    def composite_key(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Unique key of grant, composed by combining a subset of app, entitlement, grantee, grantor and grantMechanism.  Used to prevent duplicate Grants.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "composite_key")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def entitlement(self) -> pulumi.Output['outputs.DomainsGrantEntitlement']:
        """
        The entitlement or privilege that is being granted

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value, csvColumnForResolvingResourceType:Entitlement Name, mapsTo:entitlement.attributeValue, referencedResourceTypeUniqueAttributeNameMappings:[[mapsFromColumnName:Entitlement Value, resourceTypeAttributeName:displayName], [mapsFromColumnName:App Name, resourceTypeAttributeName:app.display]], resolveValueUsingResourceType:[[resolveBy:AppRole, valueToBeResolved:appRoles]]], [columnHeaderName:Entitlement Name, defaultValue:appRoles, mapsTo:entitlement.attributeName]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "entitlement")

    @property
    @pulumi.getter(name="grantMechanism")
    def grant_mechanism(self) -> pulumi.Output[builtins.str]:
        """
        Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':
        * 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.
        * 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.
        * 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "grant_mechanism")

    @property
    @pulumi.getter(name="grantedAttributeValuesJson")
    def granted_attribute_values_json(self) -> pulumi.Output[builtins.str]:
        """
        Store granted attribute-values as a string in Javascript Object Notation (JSON) format.

        **Added In:** 18.3.4

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "granted_attribute_values_json")

    @property
    @pulumi.getter
    def grantee(self) -> pulumi.Output['outputs.DomainsGrantGrantee']:
        """
        Grantee beneficiary. The grantee may be a User, Group, App or DynamicResourceGroup.

        **SCIM++ Properties:**
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, csvColumnForResolvingResourceType:Grantee Type, mapsTo:grantee.value], [columnHeaderName:Grantee Type, mapsTo:grantee.type]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def grantors(self) -> pulumi.Output[Sequence['outputs.DomainsGrantGrantor']]:
        """
        (Updatable) User conferring the grant to the beneficiary

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * idcsIgnoreReadOnlyAndImmutableRefAttrsDuringForceDelete: true
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "grantors")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsGrantIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsGrantIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="isFulfilled")
    def is_fulfilled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) If true, this Grant has been fulfilled successfully.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_fulfilled")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsGrantMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[builtins.str]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsGrantTag']]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

