# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsMyOauth2clientCredentialArgs', 'DomainsMyOauth2clientCredential']

@pulumi.input_type
class DomainsMyOauth2clientCredentialArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[builtins.str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 scopes: pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]],
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 is_reset_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]]] = None,
                 user: Optional[pulumi.Input['DomainsMyOauth2clientCredentialUserArgs']] = None):
        """
        The set of arguments for constructing a DomainsMyOauth2clientCredential resource.
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]] scopes: Scopes
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [audience, scope]
               * type: complex
               * mutability: readWrite
               * multiValued: true
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] description: Description
               
               **Added In:** 2101262133
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: false
               * returned: default
        :param pulumi.Input[builtins.str] expires_on: When the user's credentials expire.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[builtins.bool] is_reset_secret: Specifies whether the secret must be reset.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: Name
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[builtins.str] status: The user's credential status.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsMyOauth2clientCredentialUserArgs'] user: The user linked to the OAuth2 client credential.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "scopes", scopes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if is_reset_secret is not None:
            pulumi.set(__self__, "is_reset_secret", is_reset_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]]:
        """
        Scopes

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [audience, scope]
        * type: complex
        * mutability: readWrite
        * multiValued: true
        * required: true
        * returned: default
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description

        **Added In:** 2101262133

        **SCIM++ Properties:**
        * caseExact: false
        * type: string
        * mutability: readWrite
        * required: false
        * returned: default
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the user's credentials expire.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @property
    @pulumi.getter(name="isResetSecret")
    def is_reset_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the secret must be reset.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_reset_secret")

    @is_reset_secret.setter
    def is_reset_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_reset_secret", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name

        **SCIM++ Properties:**
        * caseExact: false
        * type: string
        * mutability: readWrite
        * required: true
        * returned: default
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's credential status.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: never
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]]]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['DomainsMyOauth2clientCredentialUserArgs']]:
        """
        The user linked to the OAuth2 client credential.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['DomainsMyOauth2clientCredentialUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _DomainsMyOauth2clientCredentialState:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_reset_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialMetaArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input['DomainsMyOauth2clientCredentialUserArgs']] = None):
        """
        Input properties used for looking up and filtering DomainsMyOauth2clientCredential resources.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: Description
               
               **Added In:** 2101262133
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: false
               * returned: default
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] expires_on: When the user's credentials expire.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] is_reset_secret: Specifies whether the secret must be reset.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: Name
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]] scopes: Scopes
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [audience, scope]
               * type: complex
               * mutability: readWrite
               * multiValued: true
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] status: The user's credential status.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsMyOauth2clientCredentialUserArgs'] user: The user linked to the OAuth2 client credential.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if is_reset_secret is not None:
            pulumi.set(__self__, "is_reset_secret", is_reset_secret)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description

        **Added In:** 2101262133

        **SCIM++ Properties:**
        * caseExact: false
        * type: string
        * mutability: readWrite
        * required: false
        * returned: default
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the user's credentials expire.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="isResetSecret")
    def is_reset_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the secret must be reset.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_reset_secret")

    @is_reset_secret.setter
    def is_reset_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_reset_secret", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name

        **SCIM++ Properties:**
        * caseExact: false
        * type: string
        * mutability: readWrite
        * required: true
        * returned: default
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]]]:
        """
        Scopes

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [audience, scope]
        * type: complex
        * mutability: readWrite
        * multiValued: true
        * required: true
        * returned: default
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's credential status.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: never
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]]]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsMyOauth2clientCredentialTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['DomainsMyOauth2clientCredentialUserArgs']]:
        """
        The user linked to the OAuth2 client credential.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['DomainsMyOauth2clientCredentialUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.type_token("oci:Identity/domainsMyOauth2clientCredential:DomainsMyOauth2clientCredential")
class DomainsMyOauth2clientCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 is_reset_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialScopeArgs', 'DomainsMyOauth2clientCredentialScopeArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialTagArgs', 'DomainsMyOauth2clientCredentialTagArgsDict']]]]] = None,
                 user: Optional[pulumi.Input[Union['DomainsMyOauth2clientCredentialUserArgs', 'DomainsMyOauth2clientCredentialUserArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the My O Auth2 Client Credential resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a user's own OAuth2 client credential.

        ## Import

        MyOAuth2ClientCredentials can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsMyOauth2clientCredential:DomainsMyOauth2clientCredential test_my_oauth2client_credential "idcsEndpoint/{idcsEndpoint}/myOAuth2ClientCredentials/{myOAuth2ClientCredentialId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] description: Description
               
               **Added In:** 2101262133
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: false
               * returned: default
        :param pulumi.Input[builtins.str] expires_on: When the user's credentials expire.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.bool] is_reset_secret: Specifies whether the secret must be reset.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: Name
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialScopeArgs', 'DomainsMyOauth2clientCredentialScopeArgsDict']]]] scopes: Scopes
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [audience, scope]
               * type: complex
               * mutability: readWrite
               * multiValued: true
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] status: The user's credential status.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialTagArgs', 'DomainsMyOauth2clientCredentialTagArgsDict']]]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsMyOauth2clientCredentialUserArgs', 'DomainsMyOauth2clientCredentialUserArgsDict']] user: The user linked to the OAuth2 client credential.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsMyOauth2clientCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the My O Auth2 Client Credential resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a user's own OAuth2 client credential.

        ## Import

        MyOAuth2ClientCredentials can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsMyOauth2clientCredential:DomainsMyOauth2clientCredential test_my_oauth2client_credential "idcsEndpoint/{idcsEndpoint}/myOAuth2ClientCredentials/{myOAuth2ClientCredentialId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsMyOauth2clientCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsMyOauth2clientCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 is_reset_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialScopeArgs', 'DomainsMyOauth2clientCredentialScopeArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialTagArgs', 'DomainsMyOauth2clientCredentialTagArgsDict']]]]] = None,
                 user: Optional[pulumi.Input[Union['DomainsMyOauth2clientCredentialUserArgs', 'DomainsMyOauth2clientCredentialUserArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsMyOauth2clientCredentialArgs.__new__(DomainsMyOauth2clientCredentialArgs)

            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["description"] = description
            __props__.__dict__["expires_on"] = expires_on
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["is_reset_secret"] = is_reset_secret
            __props__.__dict__["name"] = name
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user"] = user
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsMyOauth2clientCredential, __self__).__init__(
            'oci:Identity/domainsMyOauth2clientCredential:DomainsMyOauth2clientCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            expires_on: Optional[pulumi.Input[builtins.str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialIdcsCreatedByArgs', 'DomainsMyOauth2clientCredentialIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialIdcsLastModifiedByArgs', 'DomainsMyOauth2clientCredentialIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            is_reset_secret: Optional[pulumi.Input[builtins.bool]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialMetaArgs', 'DomainsMyOauth2clientCredentialMetaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialScopeArgs', 'DomainsMyOauth2clientCredentialScopeArgsDict']]]]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialTagArgs', 'DomainsMyOauth2clientCredentialTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[Union['DomainsMyOauth2clientCredentialUserArgs', 'DomainsMyOauth2clientCredentialUserArgsDict']]] = None) -> 'DomainsMyOauth2clientCredential':
        """
        Get an existing DomainsMyOauth2clientCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: Description
               
               **Added In:** 2101262133
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: false
               * returned: default
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] expires_on: When the user's credentials expire.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialIdcsCreatedByArgs', 'DomainsMyOauth2clientCredentialIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialIdcsLastModifiedByArgs', 'DomainsMyOauth2clientCredentialIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] is_reset_secret: Specifies whether the secret must be reset.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialMetaArgs', 'DomainsMyOauth2clientCredentialMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: Name
               
               **SCIM++ Properties:**
               * caseExact: false
               * type: string
               * mutability: readWrite
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialScopeArgs', 'DomainsMyOauth2clientCredentialScopeArgsDict']]]] scopes: Scopes
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [audience, scope]
               * type: complex
               * mutability: readWrite
               * multiValued: true
               * required: true
               * returned: default
        :param pulumi.Input[builtins.str] status: The user's credential status.
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsMyOauth2clientCredentialTagArgs', 'DomainsMyOauth2clientCredentialTagArgsDict']]]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsMyOauth2clientCredentialUserArgs', 'DomainsMyOauth2clientCredentialUserArgsDict']] user: The user linked to the OAuth2 client credential.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsMyOauth2clientCredentialState.__new__(_DomainsMyOauth2clientCredentialState)

        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["is_reset_secret"] = is_reset_secret
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name"] = name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["user"] = user
        return DomainsMyOauth2clientCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description

        **Added In:** 2101262133

        **SCIM++ Properties:**
        * caseExact: false
        * type: string
        * mutability: readWrite
        * required: false
        * returned: default
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[builtins.str]:
        """
        When the user's credentials expire.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsMyOauth2clientCredentialIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsMyOauth2clientCredentialIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="isResetSecret")
    def is_reset_secret(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the secret must be reset.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_reset_secret")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsMyOauth2clientCredentialMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name

        **SCIM++ Properties:**
        * caseExact: false
        * type: string
        * mutability: readWrite
        * required: true
        * returned: default
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence['outputs.DomainsMyOauth2clientCredentialScope']]:
        """
        Scopes

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [audience, scope]
        * type: complex
        * mutability: readWrite
        * multiValued: true
        * required: true
        * returned: default
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The user's credential status.

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: never
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsMyOauth2clientCredentialTag']]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.DomainsMyOauth2clientCredentialUser']:
        """
        The user linked to the OAuth2 client credential.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "user")

