# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamespaceLookupResult',
    'AwaitableGetNamespaceLookupResult',
    'get_namespace_lookup',
    'get_namespace_lookup_output',
]

@pulumi.output_type
class GetNamespaceLookupResult:
    """
    A collection of values returned by getNamespaceLookup.
    """
    def __init__(__self__, active_edit_version=None, canonical_link=None, categories=None, char_encoding=None, compartment_id=None, default_match_value=None, defined_tags=None, description=None, edit_version=None, fields=None, freeform_tags=None, id=None, is_built_in=None, is_hidden=None, lookup_display_name=None, lookup_id=None, lookup_name=None, lookup_reference=None, lookup_reference_string=None, max_matches=None, namespace=None, referring_sources=None, register_lookup_file=None, status_summaries=None, time_updated=None, type=None):
        if active_edit_version and not isinstance(active_edit_version, str):
            raise TypeError("Expected argument 'active_edit_version' to be a str")
        pulumi.set(__self__, "active_edit_version", active_edit_version)
        if canonical_link and not isinstance(canonical_link, str):
            raise TypeError("Expected argument 'canonical_link' to be a str")
        pulumi.set(__self__, "canonical_link", canonical_link)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if char_encoding and not isinstance(char_encoding, str):
            raise TypeError("Expected argument 'char_encoding' to be a str")
        pulumi.set(__self__, "char_encoding", char_encoding)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if default_match_value and not isinstance(default_match_value, str):
            raise TypeError("Expected argument 'default_match_value' to be a str")
        pulumi.set(__self__, "default_match_value", default_match_value)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if edit_version and not isinstance(edit_version, str):
            raise TypeError("Expected argument 'edit_version' to be a str")
        pulumi.set(__self__, "edit_version", edit_version)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_built_in and not isinstance(is_built_in, str):
            raise TypeError("Expected argument 'is_built_in' to be a str")
        pulumi.set(__self__, "is_built_in", is_built_in)
        if is_hidden and not isinstance(is_hidden, bool):
            raise TypeError("Expected argument 'is_hidden' to be a bool")
        pulumi.set(__self__, "is_hidden", is_hidden)
        if lookup_display_name and not isinstance(lookup_display_name, str):
            raise TypeError("Expected argument 'lookup_display_name' to be a str")
        pulumi.set(__self__, "lookup_display_name", lookup_display_name)
        if lookup_id and not isinstance(lookup_id, str):
            raise TypeError("Expected argument 'lookup_id' to be a str")
        pulumi.set(__self__, "lookup_id", lookup_id)
        if lookup_name and not isinstance(lookup_name, str):
            raise TypeError("Expected argument 'lookup_name' to be a str")
        pulumi.set(__self__, "lookup_name", lookup_name)
        if lookup_reference and not isinstance(lookup_reference, str):
            raise TypeError("Expected argument 'lookup_reference' to be a str")
        pulumi.set(__self__, "lookup_reference", lookup_reference)
        if lookup_reference_string and not isinstance(lookup_reference_string, str):
            raise TypeError("Expected argument 'lookup_reference_string' to be a str")
        pulumi.set(__self__, "lookup_reference_string", lookup_reference_string)
        if max_matches and not isinstance(max_matches, str):
            raise TypeError("Expected argument 'max_matches' to be a str")
        pulumi.set(__self__, "max_matches", max_matches)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if referring_sources and not isinstance(referring_sources, list):
            raise TypeError("Expected argument 'referring_sources' to be a list")
        pulumi.set(__self__, "referring_sources", referring_sources)
        if register_lookup_file and not isinstance(register_lookup_file, str):
            raise TypeError("Expected argument 'register_lookup_file' to be a str")
        pulumi.set(__self__, "register_lookup_file", register_lookup_file)
        if status_summaries and not isinstance(status_summaries, list):
            raise TypeError("Expected argument 'status_summaries' to be a list")
        pulumi.set(__self__, "status_summaries", status_summaries)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="activeEditVersion")
    def active_edit_version(self) -> builtins.str:
        """
        The active edit version.
        """
        return pulumi.get(self, "active_edit_version")

    @property
    @pulumi.getter(name="canonicalLink")
    def canonical_link(self) -> builtins.str:
        """
        The canonical link.
        """
        return pulumi.get(self, "canonical_link")

    @property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetNamespaceLookupCategoryResult']:
        """
        An array of categories assigned to this lookup. The isSystem flag denotes if each category assignment is user-created or Oracle-defined.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> builtins.str:
        return pulumi.get(self, "char_encoding")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultMatchValue")
    def default_match_value(self) -> builtins.str:
        """
        The default match value.
        """
        return pulumi.get(self, "default_match_value")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The lookup description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="editVersion")
    def edit_version(self) -> builtins.str:
        """
        The edit version.
        """
        return pulumi.get(self, "edit_version")

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GetNamespaceLookupFieldResult']:
        """
        The lookup fields.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The log analytics entity OCID. This ID is a reference used by log analytics features and it represents a resource that is provisioned and managed by the customer on their premises or on the cloud.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBuiltIn")
    def is_built_in(self) -> builtins.str:
        """
        A flag indicating if the lookup is custom (user-defined) or built in.
        """
        return pulumi.get(self, "is_built_in")

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> builtins.bool:
        """
        A flag indicating if the lookup is hidden or not.  A hidden lookup will not be returned in list operations by default.
        """
        return pulumi.get(self, "is_hidden")

    @property
    @pulumi.getter(name="lookupDisplayName")
    def lookup_display_name(self) -> builtins.str:
        """
        The lookup display name.
        """
        return pulumi.get(self, "lookup_display_name")

    @property
    @pulumi.getter(name="lookupId")
    def lookup_id(self) -> builtins.str:
        """
        The lookup OCID.
        """
        return pulumi.get(self, "lookup_id")

    @property
    @pulumi.getter(name="lookupName")
    def lookup_name(self) -> builtins.str:
        """
        The lookup name.
        """
        return pulumi.get(self, "lookup_name")

    @property
    @pulumi.getter(name="lookupReference")
    def lookup_reference(self) -> builtins.str:
        """
        The lookup reference as an integer.
        """
        return pulumi.get(self, "lookup_reference")

    @property
    @pulumi.getter(name="lookupReferenceString")
    def lookup_reference_string(self) -> builtins.str:
        """
        The lookup reference as a string.
        """
        return pulumi.get(self, "lookup_reference_string")

    @property
    @pulumi.getter(name="maxMatches")
    def max_matches(self) -> builtins.str:
        return pulumi.get(self, "max_matches")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="referringSources")
    def referring_sources(self) -> Sequence['outputs.GetNamespaceLookupReferringSourceResult']:
        """
        AutoLookups
        """
        return pulumi.get(self, "referring_sources")

    @property
    @pulumi.getter(name="registerLookupFile")
    def register_lookup_file(self) -> builtins.str:
        return pulumi.get(self, "register_lookup_file")

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> Sequence['outputs.GetNamespaceLookupStatusSummaryResult']:
        """
        StatusSummary
        """
        return pulumi.get(self, "status_summaries")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The last updated date.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The lookup type. Valid values are Lookup, Dictionary or Module.
        """
        return pulumi.get(self, "type")


class AwaitableGetNamespaceLookupResult(GetNamespaceLookupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceLookupResult(
            active_edit_version=self.active_edit_version,
            canonical_link=self.canonical_link,
            categories=self.categories,
            char_encoding=self.char_encoding,
            compartment_id=self.compartment_id,
            default_match_value=self.default_match_value,
            defined_tags=self.defined_tags,
            description=self.description,
            edit_version=self.edit_version,
            fields=self.fields,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_built_in=self.is_built_in,
            is_hidden=self.is_hidden,
            lookup_display_name=self.lookup_display_name,
            lookup_id=self.lookup_id,
            lookup_name=self.lookup_name,
            lookup_reference=self.lookup_reference,
            lookup_reference_string=self.lookup_reference_string,
            max_matches=self.max_matches,
            namespace=self.namespace,
            referring_sources=self.referring_sources,
            register_lookup_file=self.register_lookup_file,
            status_summaries=self.status_summaries,
            time_updated=self.time_updated,
            type=self.type)


def get_namespace_lookup(lookup_name: Optional[builtins.str] = None,
                         namespace: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceLookupResult:
    """
    This data source provides details about a specific Namespace Lookup resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the lookup with the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_lookup = oci.LogAnalytics.get_namespace_lookup(lookup_name=namespace_lookup_lookup_name,
        namespace=namespace_lookup_namespace)
    ```


    :param builtins.str lookup_name: The name of the lookup to operate on.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['lookupName'] = lookup_name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceLookup:getNamespaceLookup', __args__, opts=opts, typ=GetNamespaceLookupResult).value

    return AwaitableGetNamespaceLookupResult(
        active_edit_version=pulumi.get(__ret__, 'active_edit_version'),
        canonical_link=pulumi.get(__ret__, 'canonical_link'),
        categories=pulumi.get(__ret__, 'categories'),
        char_encoding=pulumi.get(__ret__, 'char_encoding'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        default_match_value=pulumi.get(__ret__, 'default_match_value'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        edit_version=pulumi.get(__ret__, 'edit_version'),
        fields=pulumi.get(__ret__, 'fields'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_built_in=pulumi.get(__ret__, 'is_built_in'),
        is_hidden=pulumi.get(__ret__, 'is_hidden'),
        lookup_display_name=pulumi.get(__ret__, 'lookup_display_name'),
        lookup_id=pulumi.get(__ret__, 'lookup_id'),
        lookup_name=pulumi.get(__ret__, 'lookup_name'),
        lookup_reference=pulumi.get(__ret__, 'lookup_reference'),
        lookup_reference_string=pulumi.get(__ret__, 'lookup_reference_string'),
        max_matches=pulumi.get(__ret__, 'max_matches'),
        namespace=pulumi.get(__ret__, 'namespace'),
        referring_sources=pulumi.get(__ret__, 'referring_sources'),
        register_lookup_file=pulumi.get(__ret__, 'register_lookup_file'),
        status_summaries=pulumi.get(__ret__, 'status_summaries'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_namespace_lookup_output(lookup_name: Optional[pulumi.Input[builtins.str]] = None,
                                namespace: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceLookupResult]:
    """
    This data source provides details about a specific Namespace Lookup resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the lookup with the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_lookup = oci.LogAnalytics.get_namespace_lookup(lookup_name=namespace_lookup_lookup_name,
        namespace=namespace_lookup_namespace)
    ```


    :param builtins.str lookup_name: The name of the lookup to operate on.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['lookupName'] = lookup_name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getNamespaceLookup:getNamespaceLookup', __args__, opts=opts, typ=GetNamespaceLookupResult)
    return __ret__.apply(lambda __response__: GetNamespaceLookupResult(
        active_edit_version=pulumi.get(__response__, 'active_edit_version'),
        canonical_link=pulumi.get(__response__, 'canonical_link'),
        categories=pulumi.get(__response__, 'categories'),
        char_encoding=pulumi.get(__response__, 'char_encoding'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        default_match_value=pulumi.get(__response__, 'default_match_value'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        edit_version=pulumi.get(__response__, 'edit_version'),
        fields=pulumi.get(__response__, 'fields'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_built_in=pulumi.get(__response__, 'is_built_in'),
        is_hidden=pulumi.get(__response__, 'is_hidden'),
        lookup_display_name=pulumi.get(__response__, 'lookup_display_name'),
        lookup_id=pulumi.get(__response__, 'lookup_id'),
        lookup_name=pulumi.get(__response__, 'lookup_name'),
        lookup_reference=pulumi.get(__response__, 'lookup_reference'),
        lookup_reference_string=pulumi.get(__response__, 'lookup_reference_string'),
        max_matches=pulumi.get(__response__, 'max_matches'),
        namespace=pulumi.get(__response__, 'namespace'),
        referring_sources=pulumi.get(__response__, 'referring_sources'),
        register_lookup_file=pulumi.get(__response__, 'register_lookup_file'),
        status_summaries=pulumi.get(__response__, 'status_summaries'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
