# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamespaceLookupArgs', 'NamespaceLookup']

@pulumi.input_type
class NamespaceLookupArgs:
    def __init__(__self__, *,
                 lookup_name: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 register_lookup_file: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]]] = None,
                 char_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_match_value: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 max_matches: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NamespaceLookup resource.
        :param pulumi.Input[builtins.str] lookup_name: The name of the lookup to operate on.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[builtins.str] register_lookup_file: Path to the file containing data for lookup creation.
        :param pulumi.Input[builtins.str] type: The lookup type. Valid values are Lookup, Dictionary or Module.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]] categories: (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        :param pulumi.Input[builtins.str] char_encoding: The character encoding of the uploaded file.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] default_match_value: (Updatable) The default match value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The lookup description.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]] fields: (Updatable) The lookup fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_hidden: A flag indicating whether or not the new lookup should be hidden.
        :param pulumi.Input[builtins.str] max_matches: (Updatable) The maximum number of matches.
        """
        pulumi.set(__self__, "lookup_name", lookup_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "register_lookup_file", register_lookup_file)
        pulumi.set(__self__, "type", type)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if char_encoding is not None:
            pulumi.set(__self__, "char_encoding", char_encoding)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if default_match_value is not None:
            pulumi.set(__self__, "default_match_value", default_match_value)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if max_matches is not None:
            pulumi.set(__self__, "max_matches", max_matches)

    @property
    @pulumi.getter(name="lookupName")
    def lookup_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the lookup to operate on.
        """
        return pulumi.get(self, "lookup_name")

    @lookup_name.setter
    def lookup_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lookup_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="registerLookupFile")
    def register_lookup_file(self) -> pulumi.Input[builtins.str]:
        """
        Path to the file containing data for lookup creation.
        """
        return pulumi.get(self, "register_lookup_file")

    @register_lookup_file.setter
    def register_lookup_file(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "register_lookup_file", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The lookup type. Valid values are Lookup, Dictionary or Module.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]]]:
        """
        (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character encoding of the uploaded file.
        """
        return pulumi.get(self, "char_encoding")

    @char_encoding.setter
    def char_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "char_encoding", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="defaultMatchValue")
    def default_match_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The default match value.
        """
        return pulumi.get(self, "default_match_value")

    @default_match_value.setter
    def default_match_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_match_value", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The lookup description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]]]:
        """
        (Updatable) The lookup fields.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag indicating whether or not the new lookup should be hidden.
        """
        return pulumi.get(self, "is_hidden")

    @is_hidden.setter
    def is_hidden(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_hidden", value)

    @property
    @pulumi.getter(name="maxMatches")
    def max_matches(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The maximum number of matches.
        """
        return pulumi.get(self, "max_matches")

    @max_matches.setter
    def max_matches(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_matches", value)


@pulumi.input_type
class _NamespaceLookupState:
    def __init__(__self__, *,
                 active_edit_version: Optional[pulumi.Input[builtins.str]] = None,
                 canonical_link: Optional[pulumi.Input[builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]]] = None,
                 char_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_match_value: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edit_version: Optional[pulumi.Input[builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_built_in: Optional[pulumi.Input[builtins.str]] = None,
                 is_hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 lookup_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 lookup_id: Optional[pulumi.Input[builtins.str]] = None,
                 lookup_name: Optional[pulumi.Input[builtins.str]] = None,
                 lookup_reference: Optional[pulumi.Input[builtins.str]] = None,
                 lookup_reference_string: Optional[pulumi.Input[builtins.str]] = None,
                 max_matches: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 referring_sources: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupReferringSourceArgs']]]] = None,
                 register_lookup_file: Optional[pulumi.Input[builtins.str]] = None,
                 status_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupStatusSummaryArgs']]]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NamespaceLookup resources.
        :param pulumi.Input[builtins.str] active_edit_version: The active edit version.
        :param pulumi.Input[builtins.str] canonical_link: The canonical link.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]] categories: (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        :param pulumi.Input[builtins.str] char_encoding: The character encoding of the uploaded file.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] default_match_value: (Updatable) The default match value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The lookup description.
        :param pulumi.Input[builtins.str] edit_version: The edit version.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]] fields: (Updatable) The lookup fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] is_built_in: A flag indicating if the lookup is custom (user-defined) or built in.
        :param pulumi.Input[builtins.bool] is_hidden: A flag indicating whether or not the new lookup should be hidden.
        :param pulumi.Input[builtins.str] lookup_display_name: The lookup display name.
        :param pulumi.Input[builtins.str] lookup_id: The lookup OCID.
        :param pulumi.Input[builtins.str] lookup_name: The name of the lookup to operate on.
        :param pulumi.Input[builtins.str] lookup_reference: The lookup reference as an integer.
        :param pulumi.Input[builtins.str] lookup_reference_string: The lookup reference as a string.
        :param pulumi.Input[builtins.str] max_matches: (Updatable) The maximum number of matches.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLookupReferringSourceArgs']]] referring_sources: AutoLookups
        :param pulumi.Input[builtins.str] register_lookup_file: Path to the file containing data for lookup creation.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLookupStatusSummaryArgs']]] status_summaries: StatusSummary
        :param pulumi.Input[builtins.str] time_updated: The last updated date.
        :param pulumi.Input[builtins.str] type: The lookup type. Valid values are Lookup, Dictionary or Module.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if active_edit_version is not None:
            pulumi.set(__self__, "active_edit_version", active_edit_version)
        if canonical_link is not None:
            pulumi.set(__self__, "canonical_link", canonical_link)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if char_encoding is not None:
            pulumi.set(__self__, "char_encoding", char_encoding)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if default_match_value is not None:
            pulumi.set(__self__, "default_match_value", default_match_value)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edit_version is not None:
            pulumi.set(__self__, "edit_version", edit_version)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_built_in is not None:
            pulumi.set(__self__, "is_built_in", is_built_in)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if lookup_display_name is not None:
            pulumi.set(__self__, "lookup_display_name", lookup_display_name)
        if lookup_id is not None:
            pulumi.set(__self__, "lookup_id", lookup_id)
        if lookup_name is not None:
            pulumi.set(__self__, "lookup_name", lookup_name)
        if lookup_reference is not None:
            pulumi.set(__self__, "lookup_reference", lookup_reference)
        if lookup_reference_string is not None:
            pulumi.set(__self__, "lookup_reference_string", lookup_reference_string)
        if max_matches is not None:
            pulumi.set(__self__, "max_matches", max_matches)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if referring_sources is not None:
            pulumi.set(__self__, "referring_sources", referring_sources)
        if register_lookup_file is not None:
            pulumi.set(__self__, "register_lookup_file", register_lookup_file)
        if status_summaries is not None:
            pulumi.set(__self__, "status_summaries", status_summaries)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="activeEditVersion")
    def active_edit_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The active edit version.
        """
        return pulumi.get(self, "active_edit_version")

    @active_edit_version.setter
    def active_edit_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "active_edit_version", value)

    @property
    @pulumi.getter(name="canonicalLink")
    def canonical_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canonical link.
        """
        return pulumi.get(self, "canonical_link")

    @canonical_link.setter
    def canonical_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "canonical_link", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]]]:
        """
        (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character encoding of the uploaded file.
        """
        return pulumi.get(self, "char_encoding")

    @char_encoding.setter
    def char_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "char_encoding", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="defaultMatchValue")
    def default_match_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The default match value.
        """
        return pulumi.get(self, "default_match_value")

    @default_match_value.setter
    def default_match_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_match_value", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The lookup description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="editVersion")
    def edit_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edit version.
        """
        return pulumi.get(self, "edit_version")

    @edit_version.setter
    def edit_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edit_version", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]]]:
        """
        (Updatable) The lookup fields.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isBuiltIn")
    def is_built_in(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A flag indicating if the lookup is custom (user-defined) or built in.
        """
        return pulumi.get(self, "is_built_in")

    @is_built_in.setter
    def is_built_in(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "is_built_in", value)

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag indicating whether or not the new lookup should be hidden.
        """
        return pulumi.get(self, "is_hidden")

    @is_hidden.setter
    def is_hidden(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_hidden", value)

    @property
    @pulumi.getter(name="lookupDisplayName")
    def lookup_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lookup display name.
        """
        return pulumi.get(self, "lookup_display_name")

    @lookup_display_name.setter
    def lookup_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lookup_display_name", value)

    @property
    @pulumi.getter(name="lookupId")
    def lookup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lookup OCID.
        """
        return pulumi.get(self, "lookup_id")

    @lookup_id.setter
    def lookup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lookup_id", value)

    @property
    @pulumi.getter(name="lookupName")
    def lookup_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the lookup to operate on.
        """
        return pulumi.get(self, "lookup_name")

    @lookup_name.setter
    def lookup_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lookup_name", value)

    @property
    @pulumi.getter(name="lookupReference")
    def lookup_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lookup reference as an integer.
        """
        return pulumi.get(self, "lookup_reference")

    @lookup_reference.setter
    def lookup_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lookup_reference", value)

    @property
    @pulumi.getter(name="lookupReferenceString")
    def lookup_reference_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lookup reference as a string.
        """
        return pulumi.get(self, "lookup_reference_string")

    @lookup_reference_string.setter
    def lookup_reference_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lookup_reference_string", value)

    @property
    @pulumi.getter(name="maxMatches")
    def max_matches(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The maximum number of matches.
        """
        return pulumi.get(self, "max_matches")

    @max_matches.setter
    def max_matches(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_matches", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="referringSources")
    def referring_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupReferringSourceArgs']]]]:
        """
        AutoLookups
        """
        return pulumi.get(self, "referring_sources")

    @referring_sources.setter
    def referring_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupReferringSourceArgs']]]]):
        pulumi.set(self, "referring_sources", value)

    @property
    @pulumi.getter(name="registerLookupFile")
    def register_lookup_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to the file containing data for lookup creation.
        """
        return pulumi.get(self, "register_lookup_file")

    @register_lookup_file.setter
    def register_lookup_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "register_lookup_file", value)

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupStatusSummaryArgs']]]]:
        """
        StatusSummary
        """
        return pulumi.get(self, "status_summaries")

    @status_summaries.setter
    def status_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLookupStatusSummaryArgs']]]]):
        pulumi.set(self, "status_summaries", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last updated date.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lookup type. Valid values are Lookup, Dictionary or Module.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:LogAnalytics/namespaceLookup:NamespaceLookup")
class NamespaceLookup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupCategoryArgs', 'NamespaceLookupCategoryArgsDict']]]]] = None,
                 char_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_match_value: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupFieldArgs', 'NamespaceLookupFieldArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 lookup_name: Optional[pulumi.Input[builtins.str]] = None,
                 max_matches: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 register_lookup_file: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Namespace Lookup resource in Oracle Cloud Infrastructure Log Analytics service.

        Creates a lookup with the specified name, type and description. The csv file containing the lookup content is passed in as binary data in the request.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace_lookup = oci.log_analytics.NamespaceLookup("test_namespace_lookup",
            lookup_name=namespace_lookup_lookup_name,
            namespace=namespace_lookup_namespace,
            register_lookup_file=namespace_lookup_register_lookup_file,
            type=namespace_lookup_type,
            categories=[{
                "description": namespace_lookup_categories_description,
                "display_name": namespace_lookup_categories_display_name,
                "is_system": namespace_lookup_categories_is_system,
                "name": namespace_lookup_categories_name,
                "type": namespace_lookup_categories_type,
            }],
            char_encoding=namespace_lookup_char_encoding,
            compartment_id=namespace_lookup_compartment_id,
            default_match_value=namespace_lookup_default_match_value,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=namespace_lookup_description,
            fields=[{
                "common_field_name": namespace_lookup_fields_common_field_name,
                "default_match_value": namespace_lookup_fields_default_match_value,
                "display_name": namespace_lookup_fields_display_name,
                "is_common_field": namespace_lookup_fields_is_common_field,
                "match_operator": namespace_lookup_fields_match_operator,
                "name": namespace_lookup_fields_name,
                "position": namespace_lookup_fields_position,
            }],
            freeform_tags={
                "bar-key": "value",
            },
            is_hidden=namespace_lookup_is_hidden,
            max_matches=namespace_lookup_max_matches)
        ```

        ## Import

        NamespaceLookups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/namespaceLookup:NamespaceLookup test_namespace_lookup "namespaces/{namespaceName}/lookups/{lookupName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupCategoryArgs', 'NamespaceLookupCategoryArgsDict']]]] categories: (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        :param pulumi.Input[builtins.str] char_encoding: The character encoding of the uploaded file.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] default_match_value: (Updatable) The default match value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The lookup description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupFieldArgs', 'NamespaceLookupFieldArgsDict']]]] fields: (Updatable) The lookup fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_hidden: A flag indicating whether or not the new lookup should be hidden.
        :param pulumi.Input[builtins.str] lookup_name: The name of the lookup to operate on.
        :param pulumi.Input[builtins.str] max_matches: (Updatable) The maximum number of matches.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[builtins.str] register_lookup_file: Path to the file containing data for lookup creation.
        :param pulumi.Input[builtins.str] type: The lookup type. Valid values are Lookup, Dictionary or Module.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceLookupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Namespace Lookup resource in Oracle Cloud Infrastructure Log Analytics service.

        Creates a lookup with the specified name, type and description. The csv file containing the lookup content is passed in as binary data in the request.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace_lookup = oci.log_analytics.NamespaceLookup("test_namespace_lookup",
            lookup_name=namespace_lookup_lookup_name,
            namespace=namespace_lookup_namespace,
            register_lookup_file=namespace_lookup_register_lookup_file,
            type=namespace_lookup_type,
            categories=[{
                "description": namespace_lookup_categories_description,
                "display_name": namespace_lookup_categories_display_name,
                "is_system": namespace_lookup_categories_is_system,
                "name": namespace_lookup_categories_name,
                "type": namespace_lookup_categories_type,
            }],
            char_encoding=namespace_lookup_char_encoding,
            compartment_id=namespace_lookup_compartment_id,
            default_match_value=namespace_lookup_default_match_value,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=namespace_lookup_description,
            fields=[{
                "common_field_name": namespace_lookup_fields_common_field_name,
                "default_match_value": namespace_lookup_fields_default_match_value,
                "display_name": namespace_lookup_fields_display_name,
                "is_common_field": namespace_lookup_fields_is_common_field,
                "match_operator": namespace_lookup_fields_match_operator,
                "name": namespace_lookup_fields_name,
                "position": namespace_lookup_fields_position,
            }],
            freeform_tags={
                "bar-key": "value",
            },
            is_hidden=namespace_lookup_is_hidden,
            max_matches=namespace_lookup_max_matches)
        ```

        ## Import

        NamespaceLookups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/namespaceLookup:NamespaceLookup test_namespace_lookup "namespaces/{namespaceName}/lookups/{lookupName}"
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceLookupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceLookupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupCategoryArgs', 'NamespaceLookupCategoryArgsDict']]]]] = None,
                 char_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_match_value: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupFieldArgs', 'NamespaceLookupFieldArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 lookup_name: Optional[pulumi.Input[builtins.str]] = None,
                 max_matches: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 register_lookup_file: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceLookupArgs.__new__(NamespaceLookupArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["char_encoding"] = char_encoding
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["default_match_value"] = default_match_value
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["fields"] = fields
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_hidden"] = is_hidden
            if lookup_name is None and not opts.urn:
                raise TypeError("Missing required property 'lookup_name'")
            __props__.__dict__["lookup_name"] = lookup_name
            __props__.__dict__["max_matches"] = max_matches
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if register_lookup_file is None and not opts.urn:
                raise TypeError("Missing required property 'register_lookup_file'")
            __props__.__dict__["register_lookup_file"] = register_lookup_file
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["active_edit_version"] = None
            __props__.__dict__["canonical_link"] = None
            __props__.__dict__["edit_version"] = None
            __props__.__dict__["is_built_in"] = None
            __props__.__dict__["lookup_display_name"] = None
            __props__.__dict__["lookup_id"] = None
            __props__.__dict__["lookup_reference"] = None
            __props__.__dict__["lookup_reference_string"] = None
            __props__.__dict__["referring_sources"] = None
            __props__.__dict__["status_summaries"] = None
            __props__.__dict__["time_updated"] = None
        super(NamespaceLookup, __self__).__init__(
            'oci:LogAnalytics/namespaceLookup:NamespaceLookup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_edit_version: Optional[pulumi.Input[builtins.str]] = None,
            canonical_link: Optional[pulumi.Input[builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupCategoryArgs', 'NamespaceLookupCategoryArgsDict']]]]] = None,
            char_encoding: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            default_match_value: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            edit_version: Optional[pulumi.Input[builtins.str]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupFieldArgs', 'NamespaceLookupFieldArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_built_in: Optional[pulumi.Input[builtins.str]] = None,
            is_hidden: Optional[pulumi.Input[builtins.bool]] = None,
            lookup_display_name: Optional[pulumi.Input[builtins.str]] = None,
            lookup_id: Optional[pulumi.Input[builtins.str]] = None,
            lookup_name: Optional[pulumi.Input[builtins.str]] = None,
            lookup_reference: Optional[pulumi.Input[builtins.str]] = None,
            lookup_reference_string: Optional[pulumi.Input[builtins.str]] = None,
            max_matches: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            referring_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupReferringSourceArgs', 'NamespaceLookupReferringSourceArgsDict']]]]] = None,
            register_lookup_file: Optional[pulumi.Input[builtins.str]] = None,
            status_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupStatusSummaryArgs', 'NamespaceLookupStatusSummaryArgsDict']]]]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'NamespaceLookup':
        """
        Get an existing NamespaceLookup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] active_edit_version: The active edit version.
        :param pulumi.Input[builtins.str] canonical_link: The canonical link.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupCategoryArgs', 'NamespaceLookupCategoryArgsDict']]]] categories: (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        :param pulumi.Input[builtins.str] char_encoding: The character encoding of the uploaded file.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] default_match_value: (Updatable) The default match value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The lookup description.
        :param pulumi.Input[builtins.str] edit_version: The edit version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupFieldArgs', 'NamespaceLookupFieldArgsDict']]]] fields: (Updatable) The lookup fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] is_built_in: A flag indicating if the lookup is custom (user-defined) or built in.
        :param pulumi.Input[builtins.bool] is_hidden: A flag indicating whether or not the new lookup should be hidden.
        :param pulumi.Input[builtins.str] lookup_display_name: The lookup display name.
        :param pulumi.Input[builtins.str] lookup_id: The lookup OCID.
        :param pulumi.Input[builtins.str] lookup_name: The name of the lookup to operate on.
        :param pulumi.Input[builtins.str] lookup_reference: The lookup reference as an integer.
        :param pulumi.Input[builtins.str] lookup_reference_string: The lookup reference as a string.
        :param pulumi.Input[builtins.str] max_matches: (Updatable) The maximum number of matches.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupReferringSourceArgs', 'NamespaceLookupReferringSourceArgsDict']]]] referring_sources: AutoLookups
        :param pulumi.Input[builtins.str] register_lookup_file: Path to the file containing data for lookup creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceLookupStatusSummaryArgs', 'NamespaceLookupStatusSummaryArgsDict']]]] status_summaries: StatusSummary
        :param pulumi.Input[builtins.str] time_updated: The last updated date.
        :param pulumi.Input[builtins.str] type: The lookup type. Valid values are Lookup, Dictionary or Module.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceLookupState.__new__(_NamespaceLookupState)

        __props__.__dict__["active_edit_version"] = active_edit_version
        __props__.__dict__["canonical_link"] = canonical_link
        __props__.__dict__["categories"] = categories
        __props__.__dict__["char_encoding"] = char_encoding
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["default_match_value"] = default_match_value
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["edit_version"] = edit_version
        __props__.__dict__["fields"] = fields
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_built_in"] = is_built_in
        __props__.__dict__["is_hidden"] = is_hidden
        __props__.__dict__["lookup_display_name"] = lookup_display_name
        __props__.__dict__["lookup_id"] = lookup_id
        __props__.__dict__["lookup_name"] = lookup_name
        __props__.__dict__["lookup_reference"] = lookup_reference
        __props__.__dict__["lookup_reference_string"] = lookup_reference_string
        __props__.__dict__["max_matches"] = max_matches
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["referring_sources"] = referring_sources
        __props__.__dict__["register_lookup_file"] = register_lookup_file
        __props__.__dict__["status_summaries"] = status_summaries
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return NamespaceLookup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeEditVersion")
    def active_edit_version(self) -> pulumi.Output[builtins.str]:
        """
        The active edit version.
        """
        return pulumi.get(self, "active_edit_version")

    @property
    @pulumi.getter(name="canonicalLink")
    def canonical_link(self) -> pulumi.Output[builtins.str]:
        """
        The canonical link.
        """
        return pulumi.get(self, "canonical_link")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.NamespaceLookupCategory']]:
        """
        (Updatable) An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice. Oracle-defined category assignments cannot be removed.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The character encoding of the uploaded file.
        """
        return pulumi.get(self, "char_encoding")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultMatchValue")
    def default_match_value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The default match value.
        """
        return pulumi.get(self, "default_match_value")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The lookup description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="editVersion")
    def edit_version(self) -> pulumi.Output[builtins.str]:
        """
        The edit version.
        """
        return pulumi.get(self, "edit_version")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Sequence['outputs.NamespaceLookupField']]:
        """
        (Updatable) The lookup fields.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isBuiltIn")
    def is_built_in(self) -> pulumi.Output[builtins.str]:
        """
        A flag indicating if the lookup is custom (user-defined) or built in.
        """
        return pulumi.get(self, "is_built_in")

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> pulumi.Output[builtins.bool]:
        """
        A flag indicating whether or not the new lookup should be hidden.
        """
        return pulumi.get(self, "is_hidden")

    @property
    @pulumi.getter(name="lookupDisplayName")
    def lookup_display_name(self) -> pulumi.Output[builtins.str]:
        """
        The lookup display name.
        """
        return pulumi.get(self, "lookup_display_name")

    @property
    @pulumi.getter(name="lookupId")
    def lookup_id(self) -> pulumi.Output[builtins.str]:
        """
        The lookup OCID.
        """
        return pulumi.get(self, "lookup_id")

    @property
    @pulumi.getter(name="lookupName")
    def lookup_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the lookup to operate on.
        """
        return pulumi.get(self, "lookup_name")

    @property
    @pulumi.getter(name="lookupReference")
    def lookup_reference(self) -> pulumi.Output[builtins.str]:
        """
        The lookup reference as an integer.
        """
        return pulumi.get(self, "lookup_reference")

    @property
    @pulumi.getter(name="lookupReferenceString")
    def lookup_reference_string(self) -> pulumi.Output[builtins.str]:
        """
        The lookup reference as a string.
        """
        return pulumi.get(self, "lookup_reference_string")

    @property
    @pulumi.getter(name="maxMatches")
    def max_matches(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The maximum number of matches.
        """
        return pulumi.get(self, "max_matches")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="referringSources")
    def referring_sources(self) -> pulumi.Output[Sequence['outputs.NamespaceLookupReferringSource']]:
        """
        AutoLookups
        """
        return pulumi.get(self, "referring_sources")

    @property
    @pulumi.getter(name="registerLookupFile")
    def register_lookup_file(self) -> pulumi.Output[builtins.str]:
        """
        Path to the file containing data for lookup creation.
        """
        return pulumi.get(self, "register_lookup_file")

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> pulumi.Output[Sequence['outputs.NamespaceLookupStatusSummary']]:
        """
        StatusSummary
        """
        return pulumi.get(self, "status_summaries")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The last updated date.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The lookup type. Valid values are Lookup, Dictionary or Module.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

