# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ChannelSourceArgs',
    'ChannelSourceArgsDict',
    'ChannelSourceAnonymousTransactionsHandlingArgs',
    'ChannelSourceAnonymousTransactionsHandlingArgsDict',
    'ChannelSourceSslCaCertificateArgs',
    'ChannelSourceSslCaCertificateArgsDict',
    'ChannelTargetArgs',
    'ChannelTargetArgsDict',
    'ChannelTargetFilterArgs',
    'ChannelTargetFilterArgsDict',
    'HeatWaveClusterClusterNodeArgs',
    'HeatWaveClusterClusterNodeArgsDict',
    'MysqlBackupDbSystemSnapshotArgs',
    'MysqlBackupDbSystemSnapshotArgsDict',
    'MysqlBackupDbSystemSnapshotBackupPolicyArgs',
    'MysqlBackupDbSystemSnapshotBackupPolicyArgsDict',
    'MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs',
    'MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgsDict',
    'MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs',
    'MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgsDict',
    'MysqlBackupDbSystemSnapshotDataStorageArgs',
    'MysqlBackupDbSystemSnapshotDataStorageArgsDict',
    'MysqlBackupDbSystemSnapshotDeletionPolicyArgs',
    'MysqlBackupDbSystemSnapshotDeletionPolicyArgsDict',
    'MysqlBackupDbSystemSnapshotEndpointArgs',
    'MysqlBackupDbSystemSnapshotEndpointArgsDict',
    'MysqlBackupDbSystemSnapshotMaintenanceArgs',
    'MysqlBackupDbSystemSnapshotMaintenanceArgsDict',
    'MysqlBackupDbSystemSnapshotReadEndpointArgs',
    'MysqlBackupDbSystemSnapshotReadEndpointArgsDict',
    'MysqlBackupDbSystemSnapshotRestArgs',
    'MysqlBackupDbSystemSnapshotRestArgsDict',
    'MysqlBackupDbSystemSnapshotSecureConnectionArgs',
    'MysqlBackupDbSystemSnapshotSecureConnectionArgsDict',
    'MysqlBackupDbSystemSnapshotSummaryArgs',
    'MysqlBackupDbSystemSnapshotSummaryArgsDict',
    'MysqlBackupSourceDetailsArgs',
    'MysqlBackupSourceDetailsArgsDict',
    'MysqlConfigurationInitVariablesArgs',
    'MysqlConfigurationInitVariablesArgsDict',
    'MysqlConfigurationVariablesArgs',
    'MysqlConfigurationVariablesArgsDict',
    'MysqlDbSystemBackupPolicyArgs',
    'MysqlDbSystemBackupPolicyArgsDict',
    'MysqlDbSystemBackupPolicyCopyPolicyArgs',
    'MysqlDbSystemBackupPolicyCopyPolicyArgsDict',
    'MysqlDbSystemBackupPolicyPitrPolicyArgs',
    'MysqlDbSystemBackupPolicyPitrPolicyArgsDict',
    'MysqlDbSystemChannelArgs',
    'MysqlDbSystemChannelArgsDict',
    'MysqlDbSystemChannelSourceArgs',
    'MysqlDbSystemChannelSourceArgsDict',
    'MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs',
    'MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgsDict',
    'MysqlDbSystemChannelSourceSslCaCertificateArgs',
    'MysqlDbSystemChannelSourceSslCaCertificateArgsDict',
    'MysqlDbSystemChannelTargetArgs',
    'MysqlDbSystemChannelTargetArgsDict',
    'MysqlDbSystemChannelTargetFilterArgs',
    'MysqlDbSystemChannelTargetFilterArgsDict',
    'MysqlDbSystemCurrentPlacementArgs',
    'MysqlDbSystemCurrentPlacementArgsDict',
    'MysqlDbSystemCustomerContactArgs',
    'MysqlDbSystemCustomerContactArgsDict',
    'MysqlDbSystemDataStorageArgs',
    'MysqlDbSystemDataStorageArgsDict',
    'MysqlDbSystemDeletionPolicyArgs',
    'MysqlDbSystemDeletionPolicyArgsDict',
    'MysqlDbSystemEndpointArgs',
    'MysqlDbSystemEndpointArgsDict',
    'MysqlDbSystemHeatWaveClusterArgs',
    'MysqlDbSystemHeatWaveClusterArgsDict',
    'MysqlDbSystemMaintenanceArgs',
    'MysqlDbSystemMaintenanceArgsDict',
    'MysqlDbSystemPointInTimeRecoveryDetailArgs',
    'MysqlDbSystemPointInTimeRecoveryDetailArgsDict',
    'MysqlDbSystemReadEndpointArgs',
    'MysqlDbSystemReadEndpointArgsDict',
    'MysqlDbSystemRestArgs',
    'MysqlDbSystemRestArgsDict',
    'MysqlDbSystemSecureConnectionsArgs',
    'MysqlDbSystemSecureConnectionsArgsDict',
    'MysqlDbSystemSourceArgs',
    'MysqlDbSystemSourceArgsDict',
    'ReplicaReplicaOverridesArgs',
    'ReplicaReplicaOverridesArgsDict',
    'ReplicaSecureConnectionArgs',
    'ReplicaSecureConnectionArgsDict',
    'GetChannelsFilterArgs',
    'GetChannelsFilterArgsDict',
    'GetMysqlBackupsFilterArgs',
    'GetMysqlBackupsFilterArgsDict',
    'GetMysqlConfigurationsFilterArgs',
    'GetMysqlConfigurationsFilterArgsDict',
    'GetMysqlDbSystemsFilterArgs',
    'GetMysqlDbSystemsFilterArgsDict',
    'GetMysqlVersionFilterArgs',
    'GetMysqlVersionFilterArgsDict',
    'GetReplicasFilterArgs',
    'GetReplicasFilterArgsDict',
    'GetShapesFilterArgs',
    'GetShapesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ChannelSourceArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        (Updatable) The network address of the MySQL instance.
        """
        password: pulumi.Input[builtins.str]
        """
        (Updatable) The password for the replication user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        """
        source_type: pulumi.Input[builtins.str]
        """
        (Updatable) The specific source identifier.
        """
        ssl_mode: pulumi.Input[builtins.str]
        """
        (Updatable) The SSL mode of the Channel.
        """
        username: pulumi.Input[builtins.str]
        """
        (Updatable) The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        anonymous_transactions_handling: NotRequired[pulumi.Input['ChannelSourceAnonymousTransactionsHandlingArgsDict']]
        """
        (Updatable) Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The port the source MySQL instance listens on.
        """
        ssl_ca_certificate: NotRequired[pulumi.Input['ChannelSourceSslCaCertificateArgsDict']]
        """
        (Updatable) The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
elif False:
    ChannelSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelSourceArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 source_type: pulumi.Input[builtins.str],
                 ssl_mode: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 anonymous_transactions_handling: Optional[pulumi.Input['ChannelSourceAnonymousTransactionsHandlingArgs']] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 ssl_ca_certificate: Optional[pulumi.Input['ChannelSourceSslCaCertificateArgs']] = None):
        """
        :param pulumi.Input[builtins.str] hostname: (Updatable) The network address of the MySQL instance.
        :param pulumi.Input[builtins.str] password: (Updatable) The password for the replication user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        :param pulumi.Input[builtins.str] source_type: (Updatable) The specific source identifier.
        :param pulumi.Input[builtins.str] ssl_mode: (Updatable) The SSL mode of the Channel.
        :param pulumi.Input[builtins.str] username: (Updatable) The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        :param pulumi.Input['ChannelSourceAnonymousTransactionsHandlingArgs'] anonymous_transactions_handling: (Updatable) Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param pulumi.Input[builtins.int] port: (Updatable) The port the source MySQL instance listens on.
        :param pulumi.Input['ChannelSourceSslCaCertificateArgs'] ssl_ca_certificate: (Updatable) The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "username", username)
        if anonymous_transactions_handling is not None:
            pulumi.set(__self__, "anonymous_transactions_handling", anonymous_transactions_handling)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_ca_certificate is not None:
            pulumi.set(__self__, "ssl_ca_certificate", ssl_ca_certificate)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The network address of the MySQL instance.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The password for the replication user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="anonymousTransactionsHandling")
    def anonymous_transactions_handling(self) -> Optional[pulumi.Input['ChannelSourceAnonymousTransactionsHandlingArgs']]:
        """
        (Updatable) Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handling")

    @anonymous_transactions_handling.setter
    def anonymous_transactions_handling(self, value: Optional[pulumi.Input['ChannelSourceAnonymousTransactionsHandlingArgs']]):
        pulumi.set(self, "anonymous_transactions_handling", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The port the source MySQL instance listens on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sslCaCertificate")
    def ssl_ca_certificate(self) -> Optional[pulumi.Input['ChannelSourceSslCaCertificateArgs']]:
        """
        (Updatable) The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificate")

    @ssl_ca_certificate.setter
    def ssl_ca_certificate(self, value: Optional[pulumi.Input['ChannelSourceSslCaCertificateArgs']]):
        pulumi.set(self, "ssl_ca_certificate", value)


if not MYPY:
    class ChannelSourceAnonymousTransactionsHandlingArgsDict(TypedDict):
        policy: pulumi.Input[builtins.str]
        """
        (Updatable) Specifies how the replication channel handles anonymous transactions.
        """
        last_configured_log_filename: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        last_configured_log_offset: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        uuid: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
elif False:
    ChannelSourceAnonymousTransactionsHandlingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelSourceAnonymousTransactionsHandlingArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[builtins.str],
                 last_configured_log_filename: Optional[pulumi.Input[builtins.str]] = None,
                 last_configured_log_offset: Optional[pulumi.Input[builtins.str]] = None,
                 uuid: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] policy: (Updatable) Specifies how the replication channel handles anonymous transactions.
        :param pulumi.Input[builtins.str] last_configured_log_filename: (Updatable) Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param pulumi.Input[builtins.str] last_configured_log_offset: (Updatable) Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param pulumi.Input[builtins.str] uuid: (Updatable) The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        pulumi.set(__self__, "policy", policy)
        if last_configured_log_filename is not None:
            pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        if last_configured_log_offset is not None:
            pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @last_configured_log_filename.setter
    def last_configured_log_filename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_configured_log_filename", value)

    @property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @last_configured_log_offset.setter
    def last_configured_log_offset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_configured_log_offset", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class ChannelSourceSslCaCertificateArgsDict(TypedDict):
        certificate_type: pulumi.Input[builtins.str]
        """
        (Updatable) The type of CA certificate.
        """
        contents: pulumi.Input[builtins.str]
        """
        (Updatable) The string containing the CA certificate in PEM format.
        """
elif False:
    ChannelSourceSslCaCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelSourceSslCaCertificateArgs:
    def __init__(__self__, *,
                 certificate_type: pulumi.Input[builtins.str],
                 contents: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] certificate_type: (Updatable) The type of CA certificate.
        :param pulumi.Input[builtins.str] contents: (Updatable) The string containing the CA certificate in PEM format.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "contents", contents)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_type", value)

    @property
    @pulumi.getter
    def contents(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "contents", value)


if not MYPY:
    class ChannelTargetArgsDict(TypedDict):
        db_system_id: pulumi.Input[builtins.str]
        """
        The OCID of the target DB System.
        """
        target_type: pulumi.Input[builtins.str]
        """
        (Updatable) The specific target identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        applier_username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The username for the replication applier of the target MySQL DB System.
        """
        channel_name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        delay_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChannelTargetFilterArgsDict']]]]
        """
        (Updatable) Replication filter rules to be applied at the DB System Channel target.
        """
        tables_without_primary_key_handling: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key. The default value is set to ALLOW.
        """
elif False:
    ChannelTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelTargetArgs:
    def __init__(__self__, *,
                 db_system_id: pulumi.Input[builtins.str],
                 target_type: pulumi.Input[builtins.str],
                 applier_username: Optional[pulumi.Input[builtins.str]] = None,
                 channel_name: Optional[pulumi.Input[builtins.str]] = None,
                 delay_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelTargetFilterArgs']]]] = None,
                 tables_without_primary_key_handling: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] db_system_id: The OCID of the target DB System.
        :param pulumi.Input[builtins.str] target_type: (Updatable) The specific target identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] applier_username: (Updatable) The username for the replication applier of the target MySQL DB System.
        :param pulumi.Input[builtins.str] channel_name: (Updatable) The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param pulumi.Input[builtins.int] delay_in_seconds: (Updatable) Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelTargetFilterArgs']]] filters: (Updatable) Replication filter rules to be applied at the DB System Channel target.
        :param pulumi.Input[builtins.str] tables_without_primary_key_handling: (Updatable) Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key. The default value is set to ALLOW.
        """
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "target_type", target_type)
        if applier_username is not None:
            pulumi.set(__self__, "applier_username", applier_username)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if delay_in_seconds is not None:
            pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if tables_without_primary_key_handling is not None:
            pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the target DB System.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The specific target identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @applier_username.setter
    def applier_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "applier_username", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @delay_in_seconds.setter
    def delay_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "delay_in_seconds", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelTargetFilterArgs']]]]:
        """
        (Updatable) Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelTargetFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key. The default value is set to ALLOW.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @tables_without_primary_key_handling.setter
    def tables_without_primary_key_handling(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tables_without_primary_key_handling", value)


if not MYPY:
    class ChannelTargetFilterArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        (Updatable) The type of the filter rule.

        For details on each type, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html)
        """
        value: pulumi.Input[builtins.str]
        """
        (Updatable) The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
elif False:
    ChannelTargetFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelTargetFilterArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] type: (Updatable) The type of the filter rule.
               
               For details on each type, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html)
        :param pulumi.Input[builtins.str] value: (Updatable) The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The type of the filter rule.

        For details on each type, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class HeatWaveClusterClusterNodeArgsDict(TypedDict):
        node_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the node within MySQL HeatWave cluster.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        time_created: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        time_updated: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
elif False:
    HeatWaveClusterClusterNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HeatWaveClusterClusterNodeArgs:
    def __init__(__self__, *,
                 node_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] node_id: The ID of the node within MySQL HeatWave cluster.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the node within MySQL HeatWave cluster.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotArgsDict(TypedDict):
        admin_username: NotRequired[pulumi.Input[builtins.str]]
        """
        The username for the administrative user.
        """
        availability_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        The Availability Domain where the primary DB System should be located.
        """
        backup_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyArgsDict']]]]
        """
        The Backup policy for the DB System.
        """
        compartment_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        configuration_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the Configuration to be used for Instances in this DB System.
        """
        crash_recovery: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        data_storage_size_in_gb: NotRequired[pulumi.Input[builtins.int]]
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        data_storages: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDataStorageArgsDict']]]]
        """
        Data Storage information.
        """
        database_management: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether to enable monitoring via the Database Management service.
        """
        defined_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        deletion_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDeletionPolicyArgsDict']]]]
        """
        The Deletion policy for the DB System.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A user-supplied description for the backup.
        """
        display_name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A user-supplied display name for the backup.
        """
        endpoints: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotEndpointArgsDict']]]]
        """
        The network endpoints available for this DB System.
        """
        fault_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Fault Domain the DB System is located in.
        """
        freeform_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        hostname_label: NotRequired[pulumi.Input[builtins.str]]
        """
        The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the backup itself
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        is_highly_available: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies if the DB System is highly available.
        """
        maintenances: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotMaintenanceArgsDict']]]]
        """
        The Maintenance Policy for the DB System or Read Replica that this model is included in.
        """
        mysql_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The MySQL server version of the DB System used for backup.
        """
        nsg_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        port_x: NotRequired[pulumi.Input[builtins.int]]
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        read_endpoints: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotReadEndpointArgsDict']]]]
        """
        The read endpoint of a DB System.
        """
        region: NotRequired[pulumi.Input[builtins.str]]
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        rests: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotRestArgsDict']]]]
        """
        REST configuration details.
        """
        secure_connections: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSecureConnectionArgsDict']]]]
        """
        Secure connection configuration details.
        """
        shape_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The shape of the DB System instance used for backup.
        """
        subnet_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the subnet the DB System is associated with.
        """
elif False:
    MysqlBackupDbSystemSnapshotArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotArgs:
    def __init__(__self__, *,
                 admin_username: Optional[pulumi.Input[builtins.str]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 backup_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 crash_recovery: Optional[pulumi.Input[builtins.str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 data_storages: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDataStorageArgs']]]] = None,
                 database_management: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 deletion_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDeletionPolicyArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotEndpointArgs']]]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_highly_available: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenances: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotMaintenanceArgs']]]] = None,
                 mysql_version: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 port_x: Optional[pulumi.Input[builtins.int]] = None,
                 read_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotReadEndpointArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rests: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotRestArgs']]]] = None,
                 secure_connections: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSecureConnectionArgs']]]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] admin_username: The username for the administrative user.
        :param pulumi.Input[builtins.str] availability_domain: The Availability Domain where the primary DB System should be located.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyArgs']]] backup_policies: The Backup policy for the DB System.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param pulumi.Input[builtins.str] configuration_id: The OCID of the Configuration to be used for Instances in this DB System.
        :param pulumi.Input[builtins.str] crash_recovery: Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param pulumi.Input[builtins.int] data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDataStorageArgs']]] data_storages: Data Storage information.
        :param pulumi.Input[builtins.str] database_management: Whether to enable monitoring via the Database Management service.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDeletionPolicyArgs']]] deletion_policies: The Deletion policy for the DB System.
        :param pulumi.Input[builtins.str] description: (Updatable) A user-supplied description for the backup.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-supplied display name for the backup.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotEndpointArgs']]] endpoints: The network endpoints available for this DB System.
        :param pulumi.Input[builtins.str] fault_domain: The name of the Fault Domain the DB System is located in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param pulumi.Input[builtins.str] id: OCID of the backup itself
        :param pulumi.Input[builtins.str] ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[builtins.bool] is_highly_available: Specifies if the DB System is highly available.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotMaintenanceArgs']]] maintenances: The Maintenance Policy for the DB System or Read Replica that this model is included in.
        :param pulumi.Input[builtins.str] mysql_version: The MySQL server version of the DB System used for backup.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param pulumi.Input[builtins.int] port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param pulumi.Input[builtins.int] port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotReadEndpointArgs']]] read_endpoints: The read endpoint of a DB System.
        :param pulumi.Input[builtins.str] region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotRestArgs']]] rests: REST configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSecureConnectionArgs']]] secure_connections: Secure connection configuration details.
        :param pulumi.Input[builtins.str] shape_name: The shape of the DB System instance used for backup.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of the subnet the DB System is associated with.
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if crash_recovery is not None:
            pulumi.set(__self__, "crash_recovery", crash_recovery)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storages is not None:
            pulumi.set(__self__, "data_storages", data_storages)
        if database_management is not None:
            pulumi.set(__self__, "database_management", database_management)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_policies is not None:
            pulumi.set(__self__, "deletion_policies", deletion_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_highly_available is not None:
            pulumi.set(__self__, "is_highly_available", is_highly_available)
        if maintenances is not None:
            pulumi.set(__self__, "maintenances", maintenances)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if read_endpoints is not None:
            pulumi.set(__self__, "read_endpoints", read_endpoints)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rests is not None:
            pulumi.set(__self__, "rests", rests)
        if secure_connections is not None:
            pulumi.set(__self__, "secure_connections", secure_connections)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the administrative user.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Availability Domain where the primary DB System should be located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyArgs']]]]:
        """
        The Backup policy for the DB System.
        """
        return pulumi.get(self, "backup_policies")

    @backup_policies.setter
    def backup_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyArgs']]]]):
        pulumi.set(self, "backup_policies", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Configuration to be used for Instances in this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @crash_recovery.setter
    def crash_recovery(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crash_recovery", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorages")
    def data_storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDataStorageArgs']]]]:
        """
        Data Storage information.
        """
        return pulumi.get(self, "data_storages")

    @data_storages.setter
    def data_storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDataStorageArgs']]]]):
        pulumi.set(self, "data_storages", value)

    @property
    @pulumi.getter(name="databaseManagement")
    def database_management(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to enable monitoring via the Database Management service.
        """
        return pulumi.get(self, "database_management")

    @database_management.setter
    def database_management(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_management", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDeletionPolicyArgs']]]]:
        """
        The Deletion policy for the DB System.
        """
        return pulumi.get(self, "deletion_policies")

    @deletion_policies.setter
    def deletion_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotDeletionPolicyArgs']]]]):
        pulumi.set(self, "deletion_policies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotEndpointArgs']]]]:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Fault Domain the DB System is located in.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the DB System is highly available.
        """
        return pulumi.get(self, "is_highly_available")

    @is_highly_available.setter
    def is_highly_available(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_highly_available", value)

    @property
    @pulumi.getter
    def maintenances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotMaintenanceArgs']]]]:
        """
        The Maintenance Policy for the DB System or Read Replica that this model is included in.
        """
        return pulumi.get(self, "maintenances")

    @maintenances.setter
    def maintenances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotMaintenanceArgs']]]]):
        pulumi.set(self, "maintenances", value)

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mysql_version", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @port_x.setter
    def port_x(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port_x", value)

    @property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotReadEndpointArgs']]]]:
        """
        The read endpoint of a DB System.
        """
        return pulumi.get(self, "read_endpoints")

    @read_endpoints.setter
    def read_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotReadEndpointArgs']]]]):
        pulumi.set(self, "read_endpoints", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def rests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotRestArgs']]]]:
        """
        REST configuration details.
        """
        return pulumi.get(self, "rests")

    @rests.setter
    def rests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotRestArgs']]]]):
        pulumi.set(self, "rests", value)

    @property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSecureConnectionArgs']]]]:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @secure_connections.setter
    def secure_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSecureConnectionArgs']]]]):
        pulumi.set(self, "secure_connections", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotBackupPolicyArgsDict(TypedDict):
        copy_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgsDict']]]]
        """
        List of policies of a DB system to schedule cross-region DB system backup copy.
        """
        defined_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        freeform_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        pitr_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgsDict']]]]
        """
        The PITR policy for the DB System.
        """
        retention_in_days: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) Number of days to retain this backup.
        """
        window_start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The start time of the maintenance window.
        """
elif False:
    MysqlBackupDbSystemSnapshotBackupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotBackupPolicyArgs:
    def __init__(__self__, *,
                 copy_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pitr_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs']]]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 window_start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs']]] copy_policies: List of policies of a DB system to schedule cross-region DB system backup copy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs']]] pitr_policies: The PITR policy for the DB System.
        :param pulumi.Input[builtins.int] retention_in_days: (Updatable) Number of days to retain this backup.
        :param pulumi.Input[builtins.str] window_start_time: The start time of the maintenance window.
        """
        if copy_policies is not None:
            pulumi.set(__self__, "copy_policies", copy_policies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if pitr_policies is not None:
            pulumi.set(__self__, "pitr_policies", pitr_policies)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs']]]]:
        """
        List of policies of a DB system to schedule cross-region DB system backup copy.
        """
        return pulumi.get(self, "copy_policies")

    @copy_policies.setter
    def copy_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs']]]]):
        pulumi.set(self, "copy_policies", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="pitrPolicies")
    def pitr_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs']]]]:
        """
        The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policies")

    @pitr_policies.setter
    def pitr_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs']]]]):
        pulumi.set(self, "pitr_policies", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "window_start_time", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgsDict(TypedDict):
        backup_copy_retention_in_days: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of days to retain the copied DB system backup.
        """
        copy_to_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The destination region name to which the DB system backup will be copied.
        """
elif False:
    MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs:
    def __init__(__self__, *,
                 backup_copy_retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 copy_to_region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] backup_copy_retention_in_days: Number of days to retain the copied DB system backup.
        :param pulumi.Input[builtins.str] copy_to_region: The destination region name to which the DB system backup will be copied.
        """
        if backup_copy_retention_in_days is not None:
            pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)
        if copy_to_region is not None:
            pulumi.set(__self__, "copy_to_region", copy_to_region)

    @property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")

    @backup_copy_retention_in_days.setter
    def backup_copy_retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_copy_retention_in_days", value)

    @property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")

    @copy_to_region.setter
    def copy_to_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "copy_to_region", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgsDict(TypedDict):
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
elif False:
    MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs:
    def __init__(__self__, *,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] is_enabled: Specifies if the DB System read endpoint is enabled or not.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotDataStorageArgsDict(TypedDict):
        allocated_storage_size_in_gbs: NotRequired[pulumi.Input[builtins.int]]
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        data_storage_size_in_gb: NotRequired[pulumi.Input[builtins.int]]
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        data_storage_size_limit_in_gbs: NotRequired[pulumi.Input[builtins.int]]
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        is_auto_expand_storage_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        max_storage_size_in_gbs: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
elif False:
    MysqlBackupDbSystemSnapshotDataStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotDataStorageArgs:
    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 data_storage_size_limit_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 is_auto_expand_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param pulumi.Input[builtins.int] data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param pulumi.Input[builtins.int] data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param pulumi.Input[builtins.bool] is_auto_expand_storage_enabled: Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param pulumi.Input[builtins.int] max_storage_size_in_gbs: Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        if allocated_storage_size_in_gbs is not None:
            pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_limit_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        if is_auto_expand_storage_enabled is not None:
            pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        if max_storage_size_in_gbs is not None:
            pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @allocated_storage_size_in_gbs.setter
    def allocated_storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocated_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @data_storage_size_limit_in_gbs.setter
    def data_storage_size_limit_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "data_storage_size_limit_in_gbs", value)

    @property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @is_auto_expand_storage_enabled.setter
    def is_auto_expand_storage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_expand_storage_enabled", value)

    @property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")

    @max_storage_size_in_gbs.setter
    def max_storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_storage_size_in_gbs", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotDeletionPolicyArgsDict(TypedDict):
        automatic_backup_retention: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        final_backup: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        is_delete_protected: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
elif False:
    MysqlBackupDbSystemSnapshotDeletionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotDeletionPolicyArgs:
    def __init__(__self__, *,
                 automatic_backup_retention: Optional[pulumi.Input[builtins.str]] = None,
                 final_backup: Optional[pulumi.Input[builtins.str]] = None,
                 is_delete_protected: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] automatic_backup_retention: Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param pulumi.Input[builtins.str] final_backup: Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param pulumi.Input[builtins.bool] is_delete_protected: Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        if automatic_backup_retention is not None:
            pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        if final_backup is not None:
            pulumi.set(__self__, "final_backup", final_backup)
        if is_delete_protected is not None:
            pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @automatic_backup_retention.setter
    def automatic_backup_retention(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automatic_backup_retention", value)

    @property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @final_backup.setter
    def final_backup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "final_backup", value)

    @property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")

    @is_delete_protected.setter
    def is_delete_protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_delete_protected", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotEndpointArgsDict(TypedDict):
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        The network address of the DB System.
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        modes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The access modes from the client that this endpoint supports.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        port_x: NotRequired[pulumi.Input[builtins.int]]
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the resource that this endpoint is attached to.
        """
        resource_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of endpoint that clients and connectors can connect to.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        status_details: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional information about the current endpoint status.
        """
elif False:
    MysqlBackupDbSystemSnapshotEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotEndpointArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 port_x: Optional[pulumi.Input[builtins.int]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_details: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: The network address of the DB System.
        :param pulumi.Input[builtins.str] ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modes: The access modes from the client that this endpoint supports.
        :param pulumi.Input[builtins.int] port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param pulumi.Input[builtins.int] port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[builtins.str] resource_id: The OCID of the resource that this endpoint is attached to.
        :param pulumi.Input[builtins.str] resource_type: The type of endpoint that clients and connectors can connect to.
        :param pulumi.Input[builtins.str] status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param pulumi.Input[builtins.str] status_details: Additional information about the current endpoint status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if modes is not None:
            pulumi.set(__self__, "modes", modes)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @modes.setter
    def modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "modes", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @port_x.setter
    def port_x(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port_x", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")

    @status_details.setter
    def status_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_details", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotMaintenanceArgsDict(TypedDict):
        window_start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The start time of the maintenance window.
        """
elif False:
    MysqlBackupDbSystemSnapshotMaintenanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotMaintenanceArgs:
    def __init__(__self__, *,
                 window_start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] window_start_time: The start time of the maintenance window.
        """
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "window_start_time", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotReadEndpointArgsDict(TypedDict):
        exclude_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        read_endpoint_hostname_label: NotRequired[pulumi.Input[builtins.str]]
        """
        The hostname for the read endpoint of the DB System. Used for DNS.
        """
        read_endpoint_ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
elif False:
    MysqlBackupDbSystemSnapshotReadEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotReadEndpointArgs:
    def __init__(__self__, *,
                 exclude_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 read_endpoint_hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 read_endpoint_ip_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude_ips: A list of IP addresses of read replicas that are excluded from serving read requests.
        :param pulumi.Input[builtins.bool] is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param pulumi.Input[builtins.str] read_endpoint_hostname_label: The hostname for the read endpoint of the DB System. Used for DNS.
        :param pulumi.Input[builtins.str] read_endpoint_ip_address: The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        if exclude_ips is not None:
            pulumi.set(__self__, "exclude_ips", exclude_ips)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if read_endpoint_hostname_label is not None:
            pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        if read_endpoint_ip_address is not None:
            pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @exclude_ips.setter
    def exclude_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exclude_ips", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname for the read endpoint of the DB System. Used for DNS.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @read_endpoint_hostname_label.setter
    def read_endpoint_hostname_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_endpoint_hostname_label", value)

    @property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")

    @read_endpoint_ip_address.setter
    def read_endpoint_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_endpoint_ip_address", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotRestArgsDict(TypedDict):
        configuration: NotRequired[pulumi.Input[builtins.str]]
        """
        Select how REST is configured across the DB System instances.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
elif False:
    MysqlBackupDbSystemSnapshotRestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotRestArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] configuration: Select how REST is configured across the DB System instances.
        :param pulumi.Input[builtins.int] port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotSecureConnectionArgsDict(TypedDict):
        certificate_generation_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        certificate_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the certificate to use.
        """
elif False:
    MysqlBackupDbSystemSnapshotSecureConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotSecureConnectionArgs:
    def __init__(__self__, *,
                 certificate_generation_type: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param pulumi.Input[builtins.str] certificate_id: The OCID of the certificate to use.
        """
        if certificate_generation_type is not None:
            pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @certificate_generation_type.setter
    def certificate_generation_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_generation_type", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_id", value)


if not MYPY:
    class MysqlBackupDbSystemSnapshotSummaryArgsDict(TypedDict):
        display_name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A user-supplied display name for the backup.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the backup itself
        """
        region: NotRequired[pulumi.Input[builtins.str]]
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
elif False:
    MysqlBackupDbSystemSnapshotSummaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupDbSystemSnapshotSummaryArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-supplied display name for the backup.
        :param pulumi.Input[builtins.str] id: OCID of the backup itself
        :param pulumi.Input[builtins.str] region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


if not MYPY:
    class MysqlBackupSourceDetailsArgsDict(TypedDict):
        backup_id: pulumi.Input[builtins.str]
        """
        The OCID of the source backup.
        """
        compartment_id: pulumi.Input[builtins.str]
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        region: pulumi.Input[builtins.str]
        """
        The region of the backup source.
        """
elif False:
    MysqlBackupSourceDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlBackupSourceDetailsArgs:
    def __init__(__self__, *,
                 backup_id: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 region: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] backup_id: The OCID of the source backup.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param pulumi.Input[builtins.str] region: The region of the backup source.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the source backup.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        The region of the backup source.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)


if not MYPY:
    class MysqlConfigurationInitVariablesArgsDict(TypedDict):
        lower_case_table_names: NotRequired[pulumi.Input[builtins.str]]
        """
        Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).

        lowerCaseTableNames controls case-sensitivity of tables and schema names and how they are stored in the DB System.

        Valid values are:
        * CASE_SENSITIVE - (default) Table and schema name comparisons are case-sensitive and stored as specified. (lower_case_table_names=0)
        * CASE_INSENSITIVE_LOWERCASE - Table and schema name comparisons are not case-sensitive and stored in lowercase. (lower_case_table_names=1)
        """
elif False:
    MysqlConfigurationInitVariablesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlConfigurationInitVariablesArgs:
    def __init__(__self__, *,
                 lower_case_table_names: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] lower_case_table_names: Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).
               
               lowerCaseTableNames controls case-sensitivity of tables and schema names and how they are stored in the DB System.
               
               Valid values are:
               * CASE_SENSITIVE - (default) Table and schema name comparisons are case-sensitive and stored as specified. (lower_case_table_names=0)
               * CASE_INSENSITIVE_LOWERCASE - Table and schema name comparisons are not case-sensitive and stored in lowercase. (lower_case_table_names=1)
        """
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).

        lowerCaseTableNames controls case-sensitivity of tables and schema names and how they are stored in the DB System.

        Valid values are:
        * CASE_SENSITIVE - (default) Table and schema name comparisons are case-sensitive and stored as specified. (lower_case_table_names=0)
        * CASE_INSENSITIVE_LOWERCASE - Table and schema name comparisons are not case-sensitive and stored in lowercase. (lower_case_table_names=1)
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lower_case_table_names", value)


if not MYPY:
    class MysqlConfigurationVariablesArgsDict(TypedDict):
        auto_increment_increment: NotRequired[pulumi.Input[builtins.int]]
        """
        auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.

        autoIncrementIncrement corresponds to the MySQL Replication Source Options variable [auto_increment_increment] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment).
        """
        auto_increment_offset: NotRequired[pulumi.Input[builtins.int]]
        """
        This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.

        autoIncrementOffset corresponds to the MySQL Replication Source Options variable [auto_increment_offset] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset).
        """
        autocommit: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("autocommit")
        """
        big_tables: NotRequired[pulumi.Input[builtins.bool]]
        """
        If enabled, the server stores all temporary tables on disk rather than in memory.

        bigTables corresponds to the MySQL server variable [big_tables](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_big_tables).
        """
        binlog_expire_logs_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        """
        binlog_group_commit_sync_delay: NotRequired[pulumi.Input[builtins.int]]
        """
        Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.

        binlogGroupCommitSyncDelay corresponds to the MySQL Replication system variable [binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)
        """
        binlog_group_commit_sync_no_delay_count: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.

        binlogGroupCommitSyncNoDelayCount corresponds to the MySQL Replication system variable [binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)
        """
        binlog_row_metadata: NotRequired[pulumi.Input[builtins.str]]
        """
        Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        """
        binlog_row_value_options: NotRequired[pulumi.Input[builtins.str]]
        """
        When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        """
        binlog_transaction_compression: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        """
        block_encryption_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.

        block_encryption_mode corresponds to the MySQL Server Administration system variable [block_encryption_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)
        """
        character_set_server: NotRequired[pulumi.Input[builtins.str]]
        """
        The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.

        characterSetServer corresponds to the MySQL server variable [character_set_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_character_set_server).
        """
        collation_server: NotRequired[pulumi.Input[builtins.str]]
        """
        The server's default collation.

        collationServer corresponds to the MySQL server variable [collation_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_collation_server).
        """
        completion_type: NotRequired[pulumi.Input[builtins.str]]
        """
        ("completion_type")
        """
        connect_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.

        connectTimeout corresponds to the MySQL system variable [connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)

        Increasing the connect_timeout value might help if clients frequently encounter errors of the form "Lost connection to MySQL server at 'XXX', system error: errno".
        """
        connection_memory_chunk_size: NotRequired[pulumi.Input[builtins.int]]
        """
        Set the chunking size for updates to the global memory usage counter Global_connection_memory.

        connectionMemoryChunkSize corresponds to the MySQL system variable [connection_memory_chunk_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_chunk_size).
        """
        connection_memory_limit: NotRequired[pulumi.Input[builtins.str]]
        """
        Set the maximum amount of memory that can be used by a single user connection.

        connectionMemoryLimit corresponds to the MySQL system variable [connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_limit).
        """
        cte_max_recursion_depth: NotRequired[pulumi.Input[builtins.str]]
        """
        ("cte_max_recursion_depth")
        """
        default_authentication_plugin: NotRequired[pulumi.Input[builtins.str]]
        """
        The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.

        As of MySQL 8.0.27, which introduces multifactor authentication, default_authentication_plugin is still used, but in conjunction with and at a lower precedence than the authentication_policy system variable. For details, see The Default Authentication Plugin. Because of this diminished role, default_authentication_plugin is deprecated as of MySQL 8.0.27 and subject to removal in a future MySQL version.

        defaultAuthenticationPlugin corresponds to the MySQL system variable [default_authentication_plugin](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin).
        """
        explain_format: NotRequired[pulumi.Input[builtins.str]]
        """
        This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.

        explainFormat corresponds to the MySQL system variable [explain_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explain_format).
        """
        explicit_defaults_for_timestamp: NotRequired[pulumi.Input[builtins.bool]]
        """
        This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.

        explicit_defaults_for_timestamp corresponds to the MySQL Server Administration system variable [explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)
        """
        foreign_key_checks: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("foreign_key_checks")
        """
        generated_random_password_length: NotRequired[pulumi.Input[builtins.int]]
        """
        ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        """
        global_connection_memory_limit: NotRequired[pulumi.Input[builtins.str]]
        """
        Set the total amount of memory that can be used by all user connections.

        globalConnectionMemoryLimit corresponds to the MySQL system variable [global_connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_limit).
        """
        global_connection_memory_tracking: NotRequired[pulumi.Input[builtins.bool]]
        """
        Determines whether the MySQL server calculates Global_connection_memory.

        globalConnectionMemoryTracking corresponds to the MySQL system variable [global_connection_memory_tracking](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_tracking).
        """
        group_concat_max_len: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.

        This is the MySQL variable "group_concat_max_len". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)
        """
        group_replication_consistency: NotRequired[pulumi.Input[builtins.str]]
        """
        * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
        * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
        * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        """
        information_schema_stats_expiry: NotRequired[pulumi.Input[builtins.int]]
        """
        ("information_schema_stats_expiry")
        """
        innodb_adaptive_hash_index: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.

        innodbAdaptiveHashIndex corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_adaptive_hash_index] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index).
        """
        innodb_autoinc_lock_mode: NotRequired[pulumi.Input[builtins.int]]
        """
        The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.

        innodbAutoincLockMode corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_autoinc_lock_mode] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode).
        """
        innodb_buffer_pool_dump_pct: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.

        innodbBufferPoolDumpPct corresponds to the MySQL InnoDB system variable [innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct).

        The range is 1 to 100. The default value is 25.

        For example, if there are 4 buffer pools with 100 pages each, and innodb_buffer_pool_dump_pct is set to 25, the 25 most recently used pages from each buffer pool are dumped.
        """
        innodb_buffer_pool_instances: NotRequired[pulumi.Input[builtins.int]]
        """
        ("innodb_buffer_pool_instances")
        """
        innodb_buffer_pool_size: NotRequired[pulumi.Input[builtins.str]]
        """
        The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.

        innodbBufferPoolSize corresponds to the MySQL server system variable [innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size).

        The default and maximum values depend on the amount of RAM provisioned by the shape. See [Default User Variables](https://www.terraform.io/mysql-database/doc/configuring-db-system.html#GUID-B5504C19-F6F4-4DAB-8506-189A4E8F4A6A).
        """
        innodb_change_buffering: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.

        innodbChangeBuffering corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_change_buffering] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).
        """
        innodb_ddl_buffer_size: NotRequired[pulumi.Input[builtins.str]]
        """
        innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        """
        innodb_ddl_threads: NotRequired[pulumi.Input[builtins.int]]
        """
        innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        """
        innodb_ft_enable_stopword: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("innodb_ft_enable_stopword")
        """
        innodb_ft_max_token_size: NotRequired[pulumi.Input[builtins.int]]
        """
        ("innodb_ft_max_token_size")
        """
        innodb_ft_min_token_size: NotRequired[pulumi.Input[builtins.int]]
        """
        ("innodb_ft_min_token_size")
        """
        innodb_ft_num_word_optimize: NotRequired[pulumi.Input[builtins.int]]
        """
        ("innodb_ft_num_word_optimize")
        """
        innodb_ft_result_cache_limit: NotRequired[pulumi.Input[builtins.str]]
        """
        ("innodb_ft_result_cache_limit")
        """
        innodb_ft_server_stopword_table: NotRequired[pulumi.Input[builtins.str]]
        """
        ("innodb_ft_server_stopword_table")
        """
        innodb_lock_wait_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        ("innodb_lock_wait_timeout")
        """
        innodb_log_writer_threads: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.

        This is the MySQL variable "innodb_log_writer_threads". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)
        """
        innodb_max_purge_lag: NotRequired[pulumi.Input[builtins.str]]
        """
        The desired maximum purge lag in terms of transactions.

        InnoDB maintains a list of transactions that have index records delete-marked by UPDATE or DELETE operations. The length of the list is the purge lag.

        If this value is exceeded, a delay is imposed on INSERT, UPDATE, and DELETE operations to allow time for purge to catch up.

        The default value is 0, which means there is no maximum purge lag and no delay.

        innodbMaxPurgeLag corresponds to the MySQL server system variable [innodb_max_purge_lag](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag).
        """
        innodb_max_purge_lag_delay: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.

        The specified innodb_max_purge_lag_delay value is an upper limit on the delay period.

        innodbMaxPurgeLagDelay corresponds to the MySQL server system variable [innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay).
        """
        innodb_numa_interleave: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.

        innodbNumaInterleave corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_numa_interleave] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave).
        """
        innodb_online_alter_log_max_size: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.

        innodbOnlineAlterLogMaxSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_online_alter_log_max_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size).
        """
        innodb_redo_log_capacity: NotRequired[pulumi.Input[builtins.str]]
        """
        Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.

        innodbRedoLogCapacity corresponds to the InnoDB Startup Options and System Variables [innodb_redo_log_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_capacity)
        """
        innodb_rollback_on_timeout: NotRequired[pulumi.Input[builtins.bool]]
        """
        InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.

        innodbRollbackOnTimeout corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_rollback_on_timeout] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout).
        """
        innodb_sort_buffer_size: NotRequired[pulumi.Input[builtins.int]]
        """
        This variable defines:
        * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
        * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.

        innodbSortBufferSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_sort_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size).
        """
        innodb_stats_persistent_sample_pages: NotRequired[pulumi.Input[builtins.str]]
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.

        innodbStatsPersistentSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)

        innodb_stats_persistent_sample_pages only applies when innodb_stats_persistent is enabled for a table; when innodb_stats_persistent is disabled, innodb_stats_transient_sample_pages applies instead.
        """
        innodb_stats_transient_sample_pages: NotRequired[pulumi.Input[builtins.str]]
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).

        innodbStatsTransientSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)

        innodb_stats_transient_sample_pages only applies when innodb_stats_persistent is disabled for a table; when innodb_stats_persistent is enabled, innodb_stats_persistent_sample_pages applies instead.

        innodb_stats_persistent is ON by default and cannot be changed. It is possible to override it using the STATS_PERSISTENT clause of the [CREATE TABLE](https://dev.mysql.com/doc/refman/8.0/en/create-table.html) and [ALTER TABLE](https://dev.mysql.com/doc/refman/8.0/en/alter-table.html) statements.
        """
        innodb_strict_mode: NotRequired[pulumi.Input[builtins.bool]]
        """
        When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.

        innodbStrictMode corresponds to the MySQL InnoDB system variable [innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)
        """
        innodb_undo_log_truncate: NotRequired[pulumi.Input[builtins.bool]]
        """
        When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.

        innodbUndoLogTruncate corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_undo_log_truncate] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate).
        """
        interactive_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.

        interactiveTimeout corresponds to the MySQL system variable. [interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)
        """
        join_buffer_size: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.

        joinBufferSize corresponds to the MySQL Server System variable [join_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size).
        """
        local_infile: NotRequired[pulumi.Input[builtins.bool]]
        """
        This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side. 

        local_infile corresponds to the MySQL Server system variable [local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)
        """
        long_query_time: NotRequired[pulumi.Input[builtins.int]]
        """
        If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.

        longQueryTime corresponds to the MySQL Server System variable [long_query_time] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time).
        """
        mandatory_roles: NotRequired[pulumi.Input[builtins.str]]
        """
        ("mandatory_roles")
        """
        max_allowed_packet: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum size of one packet or any generated/intermediate string.

        This is the mysql variable "max_allowed_packet".
        """
        max_binlog_cache_size: NotRequired[pulumi.Input[builtins.str]]
        """
        Sets the size of the transaction cache.

        maxBinlogCacheSize corresponds to the MySQL server system variable [max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size).
        """
        max_connect_errors: NotRequired[pulumi.Input[builtins.str]]
        """
        ("max_connect_errors")
        """
        max_connections: NotRequired[pulumi.Input[builtins.int]]
        """
        ("max_connections")
        """
        max_execution_time: NotRequired[pulumi.Input[builtins.str]]
        """
        ("max_execution_time")
        """
        max_heap_table_size: NotRequired[pulumi.Input[builtins.str]]
        """
        This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.

        maxHeapTableSize corresponds to the MySQL system variable [max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)
        """
        max_prepared_stmt_count: NotRequired[pulumi.Input[builtins.int]]
        """
        ("max_prepared_stmt_count")
        """
        max_seeks_for_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.

        maxSeeksForKey corresponds to the MySQL Server System variable [max_seeks_for_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key).
        """
        max_user_connections: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.

        maxUserConnections corresponds to the MySQL Server System variable [max_user_connections] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections).
        """
        mysql_firewall_mode: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("mysql_firewall_mode")
        """
        mysql_zstd_default_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        """
        mysqlx_connect_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds X Plugin waits for the first packet to be received from newly connected clients.

        mysqlxConnectTimeout corresponds to the MySQL X Plugin system variable [mysqlx_connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_connect_timeout)
        """
        mysqlx_deflate_default_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        """
        mysqlx_deflate_max_client_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        """
        mysqlx_document_id_unique_prefix: NotRequired[pulumi.Input[builtins.int]]
        """
        ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        """
        mysqlx_enable_hello_notice: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        """
        mysqlx_idle_worker_thread_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        """
        mysqlx_interactive_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds to wait for interactive clients to timeout.

        mysqlxInteractiveTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_interactive_timeout)
        """
        mysqlx_lz4default_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        """
        mysqlx_lz4max_client_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        """
        mysqlx_max_allowed_packet: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum size of network packets that can be received by X Plugin.

        This is the mysql variable "mysqlx_max_allowed_packet".
        """
        mysqlx_min_worker_threads: NotRequired[pulumi.Input[builtins.int]]
        """
        ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        """
        mysqlx_read_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.

        mysqlxReadTimeout corresponds to the MySQL X Plugin system variable [mysqlx_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_read_timeout)
        """
        mysqlx_wait_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds that X Plugin waits for activity on a connection.

        mysqlxWaitTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_wait_timeout)
        """
        mysqlx_write_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.

        mysqlxReadmysqlxWriteTimeoutTimeout corresponds to the MySQL X Plugin system variable [mysqlx_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_write_timeout)
        """
        mysqlx_zstd_default_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        """
        mysqlx_zstd_max_client_compression_level: NotRequired[pulumi.Input[builtins.int]]
        """
        Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        """
        net_read_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds to wait for more data from a connection before aborting the read.

        netReadTimeout corresponds to the MySQL system variable [net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)
        """
        net_write_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.

        netWriteTimeout corresponds to the MySQL system variable [net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)
        """
        optimizer_switch: NotRequired[pulumi.Input[builtins.str]]
        """
        The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.

        Setting hypergraph_optimizer=on for cloud builds below 9.0.0 will fail.

        optimizerSwitch corresponds to the MySQL Server System variable [optimizer_switch] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch).
        """
        parser_max_mem_size: NotRequired[pulumi.Input[builtins.str]]
        """
        ("parser_max_mem_size")
        """
        query_alloc_block_size: NotRequired[pulumi.Input[builtins.str]]
        """
        ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        query_prealloc_size: NotRequired[pulumi.Input[builtins.str]]
        """
        ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        range_optimizer_max_mem_size: NotRequired[pulumi.Input[builtins.str]]
        """
        The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans. 

        rangeOptimizerMaxMemSize corresponds to the MySQL Server System variable [range_optimizer_max_mem_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size).
        """
        regexp_time_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        """
        relay_log_space_limit: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum amount of space to use for all relay logs.

        relayLogSpaceLimit corresponds to the MySQL Replica Server Options variable [relay_log_space_limit] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit).
        """
        replica_net_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.

        replicaNetTimeout corresponds to the MySQL Replica server system variable [replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_timeout)
        """
        replica_parallel_workers: NotRequired[pulumi.Input[builtins.int]]
        """
        Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)

        replicaParallelWorkers corresponds to the MySQL Replica Server Options variable [replica_parallel_workers] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_parallel_workers).
        """
        replica_type_conversions: NotRequired[pulumi.Input[builtins.str]]
        """
        From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.

        replica_type_conversions controls the type conversion mode in effect on the replica when using row-based replication. Its value is a comma-delimited set of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY, ALL_SIGNED, ALL_UNSIGNED. Set this variable to an empty string to disallow type conversions between the source and the replica. Setting this variable takes effect for all replication channels immediately, including running channels.

        replica_type_conversions corresponds to the MySQL Replica Server Options variable [replica_type_conversions] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_type_conversions).
        """
        require_secure_transport: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.

        require_secure_transport corresponds to the MySQL Server Administration system variable [require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)
        """
        skip_name_resolve: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.

        skipNameResolve corresponds to the MySQL Server System variable [skip_name_resolve] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve).
        """
        sort_buffer_size: NotRequired[pulumi.Input[builtins.str]]
        """
        Each session that must perform a sort allocates a buffer of this size.

        sortBufferSize corresponds to the MySQL system variable [sort_buffer_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_sort_buffer_size)
        """
        sql_generate_invisible_primary_key: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.

        sqlGenerateInvisiblePrimaryKey corresponds to the MySQL system variable [sql_generate_invisible_primary_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_generate_invisible_primary_key).
        """
        sql_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        ("sql_mode")
        """
        sql_require_primary_key: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("sql_require_primary_key")
        """
        sql_warnings: NotRequired[pulumi.Input[builtins.bool]]
        """
        ("sql_warnings")
        """
        table_definition_cache: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.

        table_definition_cache corresponds to the MySQL Server Administration system variable [table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)
        """
        table_open_cache: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.

        table_open_cache corresponds to the MySQL Server Administration system variable [table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)
        """
        temptable_max_ram: NotRequired[pulumi.Input[builtins.str]]
        """
        Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.

        temptableMaxRam corresponds to the MySQL system variable [temptable_max_ram] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram).
        """
        thread_pool_dedicated_listeners: NotRequired[pulumi.Input[builtins.bool]]
        """
        Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        """
        thread_pool_max_transactions_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        """
        thread_pool_query_threads_per_group: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions. 

        threadPoolQueryThreadsPerGroup corresponds to the MySQL Server system variable [thread_pool_query_threads_per_group](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_query_threads_per_group)
        """
        thread_pool_size: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.

        threadPoolSize corresponds to the MySQL Server System variable [thread_pool_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size).
        """
        thread_pool_transaction_delay: NotRequired[pulumi.Input[builtins.int]]
        """
        The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running. 

        threadPoolTransactionDelay corresponds to the MySQL Server system variable [thread_pool_transaction_delay](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_transaction_delay)
        """
        time_zone: NotRequired[pulumi.Input[builtins.str]]
        """
        Initializes the time zone for each client that connects.

        This corresponds to the MySQL System Variable "time_zone".

        The values can be given in one of the following formats, none of which are case-sensitive:
        * As a string indicating an offset from UTC of the form [H]H:MM, prefixed with a + or -, such as '+10:00', '-6:00', or '+05:30'. The permitted range is '-13:59' to '+14:00', inclusive.
        * As a named time zone, as defined by the "IANA Time Zone database", such as 'Europe/Helsinki', 'US/Eastern', 'MET', or 'UTC'.
        """
        tmp_table_size: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.

        tmp_table_size corresponds to the MySQL system variable [tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)
        """
        transaction_isolation: NotRequired[pulumi.Input[builtins.str]]
        """
        ("transaction_isolation")
        """
        wait_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.

        waitTimeout corresponds to the MySQL system variable. [wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    MysqlConfigurationVariablesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlConfigurationVariablesArgs:
    def __init__(__self__, *,
                 auto_increment_increment: Optional[pulumi.Input[builtins.int]] = None,
                 auto_increment_offset: Optional[pulumi.Input[builtins.int]] = None,
                 autocommit: Optional[pulumi.Input[builtins.bool]] = None,
                 big_tables: Optional[pulumi.Input[builtins.bool]] = None,
                 binlog_expire_logs_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 binlog_group_commit_sync_delay: Optional[pulumi.Input[builtins.int]] = None,
                 binlog_group_commit_sync_no_delay_count: Optional[pulumi.Input[builtins.int]] = None,
                 binlog_row_metadata: Optional[pulumi.Input[builtins.str]] = None,
                 binlog_row_value_options: Optional[pulumi.Input[builtins.str]] = None,
                 binlog_transaction_compression: Optional[pulumi.Input[builtins.bool]] = None,
                 block_encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 character_set_server: Optional[pulumi.Input[builtins.str]] = None,
                 collation_server: Optional[pulumi.Input[builtins.str]] = None,
                 completion_type: Optional[pulumi.Input[builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 connection_memory_chunk_size: Optional[pulumi.Input[builtins.int]] = None,
                 connection_memory_limit: Optional[pulumi.Input[builtins.str]] = None,
                 cte_max_recursion_depth: Optional[pulumi.Input[builtins.str]] = None,
                 default_authentication_plugin: Optional[pulumi.Input[builtins.str]] = None,
                 explain_format: Optional[pulumi.Input[builtins.str]] = None,
                 explicit_defaults_for_timestamp: Optional[pulumi.Input[builtins.bool]] = None,
                 foreign_key_checks: Optional[pulumi.Input[builtins.bool]] = None,
                 generated_random_password_length: Optional[pulumi.Input[builtins.int]] = None,
                 global_connection_memory_limit: Optional[pulumi.Input[builtins.str]] = None,
                 global_connection_memory_tracking: Optional[pulumi.Input[builtins.bool]] = None,
                 group_concat_max_len: Optional[pulumi.Input[builtins.str]] = None,
                 group_replication_consistency: Optional[pulumi.Input[builtins.str]] = None,
                 information_schema_stats_expiry: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_adaptive_hash_index: Optional[pulumi.Input[builtins.bool]] = None,
                 innodb_autoinc_lock_mode: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_buffer_pool_dump_pct: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_buffer_pool_instances: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_buffer_pool_size: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_change_buffering: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_ddl_buffer_size: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_ddl_threads: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_ft_enable_stopword: Optional[pulumi.Input[builtins.bool]] = None,
                 innodb_ft_max_token_size: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_ft_min_token_size: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_ft_num_word_optimize: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_ft_result_cache_limit: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_ft_server_stopword_table: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_lock_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_log_writer_threads: Optional[pulumi.Input[builtins.bool]] = None,
                 innodb_max_purge_lag: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_max_purge_lag_delay: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_numa_interleave: Optional[pulumi.Input[builtins.bool]] = None,
                 innodb_online_alter_log_max_size: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_redo_log_capacity: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_rollback_on_timeout: Optional[pulumi.Input[builtins.bool]] = None,
                 innodb_sort_buffer_size: Optional[pulumi.Input[builtins.int]] = None,
                 innodb_stats_persistent_sample_pages: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_stats_transient_sample_pages: Optional[pulumi.Input[builtins.str]] = None,
                 innodb_strict_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 innodb_undo_log_truncate: Optional[pulumi.Input[builtins.bool]] = None,
                 interactive_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 join_buffer_size: Optional[pulumi.Input[builtins.str]] = None,
                 local_infile: Optional[pulumi.Input[builtins.bool]] = None,
                 long_query_time: Optional[pulumi.Input[builtins.int]] = None,
                 mandatory_roles: Optional[pulumi.Input[builtins.str]] = None,
                 max_allowed_packet: Optional[pulumi.Input[builtins.int]] = None,
                 max_binlog_cache_size: Optional[pulumi.Input[builtins.str]] = None,
                 max_connect_errors: Optional[pulumi.Input[builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[builtins.int]] = None,
                 max_execution_time: Optional[pulumi.Input[builtins.str]] = None,
                 max_heap_table_size: Optional[pulumi.Input[builtins.str]] = None,
                 max_prepared_stmt_count: Optional[pulumi.Input[builtins.int]] = None,
                 max_seeks_for_key: Optional[pulumi.Input[builtins.str]] = None,
                 max_user_connections: Optional[pulumi.Input[builtins.str]] = None,
                 mysql_firewall_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 mysql_zstd_default_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_deflate_default_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_deflate_max_client_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_document_id_unique_prefix: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_enable_hello_notice: Optional[pulumi.Input[builtins.bool]] = None,
                 mysqlx_idle_worker_thread_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_interactive_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_lz4default_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_lz4max_client_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_max_allowed_packet: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_min_worker_threads: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_write_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_zstd_default_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 mysqlx_zstd_max_client_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 net_read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 net_write_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 optimizer_switch: Optional[pulumi.Input[builtins.str]] = None,
                 parser_max_mem_size: Optional[pulumi.Input[builtins.str]] = None,
                 query_alloc_block_size: Optional[pulumi.Input[builtins.str]] = None,
                 query_prealloc_size: Optional[pulumi.Input[builtins.str]] = None,
                 range_optimizer_max_mem_size: Optional[pulumi.Input[builtins.str]] = None,
                 regexp_time_limit: Optional[pulumi.Input[builtins.int]] = None,
                 relay_log_space_limit: Optional[pulumi.Input[builtins.str]] = None,
                 replica_net_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 replica_parallel_workers: Optional[pulumi.Input[builtins.int]] = None,
                 replica_type_conversions: Optional[pulumi.Input[builtins.str]] = None,
                 require_secure_transport: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_name_resolve: Optional[pulumi.Input[builtins.bool]] = None,
                 sort_buffer_size: Optional[pulumi.Input[builtins.str]] = None,
                 sql_generate_invisible_primary_key: Optional[pulumi.Input[builtins.bool]] = None,
                 sql_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sql_require_primary_key: Optional[pulumi.Input[builtins.bool]] = None,
                 sql_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 table_definition_cache: Optional[pulumi.Input[builtins.int]] = None,
                 table_open_cache: Optional[pulumi.Input[builtins.int]] = None,
                 temptable_max_ram: Optional[pulumi.Input[builtins.str]] = None,
                 thread_pool_dedicated_listeners: Optional[pulumi.Input[builtins.bool]] = None,
                 thread_pool_max_transactions_limit: Optional[pulumi.Input[builtins.int]] = None,
                 thread_pool_query_threads_per_group: Optional[pulumi.Input[builtins.int]] = None,
                 thread_pool_size: Optional[pulumi.Input[builtins.int]] = None,
                 thread_pool_transaction_delay: Optional[pulumi.Input[builtins.int]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 tmp_table_size: Optional[pulumi.Input[builtins.str]] = None,
                 transaction_isolation: Optional[pulumi.Input[builtins.str]] = None,
                 wait_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] auto_increment_increment: auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.
               
               autoIncrementIncrement corresponds to the MySQL Replication Source Options variable [auto_increment_increment] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment).
        :param pulumi.Input[builtins.int] auto_increment_offset: This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.
               
               autoIncrementOffset corresponds to the MySQL Replication Source Options variable [auto_increment_offset] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset).
        :param pulumi.Input[builtins.bool] autocommit: ("autocommit")
        :param pulumi.Input[builtins.bool] big_tables: If enabled, the server stores all temporary tables on disk rather than in memory.
               
               bigTables corresponds to the MySQL server variable [big_tables](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_big_tables).
        :param pulumi.Input[builtins.int] binlog_expire_logs_seconds: Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        :param pulumi.Input[builtins.int] binlog_group_commit_sync_delay: Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.
               
               binlogGroupCommitSyncDelay corresponds to the MySQL Replication system variable [binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)
        :param pulumi.Input[builtins.int] binlog_group_commit_sync_no_delay_count: The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.
               
               binlogGroupCommitSyncNoDelayCount corresponds to the MySQL Replication system variable [binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)
        :param pulumi.Input[builtins.str] binlog_row_metadata: Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        :param pulumi.Input[builtins.str] binlog_row_value_options: When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        :param pulumi.Input[builtins.bool] binlog_transaction_compression: Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        :param pulumi.Input[builtins.str] block_encryption_mode: This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.
               
               block_encryption_mode corresponds to the MySQL Server Administration system variable [block_encryption_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)
        :param pulumi.Input[builtins.str] character_set_server: The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.
               
               characterSetServer corresponds to the MySQL server variable [character_set_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_character_set_server).
        :param pulumi.Input[builtins.str] collation_server: The server's default collation.
               
               collationServer corresponds to the MySQL server variable [collation_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_collation_server).
        :param pulumi.Input[builtins.str] completion_type: ("completion_type")
        :param pulumi.Input[builtins.int] connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
               
               connectTimeout corresponds to the MySQL system variable [connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)
               
               Increasing the connect_timeout value might help if clients frequently encounter errors of the form "Lost connection to MySQL server at 'XXX', system error: errno".
        :param pulumi.Input[builtins.int] connection_memory_chunk_size: Set the chunking size for updates to the global memory usage counter Global_connection_memory.
               
               connectionMemoryChunkSize corresponds to the MySQL system variable [connection_memory_chunk_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_chunk_size).
        :param pulumi.Input[builtins.str] connection_memory_limit: Set the maximum amount of memory that can be used by a single user connection.
               
               connectionMemoryLimit corresponds to the MySQL system variable [connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_limit).
        :param pulumi.Input[builtins.str] cte_max_recursion_depth: ("cte_max_recursion_depth")
        :param pulumi.Input[builtins.str] default_authentication_plugin: The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.
               
               As of MySQL 8.0.27, which introduces multifactor authentication, default_authentication_plugin is still used, but in conjunction with and at a lower precedence than the authentication_policy system variable. For details, see The Default Authentication Plugin. Because of this diminished role, default_authentication_plugin is deprecated as of MySQL 8.0.27 and subject to removal in a future MySQL version.
               
               defaultAuthenticationPlugin corresponds to the MySQL system variable [default_authentication_plugin](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin).
        :param pulumi.Input[builtins.str] explain_format: This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.
               
               explainFormat corresponds to the MySQL system variable [explain_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explain_format).
        :param pulumi.Input[builtins.bool] explicit_defaults_for_timestamp: This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.
               
               explicit_defaults_for_timestamp corresponds to the MySQL Server Administration system variable [explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)
        :param pulumi.Input[builtins.bool] foreign_key_checks: ("foreign_key_checks")
        :param pulumi.Input[builtins.int] generated_random_password_length: ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.str] global_connection_memory_limit: Set the total amount of memory that can be used by all user connections.
               
               globalConnectionMemoryLimit corresponds to the MySQL system variable [global_connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_limit).
        :param pulumi.Input[builtins.bool] global_connection_memory_tracking: Determines whether the MySQL server calculates Global_connection_memory.
               
               globalConnectionMemoryTracking corresponds to the MySQL system variable [global_connection_memory_tracking](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_tracking).
        :param pulumi.Input[builtins.str] group_concat_max_len: Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.
               
               This is the MySQL variable "group_concat_max_len". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)
        :param pulumi.Input[builtins.str] group_replication_consistency: * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
               * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
               * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        :param pulumi.Input[builtins.int] information_schema_stats_expiry: ("information_schema_stats_expiry")
        :param pulumi.Input[builtins.bool] innodb_adaptive_hash_index: Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.
               
               innodbAdaptiveHashIndex corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_adaptive_hash_index] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index).
        :param pulumi.Input[builtins.int] innodb_autoinc_lock_mode: The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.
               
               innodbAutoincLockMode corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_autoinc_lock_mode] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode).
        :param pulumi.Input[builtins.int] innodb_buffer_pool_dump_pct: Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.
               
               innodbBufferPoolDumpPct corresponds to the MySQL InnoDB system variable [innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct).
               
               The range is 1 to 100. The default value is 25.
               
               For example, if there are 4 buffer pools with 100 pages each, and innodb_buffer_pool_dump_pct is set to 25, the 25 most recently used pages from each buffer pool are dumped.
        :param pulumi.Input[builtins.int] innodb_buffer_pool_instances: ("innodb_buffer_pool_instances")
        :param pulumi.Input[builtins.str] innodb_buffer_pool_size: The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.
               
               innodbBufferPoolSize corresponds to the MySQL server system variable [innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size).
               
               The default and maximum values depend on the amount of RAM provisioned by the shape. See [Default User Variables](https://www.terraform.io/mysql-database/doc/configuring-db-system.html#GUID-B5504C19-F6F4-4DAB-8506-189A4E8F4A6A).
        :param pulumi.Input[builtins.str] innodb_change_buffering: Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.
               
               innodbChangeBuffering corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_change_buffering] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).
        :param pulumi.Input[builtins.str] innodb_ddl_buffer_size: innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        :param pulumi.Input[builtins.int] innodb_ddl_threads: innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        :param pulumi.Input[builtins.bool] innodb_ft_enable_stopword: ("innodb_ft_enable_stopword")
        :param pulumi.Input[builtins.int] innodb_ft_max_token_size: ("innodb_ft_max_token_size")
        :param pulumi.Input[builtins.int] innodb_ft_min_token_size: ("innodb_ft_min_token_size")
        :param pulumi.Input[builtins.int] innodb_ft_num_word_optimize: ("innodb_ft_num_word_optimize")
        :param pulumi.Input[builtins.str] innodb_ft_result_cache_limit: ("innodb_ft_result_cache_limit")
        :param pulumi.Input[builtins.str] innodb_ft_server_stopword_table: ("innodb_ft_server_stopword_table")
        :param pulumi.Input[builtins.int] innodb_lock_wait_timeout: ("innodb_lock_wait_timeout")
        :param pulumi.Input[builtins.bool] innodb_log_writer_threads: Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.
               
               This is the MySQL variable "innodb_log_writer_threads". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)
        :param pulumi.Input[builtins.str] innodb_max_purge_lag: The desired maximum purge lag in terms of transactions.
               
               InnoDB maintains a list of transactions that have index records delete-marked by UPDATE or DELETE operations. The length of the list is the purge lag.
               
               If this value is exceeded, a delay is imposed on INSERT, UPDATE, and DELETE operations to allow time for purge to catch up.
               
               The default value is 0, which means there is no maximum purge lag and no delay.
               
               innodbMaxPurgeLag corresponds to the MySQL server system variable [innodb_max_purge_lag](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag).
        :param pulumi.Input[builtins.int] innodb_max_purge_lag_delay: The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.
               
               The specified innodb_max_purge_lag_delay value is an upper limit on the delay period.
               
               innodbMaxPurgeLagDelay corresponds to the MySQL server system variable [innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay).
        :param pulumi.Input[builtins.bool] innodb_numa_interleave: Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.
               
               innodbNumaInterleave corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_numa_interleave] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave).
        :param pulumi.Input[builtins.str] innodb_online_alter_log_max_size: Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.
               
               innodbOnlineAlterLogMaxSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_online_alter_log_max_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size).
        :param pulumi.Input[builtins.str] innodb_redo_log_capacity: Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.
               
               innodbRedoLogCapacity corresponds to the InnoDB Startup Options and System Variables [innodb_redo_log_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_capacity)
        :param pulumi.Input[builtins.bool] innodb_rollback_on_timeout: InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.
               
               innodbRollbackOnTimeout corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_rollback_on_timeout] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout).
        :param pulumi.Input[builtins.int] innodb_sort_buffer_size: This variable defines:
               * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
               * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.
               
               innodbSortBufferSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_sort_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size).
        :param pulumi.Input[builtins.str] innodb_stats_persistent_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.
               
               innodbStatsPersistentSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)
               
               innodb_stats_persistent_sample_pages only applies when innodb_stats_persistent is enabled for a table; when innodb_stats_persistent is disabled, innodb_stats_transient_sample_pages applies instead.
        :param pulumi.Input[builtins.str] innodb_stats_transient_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).
               
               innodbStatsTransientSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)
               
               innodb_stats_transient_sample_pages only applies when innodb_stats_persistent is disabled for a table; when innodb_stats_persistent is enabled, innodb_stats_persistent_sample_pages applies instead.
               
               innodb_stats_persistent is ON by default and cannot be changed. It is possible to override it using the STATS_PERSISTENT clause of the [CREATE TABLE](https://dev.mysql.com/doc/refman/8.0/en/create-table.html) and [ALTER TABLE](https://dev.mysql.com/doc/refman/8.0/en/alter-table.html) statements.
        :param pulumi.Input[builtins.bool] innodb_strict_mode: When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.
               
               innodbStrictMode corresponds to the MySQL InnoDB system variable [innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)
        :param pulumi.Input[builtins.bool] innodb_undo_log_truncate: When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.
               
               innodbUndoLogTruncate corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_undo_log_truncate] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate).
        :param pulumi.Input[builtins.int] interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
               
               interactiveTimeout corresponds to the MySQL system variable. [interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)
        :param pulumi.Input[builtins.str] join_buffer_size: The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.
               
               joinBufferSize corresponds to the MySQL Server System variable [join_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size).
        :param pulumi.Input[builtins.bool] local_infile: This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side. 
               
               local_infile corresponds to the MySQL Server system variable [local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)
        :param pulumi.Input[builtins.int] long_query_time: If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.
               
               longQueryTime corresponds to the MySQL Server System variable [long_query_time] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time).
        :param pulumi.Input[builtins.str] mandatory_roles: ("mandatory_roles")
        :param pulumi.Input[builtins.int] max_allowed_packet: The maximum size of one packet or any generated/intermediate string.
               
               This is the mysql variable "max_allowed_packet".
        :param pulumi.Input[builtins.str] max_binlog_cache_size: Sets the size of the transaction cache.
               
               maxBinlogCacheSize corresponds to the MySQL server system variable [max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size).
        :param pulumi.Input[builtins.str] max_connect_errors: ("max_connect_errors")
        :param pulumi.Input[builtins.int] max_connections: ("max_connections")
        :param pulumi.Input[builtins.str] max_execution_time: ("max_execution_time")
        :param pulumi.Input[builtins.str] max_heap_table_size: This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.
               
               maxHeapTableSize corresponds to the MySQL system variable [max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)
        :param pulumi.Input[builtins.int] max_prepared_stmt_count: ("max_prepared_stmt_count")
        :param pulumi.Input[builtins.str] max_seeks_for_key: Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.
               
               maxSeeksForKey corresponds to the MySQL Server System variable [max_seeks_for_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key).
        :param pulumi.Input[builtins.str] max_user_connections: The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.
               
               maxUserConnections corresponds to the MySQL Server System variable [max_user_connections] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections).
        :param pulumi.Input[builtins.bool] mysql_firewall_mode: ("mysql_firewall_mode")
        :param pulumi.Input[builtins.int] mysql_zstd_default_compression_level: DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        :param pulumi.Input[builtins.int] mysqlx_connect_timeout: The number of seconds X Plugin waits for the first packet to be received from newly connected clients.
               
               mysqlxConnectTimeout corresponds to the MySQL X Plugin system variable [mysqlx_connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_connect_timeout)
        :param pulumi.Input[builtins.int] mysqlx_deflate_default_compression_level: Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        :param pulumi.Input[builtins.int] mysqlx_deflate_max_client_compression_level: Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        :param pulumi.Input[builtins.int] mysqlx_document_id_unique_prefix: ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.bool] mysqlx_enable_hello_notice: ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.int] mysqlx_idle_worker_thread_timeout: ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.int] mysqlx_interactive_timeout: The number of seconds to wait for interactive clients to timeout.
               
               mysqlxInteractiveTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_interactive_timeout)
        :param pulumi.Input[builtins.int] mysqlx_lz4default_compression_level: Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        :param pulumi.Input[builtins.int] mysqlx_lz4max_client_compression_level: Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        :param pulumi.Input[builtins.int] mysqlx_max_allowed_packet: The maximum size of network packets that can be received by X Plugin.
               
               This is the mysql variable "mysqlx_max_allowed_packet".
        :param pulumi.Input[builtins.int] mysqlx_min_worker_threads: ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.int] mysqlx_read_timeout: The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.
               
               mysqlxReadTimeout corresponds to the MySQL X Plugin system variable [mysqlx_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_read_timeout)
        :param pulumi.Input[builtins.int] mysqlx_wait_timeout: The number of seconds that X Plugin waits for activity on a connection.
               
               mysqlxWaitTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_wait_timeout)
        :param pulumi.Input[builtins.int] mysqlx_write_timeout: The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.
               
               mysqlxReadmysqlxWriteTimeoutTimeout corresponds to the MySQL X Plugin system variable [mysqlx_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_write_timeout)
        :param pulumi.Input[builtins.int] mysqlx_zstd_default_compression_level: Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        :param pulumi.Input[builtins.int] mysqlx_zstd_max_client_compression_level: Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        :param pulumi.Input[builtins.int] net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
               
               netReadTimeout corresponds to the MySQL system variable [net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)
        :param pulumi.Input[builtins.int] net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
               
               netWriteTimeout corresponds to the MySQL system variable [net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)
        :param pulumi.Input[builtins.str] optimizer_switch: The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.
               
               Setting hypergraph_optimizer=on for cloud builds below 9.0.0 will fail.
               
               optimizerSwitch corresponds to the MySQL Server System variable [optimizer_switch] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch).
        :param pulumi.Input[builtins.str] parser_max_mem_size: ("parser_max_mem_size")
        :param pulumi.Input[builtins.str] query_alloc_block_size: ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.str] query_prealloc_size: ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        :param pulumi.Input[builtins.str] range_optimizer_max_mem_size: The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans. 
               
               rangeOptimizerMaxMemSize corresponds to the MySQL Server System variable [range_optimizer_max_mem_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size).
        :param pulumi.Input[builtins.int] regexp_time_limit: regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        :param pulumi.Input[builtins.str] relay_log_space_limit: The maximum amount of space to use for all relay logs.
               
               relayLogSpaceLimit corresponds to the MySQL Replica Server Options variable [relay_log_space_limit] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit).
        :param pulumi.Input[builtins.int] replica_net_timeout: Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.
               
               replicaNetTimeout corresponds to the MySQL Replica server system variable [replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_timeout)
        :param pulumi.Input[builtins.int] replica_parallel_workers: Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)
               
               replicaParallelWorkers corresponds to the MySQL Replica Server Options variable [replica_parallel_workers] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_parallel_workers).
        :param pulumi.Input[builtins.str] replica_type_conversions: From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.
               
               replica_type_conversions controls the type conversion mode in effect on the replica when using row-based replication. Its value is a comma-delimited set of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY, ALL_SIGNED, ALL_UNSIGNED. Set this variable to an empty string to disallow type conversions between the source and the replica. Setting this variable takes effect for all replication channels immediately, including running channels.
               
               replica_type_conversions corresponds to the MySQL Replica Server Options variable [replica_type_conversions] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_type_conversions).
        :param pulumi.Input[builtins.bool] require_secure_transport: Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.
               
               require_secure_transport corresponds to the MySQL Server Administration system variable [require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)
        :param pulumi.Input[builtins.bool] skip_name_resolve: Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.
               
               skipNameResolve corresponds to the MySQL Server System variable [skip_name_resolve] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve).
        :param pulumi.Input[builtins.str] sort_buffer_size: Each session that must perform a sort allocates a buffer of this size.
               
               sortBufferSize corresponds to the MySQL system variable [sort_buffer_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_sort_buffer_size)
        :param pulumi.Input[builtins.bool] sql_generate_invisible_primary_key: Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.
               
               sqlGenerateInvisiblePrimaryKey corresponds to the MySQL system variable [sql_generate_invisible_primary_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_generate_invisible_primary_key).
        :param pulumi.Input[builtins.str] sql_mode: ("sql_mode")
        :param pulumi.Input[builtins.bool] sql_require_primary_key: ("sql_require_primary_key")
        :param pulumi.Input[builtins.bool] sql_warnings: ("sql_warnings")
        :param pulumi.Input[builtins.int] table_definition_cache: The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.
               
               table_definition_cache corresponds to the MySQL Server Administration system variable [table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)
        :param pulumi.Input[builtins.int] table_open_cache: The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.
               
               table_open_cache corresponds to the MySQL Server Administration system variable [table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)
        :param pulumi.Input[builtins.str] temptable_max_ram: Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.
               
               temptableMaxRam corresponds to the MySQL system variable [temptable_max_ram] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram).
        :param pulumi.Input[builtins.bool] thread_pool_dedicated_listeners: Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        :param pulumi.Input[builtins.int] thread_pool_max_transactions_limit: Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        :param pulumi.Input[builtins.int] thread_pool_query_threads_per_group: The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions. 
               
               threadPoolQueryThreadsPerGroup corresponds to the MySQL Server system variable [thread_pool_query_threads_per_group](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_query_threads_per_group)
        :param pulumi.Input[builtins.int] thread_pool_size: The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.
               
               threadPoolSize corresponds to the MySQL Server System variable [thread_pool_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size).
        :param pulumi.Input[builtins.int] thread_pool_transaction_delay: The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running. 
               
               threadPoolTransactionDelay corresponds to the MySQL Server system variable [thread_pool_transaction_delay](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_transaction_delay)
        :param pulumi.Input[builtins.str] time_zone: Initializes the time zone for each client that connects.
               
               This corresponds to the MySQL System Variable "time_zone".
               
               The values can be given in one of the following formats, none of which are case-sensitive:
               * As a string indicating an offset from UTC of the form [H]H:MM, prefixed with a + or -, such as '+10:00', '-6:00', or '+05:30'. The permitted range is '-13:59' to '+14:00', inclusive.
               * As a named time zone, as defined by the "IANA Time Zone database", such as 'Europe/Helsinki', 'US/Eastern', 'MET', or 'UTC'.
        :param pulumi.Input[builtins.str] tmp_table_size: The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.
               
               tmp_table_size corresponds to the MySQL system variable [tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)
        :param pulumi.Input[builtins.str] transaction_isolation: ("transaction_isolation")
        :param pulumi.Input[builtins.int] wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
               
               waitTimeout corresponds to the MySQL system variable. [wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if auto_increment_increment is not None:
            pulumi.set(__self__, "auto_increment_increment", auto_increment_increment)
        if auto_increment_offset is not None:
            pulumi.set(__self__, "auto_increment_offset", auto_increment_offset)
        if autocommit is not None:
            pulumi.set(__self__, "autocommit", autocommit)
        if big_tables is not None:
            pulumi.set(__self__, "big_tables", big_tables)
        if binlog_expire_logs_seconds is not None:
            pulumi.set(__self__, "binlog_expire_logs_seconds", binlog_expire_logs_seconds)
        if binlog_group_commit_sync_delay is not None:
            pulumi.set(__self__, "binlog_group_commit_sync_delay", binlog_group_commit_sync_delay)
        if binlog_group_commit_sync_no_delay_count is not None:
            pulumi.set(__self__, "binlog_group_commit_sync_no_delay_count", binlog_group_commit_sync_no_delay_count)
        if binlog_row_metadata is not None:
            pulumi.set(__self__, "binlog_row_metadata", binlog_row_metadata)
        if binlog_row_value_options is not None:
            pulumi.set(__self__, "binlog_row_value_options", binlog_row_value_options)
        if binlog_transaction_compression is not None:
            pulumi.set(__self__, "binlog_transaction_compression", binlog_transaction_compression)
        if block_encryption_mode is not None:
            pulumi.set(__self__, "block_encryption_mode", block_encryption_mode)
        if character_set_server is not None:
            pulumi.set(__self__, "character_set_server", character_set_server)
        if collation_server is not None:
            pulumi.set(__self__, "collation_server", collation_server)
        if completion_type is not None:
            pulumi.set(__self__, "completion_type", completion_type)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if connection_memory_chunk_size is not None:
            pulumi.set(__self__, "connection_memory_chunk_size", connection_memory_chunk_size)
        if connection_memory_limit is not None:
            pulumi.set(__self__, "connection_memory_limit", connection_memory_limit)
        if cte_max_recursion_depth is not None:
            pulumi.set(__self__, "cte_max_recursion_depth", cte_max_recursion_depth)
        if default_authentication_plugin is not None:
            pulumi.set(__self__, "default_authentication_plugin", default_authentication_plugin)
        if explain_format is not None:
            pulumi.set(__self__, "explain_format", explain_format)
        if explicit_defaults_for_timestamp is not None:
            pulumi.set(__self__, "explicit_defaults_for_timestamp", explicit_defaults_for_timestamp)
        if foreign_key_checks is not None:
            pulumi.set(__self__, "foreign_key_checks", foreign_key_checks)
        if generated_random_password_length is not None:
            warnings.warn("""The 'generated_random_password_length' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""generated_random_password_length is deprecated: The 'generated_random_password_length' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if generated_random_password_length is not None:
            pulumi.set(__self__, "generated_random_password_length", generated_random_password_length)
        if global_connection_memory_limit is not None:
            pulumi.set(__self__, "global_connection_memory_limit", global_connection_memory_limit)
        if global_connection_memory_tracking is not None:
            pulumi.set(__self__, "global_connection_memory_tracking", global_connection_memory_tracking)
        if group_concat_max_len is not None:
            pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        if group_replication_consistency is not None:
            pulumi.set(__self__, "group_replication_consistency", group_replication_consistency)
        if information_schema_stats_expiry is not None:
            pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        if innodb_adaptive_hash_index is not None:
            pulumi.set(__self__, "innodb_adaptive_hash_index", innodb_adaptive_hash_index)
        if innodb_autoinc_lock_mode is not None:
            pulumi.set(__self__, "innodb_autoinc_lock_mode", innodb_autoinc_lock_mode)
        if innodb_buffer_pool_dump_pct is not None:
            pulumi.set(__self__, "innodb_buffer_pool_dump_pct", innodb_buffer_pool_dump_pct)
        if innodb_buffer_pool_instances is not None:
            pulumi.set(__self__, "innodb_buffer_pool_instances", innodb_buffer_pool_instances)
        if innodb_buffer_pool_size is not None:
            pulumi.set(__self__, "innodb_buffer_pool_size", innodb_buffer_pool_size)
        if innodb_change_buffering is not None:
            pulumi.set(__self__, "innodb_change_buffering", innodb_change_buffering)
        if innodb_ddl_buffer_size is not None:
            pulumi.set(__self__, "innodb_ddl_buffer_size", innodb_ddl_buffer_size)
        if innodb_ddl_threads is not None:
            pulumi.set(__self__, "innodb_ddl_threads", innodb_ddl_threads)
        if innodb_ft_enable_stopword is not None:
            pulumi.set(__self__, "innodb_ft_enable_stopword", innodb_ft_enable_stopword)
        if innodb_ft_max_token_size is not None:
            pulumi.set(__self__, "innodb_ft_max_token_size", innodb_ft_max_token_size)
        if innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        if innodb_ft_num_word_optimize is not None:
            pulumi.set(__self__, "innodb_ft_num_word_optimize", innodb_ft_num_word_optimize)
        if innodb_ft_result_cache_limit is not None:
            pulumi.set(__self__, "innodb_ft_result_cache_limit", innodb_ft_result_cache_limit)
        if innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        if innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        if innodb_log_writer_threads is not None:
            pulumi.set(__self__, "innodb_log_writer_threads", innodb_log_writer_threads)
        if innodb_max_purge_lag is not None:
            pulumi.set(__self__, "innodb_max_purge_lag", innodb_max_purge_lag)
        if innodb_max_purge_lag_delay is not None:
            pulumi.set(__self__, "innodb_max_purge_lag_delay", innodb_max_purge_lag_delay)
        if innodb_numa_interleave is not None:
            pulumi.set(__self__, "innodb_numa_interleave", innodb_numa_interleave)
        if innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        if innodb_redo_log_capacity is not None:
            pulumi.set(__self__, "innodb_redo_log_capacity", innodb_redo_log_capacity)
        if innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        if innodb_sort_buffer_size is not None:
            pulumi.set(__self__, "innodb_sort_buffer_size", innodb_sort_buffer_size)
        if innodb_stats_persistent_sample_pages is not None:
            pulumi.set(__self__, "innodb_stats_persistent_sample_pages", innodb_stats_persistent_sample_pages)
        if innodb_stats_transient_sample_pages is not None:
            pulumi.set(__self__, "innodb_stats_transient_sample_pages", innodb_stats_transient_sample_pages)
        if innodb_strict_mode is not None:
            pulumi.set(__self__, "innodb_strict_mode", innodb_strict_mode)
        if innodb_undo_log_truncate is not None:
            pulumi.set(__self__, "innodb_undo_log_truncate", innodb_undo_log_truncate)
        if interactive_timeout is not None:
            pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        if join_buffer_size is not None:
            pulumi.set(__self__, "join_buffer_size", join_buffer_size)
        if local_infile is not None:
            pulumi.set(__self__, "local_infile", local_infile)
        if long_query_time is not None:
            pulumi.set(__self__, "long_query_time", long_query_time)
        if mandatory_roles is not None:
            pulumi.set(__self__, "mandatory_roles", mandatory_roles)
        if max_allowed_packet is not None:
            pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        if max_binlog_cache_size is not None:
            pulumi.set(__self__, "max_binlog_cache_size", max_binlog_cache_size)
        if max_connect_errors is not None:
            pulumi.set(__self__, "max_connect_errors", max_connect_errors)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_execution_time is not None:
            pulumi.set(__self__, "max_execution_time", max_execution_time)
        if max_heap_table_size is not None:
            pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        if max_prepared_stmt_count is not None:
            pulumi.set(__self__, "max_prepared_stmt_count", max_prepared_stmt_count)
        if max_seeks_for_key is not None:
            pulumi.set(__self__, "max_seeks_for_key", max_seeks_for_key)
        if max_user_connections is not None:
            pulumi.set(__self__, "max_user_connections", max_user_connections)
        if mysql_firewall_mode is not None:
            pulumi.set(__self__, "mysql_firewall_mode", mysql_firewall_mode)
        if mysql_zstd_default_compression_level is not None:
            warnings.warn("""The 'mysql_zstd_default_compression_level' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""mysql_zstd_default_compression_level is deprecated: The 'mysql_zstd_default_compression_level' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if mysql_zstd_default_compression_level is not None:
            pulumi.set(__self__, "mysql_zstd_default_compression_level", mysql_zstd_default_compression_level)
        if mysqlx_connect_timeout is not None:
            pulumi.set(__self__, "mysqlx_connect_timeout", mysqlx_connect_timeout)
        if mysqlx_deflate_default_compression_level is not None:
            pulumi.set(__self__, "mysqlx_deflate_default_compression_level", mysqlx_deflate_default_compression_level)
        if mysqlx_deflate_max_client_compression_level is not None:
            pulumi.set(__self__, "mysqlx_deflate_max_client_compression_level", mysqlx_deflate_max_client_compression_level)
        if mysqlx_document_id_unique_prefix is not None:
            warnings.warn("""The 'mysqlx_document_id_unique_prefix' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""mysqlx_document_id_unique_prefix is deprecated: The 'mysqlx_document_id_unique_prefix' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if mysqlx_document_id_unique_prefix is not None:
            pulumi.set(__self__, "mysqlx_document_id_unique_prefix", mysqlx_document_id_unique_prefix)
        if mysqlx_enable_hello_notice is not None:
            pulumi.set(__self__, "mysqlx_enable_hello_notice", mysqlx_enable_hello_notice)
        if mysqlx_idle_worker_thread_timeout is not None:
            warnings.warn("""The 'mysqlx_idle_worker_thread_timeout' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""mysqlx_idle_worker_thread_timeout is deprecated: The 'mysqlx_idle_worker_thread_timeout' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if mysqlx_idle_worker_thread_timeout is not None:
            pulumi.set(__self__, "mysqlx_idle_worker_thread_timeout", mysqlx_idle_worker_thread_timeout)
        if mysqlx_interactive_timeout is not None:
            pulumi.set(__self__, "mysqlx_interactive_timeout", mysqlx_interactive_timeout)
        if mysqlx_lz4default_compression_level is not None:
            pulumi.set(__self__, "mysqlx_lz4default_compression_level", mysqlx_lz4default_compression_level)
        if mysqlx_lz4max_client_compression_level is not None:
            pulumi.set(__self__, "mysqlx_lz4max_client_compression_level", mysqlx_lz4max_client_compression_level)
        if mysqlx_max_allowed_packet is not None:
            pulumi.set(__self__, "mysqlx_max_allowed_packet", mysqlx_max_allowed_packet)
        if mysqlx_min_worker_threads is not None:
            warnings.warn("""The 'mysqlx_min_worker_threads' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""mysqlx_min_worker_threads is deprecated: The 'mysqlx_min_worker_threads' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if mysqlx_min_worker_threads is not None:
            pulumi.set(__self__, "mysqlx_min_worker_threads", mysqlx_min_worker_threads)
        if mysqlx_read_timeout is not None:
            pulumi.set(__self__, "mysqlx_read_timeout", mysqlx_read_timeout)
        if mysqlx_wait_timeout is not None:
            pulumi.set(__self__, "mysqlx_wait_timeout", mysqlx_wait_timeout)
        if mysqlx_write_timeout is not None:
            pulumi.set(__self__, "mysqlx_write_timeout", mysqlx_write_timeout)
        if mysqlx_zstd_default_compression_level is not None:
            pulumi.set(__self__, "mysqlx_zstd_default_compression_level", mysqlx_zstd_default_compression_level)
        if mysqlx_zstd_max_client_compression_level is not None:
            pulumi.set(__self__, "mysqlx_zstd_max_client_compression_level", mysqlx_zstd_max_client_compression_level)
        if net_read_timeout is not None:
            pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        if net_write_timeout is not None:
            pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        if optimizer_switch is not None:
            pulumi.set(__self__, "optimizer_switch", optimizer_switch)
        if parser_max_mem_size is not None:
            pulumi.set(__self__, "parser_max_mem_size", parser_max_mem_size)
        if query_alloc_block_size is not None:
            warnings.warn("""The 'query_alloc_block_size' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""query_alloc_block_size is deprecated: The 'query_alloc_block_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if query_alloc_block_size is not None:
            pulumi.set(__self__, "query_alloc_block_size", query_alloc_block_size)
        if query_prealloc_size is not None:
            pulumi.set(__self__, "query_prealloc_size", query_prealloc_size)
        if range_optimizer_max_mem_size is not None:
            warnings.warn("""The 'query_prealloc_size' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""range_optimizer_max_mem_size is deprecated: The 'query_prealloc_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if range_optimizer_max_mem_size is not None:
            pulumi.set(__self__, "range_optimizer_max_mem_size", range_optimizer_max_mem_size)
        if regexp_time_limit is not None:
            pulumi.set(__self__, "regexp_time_limit", regexp_time_limit)
        if relay_log_space_limit is not None:
            pulumi.set(__self__, "relay_log_space_limit", relay_log_space_limit)
        if replica_net_timeout is not None:
            pulumi.set(__self__, "replica_net_timeout", replica_net_timeout)
        if replica_parallel_workers is not None:
            pulumi.set(__self__, "replica_parallel_workers", replica_parallel_workers)
        if replica_type_conversions is not None:
            pulumi.set(__self__, "replica_type_conversions", replica_type_conversions)
        if require_secure_transport is not None:
            pulumi.set(__self__, "require_secure_transport", require_secure_transport)
        if skip_name_resolve is not None:
            pulumi.set(__self__, "skip_name_resolve", skip_name_resolve)
        if sort_buffer_size is not None:
            pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        if sql_generate_invisible_primary_key is not None:
            pulumi.set(__self__, "sql_generate_invisible_primary_key", sql_generate_invisible_primary_key)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if sql_require_primary_key is not None:
            pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        if sql_warnings is not None:
            pulumi.set(__self__, "sql_warnings", sql_warnings)
        if table_definition_cache is not None:
            pulumi.set(__self__, "table_definition_cache", table_definition_cache)
        if table_open_cache is not None:
            pulumi.set(__self__, "table_open_cache", table_open_cache)
        if temptable_max_ram is not None:
            pulumi.set(__self__, "temptable_max_ram", temptable_max_ram)
        if thread_pool_dedicated_listeners is not None:
            pulumi.set(__self__, "thread_pool_dedicated_listeners", thread_pool_dedicated_listeners)
        if thread_pool_max_transactions_limit is not None:
            pulumi.set(__self__, "thread_pool_max_transactions_limit", thread_pool_max_transactions_limit)
        if thread_pool_query_threads_per_group is not None:
            pulumi.set(__self__, "thread_pool_query_threads_per_group", thread_pool_query_threads_per_group)
        if thread_pool_size is not None:
            pulumi.set(__self__, "thread_pool_size", thread_pool_size)
        if thread_pool_transaction_delay is not None:
            pulumi.set(__self__, "thread_pool_transaction_delay", thread_pool_transaction_delay)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if tmp_table_size is not None:
            pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        if transaction_isolation is not None:
            pulumi.set(__self__, "transaction_isolation", transaction_isolation)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)

    @property
    @pulumi.getter(name="autoIncrementIncrement")
    def auto_increment_increment(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.

        autoIncrementIncrement corresponds to the MySQL Replication Source Options variable [auto_increment_increment] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment).
        """
        return pulumi.get(self, "auto_increment_increment")

    @auto_increment_increment.setter
    def auto_increment_increment(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "auto_increment_increment", value)

    @property
    @pulumi.getter(name="autoIncrementOffset")
    def auto_increment_offset(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.

        autoIncrementOffset corresponds to the MySQL Replication Source Options variable [auto_increment_offset] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset).
        """
        return pulumi.get(self, "auto_increment_offset")

    @auto_increment_offset.setter
    def auto_increment_offset(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "auto_increment_offset", value)

    @property
    @pulumi.getter
    def autocommit(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("autocommit")
        """
        return pulumi.get(self, "autocommit")

    @autocommit.setter
    def autocommit(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autocommit", value)

    @property
    @pulumi.getter(name="bigTables")
    def big_tables(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, the server stores all temporary tables on disk rather than in memory.

        bigTables corresponds to the MySQL server variable [big_tables](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_big_tables).
        """
        return pulumi.get(self, "big_tables")

    @big_tables.setter
    def big_tables(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "big_tables", value)

    @property
    @pulumi.getter(name="binlogExpireLogsSeconds")
    def binlog_expire_logs_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        """
        return pulumi.get(self, "binlog_expire_logs_seconds")

    @binlog_expire_logs_seconds.setter
    def binlog_expire_logs_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "binlog_expire_logs_seconds", value)

    @property
    @pulumi.getter(name="binlogGroupCommitSyncDelay")
    def binlog_group_commit_sync_delay(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.

        binlogGroupCommitSyncDelay corresponds to the MySQL Replication system variable [binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)
        """
        return pulumi.get(self, "binlog_group_commit_sync_delay")

    @binlog_group_commit_sync_delay.setter
    def binlog_group_commit_sync_delay(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "binlog_group_commit_sync_delay", value)

    @property
    @pulumi.getter(name="binlogGroupCommitSyncNoDelayCount")
    def binlog_group_commit_sync_no_delay_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.

        binlogGroupCommitSyncNoDelayCount corresponds to the MySQL Replication system variable [binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)
        """
        return pulumi.get(self, "binlog_group_commit_sync_no_delay_count")

    @binlog_group_commit_sync_no_delay_count.setter
    def binlog_group_commit_sync_no_delay_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "binlog_group_commit_sync_no_delay_count", value)

    @property
    @pulumi.getter(name="binlogRowMetadata")
    def binlog_row_metadata(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        """
        return pulumi.get(self, "binlog_row_metadata")

    @binlog_row_metadata.setter
    def binlog_row_metadata(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "binlog_row_metadata", value)

    @property
    @pulumi.getter(name="binlogRowValueOptions")
    def binlog_row_value_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        """
        return pulumi.get(self, "binlog_row_value_options")

    @binlog_row_value_options.setter
    def binlog_row_value_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "binlog_row_value_options", value)

    @property
    @pulumi.getter(name="binlogTransactionCompression")
    def binlog_transaction_compression(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        """
        return pulumi.get(self, "binlog_transaction_compression")

    @binlog_transaction_compression.setter
    def binlog_transaction_compression(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "binlog_transaction_compression", value)

    @property
    @pulumi.getter(name="blockEncryptionMode")
    def block_encryption_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.

        block_encryption_mode corresponds to the MySQL Server Administration system variable [block_encryption_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)
        """
        return pulumi.get(self, "block_encryption_mode")

    @block_encryption_mode.setter
    def block_encryption_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "block_encryption_mode", value)

    @property
    @pulumi.getter(name="characterSetServer")
    def character_set_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.

        characterSetServer corresponds to the MySQL server variable [character_set_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_character_set_server).
        """
        return pulumi.get(self, "character_set_server")

    @character_set_server.setter
    def character_set_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "character_set_server", value)

    @property
    @pulumi.getter(name="collationServer")
    def collation_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The server's default collation.

        collationServer corresponds to the MySQL server variable [collation_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_collation_server).
        """
        return pulumi.get(self, "collation_server")

    @collation_server.setter
    def collation_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collation_server", value)

    @property
    @pulumi.getter(name="completionType")
    def completion_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("completion_type")
        """
        return pulumi.get(self, "completion_type")

    @completion_type.setter
    def completion_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "completion_type", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.

        connectTimeout corresponds to the MySQL system variable [connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)

        Increasing the connect_timeout value might help if clients frequently encounter errors of the form "Lost connection to MySQL server at 'XXX', system error: errno".
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="connectionMemoryChunkSize")
    def connection_memory_chunk_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set the chunking size for updates to the global memory usage counter Global_connection_memory.

        connectionMemoryChunkSize corresponds to the MySQL system variable [connection_memory_chunk_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_chunk_size).
        """
        return pulumi.get(self, "connection_memory_chunk_size")

    @connection_memory_chunk_size.setter
    def connection_memory_chunk_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_memory_chunk_size", value)

    @property
    @pulumi.getter(name="connectionMemoryLimit")
    def connection_memory_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the maximum amount of memory that can be used by a single user connection.

        connectionMemoryLimit corresponds to the MySQL system variable [connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_limit).
        """
        return pulumi.get(self, "connection_memory_limit")

    @connection_memory_limit.setter
    def connection_memory_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_memory_limit", value)

    @property
    @pulumi.getter(name="cteMaxRecursionDepth")
    def cte_max_recursion_depth(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("cte_max_recursion_depth")
        """
        return pulumi.get(self, "cte_max_recursion_depth")

    @cte_max_recursion_depth.setter
    def cte_max_recursion_depth(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cte_max_recursion_depth", value)

    @property
    @pulumi.getter(name="defaultAuthenticationPlugin")
    def default_authentication_plugin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.

        As of MySQL 8.0.27, which introduces multifactor authentication, default_authentication_plugin is still used, but in conjunction with and at a lower precedence than the authentication_policy system variable. For details, see The Default Authentication Plugin. Because of this diminished role, default_authentication_plugin is deprecated as of MySQL 8.0.27 and subject to removal in a future MySQL version.

        defaultAuthenticationPlugin corresponds to the MySQL system variable [default_authentication_plugin](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin).
        """
        return pulumi.get(self, "default_authentication_plugin")

    @default_authentication_plugin.setter
    def default_authentication_plugin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_authentication_plugin", value)

    @property
    @pulumi.getter(name="explainFormat")
    def explain_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.

        explainFormat corresponds to the MySQL system variable [explain_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explain_format).
        """
        return pulumi.get(self, "explain_format")

    @explain_format.setter
    def explain_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "explain_format", value)

    @property
    @pulumi.getter(name="explicitDefaultsForTimestamp")
    def explicit_defaults_for_timestamp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.

        explicit_defaults_for_timestamp corresponds to the MySQL Server Administration system variable [explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)
        """
        return pulumi.get(self, "explicit_defaults_for_timestamp")

    @explicit_defaults_for_timestamp.setter
    def explicit_defaults_for_timestamp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "explicit_defaults_for_timestamp", value)

    @property
    @pulumi.getter(name="foreignKeyChecks")
    def foreign_key_checks(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("foreign_key_checks")
        """
        return pulumi.get(self, "foreign_key_checks")

    @foreign_key_checks.setter
    def foreign_key_checks(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "foreign_key_checks", value)

    @property
    @pulumi.getter(name="generatedRandomPasswordLength")
    @_utilities.deprecated("""The 'generated_random_password_length' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def generated_random_password_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "generated_random_password_length")

    @generated_random_password_length.setter
    def generated_random_password_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generated_random_password_length", value)

    @property
    @pulumi.getter(name="globalConnectionMemoryLimit")
    def global_connection_memory_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the total amount of memory that can be used by all user connections.

        globalConnectionMemoryLimit corresponds to the MySQL system variable [global_connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_limit).
        """
        return pulumi.get(self, "global_connection_memory_limit")

    @global_connection_memory_limit.setter
    def global_connection_memory_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "global_connection_memory_limit", value)

    @property
    @pulumi.getter(name="globalConnectionMemoryTracking")
    def global_connection_memory_tracking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether the MySQL server calculates Global_connection_memory.

        globalConnectionMemoryTracking corresponds to the MySQL system variable [global_connection_memory_tracking](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_tracking).
        """
        return pulumi.get(self, "global_connection_memory_tracking")

    @global_connection_memory_tracking.setter
    def global_connection_memory_tracking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "global_connection_memory_tracking", value)

    @property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.

        This is the MySQL variable "group_concat_max_len". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)
        """
        return pulumi.get(self, "group_concat_max_len")

    @group_concat_max_len.setter
    def group_concat_max_len(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_concat_max_len", value)

    @property
    @pulumi.getter(name="groupReplicationConsistency")
    def group_replication_consistency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
        * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
        * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        """
        return pulumi.get(self, "group_replication_consistency")

    @group_replication_consistency.setter
    def group_replication_consistency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_replication_consistency", value)

    @property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("information_schema_stats_expiry")
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @information_schema_stats_expiry.setter
    def information_schema_stats_expiry(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "information_schema_stats_expiry", value)

    @property
    @pulumi.getter(name="innodbAdaptiveHashIndex")
    def innodb_adaptive_hash_index(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.

        innodbAdaptiveHashIndex corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_adaptive_hash_index] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index).
        """
        return pulumi.get(self, "innodb_adaptive_hash_index")

    @innodb_adaptive_hash_index.setter
    def innodb_adaptive_hash_index(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_adaptive_hash_index", value)

    @property
    @pulumi.getter(name="innodbAutoincLockMode")
    def innodb_autoinc_lock_mode(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.

        innodbAutoincLockMode corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_autoinc_lock_mode] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode).
        """
        return pulumi.get(self, "innodb_autoinc_lock_mode")

    @innodb_autoinc_lock_mode.setter
    def innodb_autoinc_lock_mode(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_autoinc_lock_mode", value)

    @property
    @pulumi.getter(name="innodbBufferPoolDumpPct")
    def innodb_buffer_pool_dump_pct(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.

        innodbBufferPoolDumpPct corresponds to the MySQL InnoDB system variable [innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct).

        The range is 1 to 100. The default value is 25.

        For example, if there are 4 buffer pools with 100 pages each, and innodb_buffer_pool_dump_pct is set to 25, the 25 most recently used pages from each buffer pool are dumped.
        """
        return pulumi.get(self, "innodb_buffer_pool_dump_pct")

    @innodb_buffer_pool_dump_pct.setter
    def innodb_buffer_pool_dump_pct(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_buffer_pool_dump_pct", value)

    @property
    @pulumi.getter(name="innodbBufferPoolInstances")
    def innodb_buffer_pool_instances(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("innodb_buffer_pool_instances")
        """
        return pulumi.get(self, "innodb_buffer_pool_instances")

    @innodb_buffer_pool_instances.setter
    def innodb_buffer_pool_instances(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_buffer_pool_instances", value)

    @property
    @pulumi.getter(name="innodbBufferPoolSize")
    def innodb_buffer_pool_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.

        innodbBufferPoolSize corresponds to the MySQL server system variable [innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size).

        The default and maximum values depend on the amount of RAM provisioned by the shape. See [Default User Variables](https://www.terraform.io/mysql-database/doc/configuring-db-system.html#GUID-B5504C19-F6F4-4DAB-8506-189A4E8F4A6A).
        """
        return pulumi.get(self, "innodb_buffer_pool_size")

    @innodb_buffer_pool_size.setter
    def innodb_buffer_pool_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_buffer_pool_size", value)

    @property
    @pulumi.getter(name="innodbChangeBuffering")
    def innodb_change_buffering(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.

        innodbChangeBuffering corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_change_buffering] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).
        """
        return pulumi.get(self, "innodb_change_buffering")

    @innodb_change_buffering.setter
    def innodb_change_buffering(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_change_buffering", value)

    @property
    @pulumi.getter(name="innodbDdlBufferSize")
    def innodb_ddl_buffer_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        """
        return pulumi.get(self, "innodb_ddl_buffer_size")

    @innodb_ddl_buffer_size.setter
    def innodb_ddl_buffer_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_ddl_buffer_size", value)

    @property
    @pulumi.getter(name="innodbDdlThreads")
    def innodb_ddl_threads(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        """
        return pulumi.get(self, "innodb_ddl_threads")

    @innodb_ddl_threads.setter
    def innodb_ddl_threads(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_ddl_threads", value)

    @property
    @pulumi.getter(name="innodbFtEnableStopword")
    def innodb_ft_enable_stopword(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("innodb_ft_enable_stopword")
        """
        return pulumi.get(self, "innodb_ft_enable_stopword")

    @innodb_ft_enable_stopword.setter
    def innodb_ft_enable_stopword(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_ft_enable_stopword", value)

    @property
    @pulumi.getter(name="innodbFtMaxTokenSize")
    def innodb_ft_max_token_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("innodb_ft_max_token_size")
        """
        return pulumi.get(self, "innodb_ft_max_token_size")

    @innodb_ft_max_token_size.setter
    def innodb_ft_max_token_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_ft_max_token_size", value)

    @property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("innodb_ft_min_token_size")
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @innodb_ft_min_token_size.setter
    def innodb_ft_min_token_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_ft_min_token_size", value)

    @property
    @pulumi.getter(name="innodbFtNumWordOptimize")
    def innodb_ft_num_word_optimize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("innodb_ft_num_word_optimize")
        """
        return pulumi.get(self, "innodb_ft_num_word_optimize")

    @innodb_ft_num_word_optimize.setter
    def innodb_ft_num_word_optimize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_ft_num_word_optimize", value)

    @property
    @pulumi.getter(name="innodbFtResultCacheLimit")
    def innodb_ft_result_cache_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("innodb_ft_result_cache_limit")
        """
        return pulumi.get(self, "innodb_ft_result_cache_limit")

    @innodb_ft_result_cache_limit.setter
    def innodb_ft_result_cache_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_ft_result_cache_limit", value)

    @property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("innodb_ft_server_stopword_table")
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @innodb_ft_server_stopword_table.setter
    def innodb_ft_server_stopword_table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_ft_server_stopword_table", value)

    @property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("innodb_lock_wait_timeout")
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @innodb_lock_wait_timeout.setter
    def innodb_lock_wait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_lock_wait_timeout", value)

    @property
    @pulumi.getter(name="innodbLogWriterThreads")
    def innodb_log_writer_threads(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.

        This is the MySQL variable "innodb_log_writer_threads". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)
        """
        return pulumi.get(self, "innodb_log_writer_threads")

    @innodb_log_writer_threads.setter
    def innodb_log_writer_threads(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_log_writer_threads", value)

    @property
    @pulumi.getter(name="innodbMaxPurgeLag")
    def innodb_max_purge_lag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired maximum purge lag in terms of transactions.

        InnoDB maintains a list of transactions that have index records delete-marked by UPDATE or DELETE operations. The length of the list is the purge lag.

        If this value is exceeded, a delay is imposed on INSERT, UPDATE, and DELETE operations to allow time for purge to catch up.

        The default value is 0, which means there is no maximum purge lag and no delay.

        innodbMaxPurgeLag corresponds to the MySQL server system variable [innodb_max_purge_lag](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag).
        """
        return pulumi.get(self, "innodb_max_purge_lag")

    @innodb_max_purge_lag.setter
    def innodb_max_purge_lag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_max_purge_lag", value)

    @property
    @pulumi.getter(name="innodbMaxPurgeLagDelay")
    def innodb_max_purge_lag_delay(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.

        The specified innodb_max_purge_lag_delay value is an upper limit on the delay period.

        innodbMaxPurgeLagDelay corresponds to the MySQL server system variable [innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay).
        """
        return pulumi.get(self, "innodb_max_purge_lag_delay")

    @innodb_max_purge_lag_delay.setter
    def innodb_max_purge_lag_delay(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_max_purge_lag_delay", value)

    @property
    @pulumi.getter(name="innodbNumaInterleave")
    def innodb_numa_interleave(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.

        innodbNumaInterleave corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_numa_interleave] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave).
        """
        return pulumi.get(self, "innodb_numa_interleave")

    @innodb_numa_interleave.setter
    def innodb_numa_interleave(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_numa_interleave", value)

    @property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.

        innodbOnlineAlterLogMaxSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_online_alter_log_max_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size).
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @innodb_online_alter_log_max_size.setter
    def innodb_online_alter_log_max_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_online_alter_log_max_size", value)

    @property
    @pulumi.getter(name="innodbRedoLogCapacity")
    def innodb_redo_log_capacity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.

        innodbRedoLogCapacity corresponds to the InnoDB Startup Options and System Variables [innodb_redo_log_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_capacity)
        """
        return pulumi.get(self, "innodb_redo_log_capacity")

    @innodb_redo_log_capacity.setter
    def innodb_redo_log_capacity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_redo_log_capacity", value)

    @property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.

        innodbRollbackOnTimeout corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_rollback_on_timeout] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout).
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @innodb_rollback_on_timeout.setter
    def innodb_rollback_on_timeout(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_rollback_on_timeout", value)

    @property
    @pulumi.getter(name="innodbSortBufferSize")
    def innodb_sort_buffer_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This variable defines:
        * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
        * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.

        innodbSortBufferSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_sort_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size).
        """
        return pulumi.get(self, "innodb_sort_buffer_size")

    @innodb_sort_buffer_size.setter
    def innodb_sort_buffer_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "innodb_sort_buffer_size", value)

    @property
    @pulumi.getter(name="innodbStatsPersistentSamplePages")
    def innodb_stats_persistent_sample_pages(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.

        innodbStatsPersistentSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)

        innodb_stats_persistent_sample_pages only applies when innodb_stats_persistent is enabled for a table; when innodb_stats_persistent is disabled, innodb_stats_transient_sample_pages applies instead.
        """
        return pulumi.get(self, "innodb_stats_persistent_sample_pages")

    @innodb_stats_persistent_sample_pages.setter
    def innodb_stats_persistent_sample_pages(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_stats_persistent_sample_pages", value)

    @property
    @pulumi.getter(name="innodbStatsTransientSamplePages")
    def innodb_stats_transient_sample_pages(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).

        innodbStatsTransientSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)

        innodb_stats_transient_sample_pages only applies when innodb_stats_persistent is disabled for a table; when innodb_stats_persistent is enabled, innodb_stats_persistent_sample_pages applies instead.

        innodb_stats_persistent is ON by default and cannot be changed. It is possible to override it using the STATS_PERSISTENT clause of the [CREATE TABLE](https://dev.mysql.com/doc/refman/8.0/en/create-table.html) and [ALTER TABLE](https://dev.mysql.com/doc/refman/8.0/en/alter-table.html) statements.
        """
        return pulumi.get(self, "innodb_stats_transient_sample_pages")

    @innodb_stats_transient_sample_pages.setter
    def innodb_stats_transient_sample_pages(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "innodb_stats_transient_sample_pages", value)

    @property
    @pulumi.getter(name="innodbStrictMode")
    def innodb_strict_mode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.

        innodbStrictMode corresponds to the MySQL InnoDB system variable [innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)
        """
        return pulumi.get(self, "innodb_strict_mode")

    @innodb_strict_mode.setter
    def innodb_strict_mode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_strict_mode", value)

    @property
    @pulumi.getter(name="innodbUndoLogTruncate")
    def innodb_undo_log_truncate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.

        innodbUndoLogTruncate corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_undo_log_truncate] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate).
        """
        return pulumi.get(self, "innodb_undo_log_truncate")

    @innodb_undo_log_truncate.setter
    def innodb_undo_log_truncate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "innodb_undo_log_truncate", value)

    @property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.

        interactiveTimeout corresponds to the MySQL system variable. [interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)
        """
        return pulumi.get(self, "interactive_timeout")

    @interactive_timeout.setter
    def interactive_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interactive_timeout", value)

    @property
    @pulumi.getter(name="joinBufferSize")
    def join_buffer_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.

        joinBufferSize corresponds to the MySQL Server System variable [join_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size).
        """
        return pulumi.get(self, "join_buffer_size")

    @join_buffer_size.setter
    def join_buffer_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "join_buffer_size", value)

    @property
    @pulumi.getter(name="localInfile")
    def local_infile(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side. 

        local_infile corresponds to the MySQL Server system variable [local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)
        """
        return pulumi.get(self, "local_infile")

    @local_infile.setter
    def local_infile(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_infile", value)

    @property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.

        longQueryTime corresponds to the MySQL Server System variable [long_query_time] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time).
        """
        return pulumi.get(self, "long_query_time")

    @long_query_time.setter
    def long_query_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "long_query_time", value)

    @property
    @pulumi.getter(name="mandatoryRoles")
    def mandatory_roles(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("mandatory_roles")
        """
        return pulumi.get(self, "mandatory_roles")

    @mandatory_roles.setter
    def mandatory_roles(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mandatory_roles", value)

    @property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum size of one packet or any generated/intermediate string.

        This is the mysql variable "max_allowed_packet".
        """
        return pulumi.get(self, "max_allowed_packet")

    @max_allowed_packet.setter
    def max_allowed_packet(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_allowed_packet", value)

    @property
    @pulumi.getter(name="maxBinlogCacheSize")
    def max_binlog_cache_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the size of the transaction cache.

        maxBinlogCacheSize corresponds to the MySQL server system variable [max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size).
        """
        return pulumi.get(self, "max_binlog_cache_size")

    @max_binlog_cache_size.setter
    def max_binlog_cache_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_binlog_cache_size", value)

    @property
    @pulumi.getter(name="maxConnectErrors")
    def max_connect_errors(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("max_connect_errors")
        """
        return pulumi.get(self, "max_connect_errors")

    @max_connect_errors.setter
    def max_connect_errors(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_connect_errors", value)

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("max_connections")
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @property
    @pulumi.getter(name="maxExecutionTime")
    def max_execution_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("max_execution_time")
        """
        return pulumi.get(self, "max_execution_time")

    @max_execution_time.setter
    def max_execution_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_execution_time", value)

    @property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.

        maxHeapTableSize corresponds to the MySQL system variable [max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)
        """
        return pulumi.get(self, "max_heap_table_size")

    @max_heap_table_size.setter
    def max_heap_table_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_heap_table_size", value)

    @property
    @pulumi.getter(name="maxPreparedStmtCount")
    def max_prepared_stmt_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("max_prepared_stmt_count")
        """
        return pulumi.get(self, "max_prepared_stmt_count")

    @max_prepared_stmt_count.setter
    def max_prepared_stmt_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_prepared_stmt_count", value)

    @property
    @pulumi.getter(name="maxSeeksForKey")
    def max_seeks_for_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.

        maxSeeksForKey corresponds to the MySQL Server System variable [max_seeks_for_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key).
        """
        return pulumi.get(self, "max_seeks_for_key")

    @max_seeks_for_key.setter
    def max_seeks_for_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_seeks_for_key", value)

    @property
    @pulumi.getter(name="maxUserConnections")
    def max_user_connections(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.

        maxUserConnections corresponds to the MySQL Server System variable [max_user_connections] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections).
        """
        return pulumi.get(self, "max_user_connections")

    @max_user_connections.setter
    def max_user_connections(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_user_connections", value)

    @property
    @pulumi.getter(name="mysqlFirewallMode")
    def mysql_firewall_mode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("mysql_firewall_mode")
        """
        return pulumi.get(self, "mysql_firewall_mode")

    @mysql_firewall_mode.setter
    def mysql_firewall_mode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mysql_firewall_mode", value)

    @property
    @pulumi.getter(name="mysqlZstdDefaultCompressionLevel")
    @_utilities.deprecated("""The 'mysql_zstd_default_compression_level' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysql_zstd_default_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        """
        return pulumi.get(self, "mysql_zstd_default_compression_level")

    @mysql_zstd_default_compression_level.setter
    def mysql_zstd_default_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysql_zstd_default_compression_level", value)

    @property
    @pulumi.getter(name="mysqlxConnectTimeout")
    def mysqlx_connect_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds X Plugin waits for the first packet to be received from newly connected clients.

        mysqlxConnectTimeout corresponds to the MySQL X Plugin system variable [mysqlx_connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_connect_timeout)
        """
        return pulumi.get(self, "mysqlx_connect_timeout")

    @mysqlx_connect_timeout.setter
    def mysqlx_connect_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_connect_timeout", value)

    @property
    @pulumi.getter(name="mysqlxDeflateDefaultCompressionLevel")
    def mysqlx_deflate_default_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_default_compression_level")

    @mysqlx_deflate_default_compression_level.setter
    def mysqlx_deflate_default_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_deflate_default_compression_level", value)

    @property
    @pulumi.getter(name="mysqlxDeflateMaxClientCompressionLevel")
    def mysqlx_deflate_max_client_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_max_client_compression_level")

    @mysqlx_deflate_max_client_compression_level.setter
    def mysqlx_deflate_max_client_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_deflate_max_client_compression_level", value)

    @property
    @pulumi.getter(name="mysqlxDocumentIdUniquePrefix")
    @_utilities.deprecated("""The 'mysqlx_document_id_unique_prefix' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_document_id_unique_prefix(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_document_id_unique_prefix")

    @mysqlx_document_id_unique_prefix.setter
    def mysqlx_document_id_unique_prefix(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_document_id_unique_prefix", value)

    @property
    @pulumi.getter(name="mysqlxEnableHelloNotice")
    def mysqlx_enable_hello_notice(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_enable_hello_notice")

    @mysqlx_enable_hello_notice.setter
    def mysqlx_enable_hello_notice(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mysqlx_enable_hello_notice", value)

    @property
    @pulumi.getter(name="mysqlxIdleWorkerThreadTimeout")
    @_utilities.deprecated("""The 'mysqlx_idle_worker_thread_timeout' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_idle_worker_thread_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_idle_worker_thread_timeout")

    @mysqlx_idle_worker_thread_timeout.setter
    def mysqlx_idle_worker_thread_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_idle_worker_thread_timeout", value)

    @property
    @pulumi.getter(name="mysqlxInteractiveTimeout")
    def mysqlx_interactive_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds to wait for interactive clients to timeout.

        mysqlxInteractiveTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_interactive_timeout)
        """
        return pulumi.get(self, "mysqlx_interactive_timeout")

    @mysqlx_interactive_timeout.setter
    def mysqlx_interactive_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_interactive_timeout", value)

    @property
    @pulumi.getter(name="mysqlxLz4defaultCompressionLevel")
    def mysqlx_lz4default_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4default_compression_level")

    @mysqlx_lz4default_compression_level.setter
    def mysqlx_lz4default_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_lz4default_compression_level", value)

    @property
    @pulumi.getter(name="mysqlxLz4maxClientCompressionLevel")
    def mysqlx_lz4max_client_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4max_client_compression_level")

    @mysqlx_lz4max_client_compression_level.setter
    def mysqlx_lz4max_client_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_lz4max_client_compression_level", value)

    @property
    @pulumi.getter(name="mysqlxMaxAllowedPacket")
    def mysqlx_max_allowed_packet(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum size of network packets that can be received by X Plugin.

        This is the mysql variable "mysqlx_max_allowed_packet".
        """
        return pulumi.get(self, "mysqlx_max_allowed_packet")

    @mysqlx_max_allowed_packet.setter
    def mysqlx_max_allowed_packet(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_max_allowed_packet", value)

    @property
    @pulumi.getter(name="mysqlxMinWorkerThreads")
    @_utilities.deprecated("""The 'mysqlx_min_worker_threads' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_min_worker_threads(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_min_worker_threads")

    @mysqlx_min_worker_threads.setter
    def mysqlx_min_worker_threads(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_min_worker_threads", value)

    @property
    @pulumi.getter(name="mysqlxReadTimeout")
    def mysqlx_read_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.

        mysqlxReadTimeout corresponds to the MySQL X Plugin system variable [mysqlx_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_read_timeout)
        """
        return pulumi.get(self, "mysqlx_read_timeout")

    @mysqlx_read_timeout.setter
    def mysqlx_read_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_read_timeout", value)

    @property
    @pulumi.getter(name="mysqlxWaitTimeout")
    def mysqlx_wait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds that X Plugin waits for activity on a connection.

        mysqlxWaitTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_wait_timeout)
        """
        return pulumi.get(self, "mysqlx_wait_timeout")

    @mysqlx_wait_timeout.setter
    def mysqlx_wait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_wait_timeout", value)

    @property
    @pulumi.getter(name="mysqlxWriteTimeout")
    def mysqlx_write_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.

        mysqlxReadmysqlxWriteTimeoutTimeout corresponds to the MySQL X Plugin system variable [mysqlx_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_write_timeout)
        """
        return pulumi.get(self, "mysqlx_write_timeout")

    @mysqlx_write_timeout.setter
    def mysqlx_write_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_write_timeout", value)

    @property
    @pulumi.getter(name="mysqlxZstdDefaultCompressionLevel")
    def mysqlx_zstd_default_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_default_compression_level")

    @mysqlx_zstd_default_compression_level.setter
    def mysqlx_zstd_default_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_zstd_default_compression_level", value)

    @property
    @pulumi.getter(name="mysqlxZstdMaxClientCompressionLevel")
    def mysqlx_zstd_max_client_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_max_client_compression_level")

    @mysqlx_zstd_max_client_compression_level.setter
    def mysqlx_zstd_max_client_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mysqlx_zstd_max_client_compression_level", value)

    @property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds to wait for more data from a connection before aborting the read.

        netReadTimeout corresponds to the MySQL system variable [net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)
        """
        return pulumi.get(self, "net_read_timeout")

    @net_read_timeout.setter
    def net_read_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "net_read_timeout", value)

    @property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.

        netWriteTimeout corresponds to the MySQL system variable [net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)
        """
        return pulumi.get(self, "net_write_timeout")

    @net_write_timeout.setter
    def net_write_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "net_write_timeout", value)

    @property
    @pulumi.getter(name="optimizerSwitch")
    def optimizer_switch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.

        Setting hypergraph_optimizer=on for cloud builds below 9.0.0 will fail.

        optimizerSwitch corresponds to the MySQL Server System variable [optimizer_switch] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch).
        """
        return pulumi.get(self, "optimizer_switch")

    @optimizer_switch.setter
    def optimizer_switch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "optimizer_switch", value)

    @property
    @pulumi.getter(name="parserMaxMemSize")
    def parser_max_mem_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("parser_max_mem_size")
        """
        return pulumi.get(self, "parser_max_mem_size")

    @parser_max_mem_size.setter
    def parser_max_mem_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parser_max_mem_size", value)

    @property
    @pulumi.getter(name="queryAllocBlockSize")
    @_utilities.deprecated("""The 'query_alloc_block_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def query_alloc_block_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_alloc_block_size")

    @query_alloc_block_size.setter
    def query_alloc_block_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_alloc_block_size", value)

    @property
    @pulumi.getter(name="queryPreallocSize")
    def query_prealloc_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_prealloc_size")

    @query_prealloc_size.setter
    def query_prealloc_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_prealloc_size", value)

    @property
    @pulumi.getter(name="rangeOptimizerMaxMemSize")
    @_utilities.deprecated("""The 'query_prealloc_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def range_optimizer_max_mem_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans. 

        rangeOptimizerMaxMemSize corresponds to the MySQL Server System variable [range_optimizer_max_mem_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size).
        """
        return pulumi.get(self, "range_optimizer_max_mem_size")

    @range_optimizer_max_mem_size.setter
    def range_optimizer_max_mem_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "range_optimizer_max_mem_size", value)

    @property
    @pulumi.getter(name="regexpTimeLimit")
    def regexp_time_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        """
        return pulumi.get(self, "regexp_time_limit")

    @regexp_time_limit.setter
    def regexp_time_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "regexp_time_limit", value)

    @property
    @pulumi.getter(name="relayLogSpaceLimit")
    def relay_log_space_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount of space to use for all relay logs.

        relayLogSpaceLimit corresponds to the MySQL Replica Server Options variable [relay_log_space_limit] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit).
        """
        return pulumi.get(self, "relay_log_space_limit")

    @relay_log_space_limit.setter
    def relay_log_space_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "relay_log_space_limit", value)

    @property
    @pulumi.getter(name="replicaNetTimeout")
    def replica_net_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.

        replicaNetTimeout corresponds to the MySQL Replica server system variable [replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_timeout)
        """
        return pulumi.get(self, "replica_net_timeout")

    @replica_net_timeout.setter
    def replica_net_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_net_timeout", value)

    @property
    @pulumi.getter(name="replicaParallelWorkers")
    def replica_parallel_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)

        replicaParallelWorkers corresponds to the MySQL Replica Server Options variable [replica_parallel_workers] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_parallel_workers).
        """
        return pulumi.get(self, "replica_parallel_workers")

    @replica_parallel_workers.setter
    def replica_parallel_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_parallel_workers", value)

    @property
    @pulumi.getter(name="replicaTypeConversions")
    def replica_type_conversions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.

        replica_type_conversions controls the type conversion mode in effect on the replica when using row-based replication. Its value is a comma-delimited set of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY, ALL_SIGNED, ALL_UNSIGNED. Set this variable to an empty string to disallow type conversions between the source and the replica. Setting this variable takes effect for all replication channels immediately, including running channels.

        replica_type_conversions corresponds to the MySQL Replica Server Options variable [replica_type_conversions] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_type_conversions).
        """
        return pulumi.get(self, "replica_type_conversions")

    @replica_type_conversions.setter
    def replica_type_conversions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replica_type_conversions", value)

    @property
    @pulumi.getter(name="requireSecureTransport")
    def require_secure_transport(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.

        require_secure_transport corresponds to the MySQL Server Administration system variable [require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)
        """
        return pulumi.get(self, "require_secure_transport")

    @require_secure_transport.setter
    def require_secure_transport(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_secure_transport", value)

    @property
    @pulumi.getter(name="skipNameResolve")
    def skip_name_resolve(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.

        skipNameResolve corresponds to the MySQL Server System variable [skip_name_resolve] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve).
        """
        return pulumi.get(self, "skip_name_resolve")

    @skip_name_resolve.setter
    def skip_name_resolve(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_name_resolve", value)

    @property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Each session that must perform a sort allocates a buffer of this size.

        sortBufferSize corresponds to the MySQL system variable [sort_buffer_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_sort_buffer_size)
        """
        return pulumi.get(self, "sort_buffer_size")

    @sort_buffer_size.setter
    def sort_buffer_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sort_buffer_size", value)

    @property
    @pulumi.getter(name="sqlGenerateInvisiblePrimaryKey")
    def sql_generate_invisible_primary_key(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.

        sqlGenerateInvisiblePrimaryKey corresponds to the MySQL system variable [sql_generate_invisible_primary_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_generate_invisible_primary_key).
        """
        return pulumi.get(self, "sql_generate_invisible_primary_key")

    @sql_generate_invisible_primary_key.setter
    def sql_generate_invisible_primary_key(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sql_generate_invisible_primary_key", value)

    @property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("sql_mode")
        """
        return pulumi.get(self, "sql_mode")

    @sql_mode.setter
    def sql_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_mode", value)

    @property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("sql_require_primary_key")
        """
        return pulumi.get(self, "sql_require_primary_key")

    @sql_require_primary_key.setter
    def sql_require_primary_key(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sql_require_primary_key", value)

    @property
    @pulumi.getter(name="sqlWarnings")
    def sql_warnings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ("sql_warnings")
        """
        return pulumi.get(self, "sql_warnings")

    @sql_warnings.setter
    def sql_warnings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sql_warnings", value)

    @property
    @pulumi.getter(name="tableDefinitionCache")
    def table_definition_cache(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.

        table_definition_cache corresponds to the MySQL Server Administration system variable [table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)
        """
        return pulumi.get(self, "table_definition_cache")

    @table_definition_cache.setter
    def table_definition_cache(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "table_definition_cache", value)

    @property
    @pulumi.getter(name="tableOpenCache")
    def table_open_cache(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.

        table_open_cache corresponds to the MySQL Server Administration system variable [table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)
        """
        return pulumi.get(self, "table_open_cache")

    @table_open_cache.setter
    def table_open_cache(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "table_open_cache", value)

    @property
    @pulumi.getter(name="temptableMaxRam")
    def temptable_max_ram(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.

        temptableMaxRam corresponds to the MySQL system variable [temptable_max_ram] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram).
        """
        return pulumi.get(self, "temptable_max_ram")

    @temptable_max_ram.setter
    def temptable_max_ram(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "temptable_max_ram", value)

    @property
    @pulumi.getter(name="threadPoolDedicatedListeners")
    def thread_pool_dedicated_listeners(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        """
        return pulumi.get(self, "thread_pool_dedicated_listeners")

    @thread_pool_dedicated_listeners.setter
    def thread_pool_dedicated_listeners(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "thread_pool_dedicated_listeners", value)

    @property
    @pulumi.getter(name="threadPoolMaxTransactionsLimit")
    def thread_pool_max_transactions_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        """
        return pulumi.get(self, "thread_pool_max_transactions_limit")

    @thread_pool_max_transactions_limit.setter
    def thread_pool_max_transactions_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "thread_pool_max_transactions_limit", value)

    @property
    @pulumi.getter(name="threadPoolQueryThreadsPerGroup")
    def thread_pool_query_threads_per_group(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions. 

        threadPoolQueryThreadsPerGroup corresponds to the MySQL Server system variable [thread_pool_query_threads_per_group](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_query_threads_per_group)
        """
        return pulumi.get(self, "thread_pool_query_threads_per_group")

    @thread_pool_query_threads_per_group.setter
    def thread_pool_query_threads_per_group(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "thread_pool_query_threads_per_group", value)

    @property
    @pulumi.getter(name="threadPoolSize")
    def thread_pool_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.

        threadPoolSize corresponds to the MySQL Server System variable [thread_pool_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size).
        """
        return pulumi.get(self, "thread_pool_size")

    @thread_pool_size.setter
    def thread_pool_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "thread_pool_size", value)

    @property
    @pulumi.getter(name="threadPoolTransactionDelay")
    def thread_pool_transaction_delay(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running. 

        threadPoolTransactionDelay corresponds to the MySQL Server system variable [thread_pool_transaction_delay](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_transaction_delay)
        """
        return pulumi.get(self, "thread_pool_transaction_delay")

    @thread_pool_transaction_delay.setter
    def thread_pool_transaction_delay(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "thread_pool_transaction_delay", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Initializes the time zone for each client that connects.

        This corresponds to the MySQL System Variable "time_zone".

        The values can be given in one of the following formats, none of which are case-sensitive:
        * As a string indicating an offset from UTC of the form [H]H:MM, prefixed with a + or -, such as '+10:00', '-6:00', or '+05:30'. The permitted range is '-13:59' to '+14:00', inclusive.
        * As a named time zone, as defined by the "IANA Time Zone database", such as 'Europe/Helsinki', 'US/Eastern', 'MET', or 'UTC'.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.

        tmp_table_size corresponds to the MySQL system variable [tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)
        """
        return pulumi.get(self, "tmp_table_size")

    @tmp_table_size.setter
    def tmp_table_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tmp_table_size", value)

    @property
    @pulumi.getter(name="transactionIsolation")
    def transaction_isolation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ("transaction_isolation")
        """
        return pulumi.get(self, "transaction_isolation")

    @transaction_isolation.setter
    def transaction_isolation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transaction_isolation", value)

    @property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.

        waitTimeout corresponds to the MySQL system variable. [wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wait_timeout")

    @wait_timeout.setter
    def wait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "wait_timeout", value)


if not MYPY:
    class MysqlDbSystemBackupPolicyArgsDict(TypedDict):
        copy_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemBackupPolicyCopyPolicyArgsDict']]]]
        """
        (Updatable) List of policies of a DB system to schedule cross-region DB system backup copy.

        The policy includes the name of the destination region to which the DB system backup will be copied, and an optional parameter which specifies the retention period of the copied DB system backup in days.

        **Note:** Currently, only one policy can be specified in the list.
        """
        defined_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{"foo-namespace.bar-key": "value"}`
        """
        freeform_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{"bar-key": "value"}`
        """
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Specifies if automatic backups are enabled.
        """
        pitr_policy: NotRequired[pulumi.Input['MysqlDbSystemBackupPolicyPitrPolicyArgsDict']]
        """
        (Updatable) The PITR policy for the DB System.
        """
        retention_in_days: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) Number of days to retain an automatic backup.
        """
        window_start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The start of a 30-minute window of time in which daily, automated backups occur.

        This should be in the format of the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        At some point in the window, the system may incur a brief service disruption as the backup is performed.
        """
elif False:
    MysqlDbSystemBackupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemBackupPolicyArgs:
    def __init__(__self__, *,
                 copy_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemBackupPolicyCopyPolicyArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pitr_policy: Optional[pulumi.Input['MysqlDbSystemBackupPolicyPitrPolicyArgs']] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 window_start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemBackupPolicyCopyPolicyArgs']]] copy_policies: (Updatable) List of policies of a DB system to schedule cross-region DB system backup copy.
               
               The policy includes the name of the destination region to which the DB system backup will be copied, and an optional parameter which specifies the retention period of the copied DB system backup in days.
               
               **Note:** Currently, only one policy can be specified in the list.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces.
               
               Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.
               
               Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
               
               Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.
               
               Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Specifies if automatic backups are enabled.
        :param pulumi.Input['MysqlDbSystemBackupPolicyPitrPolicyArgs'] pitr_policy: (Updatable) The PITR policy for the DB System.
        :param pulumi.Input[builtins.int] retention_in_days: (Updatable) Number of days to retain an automatic backup.
        :param pulumi.Input[builtins.str] window_start_time: (Updatable) The start of a 30-minute window of time in which daily, automated backups occur.
               
               This should be in the format of the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
               
               At some point in the window, the system may incur a brief service disruption as the backup is performed.
        """
        if copy_policies is not None:
            pulumi.set(__self__, "copy_policies", copy_policies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if pitr_policy is not None:
            pulumi.set(__self__, "pitr_policy", pitr_policy)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemBackupPolicyCopyPolicyArgs']]]]:
        """
        (Updatable) List of policies of a DB system to schedule cross-region DB system backup copy.

        The policy includes the name of the destination region to which the DB system backup will be copied, and an optional parameter which specifies the retention period of the copied DB system backup in days.

        **Note:** Currently, only one policy can be specified in the list.
        """
        return pulumi.get(self, "copy_policies")

    @copy_policies.setter
    def copy_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemBackupPolicyCopyPolicyArgs']]]]):
        pulumi.set(self, "copy_policies", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies if automatic backups are enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="pitrPolicy")
    def pitr_policy(self) -> Optional[pulumi.Input['MysqlDbSystemBackupPolicyPitrPolicyArgs']]:
        """
        (Updatable) The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policy")

    @pitr_policy.setter
    def pitr_policy(self, value: Optional[pulumi.Input['MysqlDbSystemBackupPolicyPitrPolicyArgs']]):
        pulumi.set(self, "pitr_policy", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Number of days to retain an automatic backup.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The start of a 30-minute window of time in which daily, automated backups occur.

        This should be in the format of the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        At some point in the window, the system may incur a brief service disruption as the backup is performed.
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "window_start_time", value)


if not MYPY:
    class MysqlDbSystemBackupPolicyCopyPolicyArgsDict(TypedDict):
        copy_to_region: pulumi.Input[builtins.str]
        """
        (Updatable) The destination region name to which the DB system backup will be copied.
        """
        backup_copy_retention_in_days: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) Number of days to retain the copied DB system backup.
        """
elif False:
    MysqlDbSystemBackupPolicyCopyPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemBackupPolicyCopyPolicyArgs:
    def __init__(__self__, *,
                 copy_to_region: pulumi.Input[builtins.str],
                 backup_copy_retention_in_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] copy_to_region: (Updatable) The destination region name to which the DB system backup will be copied.
        :param pulumi.Input[builtins.int] backup_copy_retention_in_days: (Updatable) Number of days to retain the copied DB system backup.
        """
        pulumi.set(__self__, "copy_to_region", copy_to_region)
        if backup_copy_retention_in_days is not None:
            pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)

    @property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")

    @copy_to_region.setter
    def copy_to_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "copy_to_region", value)

    @property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")

    @backup_copy_retention_in_days.setter
    def backup_copy_retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_copy_retention_in_days", value)


if not MYPY:
    class MysqlDbSystemBackupPolicyPitrPolicyArgsDict(TypedDict):
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Specifies if PITR is enabled or disabled.
        """
elif False:
    MysqlDbSystemBackupPolicyPitrPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemBackupPolicyPitrPolicyArgs:
    def __init__(__self__, *,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Specifies if PITR is enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies if PITR is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)


if not MYPY:
    class MysqlDbSystemChannelArgsDict(TypedDict):
        compartment_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the compartment.
        """
        defined_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        display_name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        """
        freeform_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the DB System.
        """
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        lifecycle_details: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional information about the current lifecycleState.
        """
        sources: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceArgsDict']]]]
        """
        Parameters detailing how to provision the initial data of the system.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        system_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetArgsDict']]]]
        """
        Details about the Channel target.
        """
        time_created: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time the DB System was created.
        """
        time_updated: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the DB System was last updated.
        """
elif False:
    MysqlDbSystemChannelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemChannelArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetArgs']]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] id: The OCID of the DB System.
        :param pulumi.Input[builtins.bool] is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceArgs']]] sources: Parameters detailing how to provision the initial data of the system.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetArgs']]] targets: Details about the Channel target.
        :param pulumi.Input[builtins.str] time_created: The date and time the DB System was created.
        :param pulumi.Input[builtins.str] time_updated: The time the DB System was last updated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the DB System.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceArgs']]]]:
        """
        Parameters detailing how to provision the initial data of the system.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetArgs']]]]:
        """
        Details about the Channel target.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class MysqlDbSystemChannelSourceArgsDict(TypedDict):
        anonymous_transactions_handlings: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgsDict']]]]
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        The network address of the DB System.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port for primary endpoint of the DB System to listen on.
        """
        source_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        """
        ssl_ca_certificates: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceSslCaCertificateArgsDict']]]]
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        ssl_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The SSL mode of the Channel.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
elif False:
    MysqlDbSystemChannelSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemChannelSourceArgs:
    def __init__(__self__, *,
                 anonymous_transactions_handlings: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs']]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceSslCaCertificateArgs']]]] = None,
                 ssl_mode: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs']]] anonymous_transactions_handlings: Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param pulumi.Input[builtins.str] hostname: The network address of the DB System.
        :param pulumi.Input[builtins.int] port: The port for primary endpoint of the DB System to listen on.
        :param pulumi.Input[builtins.str] source_type: The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceSslCaCertificateArgs']]] ssl_ca_certificates: The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        :param pulumi.Input[builtins.str] ssl_mode: The SSL mode of the Channel.
        :param pulumi.Input[builtins.str] username: The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        if anonymous_transactions_handlings is not None:
            pulumi.set(__self__, "anonymous_transactions_handlings", anonymous_transactions_handlings)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if ssl_ca_certificates is not None:
            pulumi.set(__self__, "ssl_ca_certificates", ssl_ca_certificates)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="anonymousTransactionsHandlings")
    def anonymous_transactions_handlings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs']]]]:
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handlings")

    @anonymous_transactions_handlings.setter
    def anonymous_transactions_handlings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs']]]]):
        pulumi.set(self, "anonymous_transactions_handlings", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="sslCaCertificates")
    def ssl_ca_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceSslCaCertificateArgs']]]]:
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificates")

    @ssl_ca_certificates.setter
    def ssl_ca_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelSourceSslCaCertificateArgs']]]]):
        pulumi.set(self, "ssl_ca_certificates", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgsDict(TypedDict):
        last_configured_log_filename: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        last_configured_log_offset: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        uuid: NotRequired[pulumi.Input[builtins.str]]
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
elif False:
    MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs:
    def __init__(__self__, *,
                 last_configured_log_filename: Optional[pulumi.Input[builtins.str]] = None,
                 last_configured_log_offset: Optional[pulumi.Input[builtins.str]] = None,
                 policy: Optional[pulumi.Input[builtins.str]] = None,
                 uuid: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] last_configured_log_filename: Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param pulumi.Input[builtins.str] last_configured_log_offset: Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param pulumi.Input[builtins.str] policy: Specifies how the replication channel handles anonymous transactions.
        :param pulumi.Input[builtins.str] uuid: The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        if last_configured_log_filename is not None:
            pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        if last_configured_log_offset is not None:
            pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @last_configured_log_filename.setter
    def last_configured_log_filename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_configured_log_filename", value)

    @property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @last_configured_log_offset.setter
    def last_configured_log_offset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_configured_log_offset", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class MysqlDbSystemChannelSourceSslCaCertificateArgsDict(TypedDict):
        certificate_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of CA certificate.
        """
        contents: NotRequired[pulumi.Input[builtins.str]]
        """
        The string containing the CA certificate in PEM format.
        """
elif False:
    MysqlDbSystemChannelSourceSslCaCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemChannelSourceSslCaCertificateArgs:
    def __init__(__self__, *,
                 certificate_type: Optional[pulumi.Input[builtins.str]] = None,
                 contents: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_type: The type of CA certificate.
        :param pulumi.Input[builtins.str] contents: The string containing the CA certificate in PEM format.
        """
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if contents is not None:
            pulumi.set(__self__, "contents", contents)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_type", value)

    @property
    @pulumi.getter
    def contents(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contents", value)


if not MYPY:
    class MysqlDbSystemChannelTargetArgsDict(TypedDict):
        applier_username: NotRequired[pulumi.Input[builtins.str]]
        """
        The username for the replication applier of the target MySQL DB System.
        """
        channel_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        db_system_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        delay_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetFilterArgsDict']]]]
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        tables_without_primary_key_handling: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        target_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The specific target identifier.
        """
elif False:
    MysqlDbSystemChannelTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemChannelTargetArgs:
    def __init__(__self__, *,
                 applier_username: Optional[pulumi.Input[builtins.str]] = None,
                 channel_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 delay_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetFilterArgs']]]] = None,
                 tables_without_primary_key_handling: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] applier_username: The username for the replication applier of the target MySQL DB System.
        :param pulumi.Input[builtins.str] channel_name: The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param pulumi.Input[builtins.str] db_system_id: The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        :param pulumi.Input[builtins.int] delay_in_seconds: Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetFilterArgs']]] filters: Replication filter rules to be applied at the DB System Channel target.
        :param pulumi.Input[builtins.str] tables_without_primary_key_handling: Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        :param pulumi.Input[builtins.str] target_type: The specific target identifier.
        """
        if applier_username is not None:
            pulumi.set(__self__, "applier_username", applier_username)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if delay_in_seconds is not None:
            pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if tables_without_primary_key_handling is not None:
            pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @applier_username.setter
    def applier_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "applier_username", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @delay_in_seconds.setter
    def delay_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "delay_in_seconds", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetFilterArgs']]]]:
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelTargetFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @tables_without_primary_key_handling.setter
    def tables_without_primary_key_handling(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tables_without_primary_key_handling", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific target identifier.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_type", value)


if not MYPY:
    class MysqlDbSystemChannelTargetFilterArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of the filter rule.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
elif False:
    MysqlDbSystemChannelTargetFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemChannelTargetFilterArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The type of the filter rule.
        :param pulumi.Input[builtins.str] value: The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the filter rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class MysqlDbSystemCurrentPlacementArgsDict(TypedDict):
        availability_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.
        """
        fault_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
elif False:
    MysqlDbSystemCurrentPlacementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemCurrentPlacementArgs:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] availability_domain: The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the availability domain in which the DB System is placed.
        :param pulumi.Input[builtins.str] fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fault_domain", value)


if not MYPY:
    class MysqlDbSystemCustomerContactArgsDict(TypedDict):
        email: pulumi.Input[builtins.str]
        """
        (Updatable) The email address used by Oracle to send notifications regarding the DB System.
        """
elif False:
    MysqlDbSystemCustomerContactArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemCustomerContactArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] email: (Updatable) The email address used by Oracle to send notifications regarding the DB System.
        """
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The email address used by Oracle to send notifications regarding the DB System.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)


if not MYPY:
    class MysqlDbSystemDataStorageArgsDict(TypedDict):
        allocated_storage_size_in_gbs: NotRequired[pulumi.Input[builtins.int]]
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        data_storage_size_in_gb: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        """
        data_storage_size_limit_in_gbs: NotRequired[pulumi.Input[builtins.int]]
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        is_auto_expand_storage_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        max_storage_size_in_gbs: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB. DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB. DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB. DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size. You cannot set the maximum data storage size to less than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.
        """
elif False:
    MysqlDbSystemDataStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemDataStorageArgs:
    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 data_storage_size_limit_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 is_auto_expand_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param pulumi.Input[builtins.int] data_storage_size_in_gb: (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        :param pulumi.Input[builtins.int] data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param pulumi.Input[builtins.bool] is_auto_expand_storage_enabled: (Updatable) Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param pulumi.Input[builtins.int] max_storage_size_in_gbs: (Updatable) Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
               
               DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB. DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB. DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB. DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.
               
               It is not possible to decrease data storage size. You cannot set the maximum data storage size to less than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.
        """
        if allocated_storage_size_in_gbs is not None:
            pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_limit_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        if is_auto_expand_storage_enabled is not None:
            pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        if max_storage_size_in_gbs is not None:
            pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @allocated_storage_size_in_gbs.setter
    def allocated_storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocated_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @data_storage_size_limit_in_gbs.setter
    def data_storage_size_limit_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "data_storage_size_limit_in_gbs", value)

    @property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @is_auto_expand_storage_enabled.setter
    def is_auto_expand_storage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_expand_storage_enabled", value)

    @property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB. DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB. DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB. DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size. You cannot set the maximum data storage size to less than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")

    @max_storage_size_in_gbs.setter
    def max_storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_storage_size_in_gbs", value)


if not MYPY:
    class MysqlDbSystemDeletionPolicyArgsDict(TypedDict):
        automatic_backup_retention: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        final_backup: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        is_delete_protected: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
elif False:
    MysqlDbSystemDeletionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemDeletionPolicyArgs:
    def __init__(__self__, *,
                 automatic_backup_retention: Optional[pulumi.Input[builtins.str]] = None,
                 final_backup: Optional[pulumi.Input[builtins.str]] = None,
                 is_delete_protected: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] automatic_backup_retention: (Updatable) Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param pulumi.Input[builtins.str] final_backup: (Updatable) Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param pulumi.Input[builtins.bool] is_delete_protected: (Updatable) Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        if automatic_backup_retention is not None:
            pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        if final_backup is not None:
            pulumi.set(__self__, "final_backup", final_backup)
        if is_delete_protected is not None:
            pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @automatic_backup_retention.setter
    def automatic_backup_retention(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automatic_backup_retention", value)

    @property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @final_backup.setter
    def final_backup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "final_backup", value)

    @property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")

    @is_delete_protected.setter
    def is_delete_protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_delete_protected", value)


if not MYPY:
    class MysqlDbSystemEndpointArgsDict(TypedDict):
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        The network address of the DB System.
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        modes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The access modes from the client that this endpoint supports.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port for primary endpoint of the DB System to listen on.
        """
        port_x: NotRequired[pulumi.Input[builtins.int]]
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the resource that this endpoint is attached to.
        """
        resource_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of endpoint that clients and connectors can connect to.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        status_details: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional information about the current endpoint status.
        """
elif False:
    MysqlDbSystemEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemEndpointArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 port_x: Optional[pulumi.Input[builtins.int]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_details: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: The network address of the DB System.
        :param pulumi.Input[builtins.str] ip_address: The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modes: The access modes from the client that this endpoint supports.
        :param pulumi.Input[builtins.int] port: The port for primary endpoint of the DB System to listen on.
        :param pulumi.Input[builtins.int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[builtins.str] resource_id: The OCID of the resource that this endpoint is attached to.
        :param pulumi.Input[builtins.str] resource_type: The type of endpoint that clients and connectors can connect to.
        :param pulumi.Input[builtins.str] status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param pulumi.Input[builtins.str] status_details: Additional information about the current endpoint status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if modes is not None:
            pulumi.set(__self__, "modes", modes)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @modes.setter
    def modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "modes", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @port_x.setter
    def port_x(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port_x", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")

    @status_details.setter
    def status_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_details", value)


if not MYPY:
    class MysqlDbSystemHeatWaveClusterArgsDict(TypedDict):
        cluster_size: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        """
        is_lakehouse_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Lakehouse enabled status for the HeatWave cluster.
        """
        shape_name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The name of the shape. The shape determines the resources allocated
        * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        time_created: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time the DB System was created.
        """
        time_updated: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the DB System was last updated.
        """
elif False:
    MysqlDbSystemHeatWaveClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemHeatWaveClusterArgs:
    def __init__(__self__, *,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 is_lakehouse_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] cluster_size: The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        :param pulumi.Input[builtins.bool] is_lakehouse_enabled: Lakehouse enabled status for the HeatWave cluster.
        :param pulumi.Input[builtins.str] shape_name: (Updatable) The name of the shape. The shape determines the resources allocated
               * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[builtins.str] time_created: The date and time the DB System was created.
        :param pulumi.Input[builtins.str] time_updated: The time the DB System was last updated.
        """
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if is_lakehouse_enabled is not None:
            pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Lakehouse enabled status for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @is_lakehouse_enabled.setter
    def is_lakehouse_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lakehouse_enabled", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the shape. The shape determines the resources allocated
        * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class MysqlDbSystemMaintenanceArgsDict(TypedDict):
        window_start_time: pulumi.Input[builtins.str]
        """
        (Updatable) The start of the 2 hour maintenance window.

        This string is of the format: "{day-of-week} {time-of-day}".

        "{day-of-week}" is a case-insensitive string like "mon", "tue", &c.

        "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        If you set the read replica maintenance window to "" or if not specified, the read replica is set same as the DB system maintenance window.
        """
elif False:
    MysqlDbSystemMaintenanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemMaintenanceArgs:
    def __init__(__self__, *,
                 window_start_time: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] window_start_time: (Updatable) The start of the 2 hour maintenance window.
               
               This string is of the format: "{day-of-week} {time-of-day}".
               
               "{day-of-week}" is a case-insensitive string like "mon", "tue", &c.
               
               "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
               
               If you set the read replica maintenance window to "" or if not specified, the read replica is set same as the DB system maintenance window.
        """
        pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The start of the 2 hour maintenance window.

        This string is of the format: "{day-of-week} {time-of-day}".

        "{day-of-week}" is a case-insensitive string like "mon", "tue", &c.

        "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        If you set the read replica maintenance window to "" or if not specified, the read replica is set same as the DB system maintenance window.
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "window_start_time", value)


if not MYPY:
    class MysqlDbSystemPointInTimeRecoveryDetailArgsDict(TypedDict):
        time_earliest_recovery_point: NotRequired[pulumi.Input[builtins.str]]
        """
        Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        time_latest_recovery_point: NotRequired[pulumi.Input[builtins.str]]
        """
        Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
elif False:
    MysqlDbSystemPointInTimeRecoveryDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemPointInTimeRecoveryDetailArgs:
    def __init__(__self__, *,
                 time_earliest_recovery_point: Optional[pulumi.Input[builtins.str]] = None,
                 time_latest_recovery_point: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] time_earliest_recovery_point: Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[builtins.str] time_latest_recovery_point: Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        if time_earliest_recovery_point is not None:
            pulumi.set(__self__, "time_earliest_recovery_point", time_earliest_recovery_point)
        if time_latest_recovery_point is not None:
            pulumi.set(__self__, "time_latest_recovery_point", time_latest_recovery_point)

    @property
    @pulumi.getter(name="timeEarliestRecoveryPoint")
    def time_earliest_recovery_point(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_earliest_recovery_point")

    @time_earliest_recovery_point.setter
    def time_earliest_recovery_point(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_earliest_recovery_point", value)

    @property
    @pulumi.getter(name="timeLatestRecoveryPoint")
    def time_latest_recovery_point(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_latest_recovery_point")

    @time_latest_recovery_point.setter
    def time_latest_recovery_point(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_latest_recovery_point", value)


if not MYPY:
    class MysqlDbSystemReadEndpointArgsDict(TypedDict):
        exclude_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        is_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Specifies if the DB System read endpoint is enabled or not.
        """
        read_endpoint_hostname_label: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The hostname for the read endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)  (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        read_endpoint_ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
elif False:
    MysqlDbSystemReadEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemReadEndpointArgs:
    def __init__(__self__, *,
                 exclude_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 read_endpoint_hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 read_endpoint_ip_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude_ips: (Updatable) A list of IP addresses of read replicas that are excluded from serving read requests.
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Specifies if the DB System read endpoint is enabled or not.
        :param pulumi.Input[builtins.str] read_endpoint_hostname_label: (Updatable) The hostname for the read endpoint of the DB System. Used for DNS.
               
               The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)  (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").
               
               Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param pulumi.Input[builtins.str] read_endpoint_ip_address: (Updatable) The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        if exclude_ips is not None:
            pulumi.set(__self__, "exclude_ips", exclude_ips)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if read_endpoint_hostname_label is not None:
            pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        if read_endpoint_ip_address is not None:
            pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @exclude_ips.setter
    def exclude_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exclude_ips", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The hostname for the read endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)  (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @read_endpoint_hostname_label.setter
    def read_endpoint_hostname_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_endpoint_hostname_label", value)

    @property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")

    @read_endpoint_ip_address.setter
    def read_endpoint_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_endpoint_ip_address", value)


if not MYPY:
    class MysqlDbSystemRestArgsDict(TypedDict):
        configuration: pulumi.Input[builtins.str]
        """
        (Updatable) Select how REST is configured across the DB System instances.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
elif False:
    MysqlDbSystemRestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemRestArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input[builtins.str],
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] configuration: (Updatable) Select how REST is configured across the DB System instances.
        :param pulumi.Input[builtins.int] port: (Updatable) The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        pulumi.set(__self__, "configuration", configuration)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class MysqlDbSystemSecureConnectionsArgsDict(TypedDict):
        certificate_generation_type: pulumi.Input[builtins.str]
        """
        (Updatable) Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        certificate_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The OCID of the certificate to use.
        """
elif False:
    MysqlDbSystemSecureConnectionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemSecureConnectionsArgs:
    def __init__(__self__, *,
                 certificate_generation_type: pulumi.Input[builtins.str],
                 certificate_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_generation_type: (Updatable) Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param pulumi.Input[builtins.str] certificate_id: (Updatable) The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @certificate_generation_type.setter
    def certificate_generation_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_generation_type", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_id", value)


if not MYPY:
    class MysqlDbSystemSourceArgsDict(TypedDict):
        source_type: pulumi.Input[builtins.str]
        """
        The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        """
        backup_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the backup to be used as the source for the new DB System.
        """
        db_system_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        recovery_point: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        """
        source_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The Pre-Authenticated Request (PAR) of a bucket/prefix or PAR of a @.manifest.json object from the Object Storage. Check [Using Pre-Authenticated Requests](https://docs.oracle.com/en-us/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm) for information related to PAR creation. Please create PAR with "Permit object reads" access type and "Enable Object Listing" permission when using a bucket/prefix PAR. Please create PAR with "Permit object reads" access type when using a @.manifest.json object PAR.
        """
elif False:
    MysqlDbSystemSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDbSystemSourceArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[builtins.str],
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_point: Optional[pulumi.Input[builtins.str]] = None,
                 source_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] source_type: The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        :param pulumi.Input[builtins.str] backup_id: The OCID of the backup to be used as the source for the new DB System.
        :param pulumi.Input[builtins.str] db_system_id: The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        :param pulumi.Input[builtins.str] recovery_point: The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        :param pulumi.Input[builtins.str] source_url: The Pre-Authenticated Request (PAR) of a bucket/prefix or PAR of a @.manifest.json object from the Object Storage. Check [Using Pre-Authenticated Requests](https://docs.oracle.com/en-us/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm) for information related to PAR creation. Please create PAR with "Permit object reads" access type and "Enable Object Listing" permission when using a bucket/prefix PAR. Please create PAR with "Permit object reads" access type when using a @.manifest.json object PAR.
        """
        pulumi.set(__self__, "source_type", source_type)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if recovery_point is not None:
            pulumi.set(__self__, "recovery_point", recovery_point)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[builtins.str]:
        """
        The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the backup to be used as the source for the new DB System.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="recoveryPoint")
    def recovery_point(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        """
        return pulumi.get(self, "recovery_point")

    @recovery_point.setter
    def recovery_point(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_point", value)

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Pre-Authenticated Request (PAR) of a bucket/prefix or PAR of a @.manifest.json object from the Object Storage. Check [Using Pre-Authenticated Requests](https://docs.oracle.com/en-us/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm) for information related to PAR creation. Please create PAR with "Permit object reads" access type and "Enable Object Listing" permission when using a bucket/prefix PAR. Please create PAR with "Permit object reads" access type when using a @.manifest.json object PAR.
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_url", value)


if not MYPY:
    class ReplicaReplicaOverridesArgsDict(TypedDict):
        configuration_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The OCID of the Configuration to be used by the read replica.
        """
        mysql_version: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The MySQL version to be used by the read replica.
        """
        nsg_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) Network Security Group OCIDs used for the VNIC attachment.
        """
        shape_name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The shape to be used by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    ReplicaReplicaOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaReplicaOverridesArgs:
    def __init__(__self__, *,
                 configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] configuration_id: (Updatable) The OCID of the Configuration to be used by the read replica.
        :param pulumi.Input[builtins.str] mysql_version: (Updatable) The MySQL version to be used by the read replica.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) Network Security Group OCIDs used for the VNIC attachment.
        :param pulumi.Input[builtins.str] shape_name: (Updatable) The shape to be used by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mysql_version", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The shape to be used by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape_name", value)


if not MYPY:
    class ReplicaSecureConnectionArgsDict(TypedDict):
        certificate_generation_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        certificate_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the certificate to use.
        """
elif False:
    ReplicaSecureConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaSecureConnectionArgs:
    def __init__(__self__, *,
                 certificate_generation_type: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param pulumi.Input[builtins.str] certificate_id: The OCID of the certificate to use.
        """
        if certificate_generation_type is not None:
            pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @certificate_generation_type.setter
    def certificate_generation_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_generation_type", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_id", value)


if not MYPY:
    class GetChannelsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetChannelsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetChannelsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMysqlBackupsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetMysqlBackupsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMysqlBackupsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMysqlConfigurationsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetMysqlConfigurationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMysqlConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMysqlDbSystemsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetMysqlDbSystemsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMysqlDbSystemsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMysqlVersionFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetMysqlVersionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMysqlVersionFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetReplicasFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetReplicasFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetReplicasFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetShapesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetShapesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetShapesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


