# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IndexKey',
    'TableReplica',
    'TableSchema',
    'TableSchemaColumn',
    'TableSchemaIdentity',
    'TableTableLimits',
    'GetIndexKeyResult',
    'GetIndexesFilterResult',
    'GetIndexesIndexCollectionResult',
    'GetIndexesIndexCollectionKeyResult',
    'GetTableReplicaResult',
    'GetTableSchemaResult',
    'GetTableSchemaColumnResult',
    'GetTableSchemaIdentityResult',
    'GetTableTableLimitResult',
    'GetTablesFilterResult',
    'GetTablesTableCollectionResult',
    'GetTablesTableCollectionReplicaResult',
    'GetTablesTableCollectionSchemaResult',
    'GetTablesTableCollectionSchemaColumnResult',
    'GetTablesTableCollectionSchemaIdentityResult',
    'GetTablesTableCollectionTableLimitResult',
]

@pulumi.output_type
class IndexKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "jsonFieldType":
            suggest = "json_field_type"
        elif key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: builtins.str,
                 json_field_type: Optional[builtins.str] = None,
                 json_path: Optional[builtins.str] = None):
        """
        :param builtins.str column_name: The name of a column to be included as an index key.
        :param builtins.str json_field_type: If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        :param builtins.str json_path: If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        pulumi.set(__self__, "column_name", column_name)
        if json_field_type is not None:
            pulumi.set(__self__, "json_field_type", json_field_type)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        """
        The name of a column to be included as an index key.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="jsonFieldType")
    def json_field_type(self) -> Optional[builtins.str]:
        """
        If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        """
        return pulumi.get(self, "json_field_type")

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[builtins.str]:
        """
        If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class TableReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityMode":
            suggest = "capacity_mode"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "maxWriteUnits":
            suggest = "max_write_units"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_mode: Optional[builtins.str] = None,
                 lifecycle_details: Optional[builtins.str] = None,
                 max_write_units: Optional[builtins.int] = None,
                 region: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 table_id: Optional[builtins.str] = None):
        """
        :param builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param builtins.str lifecycle_details: A message describing the current state in more detail.
        :param builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        :param builtins.str region: A customer-facing region identifier
        :param builtins.str state: The state of a table.
        :param builtins.str table_id: The OCID of the replica table
        """
        if capacity_mode is not None:
            pulumi.set(__self__, "capacity_mode", capacity_mode)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_write_units is not None:
            pulumi.set(__self__, "max_write_units", max_write_units)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> Optional[builtins.str]:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[builtins.str]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> Optional[builtins.int]:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        A customer-facing region identifier
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of a table.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[builtins.str]:
        """
        The OCID of the replica table
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class TableSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryKeys":
            suggest = "primary_keys"
        elif key == "shardKeys":
            suggest = "shard_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.TableSchemaColumn']] = None,
                 identities: Optional[Sequence['outputs.TableSchemaIdentity']] = None,
                 primary_keys: Optional[Sequence[builtins.str]] = None,
                 shard_keys: Optional[Sequence[builtins.str]] = None,
                 ttl: Optional[builtins.int] = None):
        """
        :param Sequence['TableSchemaColumnArgs'] columns: The columns of a table.
        :param Sequence['TableSchemaIdentityArgs'] identities: The identity properties of a table, if any.
        :param Sequence[builtins.str] primary_keys: A list of column names that make up a key.
        :param Sequence[builtins.str] shard_keys: A list of column names that make up a key.
        :param builtins.int ttl: The default Time-to-Live for the table, in days.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if primary_keys is not None:
            pulumi.set(__self__, "primary_keys", primary_keys)
        if shard_keys is not None:
            pulumi.set(__self__, "shard_keys", shard_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.TableSchemaColumn']]:
        """
        The columns of a table.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence['outputs.TableSchemaIdentity']]:
        """
        The identity properties of a table, if any.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="shardKeys")
    def shard_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "shard_keys")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.int]:
        """
        The default Time-to-Live for the table, in days.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class TableSchemaColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "isAsUuid":
            suggest = "is_as_uuid"
        elif key == "isGenerated":
            suggest = "is_generated"
        elif key == "isNullable":
            suggest = "is_nullable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSchemaColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSchemaColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSchemaColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[builtins.str] = None,
                 is_as_uuid: Optional[builtins.bool] = None,
                 is_generated: Optional[builtins.bool] = None,
                 is_nullable: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str default_value: The column default value.
        :param builtins.bool is_as_uuid: True if the STRING column was declared AS UUID.
        :param builtins.bool is_generated: True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        :param builtins.bool is_nullable: The column nullable flag.
        :param builtins.str name: Table name.
        :param builtins.str type: The column type.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_as_uuid is not None:
            pulumi.set(__self__, "is_as_uuid", is_as_uuid)
        if is_generated is not None:
            pulumi.set(__self__, "is_generated", is_generated)
        if is_nullable is not None:
            pulumi.set(__self__, "is_nullable", is_nullable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The column default value.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isAsUuid")
    def is_as_uuid(self) -> Optional[builtins.bool]:
        """
        True if the STRING column was declared AS UUID.
        """
        return pulumi.get(self, "is_as_uuid")

    @property
    @pulumi.getter(name="isGenerated")
    def is_generated(self) -> Optional[builtins.bool]:
        """
        True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        """
        return pulumi.get(self, "is_generated")

    @property
    @pulumi.getter(name="isNullable")
    def is_nullable(self) -> Optional[builtins.bool]:
        """
        The column nullable flag.
        """
        return pulumi.get(self, "is_nullable")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Table name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The column type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableSchemaIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "isAlways":
            suggest = "is_always"
        elif key == "isNull":
            suggest = "is_null"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSchemaIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSchemaIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSchemaIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[builtins.str] = None,
                 is_always: Optional[builtins.bool] = None,
                 is_null: Optional[builtins.bool] = None):
        """
        :param builtins.str column_name: The name of the identity column.
        :param builtins.bool is_always: True if the identity value is GENERATED ALWAYS.
        :param builtins.bool is_null: True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if is_always is not None:
            pulumi.set(__self__, "is_always", is_always)
        if is_null is not None:
            pulumi.set(__self__, "is_null", is_null)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[builtins.str]:
        """
        The name of the identity column.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="isAlways")
    def is_always(self) -> Optional[builtins.bool]:
        """
        True if the identity value is GENERATED ALWAYS.
        """
        return pulumi.get(self, "is_always")

    @property
    @pulumi.getter(name="isNull")
    def is_null(self) -> Optional[builtins.bool]:
        """
        True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        return pulumi.get(self, "is_null")


@pulumi.output_type
class TableTableLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadUnits":
            suggest = "max_read_units"
        elif key == "maxStorageInGbs":
            suggest = "max_storage_in_gbs"
        elif key == "maxWriteUnits":
            suggest = "max_write_units"
        elif key == "capacityMode":
            suggest = "capacity_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_units: builtins.int,
                 max_storage_in_gbs: builtins.int,
                 max_write_units: builtins.int,
                 capacity_mode: Optional[builtins.str] = None):
        """
        :param builtins.int max_read_units: (Updatable) Maximum sustained read throughput limit for the table.
        :param builtins.int max_storage_in_gbs: (Updatable) Maximum size of storage used by the table.
        :param builtins.int max_write_units: (Updatable) Maximum sustained write throughput limit for the table.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param builtins.str capacity_mode: (Updatable) The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        pulumi.set(__self__, "max_read_units", max_read_units)
        pulumi.set(__self__, "max_storage_in_gbs", max_storage_in_gbs)
        pulumi.set(__self__, "max_write_units", max_write_units)
        if capacity_mode is not None:
            pulumi.set(__self__, "capacity_mode", capacity_mode)

    @property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> builtins.int:
        """
        (Updatable) Maximum sustained read throughput limit for the table.
        """
        return pulumi.get(self, "max_read_units")

    @property
    @pulumi.getter(name="maxStorageInGbs")
    def max_storage_in_gbs(self) -> builtins.int:
        """
        (Updatable) Maximum size of storage used by the table.
        """
        return pulumi.get(self, "max_storage_in_gbs")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> builtins.int:
        """
        (Updatable) Maximum sustained write throughput limit for the table.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "max_write_units")

    @property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> Optional[builtins.str]:
        """
        (Updatable) The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")


@pulumi.output_type
class GetIndexKeyResult(dict):
    def __init__(__self__, *,
                 column_name: builtins.str,
                 json_field_type: builtins.str,
                 json_path: builtins.str):
        """
        :param builtins.str column_name: The name of a column to be included as an index key.
        :param builtins.str json_field_type: If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        :param builtins.str json_path: If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "json_field_type", json_field_type)
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        """
        The name of a column to be included as an index key.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="jsonFieldType")
    def json_field_type(self) -> builtins.str:
        """
        If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        """
        return pulumi.get(self, "json_field_type")

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> builtins.str:
        """
        If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class GetIndexesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A shell-globbing-style (*?[]) filter for names.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetIndexesIndexCollectionResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 id: builtins.str,
                 is_if_not_exists: builtins.bool,
                 keys: Sequence['outputs.GetIndexesIndexCollectionKeyResult'],
                 lifecycle_details: builtins.str,
                 name: builtins.str,
                 state: builtins.str,
                 table_id: builtins.str,
                 table_name: builtins.str,
                 table_name_or_id: builtins.str):
        """
        :param builtins.str compartment_id: The ID of a table's compartment. When a table is identified by name, the compartmentId is often needed to provide context for interpreting the name.
        :param Sequence['GetIndexesIndexCollectionKeyArgs'] keys: A set of keys for a secondary index.
        :param builtins.str lifecycle_details: A message describing the current state in more detail.
        :param builtins.str name: A shell-globbing-style (*?[]) filter for names.
        :param builtins.str state: Filter list by the lifecycle state of the item.
        :param builtins.str table_id: the OCID of the table to which this index belongs.
        :param builtins.str table_name: The name of the table to which this index belongs.
        :param builtins.str table_name_or_id: A table name within the compartment, or a table OCID.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_if_not_exists", is_if_not_exists)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_id", table_id)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "table_name_or_id", table_name_or_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of a table's compartment. When a table is identified by name, the compartmentId is often needed to provide context for interpreting the name.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIfNotExists")
    def is_if_not_exists(self) -> builtins.bool:
        return pulumi.get(self, "is_if_not_exists")

    @property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetIndexesIndexCollectionKeyResult']:
        """
        A set of keys for a secondary index.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter list by the lifecycle state of the item.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> builtins.str:
        """
        the OCID of the table to which this index belongs.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the table to which this index belongs.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> builtins.str:
        """
        A table name within the compartment, or a table OCID.
        """
        return pulumi.get(self, "table_name_or_id")


@pulumi.output_type
class GetIndexesIndexCollectionKeyResult(dict):
    def __init__(__self__, *,
                 column_name: builtins.str,
                 json_field_type: builtins.str,
                 json_path: builtins.str):
        """
        :param builtins.str column_name: The name of a column to be included as an index key.
        :param builtins.str json_field_type: If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        :param builtins.str json_path: If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "json_field_type", json_field_type)
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        """
        The name of a column to be included as an index key.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="jsonFieldType")
    def json_field_type(self) -> builtins.str:
        """
        If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        """
        return pulumi.get(self, "json_field_type")

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> builtins.str:
        """
        If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class GetTableReplicaResult(dict):
    def __init__(__self__, *,
                 capacity_mode: builtins.str,
                 lifecycle_details: builtins.str,
                 max_write_units: builtins.int,
                 region: builtins.str,
                 state: builtins.str,
                 table_id: builtins.str):
        """
        :param builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param builtins.str lifecycle_details: A message describing the current state in more detail.
        :param builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        :param builtins.str region: A customer-facing region identifier
        :param builtins.str state: The state of a table.
        :param builtins.str table_id: The OCID of the replica table
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_write_units", max_write_units)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        A customer-facing region identifier
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of a table.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> builtins.str:
        """
        The OCID of the replica table
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class GetTableSchemaResult(dict):
    def __init__(__self__, *,
                 columns: Sequence['outputs.GetTableSchemaColumnResult'],
                 identities: Sequence['outputs.GetTableSchemaIdentityResult'],
                 primary_keys: Sequence[builtins.str],
                 shard_keys: Sequence[builtins.str],
                 ttl: builtins.int):
        """
        :param Sequence['GetTableSchemaColumnArgs'] columns: The columns of a table.
        :param Sequence['GetTableSchemaIdentityArgs'] identities: The identity properties of a table, if any.
        :param Sequence[builtins.str] primary_keys: A list of column names that make up a key.
        :param Sequence[builtins.str] shard_keys: A list of column names that make up a key.
        :param builtins.int ttl: The default Time-to-Live for the table, in days.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "shard_keys", shard_keys)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.GetTableSchemaColumnResult']:
        """
        The columns of a table.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetTableSchemaIdentityResult']:
        """
        The identity properties of a table, if any.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence[builtins.str]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="shardKeys")
    def shard_keys(self) -> Sequence[builtins.str]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "shard_keys")

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        """
        The default Time-to-Live for the table, in days.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetTableSchemaColumnResult(dict):
    def __init__(__self__, *,
                 default_value: builtins.str,
                 is_as_uuid: builtins.bool,
                 is_generated: builtins.bool,
                 is_nullable: builtins.bool,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str default_value: The column default value.
        :param builtins.bool is_as_uuid: True if the STRING column was declared AS UUID.
        :param builtins.bool is_generated: True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        :param builtins.bool is_nullable: The column nullable flag.
        :param builtins.str name: The column name.
        :param builtins.str type: The column type.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "is_as_uuid", is_as_uuid)
        pulumi.set(__self__, "is_generated", is_generated)
        pulumi.set(__self__, "is_nullable", is_nullable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> builtins.str:
        """
        The column default value.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isAsUuid")
    def is_as_uuid(self) -> builtins.bool:
        """
        True if the STRING column was declared AS UUID.
        """
        return pulumi.get(self, "is_as_uuid")

    @property
    @pulumi.getter(name="isGenerated")
    def is_generated(self) -> builtins.bool:
        """
        True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        """
        return pulumi.get(self, "is_generated")

    @property
    @pulumi.getter(name="isNullable")
    def is_nullable(self) -> builtins.bool:
        """
        The column nullable flag.
        """
        return pulumi.get(self, "is_nullable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The column name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The column type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTableSchemaIdentityResult(dict):
    def __init__(__self__, *,
                 column_name: builtins.str,
                 is_always: builtins.bool,
                 is_null: builtins.bool):
        """
        :param builtins.str column_name: The name of the identity column.
        :param builtins.bool is_always: True if the identity value is GENERATED ALWAYS.
        :param builtins.bool is_null: True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "is_always", is_always)
        pulumi.set(__self__, "is_null", is_null)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        """
        The name of the identity column.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="isAlways")
    def is_always(self) -> builtins.bool:
        """
        True if the identity value is GENERATED ALWAYS.
        """
        return pulumi.get(self, "is_always")

    @property
    @pulumi.getter(name="isNull")
    def is_null(self) -> builtins.bool:
        """
        True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        return pulumi.get(self, "is_null")


@pulumi.output_type
class GetTableTableLimitResult(dict):
    def __init__(__self__, *,
                 capacity_mode: builtins.str,
                 max_read_units: builtins.int,
                 max_storage_in_gbs: builtins.int,
                 max_write_units: builtins.int):
        """
        :param builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param builtins.int max_read_units: Maximum sustained read throughput limit for the table.
        :param builtins.int max_storage_in_gbs: Maximum size of storage used by the table.
        :param builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "max_read_units", max_read_units)
        pulumi.set(__self__, "max_storage_in_gbs", max_storage_in_gbs)
        pulumi.set(__self__, "max_write_units", max_write_units)

    @property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> builtins.int:
        """
        Maximum sustained read throughput limit for the table.
        """
        return pulumi.get(self, "max_read_units")

    @property
    @pulumi.getter(name="maxStorageInGbs")
    def max_storage_in_gbs(self) -> builtins.int:
        """
        Maximum size of storage used by the table.
        """
        return pulumi.get(self, "max_storage_in_gbs")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")


@pulumi.output_type
class GetTablesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A shell-globbing-style (*?[]) filter for names.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTablesTableCollectionResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 ddl_statement: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_auto_reclaimable: builtins.bool,
                 is_multi_region: builtins.bool,
                 lifecycle_details: builtins.str,
                 local_replica_initialization_in_percent: builtins.int,
                 name: builtins.str,
                 replicas: Sequence['outputs.GetTablesTableCollectionReplicaResult'],
                 schema_state: builtins.str,
                 schemas: Sequence['outputs.GetTablesTableCollectionSchemaResult'],
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 table_limits: Sequence['outputs.GetTablesTableCollectionTableLimitResult'],
                 time_created: builtins.str,
                 time_of_expiration: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of a table's compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace": {"bar-key": "value"}}`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: Unique identifier that is immutable.
        :param builtins.bool is_auto_reclaimable: True if this table can be reclaimed after an idle period.
        :param builtins.bool is_multi_region: True if this table is currently a member of a replication set.
        :param builtins.str lifecycle_details: A message describing the current state in more detail.
        :param builtins.str name: A shell-globbing-style (*?[]) filter for names.
        :param builtins.str schema_state: The current state of this table's schema. Available states are MUTABLE - The schema can be changed. The table is not eligible for replication. FROZEN - The schema is immutable. The table is eligible for replication.
        :param builtins.str state: Filter list by the lifecycle state of the item.
        :param Mapping[str, builtins.str] system_tags: Read-only system tag. These predefined keys are scoped to namespaces.  At present the only supported namespace is `"orcl-cloud"`; and the only key in that namespace is `"free-tier-retained"`. Example: `{"orcl-cloud"": {"free-tier-retained": "true"}}`
        :param Sequence['GetTablesTableCollectionTableLimitArgs'] table_limits: Throughput and storage limits configuration of a table.
        :param builtins.str time_created: The time the the table was created. An RFC3339 formatted datetime string.
        :param builtins.str time_of_expiration: If lifecycleState is INACTIVE, indicates when this table will be automatically removed. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the the table's metadata was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "ddl_statement", ddl_statement)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_reclaimable", is_auto_reclaimable)
        pulumi.set(__self__, "is_multi_region", is_multi_region)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "local_replica_initialization_in_percent", local_replica_initialization_in_percent)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "schema_state", schema_state)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "table_limits", table_limits)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_expiration", time_of_expiration)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of a table's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="ddlStatement")
    def ddl_statement(self) -> builtins.str:
        return pulumi.get(self, "ddl_statement")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier that is immutable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoReclaimable")
    def is_auto_reclaimable(self) -> builtins.bool:
        """
        True if this table can be reclaimed after an idle period.
        """
        return pulumi.get(self, "is_auto_reclaimable")

    @property
    @pulumi.getter(name="isMultiRegion")
    def is_multi_region(self) -> builtins.bool:
        """
        True if this table is currently a member of a replication set.
        """
        return pulumi.get(self, "is_multi_region")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="localReplicaInitializationInPercent")
    def local_replica_initialization_in_percent(self) -> builtins.int:
        return pulumi.get(self, "local_replica_initialization_in_percent")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetTablesTableCollectionReplicaResult']:
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="schemaState")
    def schema_state(self) -> builtins.str:
        """
        The current state of this table's schema. Available states are MUTABLE - The schema can be changed. The table is not eligible for replication. FROZEN - The schema is immutable. The table is eligible for replication.
        """
        return pulumi.get(self, "schema_state")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.GetTablesTableCollectionSchemaResult']:
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter list by the lifecycle state of the item.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Read-only system tag. These predefined keys are scoped to namespaces.  At present the only supported namespace is `"orcl-cloud"`; and the only key in that namespace is `"free-tier-retained"`. Example: `{"orcl-cloud"": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tableLimits")
    def table_limits(self) -> Sequence['outputs.GetTablesTableCollectionTableLimitResult']:
        """
        Throughput and storage limits configuration of a table.
        """
        return pulumi.get(self, "table_limits")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the table was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfExpiration")
    def time_of_expiration(self) -> builtins.str:
        """
        If lifecycleState is INACTIVE, indicates when this table will be automatically removed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_of_expiration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the the table's metadata was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetTablesTableCollectionReplicaResult(dict):
    def __init__(__self__, *,
                 capacity_mode: builtins.str,
                 lifecycle_details: builtins.str,
                 max_write_units: builtins.int,
                 region: builtins.str,
                 state: builtins.str,
                 table_id: builtins.str):
        """
        :param builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param builtins.str lifecycle_details: A message describing the current state in more detail.
        :param builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        :param builtins.str state: Filter list by the lifecycle state of the item.
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_write_units", max_write_units)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter list by the lifecycle state of the item.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> builtins.str:
        return pulumi.get(self, "table_id")


@pulumi.output_type
class GetTablesTableCollectionSchemaResult(dict):
    def __init__(__self__, *,
                 columns: Sequence['outputs.GetTablesTableCollectionSchemaColumnResult'],
                 identities: Sequence['outputs.GetTablesTableCollectionSchemaIdentityResult'],
                 primary_keys: Sequence[builtins.str],
                 shard_keys: Sequence[builtins.str],
                 ttl: builtins.int):
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "shard_keys", shard_keys)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.GetTablesTableCollectionSchemaColumnResult']:
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetTablesTableCollectionSchemaIdentityResult']:
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="shardKeys")
    def shard_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "shard_keys")

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetTablesTableCollectionSchemaColumnResult(dict):
    def __init__(__self__, *,
                 default_value: builtins.str,
                 is_as_uuid: builtins.bool,
                 is_generated: builtins.bool,
                 is_nullable: builtins.bool,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str name: A shell-globbing-style (*?[]) filter for names.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "is_as_uuid", is_as_uuid)
        pulumi.set(__self__, "is_generated", is_generated)
        pulumi.set(__self__, "is_nullable", is_nullable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> builtins.str:
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isAsUuid")
    def is_as_uuid(self) -> builtins.bool:
        return pulumi.get(self, "is_as_uuid")

    @property
    @pulumi.getter(name="isGenerated")
    def is_generated(self) -> builtins.bool:
        return pulumi.get(self, "is_generated")

    @property
    @pulumi.getter(name="isNullable")
    def is_nullable(self) -> builtins.bool:
        return pulumi.get(self, "is_nullable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTablesTableCollectionSchemaIdentityResult(dict):
    def __init__(__self__, *,
                 column_name: builtins.str,
                 is_always: builtins.bool,
                 is_null: builtins.bool):
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "is_always", is_always)
        pulumi.set(__self__, "is_null", is_null)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> builtins.str:
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="isAlways")
    def is_always(self) -> builtins.bool:
        return pulumi.get(self, "is_always")

    @property
    @pulumi.getter(name="isNull")
    def is_null(self) -> builtins.bool:
        return pulumi.get(self, "is_null")


@pulumi.output_type
class GetTablesTableCollectionTableLimitResult(dict):
    def __init__(__self__, *,
                 capacity_mode: builtins.str,
                 max_read_units: builtins.int,
                 max_storage_in_gbs: builtins.int,
                 max_write_units: builtins.int):
        """
        :param builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param builtins.int max_read_units: Maximum sustained read throughput limit for the table.
        :param builtins.int max_storage_in_gbs: Maximum size of storage used by the table.
        :param builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "max_read_units", max_read_units)
        pulumi.set(__self__, "max_storage_in_gbs", max_storage_in_gbs)
        pulumi.set(__self__, "max_write_units", max_write_units)

    @property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> builtins.int:
        """
        Maximum sustained read throughput limit for the table.
        """
        return pulumi.get(self, "max_read_units")

    @property
    @pulumi.getter(name="maxStorageInGbs")
    def max_storage_in_gbs(self) -> builtins.int:
        """
        Maximum size of storage used by the table.
        """
        return pulumi.get(self, "max_storage_in_gbs")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")


