# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessRequestHistoryResult',
    'AwaitableGetAccessRequestHistoryResult',
    'get_access_request_history',
    'get_access_request_history_output',
]

@pulumi.output_type
class GetAccessRequestHistoryResult:
    """
    A collection of values returned by getAccessRequestHistory.
    """
    def __init__(__self__, access_request_id=None, id=None, items=None):
        if access_request_id and not isinstance(access_request_id, str):
            raise TypeError("Expected argument 'access_request_id' to be a str")
        pulumi.set(__self__, "access_request_id", access_request_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="accessRequestId")
    def access_request_id(self) -> builtins.str:
        return pulumi.get(self, "access_request_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAccessRequestHistoryItemResult']:
        """
        contains AccessRequestHistorySummary
        """
        return pulumi.get(self, "items")


class AwaitableGetAccessRequestHistoryResult(GetAccessRequestHistoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRequestHistoryResult(
            access_request_id=self.access_request_id,
            id=self.id,
            items=self.items)


def get_access_request_history(access_request_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRequestHistoryResult:
    """
    This data source provides details about a specific Access Request History resource in Oracle Cloud Infrastructure Operator Access Control service.

    Returns a history of all status associated with the accessRequestId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request_history = oci.OperatorAccessControl.get_access_request_history(access_request_id=test_access_request["id"])
    ```


    :param builtins.str access_request_id: unique AccessRequest identifier
    """
    __args__ = dict()
    __args__['accessRequestId'] = access_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getAccessRequestHistory:getAccessRequestHistory', __args__, opts=opts, typ=GetAccessRequestHistoryResult).value

    return AwaitableGetAccessRequestHistoryResult(
        access_request_id=pulumi.get(__ret__, 'access_request_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_access_request_history_output(access_request_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessRequestHistoryResult]:
    """
    This data source provides details about a specific Access Request History resource in Oracle Cloud Infrastructure Operator Access Control service.

    Returns a history of all status associated with the accessRequestId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request_history = oci.OperatorAccessControl.get_access_request_history(access_request_id=test_access_request["id"])
    ```


    :param builtins.str access_request_id: unique AccessRequest identifier
    """
    __args__ = dict()
    __args__['accessRequestId'] = access_request_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OperatorAccessControl/getAccessRequestHistory:getAccessRequestHistory', __args__, opts=opts, typ=GetAccessRequestHistoryResult)
    return __ret__.apply(lambda __response__: GetAccessRequestHistoryResult(
        access_request_id=pulumi.get(__response__, 'access_request_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
