# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessRequestApproverDetailResult',
    'GetAccessRequestExtensionApproverDetailResult',
    'GetAccessRequestHistoryItemResult',
    'GetAccessRequestsAccessRequestCollectionResult',
    'GetAccessRequestsAccessRequestCollectionItemResult',
    'GetAccessRequestsAccessRequestCollectionItemApproverDetailResult',
    'GetAccessRequestsAccessRequestCollectionItemExtensionApproverDetailResult',
    'GetAccessRequestsFilterResult',
    'GetActionPropertyResult',
    'GetActionsFilterResult',
    'GetActionsOperatorActionCollectionResult',
    'GetActionsOperatorActionCollectionItemResult',
    'GetActionsOperatorActionCollectionItemPropertyResult',
    'GetControlAssignmentsFilterResult',
    'GetControlAssignmentsOperatorControlAssignmentCollectionResult',
    'GetControlAssignmentsOperatorControlAssignmentCollectionItemResult',
    'GetControlsFilterResult',
    'GetControlsOperatorControlCollectionResult',
    'GetControlsOperatorControlCollectionItemResult',
]

@pulumi.output_type
class GetAccessRequestApproverDetailResult(dict):
    def __init__(__self__, *,
                 approval_action: builtins.str,
                 approval_additional_message: builtins.str,
                 approval_comment: builtins.str,
                 approver_id: builtins.str,
                 time_approved_for_access: builtins.str,
                 time_of_authorization: builtins.str):
        """
        :param builtins.str approval_action: The action done by the approver.
        :param builtins.str approval_additional_message: Additional message specified by the approver of the request.
        :param builtins.str approval_comment: Comment specified by the approver of the request.
        :param builtins.str approver_id: The userId of the approver.
        :param builtins.str time_approved_for_access: Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_authorization: Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_additional_message", approval_additional_message)
        pulumi.set(__self__, "approval_comment", approval_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)
        pulumi.set(__self__, "time_of_authorization", time_of_authorization)

    @property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> builtins.str:
        """
        The action done by the approver.
        """
        return pulumi.get(self, "approval_action")

    @property
    @pulumi.getter(name="approvalAdditionalMessage")
    def approval_additional_message(self) -> builtins.str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approval_additional_message")

    @property
    @pulumi.getter(name="approvalComment")
    def approval_comment(self) -> builtins.str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approval_comment")

    @property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> builtins.str:
        """
        The userId of the approver.
        """
        return pulumi.get(self, "approver_id")

    @property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> builtins.str:
        """
        Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_approved_for_access")

    @property
    @pulumi.getter(name="timeOfAuthorization")
    def time_of_authorization(self) -> builtins.str:
        """
        Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_authorization")


@pulumi.output_type
class GetAccessRequestExtensionApproverDetailResult(dict):
    def __init__(__self__, *,
                 approval_action: builtins.str,
                 approval_additional_message: builtins.str,
                 approval_comment: builtins.str,
                 approver_id: builtins.str,
                 time_approved_for_access: builtins.str,
                 time_of_authorization: builtins.str):
        """
        :param builtins.str approval_action: The action done by the approver.
        :param builtins.str approval_additional_message: Additional message specified by the approver of the request.
        :param builtins.str approval_comment: Comment specified by the approver of the request.
        :param builtins.str approver_id: The userId of the approver.
        :param builtins.str time_approved_for_access: Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_authorization: Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_additional_message", approval_additional_message)
        pulumi.set(__self__, "approval_comment", approval_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)
        pulumi.set(__self__, "time_of_authorization", time_of_authorization)

    @property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> builtins.str:
        """
        The action done by the approver.
        """
        return pulumi.get(self, "approval_action")

    @property
    @pulumi.getter(name="approvalAdditionalMessage")
    def approval_additional_message(self) -> builtins.str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approval_additional_message")

    @property
    @pulumi.getter(name="approvalComment")
    def approval_comment(self) -> builtins.str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approval_comment")

    @property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> builtins.str:
        """
        The userId of the approver.
        """
        return pulumi.get(self, "approver_id")

    @property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> builtins.str:
        """
        Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_approved_for_access")

    @property
    @pulumi.getter(name="timeOfAuthorization")
    def time_of_authorization(self) -> builtins.str:
        """
        Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_authorization")


@pulumi.output_type
class GetAccessRequestHistoryItemResult(dict):
    def __init__(__self__, *,
                 actions_lists: Sequence[builtins.str],
                 description: builtins.str,
                 duration: builtins.int,
                 is_auto_approved: builtins.bool,
                 state: builtins.str,
                 time_of_action: builtins.str,
                 user_id: builtins.str):
        """
        :param Sequence[builtins.str] actions_lists: List of operator actions for which approvals were requested by the operator.
        :param builtins.str description: Reason or description about the cause of change.
        :param builtins.int duration: Duration for approval of request or extension depending on the type of action.
        :param builtins.bool is_auto_approved: Whether the access request was automatically approved.
        :param builtins.str state: The current state of the AccessRequest.
        :param builtins.str time_of_action: Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str user_id: Approver who modified the access request.
        """
        pulumi.set(__self__, "actions_lists", actions_lists)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "is_auto_approved", is_auto_approved)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_of_action", time_of_action)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="actionsLists")
    def actions_lists(self) -> Sequence[builtins.str]:
        """
        List of operator actions for which approvals were requested by the operator.
        """
        return pulumi.get(self, "actions_lists")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Reason or description about the cause of change.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> builtins.int:
        """
        Duration for approval of request or extension depending on the type of action.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> builtins.bool:
        """
        Whether the access request was automatically approved.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the AccessRequest.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeOfAction")
    def time_of_action(self) -> builtins.str:
        """
        Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_action")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        """
        Approver who modified the access request.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetAccessRequestsAccessRequestCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAccessRequestsAccessRequestCollectionItemResult(dict):
    def __init__(__self__, *,
                 access_reason_summary: builtins.str,
                 action_requests_lists: Sequence[builtins.str],
                 approver_comment: builtins.str,
                 approver_details: Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemApproverDetailResult'],
                 audit_types: Sequence[builtins.str],
                 closure_comment: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 duration: builtins.int,
                 extend_duration: builtins.int,
                 extension_approver_details: Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemExtensionApproverDetailResult'],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_auto_approved: builtins.bool,
                 is_validate_assignment: builtins.bool,
                 lifecycle_details: builtins.str,
                 number_of_approvers: builtins.int,
                 number_of_approvers_required: builtins.int,
                 number_of_extension_approvers: builtins.int,
                 opctl_additional_message: builtins.str,
                 opctl_id: builtins.str,
                 opctl_name: builtins.str,
                 operator_id: builtins.str,
                 reason: builtins.str,
                 request_id: builtins.str,
                 resource_id: builtins.str,
                 resource_name: builtins.str,
                 resource_type: builtins.str,
                 severity: builtins.str,
                 state: builtins.str,
                 sub_resource_lists: Sequence[builtins.str],
                 system_message: builtins.str,
                 time_of_creation: builtins.str,
                 time_of_modification: builtins.str,
                 time_of_user_creation: builtins.str,
                 time_requested_for_future_access: builtins.str,
                 user_id: builtins.str,
                 workflow_ids: Sequence[builtins.str]):
        """
        :param builtins.str access_reason_summary: Summary comment by the operator creating the access request.
        :param Sequence[builtins.str] action_requests_lists: List of operator actions for which approval is sought by the operator user.
        :param builtins.str approver_comment: The last recent Comment entered by the approver of the request.
        :param Sequence['GetAccessRequestsAccessRequestCollectionItemApproverDetailArgs'] approver_details: Contains the user ids who have approved the accessRequest for extension.
        :param Sequence[builtins.str] audit_types: Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, auditing is enabled at the command level i.e., each command issued by the operator is audited. When keystroke-level is chosen,  in addition to command level logging, key strokes are also logged.
        :param builtins.str closure_comment: The comment entered by the operator while closing the request.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param builtins.int duration: Duration in hours for which access is sought on the target resource.
        :param builtins.int extend_duration: Duration in hours for which extension access is sought on the target resource.
        :param Sequence['GetAccessRequestsAccessRequestCollectionItemExtensionApproverDetailArgs'] extension_approver_details: Contains the user ids who have approved the accessRequest for extension.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param builtins.str id: The OCID of the access request.
        :param builtins.bool is_auto_approved: Whether the access request was automatically approved.
        :param builtins.bool is_validate_assignment: Whether the access request was requested for Validate Assignment.
        :param builtins.str lifecycle_details: more in detail about the lifeCycleState.
        :param builtins.int number_of_approvers: Number of approvers who have authorized an access request.
        :param builtins.int number_of_approvers_required: Number of approvers required to approve an access request.
        :param builtins.int number_of_extension_approvers: Number of approvers who have authorized an access request for extension.
        :param builtins.str opctl_additional_message: Additional message specific to the access request that can be specified by the approver at the time of approval.
        :param builtins.str opctl_id: The OCID of the operator control governing the target resource.
        :param builtins.str opctl_name: Name of the Operator control governing the target resource.
        :param builtins.str operator_id: A unique identifier associated with the operator who raised the request. This identifier can not be used directly to identify the operator. You need to provide this identifier if you would like Oracle to provide additional information about the operator action within Oracle tenancy.
        :param builtins.str reason: Summary reason for which the operator is requesting access on the target resource.
        :param builtins.str request_id: This is an automatic identifier generated by the system which is easier for human comprehension.
        :param builtins.str resource_id: The OCID of the target resource associated with the access request. The operator raises an access request to get approval to  access the target resource.
        :param builtins.str resource_name: A filter to return only resources that match the given ResourceName.
        :param builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param builtins.str severity: Priority assigned to the access request by the operator
        :param builtins.str state: A filter to return only resources whose lifecycleState matches the given AccessRequest lifecycleState.
        :param Sequence[builtins.str] sub_resource_lists: The subresources requested for approval.
        :param builtins.str system_message: System message that will be displayed to the operator at login to the target resource.
        :param builtins.str time_of_creation: Time when the access request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_modification: Time when the access request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_user_creation: The time when access request is scheduled to be approved in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_requested_for_future_access: Time in future when the user for the access request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str user_id: The OCID of the user that last modified the access request.
        :param Sequence[builtins.str] workflow_ids: The OCID of the workflow associated with the access request. This is needed if you want to contact Oracle Support for a stuck access request or for an access request that encounters an internal error.
        """
        pulumi.set(__self__, "access_reason_summary", access_reason_summary)
        pulumi.set(__self__, "action_requests_lists", action_requests_lists)
        pulumi.set(__self__, "approver_comment", approver_comment)
        pulumi.set(__self__, "approver_details", approver_details)
        pulumi.set(__self__, "audit_types", audit_types)
        pulumi.set(__self__, "closure_comment", closure_comment)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "extend_duration", extend_duration)
        pulumi.set(__self__, "extension_approver_details", extension_approver_details)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_approved", is_auto_approved)
        pulumi.set(__self__, "is_validate_assignment", is_validate_assignment)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "number_of_approvers", number_of_approvers)
        pulumi.set(__self__, "number_of_approvers_required", number_of_approvers_required)
        pulumi.set(__self__, "number_of_extension_approvers", number_of_extension_approvers)
        pulumi.set(__self__, "opctl_additional_message", opctl_additional_message)
        pulumi.set(__self__, "opctl_id", opctl_id)
        pulumi.set(__self__, "opctl_name", opctl_name)
        pulumi.set(__self__, "operator_id", operator_id)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "request_id", request_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "sub_resource_lists", sub_resource_lists)
        pulumi.set(__self__, "system_message", system_message)
        pulumi.set(__self__, "time_of_creation", time_of_creation)
        pulumi.set(__self__, "time_of_modification", time_of_modification)
        pulumi.set(__self__, "time_of_user_creation", time_of_user_creation)
        pulumi.set(__self__, "time_requested_for_future_access", time_requested_for_future_access)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "workflow_ids", workflow_ids)

    @property
    @pulumi.getter(name="accessReasonSummary")
    def access_reason_summary(self) -> builtins.str:
        """
        Summary comment by the operator creating the access request.
        """
        return pulumi.get(self, "access_reason_summary")

    @property
    @pulumi.getter(name="actionRequestsLists")
    def action_requests_lists(self) -> Sequence[builtins.str]:
        """
        List of operator actions for which approval is sought by the operator user.
        """
        return pulumi.get(self, "action_requests_lists")

    @property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> builtins.str:
        """
        The last recent Comment entered by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @property
    @pulumi.getter(name="approverDetails")
    def approver_details(self) -> Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemApproverDetailResult']:
        """
        Contains the user ids who have approved the accessRequest for extension.
        """
        return pulumi.get(self, "approver_details")

    @property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Sequence[builtins.str]:
        """
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, auditing is enabled at the command level i.e., each command issued by the operator is audited. When keystroke-level is chosen,  in addition to command level logging, key strokes are also logged.
        """
        return pulumi.get(self, "audit_types")

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> builtins.str:
        """
        The comment entered by the operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def duration(self) -> builtins.int:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="extendDuration")
    def extend_duration(self) -> builtins.int:
        """
        Duration in hours for which extension access is sought on the target resource.
        """
        return pulumi.get(self, "extend_duration")

    @property
    @pulumi.getter(name="extensionApproverDetails")
    def extension_approver_details(self) -> Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemExtensionApproverDetailResult']:
        """
        Contains the user ids who have approved the accessRequest for extension.
        """
        return pulumi.get(self, "extension_approver_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the access request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> builtins.bool:
        """
        Whether the access request was automatically approved.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter(name="isValidateAssignment")
    def is_validate_assignment(self) -> builtins.bool:
        """
        Whether the access request was requested for Validate Assignment.
        """
        return pulumi.get(self, "is_validate_assignment")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        more in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> builtins.int:
        """
        Number of approvers who have authorized an access request.
        """
        return pulumi.get(self, "number_of_approvers")

    @property
    @pulumi.getter(name="numberOfApproversRequired")
    def number_of_approvers_required(self) -> builtins.int:
        """
        Number of approvers required to approve an access request.
        """
        return pulumi.get(self, "number_of_approvers_required")

    @property
    @pulumi.getter(name="numberOfExtensionApprovers")
    def number_of_extension_approvers(self) -> builtins.int:
        """
        Number of approvers who have authorized an access request for extension.
        """
        return pulumi.get(self, "number_of_extension_approvers")

    @property
    @pulumi.getter(name="opctlAdditionalMessage")
    def opctl_additional_message(self) -> builtins.str:
        """
        Additional message specific to the access request that can be specified by the approver at the time of approval.
        """
        return pulumi.get(self, "opctl_additional_message")

    @property
    @pulumi.getter(name="opctlId")
    def opctl_id(self) -> builtins.str:
        """
        The OCID of the operator control governing the target resource.
        """
        return pulumi.get(self, "opctl_id")

    @property
    @pulumi.getter(name="opctlName")
    def opctl_name(self) -> builtins.str:
        """
        Name of the Operator control governing the target resource.
        """
        return pulumi.get(self, "opctl_name")

    @property
    @pulumi.getter(name="operatorId")
    def operator_id(self) -> builtins.str:
        """
        A unique identifier associated with the operator who raised the request. This identifier can not be used directly to identify the operator. You need to provide this identifier if you would like Oracle to provide additional information about the operator action within Oracle tenancy.
        """
        return pulumi.get(self, "operator_id")

    @property
    @pulumi.getter
    def reason(self) -> builtins.str:
        """
        Summary reason for which the operator is requesting access on the target resource.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> builtins.str:
        """
        This is an automatic identifier generated by the system which is easier for human comprehension.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given ResourceName.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        Priority assigned to the access request by the operator
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources whose lifecycleState matches the given AccessRequest lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subResourceLists")
    def sub_resource_lists(self) -> Sequence[builtins.str]:
        """
        The subresources requested for approval.
        """
        return pulumi.get(self, "sub_resource_lists")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> builtins.str:
        """
        System message that will be displayed to the operator at login to the target resource.
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> builtins.str:
        """
        Time when the access request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> builtins.str:
        """
        Time when the access request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")

    @property
    @pulumi.getter(name="timeOfUserCreation")
    def time_of_user_creation(self) -> builtins.str:
        """
        The time when access request is scheduled to be approved in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_user_creation")

    @property
    @pulumi.getter(name="timeRequestedForFutureAccess")
    def time_requested_for_future_access(self) -> builtins.str:
        """
        Time in future when the user for the access request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_requested_for_future_access")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        """
        The OCID of the user that last modified the access request.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="workflowIds")
    def workflow_ids(self) -> Sequence[builtins.str]:
        """
        The OCID of the workflow associated with the access request. This is needed if you want to contact Oracle Support for a stuck access request or for an access request that encounters an internal error.
        """
        return pulumi.get(self, "workflow_ids")


@pulumi.output_type
class GetAccessRequestsAccessRequestCollectionItemApproverDetailResult(dict):
    def __init__(__self__, *,
                 approval_action: builtins.str,
                 approval_additional_message: builtins.str,
                 approval_comment: builtins.str,
                 approver_id: builtins.str,
                 time_approved_for_access: builtins.str,
                 time_of_authorization: builtins.str):
        """
        :param builtins.str approval_action: The action done by the approver.
        :param builtins.str approval_additional_message: Additional message specified by the approver of the request.
        :param builtins.str approval_comment: Comment specified by the approver of the request.
        :param builtins.str approver_id: The userId of the approver.
        :param builtins.str time_approved_for_access: Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_authorization: Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_additional_message", approval_additional_message)
        pulumi.set(__self__, "approval_comment", approval_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)
        pulumi.set(__self__, "time_of_authorization", time_of_authorization)

    @property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> builtins.str:
        """
        The action done by the approver.
        """
        return pulumi.get(self, "approval_action")

    @property
    @pulumi.getter(name="approvalAdditionalMessage")
    def approval_additional_message(self) -> builtins.str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approval_additional_message")

    @property
    @pulumi.getter(name="approvalComment")
    def approval_comment(self) -> builtins.str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approval_comment")

    @property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> builtins.str:
        """
        The userId of the approver.
        """
        return pulumi.get(self, "approver_id")

    @property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> builtins.str:
        """
        Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_approved_for_access")

    @property
    @pulumi.getter(name="timeOfAuthorization")
    def time_of_authorization(self) -> builtins.str:
        """
        Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_authorization")


@pulumi.output_type
class GetAccessRequestsAccessRequestCollectionItemExtensionApproverDetailResult(dict):
    def __init__(__self__, *,
                 approval_action: builtins.str,
                 approval_additional_message: builtins.str,
                 approval_comment: builtins.str,
                 approver_id: builtins.str,
                 time_approved_for_access: builtins.str,
                 time_of_authorization: builtins.str):
        """
        :param builtins.str approval_action: The action done by the approver.
        :param builtins.str approval_additional_message: Additional message specified by the approver of the request.
        :param builtins.str approval_comment: Comment specified by the approver of the request.
        :param builtins.str approver_id: The userId of the approver.
        :param builtins.str time_approved_for_access: Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_authorization: Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_additional_message", approval_additional_message)
        pulumi.set(__self__, "approval_comment", approval_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)
        pulumi.set(__self__, "time_of_authorization", time_of_authorization)

    @property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> builtins.str:
        """
        The action done by the approver.
        """
        return pulumi.get(self, "approval_action")

    @property
    @pulumi.getter(name="approvalAdditionalMessage")
    def approval_additional_message(self) -> builtins.str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approval_additional_message")

    @property
    @pulumi.getter(name="approvalComment")
    def approval_comment(self) -> builtins.str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approval_comment")

    @property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> builtins.str:
        """
        The userId of the approver.
        """
        return pulumi.get(self, "approver_id")

    @property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> builtins.str:
        """
        Time for when the access request should start that is authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_approved_for_access")

    @property
    @pulumi.getter(name="timeOfAuthorization")
    def time_of_authorization(self) -> builtins.str:
        """
        Time when the access request was authorized by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_authorization")


@pulumi.output_type
class GetAccessRequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetActionPropertyResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the property
        :param builtins.str value: value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetActionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A filter to return only resources that match the entire display name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetActionsOperatorActionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetActionsOperatorActionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetActionsOperatorActionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetActionsOperatorActionCollectionItemResult(dict):
    def __init__(__self__, *,
                 component: builtins.str,
                 customer_display_name: builtins.str,
                 description: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 properties: Sequence['outputs.GetActionsOperatorActionCollectionItemPropertyResult'],
                 resource_type: builtins.str,
                 compartment_id: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str component: Name of the infrastructure layer associated with the operator action.
        :param builtins.str customer_display_name: Display Name of the operator action.
        :param builtins.str description: Description of the operator action in terms of associated risk profile, and characteristics of the operating system commands made available to the operator under this operator action.
        :param builtins.str id: Unique Oracle assigned identifier for the operator action.
        :param builtins.str name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetActionsOperatorActionCollectionItemPropertyArgs'] properties: Fine grained properties associated with the operator control.
        :param builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param builtins.str state: A filter to return only resources whose lifecycleState matches the given OperatorAction lifecycleState.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "customer_display_name", customer_display_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "resource_type", resource_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def component(self) -> builtins.str:
        """
        Name of the infrastructure layer associated with the operator action.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter(name="customerDisplayName")
    def customer_display_name(self) -> builtins.str:
        """
        Display Name of the operator action.
        """
        return pulumi.get(self, "customer_display_name")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the operator action in terms of associated risk profile, and characteristics of the operating system commands made available to the operator under this operator action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique Oracle assigned identifier for the operator action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetActionsOperatorActionCollectionItemPropertyResult']:
        """
        Fine grained properties associated with the operator control.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        A filter to return only resources whose lifecycleState matches the given OperatorAction lifecycleState.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetActionsOperatorActionCollectionItemPropertyResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: A filter to return only resources that match the entire display name given.
        :param builtins.str value: value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetControlAssignmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetControlAssignmentsOperatorControlAssignmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetControlAssignmentsOperatorControlAssignmentCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetControlAssignmentsOperatorControlAssignmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetControlAssignmentsOperatorControlAssignmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 assigner_id: builtins.str,
                 comment: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 detachment_description: builtins.str,
                 error_code: builtins.int,
                 error_message: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_auto_approve_during_maintenance: builtins.bool,
                 is_default_assignment: builtins.bool,
                 is_enforced_always: builtins.bool,
                 is_hypervisor_log_forwarded: builtins.bool,
                 is_log_forwarded: builtins.bool,
                 lifecycle_details: builtins.str,
                 op_control_name: builtins.str,
                 operator_control_id: builtins.str,
                 remote_syslog_server_address: builtins.str,
                 remote_syslog_server_ca_cert: builtins.str,
                 remote_syslog_server_port: builtins.int,
                 resource_compartment_id: builtins.str,
                 resource_id: builtins.str,
                 resource_name: builtins.str,
                 resource_type: builtins.str,
                 state: builtins.str,
                 time_assignment_from: builtins.str,
                 time_assignment_to: builtins.str,
                 time_of_assignment: builtins.str,
                 time_of_deletion: builtins.str,
                 unassigner_id: builtins.str,
                 validate_assignment_trigger: builtins.int):
        """
        :param builtins.str assigner_id: The OCID of the user who created this operator control assignment.
        :param builtins.str comment: Comment about the assignment of the operator control to this target resource.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param builtins.str detachment_description: description containing reason for releasing of OperatorControl.
        :param builtins.int error_code: The code identifying the error occurred during Assignment operation.
        :param builtins.str error_message: The message describing the error occurred during Assignment operation.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param builtins.str id: The OCID of the operator control assignment.
        :param builtins.bool is_auto_approve_during_maintenance: The boolean if true would autoApprove during maintenance.
        :param builtins.bool is_default_assignment: Whether the assignment is a default assignment.
        :param builtins.bool is_enforced_always: If set, then the target resource is always governed by the operator control.
        :param builtins.bool is_hypervisor_log_forwarded: If set, then the hypervisor audit logs will be forwarded to the relevant remote syslog server
        :param builtins.bool is_log_forwarded: If set indicates that the audit logs are being forwarded to the relevant remote logging server
        :param builtins.str lifecycle_details: More in detail about the lifeCycleState.
        :param builtins.str op_control_name: Name of the operator control name associated.
        :param builtins.str operator_control_id: The OCID of the operator control.
        :param builtins.str remote_syslog_server_address: The address of the remote syslog server where the audit logs are being forwarded to. Address in host or IP format.
        :param builtins.str remote_syslog_server_ca_cert: The CA certificate of the remote syslog server.
        :param builtins.int remote_syslog_server_port: The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        :param builtins.str resource_compartment_id: The OCID of the compartment that contains the target resource.
        :param builtins.str resource_id: The OCID of the target resource.
        :param builtins.str resource_name: A filter to return only resources that match the given ResourceName.
        :param builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param builtins.str state: A filter to return only resources whose lifecycleState matches the given OperatorControlAssignment lifecycleState.
        :param builtins.str time_assignment_from: The time at which the target resource will be brought under the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_assignment_to: The time at which the target resource will leave the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_assignment: Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_deletion: Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str unassigner_id: User id who released the operatorControl.
        """
        pulumi.set(__self__, "assigner_id", assigner_id)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "detachment_description", detachment_description)
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        pulumi.set(__self__, "is_default_assignment", is_default_assignment)
        pulumi.set(__self__, "is_enforced_always", is_enforced_always)
        pulumi.set(__self__, "is_hypervisor_log_forwarded", is_hypervisor_log_forwarded)
        pulumi.set(__self__, "is_log_forwarded", is_log_forwarded)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "op_control_name", op_control_name)
        pulumi.set(__self__, "operator_control_id", operator_control_id)
        pulumi.set(__self__, "remote_syslog_server_address", remote_syslog_server_address)
        pulumi.set(__self__, "remote_syslog_server_ca_cert", remote_syslog_server_ca_cert)
        pulumi.set(__self__, "remote_syslog_server_port", remote_syslog_server_port)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_assignment_from", time_assignment_from)
        pulumi.set(__self__, "time_assignment_to", time_assignment_to)
        pulumi.set(__self__, "time_of_assignment", time_of_assignment)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "unassigner_id", unassigner_id)
        pulumi.set(__self__, "validate_assignment_trigger", validate_assignment_trigger)

    @property
    @pulumi.getter(name="assignerId")
    def assigner_id(self) -> builtins.str:
        """
        The OCID of the user who created this operator control assignment.
        """
        return pulumi.get(self, "assigner_id")

    @property
    @pulumi.getter
    def comment(self) -> builtins.str:
        """
        Comment about the assignment of the operator control to this target resource.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="detachmentDescription")
    def detachment_description(self) -> builtins.str:
        """
        description containing reason for releasing of OperatorControl.
        """
        return pulumi.get(self, "detachment_description")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> builtins.int:
        """
        The code identifying the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> builtins.str:
        """
        The message describing the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the operator control assignment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> builtins.bool:
        """
        The boolean if true would autoApprove during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @property
    @pulumi.getter(name="isDefaultAssignment")
    def is_default_assignment(self) -> builtins.bool:
        """
        Whether the assignment is a default assignment.
        """
        return pulumi.get(self, "is_default_assignment")

    @property
    @pulumi.getter(name="isEnforcedAlways")
    def is_enforced_always(self) -> builtins.bool:
        """
        If set, then the target resource is always governed by the operator control.
        """
        return pulumi.get(self, "is_enforced_always")

    @property
    @pulumi.getter(name="isHypervisorLogForwarded")
    def is_hypervisor_log_forwarded(self) -> builtins.bool:
        """
        If set, then the hypervisor audit logs will be forwarded to the relevant remote syslog server
        """
        return pulumi.get(self, "is_hypervisor_log_forwarded")

    @property
    @pulumi.getter(name="isLogForwarded")
    def is_log_forwarded(self) -> builtins.bool:
        """
        If set indicates that the audit logs are being forwarded to the relevant remote logging server
        """
        return pulumi.get(self, "is_log_forwarded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        More in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opControlName")
    def op_control_name(self) -> builtins.str:
        """
        Name of the operator control name associated.
        """
        return pulumi.get(self, "op_control_name")

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> builtins.str:
        """
        The OCID of the operator control.
        """
        return pulumi.get(self, "operator_control_id")

    @property
    @pulumi.getter(name="remoteSyslogServerAddress")
    def remote_syslog_server_address(self) -> builtins.str:
        """
        The address of the remote syslog server where the audit logs are being forwarded to. Address in host or IP format.
        """
        return pulumi.get(self, "remote_syslog_server_address")

    @property
    @pulumi.getter(name="remoteSyslogServerCaCert")
    def remote_syslog_server_ca_cert(self) -> builtins.str:
        """
        The CA certificate of the remote syslog server.
        """
        return pulumi.get(self, "remote_syslog_server_ca_cert")

    @property
    @pulumi.getter(name="remoteSyslogServerPort")
    def remote_syslog_server_port(self) -> builtins.int:
        """
        The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        """
        return pulumi.get(self, "remote_syslog_server_port")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the target resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The OCID of the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given ResourceName.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources whose lifecycleState matches the given OperatorControlAssignment lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAssignmentFrom")
    def time_assignment_from(self) -> builtins.str:
        """
        The time at which the target resource will be brought under the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_from")

    @property
    @pulumi.getter(name="timeAssignmentTo")
    def time_assignment_to(self) -> builtins.str:
        """
        The time at which the target resource will leave the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_to")

    @property
    @pulumi.getter(name="timeOfAssignment")
    def time_of_assignment(self) -> builtins.str:
        """
        Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_assignment")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> builtins.str:
        """
        Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="unassignerId")
    def unassigner_id(self) -> builtins.str:
        """
        User id who released the operatorControl.
        """
        return pulumi.get(self, "unassigner_id")

    @property
    @pulumi.getter(name="validateAssignmentTrigger")
    def validate_assignment_trigger(self) -> builtins.int:
        return pulumi.get(self, "validate_assignment_trigger")


@pulumi.output_type
class GetControlsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetControlsOperatorControlCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetControlsOperatorControlCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetControlsOperatorControlCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetControlsOperatorControlCollectionItemResult(dict):
    def __init__(__self__, *,
                 approval_required_op_action_lists: Sequence[builtins.str],
                 approver_groups_lists: Sequence[builtins.str],
                 approvers_lists: Sequence[builtins.str],
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 email_id_lists: Sequence[builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_default_operator_control: builtins.bool,
                 is_fully_pre_approved: builtins.bool,
                 last_modified_info: builtins.str,
                 number_of_approvers: builtins.int,
                 operator_control_name: builtins.str,
                 pre_approved_op_action_lists: Sequence[builtins.str],
                 resource_type: builtins.str,
                 state: builtins.str,
                 system_message: builtins.str,
                 time_of_creation: builtins.str,
                 time_of_deletion: builtins.str,
                 time_of_modification: builtins.str):
        """
        :param Sequence[builtins.str] approval_required_op_action_lists: List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        :param Sequence[builtins.str] approver_groups_lists: List of user groups who can approve an access request associated with a target resource under the governance of this operator control.
        :param Sequence[builtins.str] approvers_lists: List of users who can approve an access request associated with a target resource under the governance of this operator control.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param builtins.str description: Description of operator control.
        :param Sequence[builtins.str] email_id_lists: List of emailId.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param builtins.str id: The OCID of the operator control.
        :param builtins.bool is_default_operator_control: Whether the operator control is a default Operator Control.
        :param builtins.bool is_fully_pre_approved: Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        :param builtins.str last_modified_info: Description associated with the latest modification of the operator control.
        :param builtins.int number_of_approvers: Number of approvers required to approve an access request.
        :param builtins.str operator_control_name: Name of the operator control. The name must be unique.
        :param Sequence[builtins.str] pre_approved_op_action_lists: List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be automatically approved if the access request only contain operator actions in the pre-approved list.
        :param builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param builtins.str state: A filter to return only resources whose lifecycleState matches the given OperatorControl lifecycleState.
        :param builtins.str system_message: System message that would be displayed to the operator users on accessing the target resource under the governance of this operator control.
        :param builtins.str time_of_creation: Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param builtins.str time_of_deletion: Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        :param builtins.str time_of_modification: Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "approval_required_op_action_lists", approval_required_op_action_lists)
        pulumi.set(__self__, "approver_groups_lists", approver_groups_lists)
        pulumi.set(__self__, "approvers_lists", approvers_lists)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "email_id_lists", email_id_lists)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default_operator_control", is_default_operator_control)
        pulumi.set(__self__, "is_fully_pre_approved", is_fully_pre_approved)
        pulumi.set(__self__, "last_modified_info", last_modified_info)
        pulumi.set(__self__, "number_of_approvers", number_of_approvers)
        pulumi.set(__self__, "operator_control_name", operator_control_name)
        pulumi.set(__self__, "pre_approved_op_action_lists", pre_approved_op_action_lists)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_message", system_message)
        pulumi.set(__self__, "time_of_creation", time_of_creation)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "time_of_modification", time_of_modification)

    @property
    @pulumi.getter(name="approvalRequiredOpActionLists")
    def approval_required_op_action_lists(self) -> Sequence[builtins.str]:
        """
        List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        """
        return pulumi.get(self, "approval_required_op_action_lists")

    @property
    @pulumi.getter(name="approverGroupsLists")
    def approver_groups_lists(self) -> Sequence[builtins.str]:
        """
        List of user groups who can approve an access request associated with a target resource under the governance of this operator control.
        """
        return pulumi.get(self, "approver_groups_lists")

    @property
    @pulumi.getter(name="approversLists")
    def approvers_lists(self) -> Sequence[builtins.str]:
        """
        List of users who can approve an access request associated with a target resource under the governance of this operator control.
        """
        return pulumi.get(self, "approvers_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of operator control.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailIdLists")
    def email_id_lists(self) -> Sequence[builtins.str]:
        """
        List of emailId.
        """
        return pulumi.get(self, "email_id_lists")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the operator control.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultOperatorControl")
    def is_default_operator_control(self) -> builtins.bool:
        """
        Whether the operator control is a default Operator Control.
        """
        return pulumi.get(self, "is_default_operator_control")

    @property
    @pulumi.getter(name="isFullyPreApproved")
    def is_fully_pre_approved(self) -> builtins.bool:
        """
        Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        """
        return pulumi.get(self, "is_fully_pre_approved")

    @property
    @pulumi.getter(name="lastModifiedInfo")
    def last_modified_info(self) -> builtins.str:
        """
        Description associated with the latest modification of the operator control.
        """
        return pulumi.get(self, "last_modified_info")

    @property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> builtins.int:
        """
        Number of approvers required to approve an access request.
        """
        return pulumi.get(self, "number_of_approvers")

    @property
    @pulumi.getter(name="operatorControlName")
    def operator_control_name(self) -> builtins.str:
        """
        Name of the operator control. The name must be unique.
        """
        return pulumi.get(self, "operator_control_name")

    @property
    @pulumi.getter(name="preApprovedOpActionLists")
    def pre_approved_op_action_lists(self) -> Sequence[builtins.str]:
        """
        List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be automatically approved if the access request only contain operator actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_op_action_lists")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources whose lifecycleState matches the given OperatorControl lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> builtins.str:
        """
        System message that would be displayed to the operator users on accessing the target resource under the governance of this operator control.
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> builtins.str:
        """
        Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> builtins.str:
        """
        Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> builtins.str:
        """
        Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")


