# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProfilesResult',
    'AwaitableGetProfilesResult',
    'get_profiles',
    'get_profiles_output',
]

@pulumi.output_type
class GetProfilesResult:
    """
    A collection of values returned by getProfiles.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, is_default_profile=None, is_service_provided_profile=None, management_station_not_equal_tos=None, management_stations=None, os_family=None, profile_collections=None, profile_id=None, profile_types=None, profile_version=None, registration_types=None, state=None, vendor_name=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default_profile and not isinstance(is_default_profile, bool):
            raise TypeError("Expected argument 'is_default_profile' to be a bool")
        pulumi.set(__self__, "is_default_profile", is_default_profile)
        if is_service_provided_profile and not isinstance(is_service_provided_profile, bool):
            raise TypeError("Expected argument 'is_service_provided_profile' to be a bool")
        pulumi.set(__self__, "is_service_provided_profile", is_service_provided_profile)
        if management_station_not_equal_tos and not isinstance(management_station_not_equal_tos, list):
            raise TypeError("Expected argument 'management_station_not_equal_tos' to be a list")
        pulumi.set(__self__, "management_station_not_equal_tos", management_station_not_equal_tos)
        if management_stations and not isinstance(management_stations, list):
            raise TypeError("Expected argument 'management_stations' to be a list")
        pulumi.set(__self__, "management_stations", management_stations)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if profile_collections and not isinstance(profile_collections, list):
            raise TypeError("Expected argument 'profile_collections' to be a list")
        pulumi.set(__self__, "profile_collections", profile_collections)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if profile_types and not isinstance(profile_types, list):
            raise TypeError("Expected argument 'profile_types' to be a list")
        pulumi.set(__self__, "profile_types", profile_types)
        if profile_version and not isinstance(profile_version, str):
            raise TypeError("Expected argument 'profile_version' to be a str")
        pulumi.set(__self__, "profile_version", profile_version)
        if registration_types and not isinstance(registration_types, list):
            raise TypeError("Expected argument 'registration_types' to be a list")
        pulumi.set(__self__, "registration_types", registration_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[builtins.str]:
        """
        The architecture type.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProfilesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultProfile")
    def is_default_profile(self) -> Optional[builtins.bool]:
        """
        Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        """
        return pulumi.get(self, "is_default_profile")

    @property
    @pulumi.getter(name="isServiceProvidedProfile")
    def is_service_provided_profile(self) -> Optional[builtins.bool]:
        """
        Indicates if the profile was created by the service. OS Management Hub provides a limited set of standardized profiles that can be used to register Autonomous Linux or Windows instances.
        """
        return pulumi.get(self, "is_service_provided_profile")

    @property
    @pulumi.getter(name="managementStationNotEqualTos")
    def management_station_not_equal_tos(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "management_station_not_equal_tos")

    @property
    @pulumi.getter(name="managementStations")
    def management_stations(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "management_stations")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[builtins.str]:
        """
        The operating system family.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="profileCollections")
    def profile_collections(self) -> Sequence['outputs.GetProfilesProfileCollectionResult']:
        """
        The list of profile_collection.
        """
        return pulumi.get(self, "profile_collections")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="profileTypes")
    def profile_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The type of profile.
        """
        return pulumi.get(self, "profile_types")

    @property
    @pulumi.getter(name="profileVersion")
    def profile_version(self) -> Optional[builtins.str]:
        """
        The version of the profile. The version is automatically incremented each time the profiled is edited.
        """
        return pulumi.get(self, "profile_version")

    @property
    @pulumi.getter(name="registrationTypes")
    def registration_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The type of instance to register.
        """
        return pulumi.get(self, "registration_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the registration profile.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[builtins.str]:
        """
        The vendor of the operating system for the instance.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetProfilesResult(GetProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfilesResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            is_default_profile=self.is_default_profile,
            is_service_provided_profile=self.is_service_provided_profile,
            management_station_not_equal_tos=self.management_station_not_equal_tos,
            management_stations=self.management_stations,
            os_family=self.os_family,
            profile_collections=self.profile_collections,
            profile_id=self.profile_id,
            profile_types=self.profile_types,
            profile_version=self.profile_version,
            registration_types=self.registration_types,
            state=self.state,
            vendor_name=self.vendor_name)


def get_profiles(arch_type: Optional[builtins.str] = None,
                 compartment_id: Optional[builtins.str] = None,
                 display_name_contains: Optional[builtins.str] = None,
                 display_names: Optional[Sequence[builtins.str]] = None,
                 filters: Optional[Sequence[Union['GetProfilesFilterArgs', 'GetProfilesFilterArgsDict']]] = None,
                 is_default_profile: Optional[builtins.bool] = None,
                 is_service_provided_profile: Optional[builtins.bool] = None,
                 management_station_not_equal_tos: Optional[Sequence[builtins.str]] = None,
                 management_stations: Optional[Sequence[builtins.str]] = None,
                 os_family: Optional[builtins.str] = None,
                 profile_id: Optional[builtins.str] = None,
                 profile_types: Optional[Sequence[builtins.str]] = None,
                 profile_version: Optional[builtins.str] = None,
                 registration_types: Optional[Sequence[builtins.str]] = None,
                 state: Optional[builtins.str] = None,
                 vendor_name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfilesResult:
    """
    This data source provides the list of Profiles in Oracle Cloud Infrastructure Os Management Hub service.

    Lists registration profiles that match the specified compartment or profile OCID. Filter the list against a
    variety of criteria including but not limited to its name, status, vendor name, and architecture type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_profiles = oci.OsManagementHub.get_profiles(arch_type=profile_arch_type,
        compartment_id=compartment_id,
        display_names=profile_display_name,
        display_name_contains=profile_display_name_contains,
        is_default_profile=profile_is_default_profile,
        is_service_provided_profile=profile_is_service_provided_profile,
        management_stations=profile_management_station,
        management_station_not_equal_tos=profile_management_station_not_equal_to,
        os_family=profile_os_family,
        profile_id=test_profile["id"],
        profile_types=profile_profile_type,
        profile_version=profile_profile_version,
        registration_types=profile_registration_type,
        state=profile_state,
        vendor_name=profile_vendor_name)
    ```


    :param builtins.str arch_type: A filter to return only profiles that match the given archType.
    :param builtins.str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param builtins.str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[builtins.str] display_names: A filter to return resources that match the given display names.
    :param builtins.bool is_default_profile: A filter to return only default profiles.
    :param builtins.bool is_service_provided_profile: A filter to return only service-provided profiles.
    :param Sequence[builtins.str] management_station_not_equal_tos: A filter to return resources that aren't associated with the specified management  station [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[builtins.str] management_stations: A filter to return resources that are associated with the specified management  station [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str os_family: A filter to return only resources that match the given operating system family.
    :param builtins.str profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile. A filter used to return the specified profile.
    :param Sequence[builtins.str] profile_types: A filter to return registration profiles that match the given profile type.
    :param builtins.str profile_version: The version of the registration profile.
    :param Sequence[builtins.str] registration_types: A filter to return profiles that match the given instance type.
    :param builtins.str state: A filter to return only registration profiles in the given state.
    :param builtins.str vendor_name: A filter to return only resources that match the given vendor name.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['isDefaultProfile'] = is_default_profile
    __args__['isServiceProvidedProfile'] = is_service_provided_profile
    __args__['managementStationNotEqualTos'] = management_station_not_equal_tos
    __args__['managementStations'] = management_stations
    __args__['osFamily'] = os_family
    __args__['profileId'] = profile_id
    __args__['profileTypes'] = profile_types
    __args__['profileVersion'] = profile_version
    __args__['registrationTypes'] = registration_types
    __args__['state'] = state
    __args__['vendorName'] = vendor_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getProfiles:getProfiles', __args__, opts=opts, typ=GetProfilesResult).value

    return AwaitableGetProfilesResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_default_profile=pulumi.get(__ret__, 'is_default_profile'),
        is_service_provided_profile=pulumi.get(__ret__, 'is_service_provided_profile'),
        management_station_not_equal_tos=pulumi.get(__ret__, 'management_station_not_equal_tos'),
        management_stations=pulumi.get(__ret__, 'management_stations'),
        os_family=pulumi.get(__ret__, 'os_family'),
        profile_collections=pulumi.get(__ret__, 'profile_collections'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        profile_types=pulumi.get(__ret__, 'profile_types'),
        profile_version=pulumi.get(__ret__, 'profile_version'),
        registration_types=pulumi.get(__ret__, 'registration_types'),
        state=pulumi.get(__ret__, 'state'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))
def get_profiles_output(arch_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        display_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        display_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetProfilesFilterArgs', 'GetProfilesFilterArgsDict']]]]] = None,
                        is_default_profile: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                        is_service_provided_profile: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                        management_station_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        management_stations: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        os_family: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        profile_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        profile_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        profile_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        registration_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        vendor_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProfilesResult]:
    """
    This data source provides the list of Profiles in Oracle Cloud Infrastructure Os Management Hub service.

    Lists registration profiles that match the specified compartment or profile OCID. Filter the list against a
    variety of criteria including but not limited to its name, status, vendor name, and architecture type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_profiles = oci.OsManagementHub.get_profiles(arch_type=profile_arch_type,
        compartment_id=compartment_id,
        display_names=profile_display_name,
        display_name_contains=profile_display_name_contains,
        is_default_profile=profile_is_default_profile,
        is_service_provided_profile=profile_is_service_provided_profile,
        management_stations=profile_management_station,
        management_station_not_equal_tos=profile_management_station_not_equal_to,
        os_family=profile_os_family,
        profile_id=test_profile["id"],
        profile_types=profile_profile_type,
        profile_version=profile_profile_version,
        registration_types=profile_registration_type,
        state=profile_state,
        vendor_name=profile_vendor_name)
    ```


    :param builtins.str arch_type: A filter to return only profiles that match the given archType.
    :param builtins.str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param builtins.str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[builtins.str] display_names: A filter to return resources that match the given display names.
    :param builtins.bool is_default_profile: A filter to return only default profiles.
    :param builtins.bool is_service_provided_profile: A filter to return only service-provided profiles.
    :param Sequence[builtins.str] management_station_not_equal_tos: A filter to return resources that aren't associated with the specified management  station [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[builtins.str] management_stations: A filter to return resources that are associated with the specified management  station [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str os_family: A filter to return only resources that match the given operating system family.
    :param builtins.str profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile. A filter used to return the specified profile.
    :param Sequence[builtins.str] profile_types: A filter to return registration profiles that match the given profile type.
    :param builtins.str profile_version: The version of the registration profile.
    :param Sequence[builtins.str] registration_types: A filter to return profiles that match the given instance type.
    :param builtins.str state: A filter to return only registration profiles in the given state.
    :param builtins.str vendor_name: A filter to return only resources that match the given vendor name.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['isDefaultProfile'] = is_default_profile
    __args__['isServiceProvidedProfile'] = is_service_provided_profile
    __args__['managementStationNotEqualTos'] = management_station_not_equal_tos
    __args__['managementStations'] = management_stations
    __args__['osFamily'] = os_family
    __args__['profileId'] = profile_id
    __args__['profileTypes'] = profile_types
    __args__['profileVersion'] = profile_version
    __args__['registrationTypes'] = registration_types
    __args__['state'] = state
    __args__['vendorName'] = vendor_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getProfiles:getProfiles', __args__, opts=opts, typ=GetProfilesResult)
    return __ret__.apply(lambda __response__: GetProfilesResult(
        arch_type=pulumi.get(__response__, 'arch_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        display_names=pulumi.get(__response__, 'display_names'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_default_profile=pulumi.get(__response__, 'is_default_profile'),
        is_service_provided_profile=pulumi.get(__response__, 'is_service_provided_profile'),
        management_station_not_equal_tos=pulumi.get(__response__, 'management_station_not_equal_tos'),
        management_stations=pulumi.get(__response__, 'management_stations'),
        os_family=pulumi.get(__response__, 'os_family'),
        profile_collections=pulumi.get(__response__, 'profile_collections'),
        profile_id=pulumi.get(__response__, 'profile_id'),
        profile_types=pulumi.get(__response__, 'profile_types'),
        profile_version=pulumi.get(__response__, 'profile_version'),
        registration_types=pulumi.get(__response__, 'registration_types'),
        state=pulumi.get(__response__, 'state'),
        vendor_name=pulumi.get(__response__, 'vendor_name')))
