# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSoftwareSourceResult',
    'AwaitableGetSoftwareSourceResult',
    'get_software_source',
    'get_software_source_output',
]

@pulumi.output_type
class GetSoftwareSourceResult:
    """
    A collection of values returned by getSoftwareSource.
    """
    def __init__(__self__, advanced_repo_options=None, arch_type=None, availability=None, availability_at_oci=None, checksum_type=None, compartment_id=None, custom_software_source_filters=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, gpg_key_fingerprint=None, gpg_key_id=None, gpg_key_url=None, id=None, is_auto_resolve_dependencies=None, is_automatically_updated=None, is_created_from_package_list=None, is_gpg_check_enabled=None, is_latest_content_only=None, is_mandatory_for_autonomous_linux=None, is_mirror_sync_allowed=None, is_ssl_verify_enabled=None, origin_software_source_id=None, os_family=None, package_count=None, packages=None, repo_id=None, size=None, software_source_id=None, software_source_sub_type=None, software_source_type=None, software_source_version=None, state=None, system_tags=None, time_created=None, time_metadata_updated=None, url=None, vendor_name=None, vendor_software_sources=None):
        if advanced_repo_options and not isinstance(advanced_repo_options, str):
            raise TypeError("Expected argument 'advanced_repo_options' to be a str")
        pulumi.set(__self__, "advanced_repo_options", advanced_repo_options)
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if availability and not isinstance(availability, str):
            raise TypeError("Expected argument 'availability' to be a str")
        pulumi.set(__self__, "availability", availability)
        if availability_at_oci and not isinstance(availability_at_oci, str):
            raise TypeError("Expected argument 'availability_at_oci' to be a str")
        pulumi.set(__self__, "availability_at_oci", availability_at_oci)
        if checksum_type and not isinstance(checksum_type, str):
            raise TypeError("Expected argument 'checksum_type' to be a str")
        pulumi.set(__self__, "checksum_type", checksum_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_software_source_filters and not isinstance(custom_software_source_filters, list):
            raise TypeError("Expected argument 'custom_software_source_filters' to be a list")
        pulumi.set(__self__, "custom_software_source_filters", custom_software_source_filters)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpg_key_fingerprint and not isinstance(gpg_key_fingerprint, str):
            raise TypeError("Expected argument 'gpg_key_fingerprint' to be a str")
        pulumi.set(__self__, "gpg_key_fingerprint", gpg_key_fingerprint)
        if gpg_key_id and not isinstance(gpg_key_id, str):
            raise TypeError("Expected argument 'gpg_key_id' to be a str")
        pulumi.set(__self__, "gpg_key_id", gpg_key_id)
        if gpg_key_url and not isinstance(gpg_key_url, str):
            raise TypeError("Expected argument 'gpg_key_url' to be a str")
        pulumi.set(__self__, "gpg_key_url", gpg_key_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_resolve_dependencies and not isinstance(is_auto_resolve_dependencies, bool):
            raise TypeError("Expected argument 'is_auto_resolve_dependencies' to be a bool")
        pulumi.set(__self__, "is_auto_resolve_dependencies", is_auto_resolve_dependencies)
        if is_automatically_updated and not isinstance(is_automatically_updated, bool):
            raise TypeError("Expected argument 'is_automatically_updated' to be a bool")
        pulumi.set(__self__, "is_automatically_updated", is_automatically_updated)
        if is_created_from_package_list and not isinstance(is_created_from_package_list, bool):
            raise TypeError("Expected argument 'is_created_from_package_list' to be a bool")
        pulumi.set(__self__, "is_created_from_package_list", is_created_from_package_list)
        if is_gpg_check_enabled and not isinstance(is_gpg_check_enabled, bool):
            raise TypeError("Expected argument 'is_gpg_check_enabled' to be a bool")
        pulumi.set(__self__, "is_gpg_check_enabled", is_gpg_check_enabled)
        if is_latest_content_only and not isinstance(is_latest_content_only, bool):
            raise TypeError("Expected argument 'is_latest_content_only' to be a bool")
        pulumi.set(__self__, "is_latest_content_only", is_latest_content_only)
        if is_mandatory_for_autonomous_linux and not isinstance(is_mandatory_for_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_mandatory_for_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_mandatory_for_autonomous_linux", is_mandatory_for_autonomous_linux)
        if is_mirror_sync_allowed and not isinstance(is_mirror_sync_allowed, bool):
            raise TypeError("Expected argument 'is_mirror_sync_allowed' to be a bool")
        pulumi.set(__self__, "is_mirror_sync_allowed", is_mirror_sync_allowed)
        if is_ssl_verify_enabled and not isinstance(is_ssl_verify_enabled, bool):
            raise TypeError("Expected argument 'is_ssl_verify_enabled' to be a bool")
        pulumi.set(__self__, "is_ssl_verify_enabled", is_ssl_verify_enabled)
        if origin_software_source_id and not isinstance(origin_software_source_id, str):
            raise TypeError("Expected argument 'origin_software_source_id' to be a str")
        pulumi.set(__self__, "origin_software_source_id", origin_software_source_id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if package_count and not isinstance(package_count, str):
            raise TypeError("Expected argument 'package_count' to be a str")
        pulumi.set(__self__, "package_count", package_count)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if repo_id and not isinstance(repo_id, str):
            raise TypeError("Expected argument 'repo_id' to be a str")
        pulumi.set(__self__, "repo_id", repo_id)
        if size and not isinstance(size, float):
            raise TypeError("Expected argument 'size' to be a float")
        pulumi.set(__self__, "size", size)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if software_source_sub_type and not isinstance(software_source_sub_type, str):
            raise TypeError("Expected argument 'software_source_sub_type' to be a str")
        pulumi.set(__self__, "software_source_sub_type", software_source_sub_type)
        if software_source_type and not isinstance(software_source_type, str):
            raise TypeError("Expected argument 'software_source_type' to be a str")
        pulumi.set(__self__, "software_source_type", software_source_type)
        if software_source_version and not isinstance(software_source_version, str):
            raise TypeError("Expected argument 'software_source_version' to be a str")
        pulumi.set(__self__, "software_source_version", software_source_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_metadata_updated and not isinstance(time_metadata_updated, str):
            raise TypeError("Expected argument 'time_metadata_updated' to be a str")
        pulumi.set(__self__, "time_metadata_updated", time_metadata_updated)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)
        if vendor_software_sources and not isinstance(vendor_software_sources, list):
            raise TypeError("Expected argument 'vendor_software_sources' to be a list")
        pulumi.set(__self__, "vendor_software_sources", vendor_software_sources)

    @property
    @pulumi.getter(name="advancedRepoOptions")
    def advanced_repo_options(self) -> builtins.str:
        """
        Advanced repository options for the software source
        """
        return pulumi.get(self, "advanced_repo_options")

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> builtins.str:
        """
        The architecture type supported by the software source.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter
    def availability(self) -> builtins.str:
        """
        Availability of the software source (for non-OCI environments).
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="availabilityAtOci")
    def availability_at_oci(self) -> builtins.str:
        """
        Availability of the software source (for Oracle Cloud Infrastructure environments).
        """
        return pulumi.get(self, "availability_at_oci")

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> builtins.str:
        """
        The yum repository checksum type used by this software source.
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the software source.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customSoftwareSourceFilters")
    def custom_software_source_filters(self) -> Sequence['outputs.GetSoftwareSourceCustomSoftwareSourceFilterResult']:
        """
        Provides the information used to apply filters to a vendor software source to create or update a custom software source.
        """
        return pulumi.get(self, "custom_software_source_filters")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        User-specified description for the software source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        User-friendly name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gpgKeyFingerprint")
    def gpg_key_fingerprint(self) -> builtins.str:
        """
        Fingerprint of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_fingerprint")

    @property
    @pulumi.getter(name="gpgKeyId")
    def gpg_key_id(self) -> builtins.str:
        """
        ID of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_id")

    @property
    @pulumi.getter(name="gpgKeyUrl")
    def gpg_key_url(self) -> builtins.str:
        """
        URI of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_url")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoResolveDependencies")
    def is_auto_resolve_dependencies(self) -> builtins.bool:
        """
        Indicates whether the service should automatically resolve package dependencies when including specific packages in the software source.
        """
        return pulumi.get(self, "is_auto_resolve_dependencies")

    @property
    @pulumi.getter(name="isAutomaticallyUpdated")
    def is_automatically_updated(self) -> builtins.bool:
        """
        Indicates whether the service should automatically update the custom software source to use the latest package versions available. The service reviews packages levels once a day.
        """
        return pulumi.get(self, "is_automatically_updated")

    @property
    @pulumi.getter(name="isCreatedFromPackageList")
    def is_created_from_package_list(self) -> builtins.bool:
        """
        Indicates whether the service should create the software source from a list of packages provided by the user.
        """
        return pulumi.get(self, "is_created_from_package_list")

    @property
    @pulumi.getter(name="isGpgCheckEnabled")
    def is_gpg_check_enabled(self) -> builtins.bool:
        """
        Whether signature verification should be done for the software source
        """
        return pulumi.get(self, "is_gpg_check_enabled")

    @property
    @pulumi.getter(name="isLatestContentOnly")
    def is_latest_content_only(self) -> builtins.bool:
        """
        Indicates whether the software source will include only the latest versions of content from vendor software sources, while accounting for other constraints set in the custom or versioned custom software source (such as a package list or filters).
        * For a module filter that does not specify a stream, this will include all available streams, and within each stream only the latest version of packages.
        * For a module filter that does specify a stream, this will include only the latest version of packages for the specified stream.
        * For a package filter that does not specify a version, this will include only the latest available version of the package.
        * For a package filter that does specify a version, this will include only the specified version of the package (the isLatestContentOnly attribute is ignored).
        * For a package list, this will include only the specified version of packages and modules in the list (the isLatestContentOnly attribute is ignored).
        """
        return pulumi.get(self, "is_latest_content_only")

    @property
    @pulumi.getter(name="isMandatoryForAutonomousLinux")
    def is_mandatory_for_autonomous_linux(self) -> builtins.bool:
        """
        Indicates whether the software source is required for the Autonomous Linux service.
        """
        return pulumi.get(self, "is_mandatory_for_autonomous_linux")

    @property
    @pulumi.getter(name="isMirrorSyncAllowed")
    def is_mirror_sync_allowed(self) -> builtins.bool:
        """
        Indicates if this software source can be mirrored to a management station.
        """
        return pulumi.get(self, "is_mirror_sync_allowed")

    @property
    @pulumi.getter(name="isSslVerifyEnabled")
    def is_ssl_verify_enabled(self) -> builtins.bool:
        """
        Indicates if SSL validation is enabled for the software source.
        """
        return pulumi.get(self, "is_ssl_verify_enabled")

    @property
    @pulumi.getter(name="originSoftwareSourceId")
    def origin_software_source_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vendor software source in the root compartment. This property applies only to replicated vendor software sources.
        """
        return pulumi.get(self, "origin_software_source_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> builtins.str:
        """
        The OS family of the software source.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="packageCount")
    def package_count(self) -> builtins.str:
        """
        Number of packages the software source contains.
        """
        return pulumi.get(self, "package_count")

    @property
    @pulumi.getter
    def packages(self) -> Sequence[builtins.str]:
        """
        The packages in the software source.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> builtins.str:
        """
        The repository ID for the software source.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter
    def size(self) -> builtins.float:
        """
        The size of the software source in bytes (B).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> builtins.str:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter(name="softwareSourceSubType")
    def software_source_sub_type(self) -> builtins.str:
        """
        Identifies how the versioned custom software source was created.
        """
        return pulumi.get(self, "software_source_sub_type")

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> builtins.str:
        """
        Type of software source.
        """
        return pulumi.get(self, "software_source_type")

    @property
    @pulumi.getter(name="softwareSourceVersion")
    def software_source_version(self) -> builtins.str:
        """
        The version to assign to this custom software source.
        """
        return pulumi.get(self, "software_source_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the software source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the software source was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMetadataUpdated")
    def time_metadata_updated(self) -> builtins.str:
        """
        The date and time the metadata for this software source was last updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_metadata_updated")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL for the repository. For vendor software sources, this is the URL to the regional yum server. For custom software sources, this is 'custom/<repoId>'.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> builtins.str:
        """
        Name of the vendor providing the software source.
        """
        return pulumi.get(self, "vendor_name")

    @property
    @pulumi.getter(name="vendorSoftwareSources")
    def vendor_software_sources(self) -> Sequence['outputs.GetSoftwareSourceVendorSoftwareSourceResult']:
        """
        List of vendor software sources that are used for the basis of the versioned custom software source.
        """
        return pulumi.get(self, "vendor_software_sources")


class AwaitableGetSoftwareSourceResult(GetSoftwareSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceResult(
            advanced_repo_options=self.advanced_repo_options,
            arch_type=self.arch_type,
            availability=self.availability,
            availability_at_oci=self.availability_at_oci,
            checksum_type=self.checksum_type,
            compartment_id=self.compartment_id,
            custom_software_source_filters=self.custom_software_source_filters,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            gpg_key_fingerprint=self.gpg_key_fingerprint,
            gpg_key_id=self.gpg_key_id,
            gpg_key_url=self.gpg_key_url,
            id=self.id,
            is_auto_resolve_dependencies=self.is_auto_resolve_dependencies,
            is_automatically_updated=self.is_automatically_updated,
            is_created_from_package_list=self.is_created_from_package_list,
            is_gpg_check_enabled=self.is_gpg_check_enabled,
            is_latest_content_only=self.is_latest_content_only,
            is_mandatory_for_autonomous_linux=self.is_mandatory_for_autonomous_linux,
            is_mirror_sync_allowed=self.is_mirror_sync_allowed,
            is_ssl_verify_enabled=self.is_ssl_verify_enabled,
            origin_software_source_id=self.origin_software_source_id,
            os_family=self.os_family,
            package_count=self.package_count,
            packages=self.packages,
            repo_id=self.repo_id,
            size=self.size,
            software_source_id=self.software_source_id,
            software_source_sub_type=self.software_source_sub_type,
            software_source_type=self.software_source_type,
            software_source_version=self.software_source_version,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_metadata_updated=self.time_metadata_updated,
            url=self.url,
            vendor_name=self.vendor_name,
            vendor_software_sources=self.vendor_software_sources)


def get_software_source(software_source_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceResult:
    """
    This data source provides details about a specific Software Source resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source = oci.OsManagementHub.get_software_source(software_source_id=test_software_source_oci_os_management_hub_software_source["id"])
    ```


    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSource:getSoftwareSource', __args__, opts=opts, typ=GetSoftwareSourceResult).value

    return AwaitableGetSoftwareSourceResult(
        advanced_repo_options=pulumi.get(__ret__, 'advanced_repo_options'),
        arch_type=pulumi.get(__ret__, 'arch_type'),
        availability=pulumi.get(__ret__, 'availability'),
        availability_at_oci=pulumi.get(__ret__, 'availability_at_oci'),
        checksum_type=pulumi.get(__ret__, 'checksum_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        custom_software_source_filters=pulumi.get(__ret__, 'custom_software_source_filters'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gpg_key_fingerprint=pulumi.get(__ret__, 'gpg_key_fingerprint'),
        gpg_key_id=pulumi.get(__ret__, 'gpg_key_id'),
        gpg_key_url=pulumi.get(__ret__, 'gpg_key_url'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_resolve_dependencies=pulumi.get(__ret__, 'is_auto_resolve_dependencies'),
        is_automatically_updated=pulumi.get(__ret__, 'is_automatically_updated'),
        is_created_from_package_list=pulumi.get(__ret__, 'is_created_from_package_list'),
        is_gpg_check_enabled=pulumi.get(__ret__, 'is_gpg_check_enabled'),
        is_latest_content_only=pulumi.get(__ret__, 'is_latest_content_only'),
        is_mandatory_for_autonomous_linux=pulumi.get(__ret__, 'is_mandatory_for_autonomous_linux'),
        is_mirror_sync_allowed=pulumi.get(__ret__, 'is_mirror_sync_allowed'),
        is_ssl_verify_enabled=pulumi.get(__ret__, 'is_ssl_verify_enabled'),
        origin_software_source_id=pulumi.get(__ret__, 'origin_software_source_id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        package_count=pulumi.get(__ret__, 'package_count'),
        packages=pulumi.get(__ret__, 'packages'),
        repo_id=pulumi.get(__ret__, 'repo_id'),
        size=pulumi.get(__ret__, 'size'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        software_source_sub_type=pulumi.get(__ret__, 'software_source_sub_type'),
        software_source_type=pulumi.get(__ret__, 'software_source_type'),
        software_source_version=pulumi.get(__ret__, 'software_source_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_metadata_updated=pulumi.get(__ret__, 'time_metadata_updated'),
        url=pulumi.get(__ret__, 'url'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'),
        vendor_software_sources=pulumi.get(__ret__, 'vendor_software_sources'))
def get_software_source_output(software_source_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwareSourceResult]:
    """
    This data source provides details about a specific Software Source resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source = oci.OsManagementHub.get_software_source(software_source_id=test_software_source_oci_os_management_hub_software_source["id"])
    ```


    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getSoftwareSource:getSoftwareSource', __args__, opts=opts, typ=GetSoftwareSourceResult)
    return __ret__.apply(lambda __response__: GetSoftwareSourceResult(
        advanced_repo_options=pulumi.get(__response__, 'advanced_repo_options'),
        arch_type=pulumi.get(__response__, 'arch_type'),
        availability=pulumi.get(__response__, 'availability'),
        availability_at_oci=pulumi.get(__response__, 'availability_at_oci'),
        checksum_type=pulumi.get(__response__, 'checksum_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        custom_software_source_filters=pulumi.get(__response__, 'custom_software_source_filters'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gpg_key_fingerprint=pulumi.get(__response__, 'gpg_key_fingerprint'),
        gpg_key_id=pulumi.get(__response__, 'gpg_key_id'),
        gpg_key_url=pulumi.get(__response__, 'gpg_key_url'),
        id=pulumi.get(__response__, 'id'),
        is_auto_resolve_dependencies=pulumi.get(__response__, 'is_auto_resolve_dependencies'),
        is_automatically_updated=pulumi.get(__response__, 'is_automatically_updated'),
        is_created_from_package_list=pulumi.get(__response__, 'is_created_from_package_list'),
        is_gpg_check_enabled=pulumi.get(__response__, 'is_gpg_check_enabled'),
        is_latest_content_only=pulumi.get(__response__, 'is_latest_content_only'),
        is_mandatory_for_autonomous_linux=pulumi.get(__response__, 'is_mandatory_for_autonomous_linux'),
        is_mirror_sync_allowed=pulumi.get(__response__, 'is_mirror_sync_allowed'),
        is_ssl_verify_enabled=pulumi.get(__response__, 'is_ssl_verify_enabled'),
        origin_software_source_id=pulumi.get(__response__, 'origin_software_source_id'),
        os_family=pulumi.get(__response__, 'os_family'),
        package_count=pulumi.get(__response__, 'package_count'),
        packages=pulumi.get(__response__, 'packages'),
        repo_id=pulumi.get(__response__, 'repo_id'),
        size=pulumi.get(__response__, 'size'),
        software_source_id=pulumi.get(__response__, 'software_source_id'),
        software_source_sub_type=pulumi.get(__response__, 'software_source_sub_type'),
        software_source_type=pulumi.get(__response__, 'software_source_type'),
        software_source_version=pulumi.get(__response__, 'software_source_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_metadata_updated=pulumi.get(__response__, 'time_metadata_updated'),
        url=pulumi.get(__response__, 'url'),
        vendor_name=pulumi.get(__response__, 'vendor_name'),
        vendor_software_sources=pulumi.get(__response__, 'vendor_software_sources')))
