# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMonitoringTemplateAlarmConditionResult',
    'AwaitableGetMonitoringTemplateAlarmConditionResult',
    'get_monitoring_template_alarm_condition',
    'get_monitoring_template_alarm_condition_output',
]

@pulumi.output_type
class GetMonitoringTemplateAlarmConditionResult:
    """
    A collection of values returned by getMonitoringTemplateAlarmCondition.
    """
    def __init__(__self__, alarm_condition_id=None, composite_type=None, condition_type=None, conditions=None, defined_tags=None, freeform_tags=None, id=None, metric_name=None, monitoring_template_id=None, namespace=None, resource_type=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if alarm_condition_id and not isinstance(alarm_condition_id, str):
            raise TypeError("Expected argument 'alarm_condition_id' to be a str")
        pulumi.set(__self__, "alarm_condition_id", alarm_condition_id)
        if composite_type and not isinstance(composite_type, str):
            raise TypeError("Expected argument 'composite_type' to be a str")
        pulumi.set(__self__, "composite_type", composite_type)
        if condition_type and not isinstance(condition_type, str):
            raise TypeError("Expected argument 'condition_type' to be a str")
        pulumi.set(__self__, "condition_type", condition_type)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metric_name and not isinstance(metric_name, str):
            raise TypeError("Expected argument 'metric_name' to be a str")
        pulumi.set(__self__, "metric_name", metric_name)
        if monitoring_template_id and not isinstance(monitoring_template_id, str):
            raise TypeError("Expected argument 'monitoring_template_id' to be a str")
        pulumi.set(__self__, "monitoring_template_id", monitoring_template_id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmConditionId")
    def alarm_condition_id(self) -> builtins.str:
        return pulumi.get(self, "alarm_condition_id")

    @property
    @pulumi.getter(name="compositeType")
    def composite_type(self) -> builtins.str:
        """
        The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        """
        return pulumi.get(self, "composite_type")

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> builtins.str:
        """
        Type of defined monitoring template.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetMonitoringTemplateAlarmConditionConditionResult']:
        """
        Monitoring template conditions
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Alarm Condition.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        The metric name.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="monitoringTemplateId")
    def monitoring_template_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        """
        return pulumi.get(self, "monitoring_template_id")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The resource type OCID.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the monitoring template
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current status of the monitoring template i.e. whether it is Published or Unpublished
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the alarm condition was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the alarm condition was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMonitoringTemplateAlarmConditionResult(GetMonitoringTemplateAlarmConditionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoringTemplateAlarmConditionResult(
            alarm_condition_id=self.alarm_condition_id,
            composite_type=self.composite_type,
            condition_type=self.condition_type,
            conditions=self.conditions,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            metric_name=self.metric_name,
            monitoring_template_id=self.monitoring_template_id,
            namespace=self.namespace,
            resource_type=self.resource_type,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_monitoring_template_alarm_condition(alarm_condition_id: Optional[builtins.str] = None,
                                            monitoring_template_id: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoringTemplateAlarmConditionResult:
    """
    This data source provides details about a specific Monitoring Template Alarm Condition resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a Alarm Condition by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitoring_template_alarm_condition = oci.StackMonitoring.get_monitoring_template_alarm_condition(alarm_condition_id=test_alarm_condition["id"],
        monitoring_template_id=test_monitoring_template["id"])
    ```


    :param builtins.str alarm_condition_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm condition.
    :param builtins.str monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
    """
    __args__ = dict()
    __args__['alarmConditionId'] = alarm_condition_id
    __args__['monitoringTemplateId'] = monitoring_template_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoringTemplateAlarmCondition:getMonitoringTemplateAlarmCondition', __args__, opts=opts, typ=GetMonitoringTemplateAlarmConditionResult).value

    return AwaitableGetMonitoringTemplateAlarmConditionResult(
        alarm_condition_id=pulumi.get(__ret__, 'alarm_condition_id'),
        composite_type=pulumi.get(__ret__, 'composite_type'),
        condition_type=pulumi.get(__ret__, 'condition_type'),
        conditions=pulumi.get(__ret__, 'conditions'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        metric_name=pulumi.get(__ret__, 'metric_name'),
        monitoring_template_id=pulumi.get(__ret__, 'monitoring_template_id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_monitoring_template_alarm_condition_output(alarm_condition_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   monitoring_template_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoringTemplateAlarmConditionResult]:
    """
    This data source provides details about a specific Monitoring Template Alarm Condition resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a Alarm Condition by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitoring_template_alarm_condition = oci.StackMonitoring.get_monitoring_template_alarm_condition(alarm_condition_id=test_alarm_condition["id"],
        monitoring_template_id=test_monitoring_template["id"])
    ```


    :param builtins.str alarm_condition_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm condition.
    :param builtins.str monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
    """
    __args__ = dict()
    __args__['alarmConditionId'] = alarm_condition_id
    __args__['monitoringTemplateId'] = monitoring_template_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMonitoringTemplateAlarmCondition:getMonitoringTemplateAlarmCondition', __args__, opts=opts, typ=GetMonitoringTemplateAlarmConditionResult)
    return __ret__.apply(lambda __response__: GetMonitoringTemplateAlarmConditionResult(
        alarm_condition_id=pulumi.get(__response__, 'alarm_condition_id'),
        composite_type=pulumi.get(__response__, 'composite_type'),
        condition_type=pulumi.get(__response__, 'condition_type'),
        conditions=pulumi.get(__response__, 'conditions'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        metric_name=pulumi.get(__response__, 'metric_name'),
        monitoring_template_id=pulumi.get(__response__, 'monitoring_template_id'),
        namespace=pulumi.get(__response__, 'namespace'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
