# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, classic_subscription_id=None, cloud_amount_currency=None, compartment_id=None, csi_number=None, currency_code=None, customer_country_code=None, defined_tags=None, end_date=None, entity_version=None, freeform_tags=None, id=None, is_classic_subscription=None, is_government_subscription=None, payment_model=None, program_type=None, promotions=None, purchase_entitlement_id=None, region_assignment=None, service_name=None, skuses=None, start_date=None, state=None, subscription_id=None, subscription_number=None, subscription_tier=None, time_created=None, time_updated=None):
        if classic_subscription_id and not isinstance(classic_subscription_id, str):
            raise TypeError("Expected argument 'classic_subscription_id' to be a str")
        pulumi.set(__self__, "classic_subscription_id", classic_subscription_id)
        if cloud_amount_currency and not isinstance(cloud_amount_currency, str):
            raise TypeError("Expected argument 'cloud_amount_currency' to be a str")
        pulumi.set(__self__, "cloud_amount_currency", cloud_amount_currency)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if csi_number and not isinstance(csi_number, str):
            raise TypeError("Expected argument 'csi_number' to be a str")
        pulumi.set(__self__, "csi_number", csi_number)
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if customer_country_code and not isinstance(customer_country_code, str):
            raise TypeError("Expected argument 'customer_country_code' to be a str")
        pulumi.set(__self__, "customer_country_code", customer_country_code)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if end_date and not isinstance(end_date, str):
            raise TypeError("Expected argument 'end_date' to be a str")
        pulumi.set(__self__, "end_date", end_date)
        if entity_version and not isinstance(entity_version, str):
            raise TypeError("Expected argument 'entity_version' to be a str")
        pulumi.set(__self__, "entity_version", entity_version)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_classic_subscription and not isinstance(is_classic_subscription, bool):
            raise TypeError("Expected argument 'is_classic_subscription' to be a bool")
        pulumi.set(__self__, "is_classic_subscription", is_classic_subscription)
        if is_government_subscription and not isinstance(is_government_subscription, bool):
            raise TypeError("Expected argument 'is_government_subscription' to be a bool")
        pulumi.set(__self__, "is_government_subscription", is_government_subscription)
        if payment_model and not isinstance(payment_model, str):
            raise TypeError("Expected argument 'payment_model' to be a str")
        pulumi.set(__self__, "payment_model", payment_model)
        if program_type and not isinstance(program_type, str):
            raise TypeError("Expected argument 'program_type' to be a str")
        pulumi.set(__self__, "program_type", program_type)
        if promotions and not isinstance(promotions, list):
            raise TypeError("Expected argument 'promotions' to be a list")
        pulumi.set(__self__, "promotions", promotions)
        if purchase_entitlement_id and not isinstance(purchase_entitlement_id, str):
            raise TypeError("Expected argument 'purchase_entitlement_id' to be a str")
        pulumi.set(__self__, "purchase_entitlement_id", purchase_entitlement_id)
        if region_assignment and not isinstance(region_assignment, str):
            raise TypeError("Expected argument 'region_assignment' to be a str")
        pulumi.set(__self__, "region_assignment", region_assignment)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if skuses and not isinstance(skuses, list):
            raise TypeError("Expected argument 'skuses' to be a list")
        pulumi.set(__self__, "skuses", skuses)
        if start_date and not isinstance(start_date, str):
            raise TypeError("Expected argument 'start_date' to be a str")
        pulumi.set(__self__, "start_date", start_date)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_number and not isinstance(subscription_number, str):
            raise TypeError("Expected argument 'subscription_number' to be a str")
        pulumi.set(__self__, "subscription_number", subscription_number)
        if subscription_tier and not isinstance(subscription_tier, str):
            raise TypeError("Expected argument 'subscription_tier' to be a str")
        pulumi.set(__self__, "subscription_tier", subscription_tier)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="classicSubscriptionId")
    def classic_subscription_id(self) -> builtins.str:
        """
        Classic subscription ID.
        """
        return pulumi.get(self, "classic_subscription_id")

    @property
    @pulumi.getter(name="cloudAmountCurrency")
    def cloud_amount_currency(self) -> builtins.str:
        """
        The currency code for the customer associated with the subscription.
        """
        return pulumi.get(self, "cloud_amount_currency")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the owning compartment. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> builtins.str:
        """
        Customer service identifier for the customer associated with the subscription.
        """
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code. For example USD, MXN.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="customerCountryCode")
    def customer_country_code(self) -> builtins.str:
        """
        The country code for the customer associated with the subscription.
        """
        return pulumi.get(self, "customer_country_code")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="entityVersion")
    def entity_version(self) -> builtins.str:
        """
        The entity version of the subscription, whether V1 (the legacy schema version), or V2 (the latest 20230401 API version).
        """
        return pulumi.get(self, "entity_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isClassicSubscription")
    def is_classic_subscription(self) -> builtins.bool:
        """
        Specifies whether or not the subscription is from classic systems.
        """
        return pulumi.get(self, "is_classic_subscription")

    @property
    @pulumi.getter(name="isGovernmentSubscription")
    def is_government_subscription(self) -> builtins.bool:
        """
        Specifies whether or not the subscription is a government subscription.
        """
        return pulumi.get(self, "is_government_subscription")

    @property
    @pulumi.getter(name="paymentModel")
    def payment_model(self) -> builtins.str:
        """
        The pay model of the subscription, such as 'Pay as you go' or 'Monthly'.
        """
        return pulumi.get(self, "payment_model")

    @property
    @pulumi.getter(name="programType")
    def program_type(self) -> builtins.str:
        """
        Specifies any program that is associated with the subscription.
        """
        return pulumi.get(self, "program_type")

    @property
    @pulumi.getter
    def promotions(self) -> Sequence['outputs.GetSubscriptionPromotionResult']:
        """
        List of promotions related to the subscription.
        """
        return pulumi.get(self, "promotions")

    @property
    @pulumi.getter(name="purchaseEntitlementId")
    def purchase_entitlement_id(self) -> builtins.str:
        """
        Purchase entitlement ID associated with the subscription.
        """
        return pulumi.get(self, "purchase_entitlement_id")

    @property
    @pulumi.getter(name="regionAssignment")
    def region_assignment(self) -> builtins.str:
        """
        Region for the subscription.
        """
        return pulumi.get(self, "region_assignment")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        The type of subscription, such as 'UCM', 'SAAS', 'ERP', 'CRM'.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetSubscriptionSkusResult']:
        """
        List of SKUs linked to this subscription.
        """
        return pulumi.get(self, "skuses")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Lifecycle state of the subscription.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionNumber")
    def subscription_number(self) -> builtins.str:
        """
        Unique Oracle Cloud Subscriptions identifier that is immutable on creation.
        """
        return pulumi.get(self, "subscription_number")

    @property
    @pulumi.getter(name="subscriptionTier")
    def subscription_tier(self) -> builtins.str:
        """
        Tier for the subscription, whether a free promotion subscription or a paid subscription.
        """
        return pulumi.get(self, "subscription_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time of creation, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time of update, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            classic_subscription_id=self.classic_subscription_id,
            cloud_amount_currency=self.cloud_amount_currency,
            compartment_id=self.compartment_id,
            csi_number=self.csi_number,
            currency_code=self.currency_code,
            customer_country_code=self.customer_country_code,
            defined_tags=self.defined_tags,
            end_date=self.end_date,
            entity_version=self.entity_version,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_classic_subscription=self.is_classic_subscription,
            is_government_subscription=self.is_government_subscription,
            payment_model=self.payment_model,
            program_type=self.program_type,
            promotions=self.promotions,
            purchase_entitlement_id=self.purchase_entitlement_id,
            region_assignment=self.region_assignment,
            service_name=self.service_name,
            skuses=self.skuses,
            start_date=self.start_date,
            state=self.state,
            subscription_id=self.subscription_id,
            subscription_number=self.subscription_number,
            subscription_tier=self.subscription_tier,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_subscription(subscription_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    This data source provides details about a specific Subscription resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets the subscription details by subscription ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription = oci.Tenantmanagercontrolplane.get_subscription(subscription_id=test_subscription_oci_tenantmanagercontrolplane_subscription["id"])
    ```


    :param builtins.str subscription_id: OCID of the subscription.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        classic_subscription_id=pulumi.get(__ret__, 'classic_subscription_id'),
        cloud_amount_currency=pulumi.get(__ret__, 'cloud_amount_currency'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        csi_number=pulumi.get(__ret__, 'csi_number'),
        currency_code=pulumi.get(__ret__, 'currency_code'),
        customer_country_code=pulumi.get(__ret__, 'customer_country_code'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        end_date=pulumi.get(__ret__, 'end_date'),
        entity_version=pulumi.get(__ret__, 'entity_version'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_classic_subscription=pulumi.get(__ret__, 'is_classic_subscription'),
        is_government_subscription=pulumi.get(__ret__, 'is_government_subscription'),
        payment_model=pulumi.get(__ret__, 'payment_model'),
        program_type=pulumi.get(__ret__, 'program_type'),
        promotions=pulumi.get(__ret__, 'promotions'),
        purchase_entitlement_id=pulumi.get(__ret__, 'purchase_entitlement_id'),
        region_assignment=pulumi.get(__ret__, 'region_assignment'),
        service_name=pulumi.get(__ret__, 'service_name'),
        skuses=pulumi.get(__ret__, 'skuses'),
        start_date=pulumi.get(__ret__, 'start_date'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscription_number=pulumi.get(__ret__, 'subscription_number'),
        subscription_tier=pulumi.get(__ret__, 'subscription_tier'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_subscription_output(subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    This data source provides details about a specific Subscription resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets the subscription details by subscription ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription = oci.Tenantmanagercontrolplane.get_subscription(subscription_id=test_subscription_oci_tenantmanagercontrolplane_subscription["id"])
    ```


    :param builtins.str subscription_id: OCID of the subscription.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSubscriptionResult(
        classic_subscription_id=pulumi.get(__response__, 'classic_subscription_id'),
        cloud_amount_currency=pulumi.get(__response__, 'cloud_amount_currency'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        csi_number=pulumi.get(__response__, 'csi_number'),
        currency_code=pulumi.get(__response__, 'currency_code'),
        customer_country_code=pulumi.get(__response__, 'customer_country_code'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        end_date=pulumi.get(__response__, 'end_date'),
        entity_version=pulumi.get(__response__, 'entity_version'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_classic_subscription=pulumi.get(__response__, 'is_classic_subscription'),
        is_government_subscription=pulumi.get(__response__, 'is_government_subscription'),
        payment_model=pulumi.get(__response__, 'payment_model'),
        program_type=pulumi.get(__response__, 'program_type'),
        promotions=pulumi.get(__response__, 'promotions'),
        purchase_entitlement_id=pulumi.get(__response__, 'purchase_entitlement_id'),
        region_assignment=pulumi.get(__response__, 'region_assignment'),
        service_name=pulumi.get(__response__, 'service_name'),
        skuses=pulumi.get(__response__, 'skuses'),
        start_date=pulumi.get(__response__, 'start_date'),
        state=pulumi.get(__response__, 'state'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscription_number=pulumi.get(__response__, 'subscription_number'),
        subscription_tier=pulumi.get(__response__, 'subscription_tier'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
