# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubscriptionMappingsResult',
    'AwaitableGetSubscriptionMappingsResult',
    'get_subscription_mappings',
    'get_subscription_mappings_output',
]

@pulumi.output_type
class GetSubscriptionMappingsResult:
    """
    A collection of values returned by getSubscriptionMappings.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, state=None, subscription_id=None, subscription_mapping_collections=None, subscription_mapping_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_mapping_collections and not isinstance(subscription_mapping_collections, list):
            raise TypeError("Expected argument 'subscription_mapping_collections' to be a list")
        pulumi.set(__self__, "subscription_mapping_collections", subscription_mapping_collections)
        if subscription_mapping_id and not isinstance(subscription_mapping_id, str):
            raise TypeError("Expected argument 'subscription_mapping_id' to be a str")
        pulumi.set(__self__, "subscription_mapping_id", subscription_mapping_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        OCID of the compartment. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSubscriptionMappingsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Lifecycle state of the subscriptionMapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        OCID of the subscription.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionMappingCollections")
    def subscription_mapping_collections(self) -> Sequence['outputs.GetSubscriptionMappingsSubscriptionMappingCollectionResult']:
        """
        The list of subscription_mapping_collection.
        """
        return pulumi.get(self, "subscription_mapping_collections")

    @property
    @pulumi.getter(name="subscriptionMappingId")
    def subscription_mapping_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subscription_mapping_id")


class AwaitableGetSubscriptionMappingsResult(GetSubscriptionMappingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionMappingsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            subscription_id=self.subscription_id,
            subscription_mapping_collections=self.subscription_mapping_collections,
            subscription_mapping_id=self.subscription_mapping_id)


def get_subscription_mappings(compartment_id: Optional[builtins.str] = None,
                              filters: Optional[Sequence[Union['GetSubscriptionMappingsFilterArgs', 'GetSubscriptionMappingsFilterArgsDict']]] = None,
                              state: Optional[builtins.str] = None,
                              subscription_id: Optional[builtins.str] = None,
                              subscription_mapping_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionMappingsResult:
    """
    This data source provides the list of Subscription Mappings in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Lists the subscription mappings for all the subscriptions owned by a given compartmentId. Only the root compartment is allowed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_mappings = oci.Tenantmanagercontrolplane.get_subscription_mappings(subscription_id=test_subscription["id"],
        compartment_id=compartment_id,
        state=subscription_mapping_state,
        subscription_mapping_id=test_subscription_mapping["id"])
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str state: The lifecycle state of the resource.
    :param builtins.str subscription_id: OCID of the subscription.
    :param builtins.str subscription_mapping_id: A unique ID for subscription and tenancy mapping.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionMappingId'] = subscription_mapping_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getSubscriptionMappings:getSubscriptionMappings', __args__, opts=opts, typ=GetSubscriptionMappingsResult).value

    return AwaitableGetSubscriptionMappingsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscription_mapping_collections=pulumi.get(__ret__, 'subscription_mapping_collections'),
        subscription_mapping_id=pulumi.get(__ret__, 'subscription_mapping_id'))
def get_subscription_mappings_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSubscriptionMappingsFilterArgs', 'GetSubscriptionMappingsFilterArgsDict']]]]] = None,
                                     state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                                     subscription_mapping_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionMappingsResult]:
    """
    This data source provides the list of Subscription Mappings in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Lists the subscription mappings for all the subscriptions owned by a given compartmentId. Only the root compartment is allowed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_mappings = oci.Tenantmanagercontrolplane.get_subscription_mappings(subscription_id=test_subscription["id"],
        compartment_id=compartment_id,
        state=subscription_mapping_state,
        subscription_mapping_id=test_subscription_mapping["id"])
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str state: The lifecycle state of the resource.
    :param builtins.str subscription_id: OCID of the subscription.
    :param builtins.str subscription_mapping_id: A unique ID for subscription and tenancy mapping.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionMappingId'] = subscription_mapping_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getSubscriptionMappings:getSubscriptionMappings', __args__, opts=opts, typ=GetSubscriptionMappingsResult)
    return __ret__.apply(lambda __response__: GetSubscriptionMappingsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscription_mapping_collections=pulumi.get(__response__, 'subscription_mapping_collections'),
        subscription_mapping_id=pulumi.get(__response__, 'subscription_mapping_id')))
