
import random
import csv
import os

# Save the required data for making the password in lists
numerals = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
lowerCaps = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z']
upperChars = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z']

combinedChars = numerals + lowerCaps + upperChars
module_dir = os.path.dirname(__file__)

def read_csv_file(file_name):
    """
    Read a CSV file and return its contents as a list.

    Args:
        file_name (str): The name of the CSV file to read.

    Returns:
        list: A list containing the values read from the CSV file.
    """
    file_path = os.path.join(module_dir, file_name)
    with open(file_path) as csv_file:
        csv_reader = csv.reader(csv_file)
        return [row[0] for row in csv_reader]

nameList = read_csv_file('names.csv')
placeList = read_csv_file('places.csv')

def custom_choice(chars):
    """
    Choose a random character from the given character set.

    Args:
        chars (list): A list containing characters to choose from.

    Returns:
        str: A random character from the given character set.
    """
    return random.choice(chars)

def make_random():
    """
    Generate a random password that is not present in the name or place list.

    Returns:
        str: A randomly generated password.
    """
    passLength = random.randint(6, 12)
    password = [custom_choice(combinedChars) for _ in range(passLength)]
    password.insert(0, random.choice(numerals))  # Include one numeric value
    random.shuffle(password)
    pswd = "".join(password)
    return pswd if passwordChecker(pswd) else make_random()

def passwordChecker(created_pass):
    """
    Check if the generated password is not present in the name or place list.

    Args:
        created_pass (str): The password to be checked.

    Returns:
        bool: True if the password is not in the name or place list, False otherwise.
    """
    return created_pass not in (nameList + placeList)

def generatePass():
    """
    Generate a random password that is not present in the name or place list.

    Returns:
        str: A randomly generated password.
    """
    return make_random()

# Example usage:
# final_pass = generatePass()
# print(len(final_pass))
# print(final_pass)