/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.astria.DataManager;
import org.astria.ManualPropagation;
import org.astria.Measurements;
import org.astria.PropagatorBuilder;
import org.astria.Settings;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.CholeskyDecomposition;
import org.hipparchus.linear.DiagonalMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.estimation.sequential.KalmanEstimatorBuilder;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.DormandPrince853IntegratorBuilder;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeStampedPVCoordinates;

public final class Estimation {
    private final Settings odCfg;
    private final Measurements odObs;
    private String[] measNames;
    private final boolean combinedMeas;
    private final AbsoluteDate epoch;
    private final AbsoluteDate propEnd;
    private final AbsoluteDate stepHandlerStart;
    private final AbsoluteDate stepHandlerEnd;
    private ArrayList<EstimationOutput> estOutput;
    public static final String[] DMC_ACC_ESTM = new String[]{"zDMCx", "zDMCy", "zDMCz"};
    public static final String DMC_ACC_PROP = "DMCEstProp";

    public Estimation(Settings odCfg, Measurements odObs) {
        this.odCfg = odCfg;
        this.odObs = odObs;
        if (odCfg.estmFilter.equalsIgnoreCase("UKF") && odCfg.gravityDegree >= 2 && odCfg.gravityOrder >= 0) {
            odCfg.forces.add(0, new NewtonianAttraction(3.986004415E14));
        }
        this.measNames = odCfg.cfgMeasurements.keySet().toArray(new String[0]);
        Arrays.sort(this.measNames);
        if (this.measNames[0].equalsIgnoreCase("Declination")) {
            this.measNames = new String[]{"RightAscension", "Declination"};
        }
        this.combinedMeas = !this.measNames[0].equalsIgnoreCase("Range") && !this.measNames[0].equalsIgnoreCase("RangeRate");
        this.epoch = DataManager.parseDateTime(odCfg.propStart);
        this.propEnd = DataManager.parseDateTime(odCfg.propEnd);
        this.stepHandlerStart = odCfg.propStepHandlerStartTime != null ? DataManager.parseDateTime(odCfg.propStepHandlerStartTime) : (odCfg.propStep >= 0.0 ? this.epoch : this.propEnd);
        this.stepHandlerEnd = odCfg.propStepHandlerEndTime != null ? DataManager.parseDateTime(odCfg.propStepHandlerEndTime) : (odCfg.propStep >= 0.0 ? this.propEnd : this.epoch);
    }

    public ArrayList<EstimationOutput> determineOrbit() {
        int size = FastMath.max(this.odObs.rawMeas.length, 10);
        if (this.odCfg.propStep != 0.0) {
            size += (int)FastMath.abs(this.propEnd.durationFrom(this.epoch) / this.odCfg.propStep) + 2;
        }
        this.estOutput = new ArrayList(size);
        if (this.odCfg.estmFilter.equalsIgnoreCase("UKF")) {
            new UnscentedKalmanFilter().determineOrbit();
        } else {
            new ExtendedKalmanFilter().determineOrbit();
        }
        return this.estOutput;
    }

    private class UnscentedKalmanFilter {
        private UnscentedKalmanFilter() {
        }

        private void determineOrbit() {
            HashMap<String, Integer> biasPos = new HashMap<String, Integer>();
            if (((Estimation)Estimation.this).odCfg.cfgStations != null) {
                String[] stations = ((Estimation)Estimation.this).odCfg.cfgStations.keySet().toArray(new String[0]);
                for (int i = 0; i < stations.length; ++i) {
                    for (int j = 0; j < Estimation.this.measNames.length; ++j) {
                        for (int k = 0; k < ((Estimation)Estimation.this).odCfg.parameters.size(); ++k) {
                            String bias = stations[i] + Estimation.this.measNames[j];
                            if (!bias.equalsIgnoreCase(((Estimation)Estimation.this).odCfg.parameters.get((int)k).name)) continue;
                            biasPos.put(bias, k + 6);
                        }
                    }
                }
            }
            int Rsize = 0;
            for (String s : Estimation.this.measNames) {
                Rsize += ((Estimation)Estimation.this).odCfg.cfgMeasurements.get((Object)s).error.length;
            }
            Array2DRowRealMatrix R = new Array2DRowRealMatrix(Rsize, Rsize);
            int j = 0;
            for (int i = 0; i < Estimation.this.measNames.length; ++i) {
                Settings.Measurement jm = ((Estimation)Estimation.this).odCfg.cfgMeasurements.get(Estimation.this.measNames[i]);
                for (int k = 0; k < jm.error.length; ++k) {
                    R.setEntry(j, j, jm.error[k] * jm.error[k]);
                    ++j;
                }
            }
            boolean enableDMC = false;
            int numStates = ((Estimation)Estimation.this).odCfg.parameters.size() + 6;
            int numSigmas = 2 * numStates;
            double weight = 0.5 / (double)numStates;
            double[] xInitial = Estimation.this.odCfg.getInitialState();
            double bound0 = Estimation.this.stepHandlerStart.durationFrom(Estimation.this.epoch);
            double bound1 = Estimation.this.stepHandlerEnd.durationFrom(Estimation.this.epoch);
            AbsoluteDate tm = Estimation.this.epoch;
            SpacecraftState[] ssta = new SpacecraftState[1];
            ManualPropagation propagator = new ManualPropagation(Estimation.this.odCfg);
            RealMatrix P = new DiagonalMatrix(((Estimation)Estimation.this).odCfg.estmCovariance);
            Array2DRowRealMatrix sigma = new Array2DRowRealMatrix(numStates, numSigmas);
            Array2DRowRealMatrix propSigma = new Array2DRowRealMatrix(numStates, numSigmas);
            Array2DRowRealMatrix estimMeas = new Array2DRowRealMatrix(Rsize, numSigmas);
            RealMatrix psdCorr = MatrixUtils.createRealIdentityMatrix(P.getRowDimension()).scalarMultiply(1.0E-6);
            RealMatrix Pprop = null;
            ArrayRealVector xhat = new ArrayRealVector(xInitial);
            RealVector xhatPrev = new ArrayRealVector(xInitial);
            double[] noiseMult = new double[Rsize];
            Arrays.fill(noiseMult, 1.0);
            block6: for (int measIndex = 0; measIndex <= ((Estimation)Estimation.this).odObs.rawMeas.length; ++measIndex) {
                String name;
                Integer pos;
                double step;
                AbsoluteDate t0 = tm;
                if (measIndex < ((Estimation)Estimation.this).odObs.rawMeas.length) {
                    tm = DataManager.parseDateTime(((Estimation)Estimation.this).odObs.rawMeas[measIndex].time);
                } else {
                    tm = Estimation.this.propEnd;
                    enableDMC = false;
                    if (FastMath.abs(tm.durationFrom(t0)) <= 1.0E-6) break;
                }
                double stepStart = t0.durationFrom(Estimation.this.epoch);
                double stepSum = 0.0;
                double stepFinal = tm.durationFrom(Estimation.this.epoch);
                RealMatrix Ptemp = P.scalarMultiply(numStates);
                RealMatrix sqrtP = new CholeskyDecomposition(Ptemp.add(Ptemp.transpose()).scalarMultiply(0.5).add(psdCorr), 1.0E-6, 1.0E-16).getL();
                do {
                    int i;
                    for (int i2 = 0; i2 < numStates; ++i2) {
                        sigma.setColumnVector(i2, xhat.add(sqrtP.getColumnVector(i2)));
                        sigma.setColumnVector(numStates + i2, xhat.subtract(sqrtP.getColumnVector(i2)));
                    }
                    double[][] sigData = sigma.getData();
                    for (int j2 = 6; j2 < ((Estimation)Estimation.this).odCfg.parameters.size() + 6; ++j2) {
                        Settings.Parameter tempep = ((Estimation)Estimation.this).odCfg.parameters.get(j2 - 6);
                        for (i = 0; i < numSigmas; ++i) {
                            sigData[j2][i] = FastMath.min(FastMath.max(sigData[j2][i], tempep.min), tempep.max);
                        }
                    }
                    sigma.setSubMatrix(sigData, 0, 0);
                    step = stepFinal - stepStart;
                    if (((Estimation)Estimation.this).odCfg.propStep != 0.0 && (stepStart >= bound0 || stepFinal >= bound0) && (stepStart <= bound1 || stepFinal <= bound1)) {
                        step = ((Estimation)Estimation.this).odCfg.propStep > 0.0 ? FastMath.min(step, ((Estimation)Estimation.this).odCfg.propStep) : FastMath.max(step, ((Estimation)Estimation.this).odCfg.propStep);
                    }
                    stepSum += step;
                    if (FastMath.abs(step) > 1.0E-6) {
                        propagator.propagate(stepStart, sigma, stepStart + step, propSigma, enableDMC);
                    } else {
                        propSigma.setSubMatrix(sigma.getData(), 0, 0);
                    }
                    xhatPrev = this.addColumns(propSigma).mapMultiplyToSelf(weight);
                    xhat = new ArrayRealVector(xhatPrev);
                    Pprop = Estimation.this.odCfg.getProcessNoiseMatrix(stepSum);
                    for (i = 0; i < numSigmas; ++i) {
                        RealVector y = propSigma.getColumnVector(i).subtract(xhatPrev);
                        Pprop = Pprop.add(y.outerProduct(y).scalarMultiply(weight));
                    }
                    if (measIndex == ((Estimation)Estimation.this).odObs.rawMeas.length || ((Estimation)Estimation.this).odCfg.propStep != 0.0 && stepStart + step >= bound0 && stepStart + step <= bound1) {
                        EstimationOutput odout = new EstimationOutput();
                        odout.time = DataManager.getUTCString(new AbsoluteDate(Estimation.this.epoch, stepStart + step));
                        odout.estimatedState = xhatPrev.toArray();
                        odout.propagatedCovariance = Pprop.getData();
                        Estimation.this.estOutput.add(odout);
                    }
                    stepStart += step;
                } while (!(FastMath.abs(step) < 1.0E-6) && !(FastMath.abs(stepFinal - stepStart) < 1.0E-6));
                if (measIndex == ((Estimation)Estimation.this).odObs.rawMeas.length) break;
                enableDMC = true;
                RealVector rawMeas = null;
                for (int i = 0; i < numSigmas; ++i) {
                    double[] fitv;
                    double[] pv = propSigma.getColumn(i);
                    ssta[0] = new SpacecraftState((Orbit)new CartesianOrbit(new PVCoordinates(new Vector3D(pv[0], pv[1], pv[2]), new Vector3D(pv[3], pv[4], pv[5])), ((Estimation)Estimation.this).odCfg.propFrame, tm, 3.986004415E14), propagator.getAttitude(tm, pv), ((Estimation)Estimation.this).odCfg.rsoMass);
                    if (Estimation.this.combinedMeas || Estimation.this.measNames.length == 1) {
                        fitv = ((Estimation)Estimation.this).odObs.measObjs.get(measIndex).estimate(0, 0, ssta).getEstimatedValue();
                        estimMeas.setColumn(i, fitv);
                        if (rawMeas != null) continue;
                        rawMeas = new ArrayRealVector(((Estimation)Estimation.this).odObs.measObjs.get(measIndex).getObservedValue());
                        continue;
                    }
                    fitv = ((Estimation)Estimation.this).odObs.measObjs.get(measIndex * 2).estimate(0, 0, ssta).getEstimatedValue();
                    estimMeas.setEntry(0, i, fitv[0]);
                    fitv = ((Estimation)Estimation.this).odObs.measObjs.get(measIndex * 2 + 1).estimate(0, 0, ssta).getEstimatedValue();
                    estimMeas.setEntry(1, i, fitv[0]);
                    if (rawMeas != null) continue;
                    rawMeas = new ArrayRealVector(new double[]{((Estimation)Estimation.this).odObs.measObjs.get(measIndex * 2).getObservedValue()[0], ((Estimation)Estimation.this).odObs.measObjs.get(measIndex * 2 + 1).getObservedValue()[0]});
                }
                if (((Estimation)Estimation.this).odObs.rawMeas[measIndex].station != null && (pos = (Integer)biasPos.get(name = ((Estimation)Estimation.this).odObs.rawMeas[measIndex].station + Estimation.this.measNames[0])) != null) {
                    if (Estimation.this.measNames.length == 2) {
                        name = ((Estimation)Estimation.this).odObs.rawMeas[measIndex].station + Estimation.this.measNames[1];
                        rawMeas = rawMeas.subtract(new ArrayRealVector(new double[]{xhatPrev.getEntry(pos), xhatPrev.getEntry((Integer)biasPos.get(name))}));
                    } else {
                        rawMeas = rawMeas.subtract(new ArrayRealVector(new double[]{xhatPrev.getEntry(pos)}));
                    }
                }
                for (int attempt = 0; attempt < 2; ++attempt) {
                    RealMatrix Pyy = R.copy();
                    for (int i = 0; attempt == 1 && i < Rsize; ++i) {
                        Pyy.setEntry(i, i, Pyy.getEntry(i, i) * noiseMult[i]);
                    }
                    RealMatrix Pxy = new Array2DRowRealMatrix(numStates, Rsize);
                    RealVector yhatpre = this.addColumns(estimMeas).mapMultiplyToSelf(weight);
                    for (int i = 0; i < numSigmas; ++i) {
                        RealVector y = estimMeas.getColumnVector(i).subtract(yhatpre);
                        Pyy = Pyy.add(y.outerProduct(y).scalarMultiply(weight));
                        Pxy = Pxy.add(propSigma.getColumnVector(i).subtract(xhatPrev).outerProduct(y).scalarMultiply(weight));
                    }
                    RealMatrix K = Pxy.multiply(MatrixUtils.inverse(Pyy));
                    xhat = new ArrayRealVector(xhatPrev.add(((Estimation)Estimation.this).odCfg.parameterMatrix.multiply(K).operate(rawMeas.subtract(yhatpre))));
                    P = Pprop.subtract(((Estimation)Estimation.this).odCfg.parameterMatrix.multiply(K.multiply(Pyy.multiply(K.transpose()))));
                    double[] pv = xhat.toArray();
                    ssta[0] = new SpacecraftState((Orbit)new CartesianOrbit(new PVCoordinates(new Vector3D(pv[0], pv[1], pv[2]), new Vector3D(pv[3], pv[4], pv[5])), ((Estimation)Estimation.this).odCfg.propFrame, tm, 3.986004415E14), propagator.getAttitude(tm, pv), ((Estimation)Estimation.this).odCfg.rsoMass);
                    EstimationOutput odout = new EstimationOutput();
                    odout.preFit = new HashMap();
                    odout.postFit = new HashMap();
                    if (Estimation.this.combinedMeas || Estimation.this.measNames.length == 1) {
                        for (int i = 0; i < Estimation.this.measNames.length; ++i) {
                            double[] fitv = ((Estimation)Estimation.this).odObs.measObjs.get(measIndex).estimate(0, 0, ssta).getEstimatedValue();
                            if (Estimation.this.measNames.length == 1) {
                                odout.preFit.put(Estimation.this.measNames[i], yhatpre.toArray());
                                odout.postFit.put(Estimation.this.measNames[i], fitv);
                                continue;
                            }
                            odout.preFit.put(Estimation.this.measNames[i], new double[]{yhatpre.getEntry(i)});
                            odout.postFit.put(Estimation.this.measNames[i], new double[]{fitv[i]});
                        }
                    } else {
                        double[] fitv = ((Estimation)Estimation.this).odObs.measObjs.get(measIndex * 2).estimate(0, 0, ssta).getEstimatedValue();
                        odout.preFit.put(Estimation.this.measNames[0], new double[]{yhatpre.getEntry(0)});
                        odout.postFit.put(Estimation.this.measNames[0], fitv);
                        fitv = ((Estimation)Estimation.this).odObs.measObjs.get(measIndex * 2 + 1).estimate(0, 0, ssta).getEstimatedValue();
                        odout.preFit.put(Estimation.this.measNames[1], new double[]{yhatpre.getEntry(1)});
                        odout.postFit.put(Estimation.this.measNames[1], fitv);
                    }
                    if (attempt == 0 && ((Estimation)Estimation.this).odCfg.estmOutlierWarmup > 0 && measIndex >= ((Estimation)Estimation.this).odCfg.estmOutlierWarmup && ((Estimation)Estimation.this).odCfg.estmOutlierSigma > 0.0) {
                        int pos2 = 0;
                        boolean isOutlier = false;
                        for (int i = 0; i < Estimation.this.measNames.length; ++i) {
                            double[] fit = odout.postFit.get(Estimation.this.measNames[i]);
                            for (int j3 = 0; j3 < fit.length; ++j3) {
                                if (FastMath.pow(rawMeas.getEntry(pos2) - fit[j3], 2) > ((Estimation)Estimation.this).odCfg.estmOutlierSigma * ((Estimation)Estimation.this).odCfg.estmOutlierSigma * Pyy.getEntry(pos2, pos2)) {
                                    isOutlier = true;
                                    noiseMult[pos2] = 1.0E16;
                                } else {
                                    noiseMult[pos2] = 1.0;
                                }
                                ++pos2;
                            }
                        }
                        if (isOutlier) continue;
                    }
                    odout.time = ((Estimation)Estimation.this).odObs.rawMeas[measIndex].time;
                    odout.station = ((Estimation)Estimation.this).odObs.rawMeas[measIndex].station;
                    odout.estimatedState = pv;
                    odout.propagatedCovariance = Pprop.getData();
                    odout.innovationCovariance = Pyy.getData();
                    odout.estimatedCovariance = P.getData();
                    Estimation.this.estOutput.add(odout);
                    continue block6;
                }
            }
        }

        private ArrayRealVector addColumns(RealMatrix mat) {
            double[][] arr = mat.getData();
            int m = mat.getRowDimension();
            int n = mat.getColumnDimension();
            ArrayRealVector out = new ArrayRealVector(m);
            for (int j = 0; j < m; ++j) {
                double sum = 0.0;
                for (int i = 0; i < n; ++i) {
                    sum += arr[j][i];
                }
                out.setEntry(j, sum);
            }
            return out;
        }
    }

    private class ExtendedKalmanFilter
    implements CovarianceMatrixProvider,
    KalmanObserver,
    OrekitFixedStepHandler {
        private PropagatorBuilder propBuilder;
        private AbsoluteDate prevDate;
        private Vector3D prevPosition;
        private Vector3D prevVelocity;
        private RealMatrix prevCovariance;
        private double measDeltaT;

        private ExtendedKalmanFilter() {
        }

        private void determineOrbit() {
            double[] Xi = Estimation.this.odCfg.getInitialState();
            this.prevDate = Estimation.this.epoch;
            this.prevPosition = new Vector3D(Xi[0], Xi[1], Xi[2]);
            this.prevVelocity = new Vector3D(Xi[3], Xi[4], Xi[5]);
            this.prevCovariance = new DiagonalMatrix(((Estimation)Estimation.this).odCfg.estmCovariance);
            CartesianOrbit X0 = new CartesianOrbit(new PVCoordinates(this.prevPosition, this.prevVelocity), ((Estimation)Estimation.this).odCfg.propFrame, Estimation.this.epoch, 3.986004415E14);
            ExtendedKalmanFilter handler = null;
            if (((Estimation)Estimation.this).odCfg.propStep != 0.0) {
                handler = this;
            }
            this.propBuilder = new PropagatorBuilder(Estimation.this.odCfg, X0, new DormandPrince853IntegratorBuilder(((Estimation)Estimation.this).odCfg.integMinTimeStep, ((Estimation)Estimation.this).odCfg.integMaxTimeStep, 1.0), PositionAngle.TRUE, 10.0, handler, false);
            this.propBuilder.setMass(((Estimation)Estimation.this).odCfg.rsoMass);
            for (ForceModel forceModel : ((Estimation)Estimation.this).odCfg.forces) {
                this.propBuilder.addForceModel(forceModel);
            }
            ParameterDriversList plst = this.propBuilder.getPropagationParametersDrivers();
            for (Settings.Parameter ep : ((Estimation)Estimation.this).odCfg.parameters) {
                ParameterDriver pdrv = new ParameterDriver(ep.name, ep.value, 1.0, ep.min, ep.max);
                pdrv.setSelected(true);
                plst.add(pdrv);
            }
            AttitudeProvider attitudeProvider = Estimation.this.odCfg.getAttitudeProvider();
            if (attitudeProvider != null) {
                this.propBuilder.setAttitudeProvider(attitudeProvider);
            }
            KalmanEstimatorBuilder builder = new KalmanEstimatorBuilder();
            builder.addPropagationConfiguration(this.propBuilder, this);
            KalmanEstimator filter = builder.build();
            filter.setObserver(this);
            AbstractIntegratedPropagator estimator = null;
            AbstractIntegratedPropagator[] estimators = filter.processMeasurements(((Estimation)Estimation.this).odObs.measObjs);
            this.propBuilder.enableDMC = false;
            estimator = estimators != null ? estimators[0] : this.propBuilder.buildPropagator(this.propBuilder.getSelectedNormalizedParameters());
            if (((Estimation)Estimation.this).odObs.rawMeas.length == 0 || !((Estimation)Estimation.this).odCfg.propEnd.equalsIgnoreCase(((Estimation)Estimation.this).odObs.rawMeas[((Estimation)Estimation.this).odObs.rawMeas.length - 1].time)) {
                SpacecraftState state = estimator.propagate(Estimation.this.propEnd);
                if (handler == null) {
                    this.handleStep(state, true);
                }
            }
        }

        @Override
        public RealMatrix getInitialCovarianceMatrix(SpacecraftState init) {
            return new DiagonalMatrix(((Estimation)Estimation.this).odCfg.estmCovariance);
        }

        @Override
        public RealMatrix getProcessNoiseMatrix(SpacecraftState prev, SpacecraftState curr) {
            double tmeas = curr.getDate().durationFrom(prev.getDate());
            if (tmeas != 0.0) {
                this.measDeltaT = tmeas;
            } else {
                tmeas = this.measDeltaT;
            }
            return Estimation.this.odCfg.getProcessNoiseMatrix(tmeas);
        }

        @Override
        public void evaluationPerformed(KalmanEstimation est) {
            RealMatrix phi;
            String key;
            this.propBuilder.enableDMC = true;
            int n = est.getCurrentMeasurementNumber() - 1;
            if (!Estimation.this.combinedMeas) {
                n /= Estimation.this.measNames.length;
            }
            Measurements.Measurement raw = ((Estimation)Estimation.this).odObs.rawMeas[n];
            EstimationOutput res = null;
            for (EstimationOutput loop : Estimation.this.estOutput) {
                if (loop.preFit == null || loop.postFit == null || !loop.time.equalsIgnoreCase(raw.time) || loop.station != null && !loop.station.equalsIgnoreCase(raw.station)) continue;
                res = loop;
                break;
            }
            if (res == null) {
                key = Estimation.this.measNames[0];
                res = new EstimationOutput();
                res.preFit = new HashMap();
                res.postFit = new HashMap();
                res.time = ((Estimation)Estimation.this).odObs.rawMeas[n].time;
                res.station = ((Estimation)Estimation.this).odObs.rawMeas[n].station;
                Estimation.this.estOutput.add(res);
            } else {
                key = Estimation.this.measNames[1];
            }
            SpacecraftState ssta = est.getPredictedSpacecraftStates()[0];
            TimeStampedPVCoordinates pvc = ssta.getPVCoordinates();
            res.estimatedState = new double[((Estimation)Estimation.this).odCfg.parameters.size() + 6];
            System.arraycopy(pvc.getPosition().toArray(), 0, res.estimatedState, 0, 3);
            System.arraycopy(pvc.getVelocity().toArray(), 0, res.estimatedState, 3, 3);
            ParameterDriversList plst = est.getEstimatedPropagationParameters();
            for (int i = 0; i < ((Estimation)Estimation.this).odCfg.parameters.size(); ++i) {
                Settings.Parameter ep = ((Estimation)Estimation.this).odCfg.parameters.get(i);
                res.estimatedState[i + 6] = est.getEstimatedPropagationParameters().findByName(ep.name).getValue();
            }
            double[] pre = est.getPredictedMeasurement().getEstimatedValue();
            double[] pos = est.getCorrectedMeasurement().getEstimatedValue();
            if (Estimation.this.combinedMeas) {
                for (int i = 0; i < Estimation.this.measNames.length; ++i) {
                    if (Estimation.this.measNames.length == 1) {
                        res.preFit.put(Estimation.this.measNames[i], pre);
                        res.postFit.put(Estimation.this.measNames[i], pos);
                        continue;
                    }
                    res.preFit.put(Estimation.this.measNames[i], new double[]{pre[i]});
                    res.postFit.put(Estimation.this.measNames[i], new double[]{pos[i]});
                }
                if (est.getPhysicalInnovationCovarianceMatrix() != null) {
                    res.innovationCovariance = est.getPhysicalInnovationCovarianceMatrix().getData();
                }
            } else {
                res.preFit.put(key, pre);
                res.postFit.put(key, pos);
                if (est.getPhysicalInnovationCovarianceMatrix() != null) {
                    if (res.innovationCovariance == null) {
                        res.innovationCovariance = new double[][]{{est.getPhysicalInnovationCovarianceMatrix().getData()[0][0], 0.0}, {0.0, 0.0}};
                    } else {
                        res.innovationCovariance[1][1] = est.getPhysicalInnovationCovarianceMatrix().getData()[0][0];
                    }
                }
            }
            if ((phi = est.getPhysicalStateTransitionMatrix()) != null && this.prevCovariance != null) {
                res.propagatedCovariance = phi.multiply(this.prevCovariance).multiply(phi.transpose()).add(Estimation.this.odCfg.getProcessNoiseMatrix(this.measDeltaT)).getData();
            }
            if (est.getPhysicalEstimatedCovarianceMatrix() != null) {
                res.estimatedCovariance = est.getPhysicalEstimatedCovarianceMatrix().getData();
            }
            this.prevCovariance = est.getPhysicalEstimatedCovarianceMatrix();
        }

        @Override
        public void handleStep(SpacecraftState state, boolean lastStep) {
            if (state.getDate().durationFrom(Estimation.this.stepHandlerStart) < 0.0 || state.getDate().durationFrom(Estimation.this.stepHandlerEnd) > 0.0) {
                return;
            }
            TimeStampedPVCoordinates pvc = state.getPVCoordinates(((Estimation)Estimation.this).odCfg.propFrame);
            for (ObservedMeasurement<?> m : ((Estimation)Estimation.this).odObs.measObjs) {
                if (m.getDate().durationFrom(state.getDate()) != 0.0) continue;
                return;
            }
            EstimationOutput odout = new EstimationOutput();
            odout.time = DataManager.getUTCString(state.getDate());
            odout.estimatedState = new double[((Estimation)Estimation.this).odCfg.parameters.size() + 6];
            System.arraycopy(pvc.getPosition().toArray(), 0, odout.estimatedState, 0, 3);
            System.arraycopy(pvc.getVelocity().toArray(), 0, odout.estimatedState, 3, 3);
            if (((Estimation)Estimation.this).odCfg.parameters.size() > 0 && Estimation.this.estOutput.size() > 0) {
                System.arraycopy(((EstimationOutput)((Estimation)Estimation.this).estOutput.get((int)(((Estimation)Estimation.this).estOutput.size() - 1))).estimatedState, 6, odout.estimatedState, 6, ((Estimation)Estimation.this).odCfg.parameters.size());
            }
            Rotation phi1 = new Rotation(this.prevPosition, pvc.getPosition());
            Rotation phi2 = new Rotation(this.prevVelocity, pvc.getVelocity());
            RealMatrix phi = MatrixUtils.createRealIdentityMatrix(this.prevCovariance.getRowDimension());
            phi.setSubMatrix(phi1.getMatrix(), 0, 0);
            phi.setSubMatrix(phi2.getMatrix(), 3, 3);
            this.prevPosition = pvc.getPosition();
            this.prevVelocity = pvc.getVelocity();
            odout.propagatedCovariance = phi.multiply(this.prevCovariance).multiply(phi.transpose()).add(Estimation.this.odCfg.getProcessNoiseMatrix(state.getDate().durationFrom(this.prevDate))).getData();
            Estimation.this.estOutput.add(odout);
            if (((Estimation)Estimation.this).odObs.rawMeas.length > 0) {
                this.prevDate = state.getDate();
            }
        }
    }

    public static class EstimationOutput {
        public String time;
        public String station;
        public double[] estimatedState;
        public double[][] propagatedCovariance;
        public double[][] innovationCovariance;
        public double[][] estimatedCovariance;
        public HashMap<String, double[]> preFit;
        public HashMap<String, double[]> postFit;
    }
}

