/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import org.astria.DataManager;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Transform;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public final class EventHandling<T extends EventDetector>
implements EventHandler<T> {
    private final String trigEvent;
    private final String mnvrType;
    private final double target;
    private int steps;

    public EventHandling(String trigEvent, String mnvrType, double target, int steps) {
        this.trigEvent = trigEvent;
        this.mnvrType = mnvrType;
        this.target = target;
        this.steps = steps;
    }

    @Override
    public Action eventOccurred(SpacecraftState state, T det, boolean incr) {
        if (this.trigEvent.equalsIgnoreCase("LongitudeCrossing") && this.mnvrType.equalsIgnoreCase("StopPropagation")) {
            return Action.STOP;
        }
        return Action.RESET_STATE;
    }

    @Override
    public SpacecraftState resetState(T det, SpacecraftState old) {
        KeplerianOrbit kep = new KeplerianOrbit(old.getOrbit());
        double a = kep.getA();
        double e = kep.getE();
        double i = kep.getI();
        double O = kep.getRightAscensionOfAscendingNode();
        double w = kep.getPerigeeArgument();
        double theta = kep.getTrueAnomaly();
        Orbit neworb = null;
        if (this.mnvrType.equalsIgnoreCase("NorthSouthStationing") || this.mnvrType.equalsIgnoreCase("EastWestStationing")) {
            TimeStampedPVCoordinates pvc = old.getOrbit().getPVCoordinates();
            OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF"));
            GeodeticPoint geo = earth.transform(pvc.getPosition(), old.getFrame(), old.getDate());
            geo = this.mnvrType.equalsIgnoreCase("NorthSouthStationing") ? new GeodeticPoint(geo.getLatitude() + (this.target - geo.getLatitude()) / (double)this.steps, geo.getLongitude(), geo.getAltitude()) : new GeodeticPoint(geo.getLatitude(), geo.getLongitude() + (this.target - geo.getLongitude()) / (double)this.steps, geo.getAltitude());
            Transform xfm = earth.getFrame().getTransformTo(old.getFrame(), old.getDate());
            Vector3D newpos = xfm.transformPosition(earth.transform(geo));
            Rotation rot = new Rotation(pvc.getPosition(), newpos);
            neworb = new CartesianOrbit(new PVCoordinates(newpos, rot.applyTo(pvc.getVelocity())), old.getFrame(), old.getDate(), old.getMu());
        } else {
            if (this.mnvrType.equalsIgnoreCase("SemiMajorAxisChange")) {
                a += (this.target - a) / (double)this.steps;
            }
            if (this.mnvrType.equalsIgnoreCase("PerigeeChange")) {
                a += (this.target - a / (1.0 - e)) / (double)this.steps;
            }
            if (this.mnvrType.equalsIgnoreCase("EccentricityChange")) {
                e += (this.target - e) / (double)this.steps;
            }
            if (this.mnvrType.equalsIgnoreCase("InclinationChange")) {
                i += (this.target - i) / (double)this.steps;
            }
            if (this.mnvrType.equalsIgnoreCase("RAANChange")) {
                O += (this.target - O) / (double)this.steps;
            }
            if (this.mnvrType.equalsIgnoreCase("ArgPerigeeChange")) {
                w += (this.target - w) / (double)this.steps;
            }
            neworb = new KeplerianOrbit(a, e, i, w, O, theta, PositionAngle.TRUE, old.getFrame(), old.getDate(), old.getMu());
        }
        --this.steps;
        if (neworb == null) {
            return old;
        }
        return new SpacecraftState(neworb, old.getAttitude(), old.getMass(), old.getAdditionalStates());
    }
}

