/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.HashMap;
import org.astria.DataManager;
import org.orekit.models.earth.atmosphere.NRLMSISE00InputParameters;
import org.orekit.time.AbsoluteDate;

public final class MSISEInputs
implements NRLMSISE00InputParameters {
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private final HashMap<String, double[]> swData;
    private final double[] apVals;

    public MSISEInputs(AbsoluteDate min, AbsoluteDate max, HashMap<String, double[]> sw, int apflag) {
        this.minDate = min;
        this.maxDate = max;
        this.swData = sw;
        this.apVals = apflag == 1 ? new double[1] : new double[7];
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public double getDailyFlux(AbsoluteDate date) {
        String p = DataManager.getUTCString(new AbsoluteDate(date, -86400.0));
        String k = p.substring(0, 4) + p.substring(5, 7) + p.substring(8, 10);
        double[] v = this.swData.get(k);
        return v[26];
    }

    @Override
    public double getAverageFlux(AbsoluteDate date) {
        String p = DataManager.getUTCString(date);
        String k = p.substring(0, 4) + p.substring(5, 7) + p.substring(8, 10);
        double[] v = this.swData.get(k);
        return v[28];
    }

    @Override
    public double[] getAp(AbsoluteDate date) {
        for (int i = 0; i < this.apVals.length; ++i) {
            double[] v;
            String k;
            if (i == 0) {
                String p = DataManager.getUTCString(date);
                k = p.substring(0, 4) + p.substring(5, 7) + p.substring(8, 10);
                v = this.swData.get(k);
                this.apVals[0] = v[22];
                continue;
            }
            if (i <= 4) {
                String p = DataManager.getUTCString(new AbsoluteDate(date, -10800.0 * (double)(i - 1)));
                k = p.substring(0, 4) + p.substring(5, 7) + p.substring(8, 10);
                v = this.swData.get(k);
                this.apVals[i] = v[Integer.parseInt(p.substring(11, 13)) / 3 + 14];
                continue;
            }
            this.apVals[i] = 0.0;
            for (int j = 8 * i - 36; j <= 8 * i - 29; ++j) {
                String p = DataManager.getUTCString(new AbsoluteDate(date, -10800.0 * (double)(j - 1)));
                String k2 = p.substring(0, 4) + p.substring(5, 7) + p.substring(8, 10);
                double[] v2 = this.swData.get(k2);
                int n = i;
                this.apVals[n] = this.apVals[n] + v2[Integer.parseInt(p.substring(11, 13)) / 3 + 14];
            }
            this.apVals[i] = this.apVals[i] / 8.0;
        }
        return this.apVals;
    }
}

