/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.ArrayList;
import org.astria.DataManager;
import org.astria.Settings;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.AngularRaDec;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.PV;
import org.orekit.estimation.measurements.Position;
import org.orekit.estimation.measurements.Range;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.modifiers.Bias;
import org.orekit.estimation.measurements.modifiers.OutlierFilter;
import org.orekit.time.AbsoluteDate;

public final class Measurements {
    public Measurement[] rawMeas;
    public ArrayList<ObservedMeasurement<?>> measObjs;

    public Measurements build(Settings odCfg) {
        this.buildMeasurementObjects(odCfg);
        return this;
    }

    private void buildMeasurementObjects(Settings odCfg) {
        ArrayList<Measurement> tempraw = new ArrayList<Measurement>(this.rawMeas.length);
        for (Measurement m : this.rawMeas) {
            if (m.station == null && m.position == null && m.positionVelocity == null) continue;
            tempraw.add(m);
        }
        this.rawMeas = tempraw.toArray(new Measurement[0]);
        this.measObjs = new ArrayList(this.rawMeas.length);
        Settings.Measurement cazim = odCfg.cfgMeasurements.get("Azimuth");
        Settings.Measurement celev = odCfg.cfgMeasurements.get("Elevation");
        Settings.Measurement crigh = odCfg.cfgMeasurements.get("RightAscension");
        Settings.Measurement cdecl = odCfg.cfgMeasurements.get("Declination");
        Settings.Measurement crang = odCfg.cfgMeasurements.get("Range");
        Settings.Measurement crrat = odCfg.cfgMeasurements.get("RangeRate");
        Settings.Measurement cpos = odCfg.cfgMeasurements.get("Position");
        Settings.Measurement cposvel = odCfg.cfgMeasurements.get("PositionVelocity");
        OutlierFilter outlier = new OutlierFilter(odCfg.estmOutlierWarmup, odCfg.estmOutlierSigma);
        boolean addBias = odCfg.estmFilter.equalsIgnoreCase("EKF");
        boolean addOutlier = addBias && odCfg.estmOutlierSigma > 0.0 && odCfg.estmOutlierWarmup > 0;
        ObservableSatellite satellite = new ObservableSatellite(0);
        double[] oneOnes = new double[]{1.0};
        double[] twoOnes = new double[]{1.0, 1.0};
        double[] oneNegInf = new double[]{Double.NEGATIVE_INFINITY};
        double[] onePosInf = new double[]{Double.POSITIVE_INFINITY};
        double[] twoNegInf = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] twoPosInf = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        String[] biasAzEl = new String[]{"Az", "El"};
        String[] biasRaDec = new String[]{"RA", "Dec"};
        String[] biasRange = new String[]{"Range"};
        String[] biasRangeRate = new String[]{"RangeRate"};
        for (Measurement m : this.rawMeas) {
            AbstractMeasurement obs;
            double[] X;
            AbstractMeasurement obs2;
            GroundStation gs = null;
            Settings.Station jsn = null;
            AbsoluteDate time = DataManager.parseDateTime(m.time);
            if (m.station != null) {
                gs = odCfg.stations.get(m.station);
                jsn = odCfg.cfgStations.get(m.station);
            }
            if (m.azimuth != 0.0 && cazim != null && celev != null) {
                obs2 = new AngularAzEl(gs, time, new double[]{m.azimuth, m.elevation}, new double[]{cazim.error[0], celev.error[0]}, twoOnes, satellite);
                if (addOutlier) {
                    obs2.addModifier(outlier);
                }
                if (addBias && (jsn.azimuthBias != 0.0 || jsn.elevationBias != 0.0)) {
                    obs2.addModifier(new Bias(biasAzEl, new double[]{jsn.azimuthBias, jsn.elevationBias}, twoOnes, twoNegInf, twoPosInf));
                }
                this.measObjs.add(obs2);
            }
            if (m.rightAscension != 0.0 && crigh != null && cdecl != null) {
                obs2 = new AngularRaDec(gs, DataManager.getFrame("EME2000"), time, new double[]{m.rightAscension, m.declination}, new double[]{crigh.error[0], cdecl.error[0]}, twoOnes, satellite);
                if (addOutlier) {
                    obs2.addModifier(outlier);
                }
                if (addBias && (jsn.rightAscensionBias != 0.0 || jsn.declinationBias != 0.0)) {
                    obs2.addModifier(new Bias(biasRaDec, new double[]{jsn.rightAscensionBias, jsn.declinationBias}, twoOnes, twoNegInf, twoPosInf));
                }
                this.measObjs.add(obs2);
            }
            if (m.range != 0.0 && crang != null) {
                obs2 = new Range(gs, crang.twoWay, time, m.range, crang.error[0], 1.0, satellite);
                if (addOutlier) {
                    obs2.addModifier(outlier);
                }
                if (addBias && jsn.rangeBias != 0.0) {
                    obs2.addModifier(new Bias(biasRange, new double[]{jsn.rangeBias}, oneOnes, oneNegInf, onePosInf));
                }
                this.measObjs.add(obs2);
            }
            if (m.rangeRate != 0.0 && crrat != null) {
                obs2 = new RangeRate(gs, time, m.rangeRate, crrat.error[0], 1.0, crrat.twoWay, satellite);
                if (addOutlier) {
                    obs2.addModifier(outlier);
                }
                if (addBias && jsn.rangeRateBias != 0.0) {
                    obs2.addModifier(new Bias(biasRangeRate, new double[]{jsn.rangeRateBias}, oneOnes, oneNegInf, onePosInf));
                }
                this.measObjs.add(obs2);
            }
            if (m.position != null && cpos != null) {
                X = m.position;
                obs = new Position(time, new Vector3D(X[0], X[1], X[2]), cpos.error, 1.0, satellite);
                if (addOutlier) {
                    obs.addModifier(outlier);
                }
                if (addBias && jsn != null && jsn.positionBias != null) {
                    obs.addModifier(new Bias(new String[]{"x", "y", "z"}, jsn.positionBias, new double[]{1.0, 1.0, 1.0}, new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}, new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}));
                }
                this.measObjs.add(obs);
            }
            if (m.positionVelocity == null || cposvel == null) continue;
            X = m.positionVelocity;
            obs = new PV(time, new Vector3D(X[0], X[1], X[2]), new Vector3D(X[3], X[4], X[5]), cposvel.error, 1.0, satellite);
            if (addOutlier) {
                obs.addModifier(outlier);
            }
            if (addBias && jsn != null && jsn.positionVelocityBias != null) {
                obs.addModifier(new Bias(new String[]{"x", "y", "z", "Vx", "Vy", "Vz"}, jsn.positionVelocityBias, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}, new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}));
            }
            this.measObjs.add(obs);
        }
    }

    public static class SimulatedMeasurement
    extends Measurement {
        public State trueState;
        public double atmDensity;
        public double[] accGravity;
        public double[] accDrag;
        public double[] accOceanTides;
        public double[] accSolidTides;
        public double[] accThirdBodies;
        public double[] accRadiationPressure;
        public double[] accThrust;
        public double[] stationState;

        public SimulatedMeasurement() {
        }

        public SimulatedMeasurement(SimulatedMeasurement src) {
            super(src);
            this.trueState = src.trueState;
            this.atmDensity = src.atmDensity;
            this.accGravity = src.accGravity;
            this.accDrag = src.accDrag;
            this.accOceanTides = src.accOceanTides;
            this.accSolidTides = src.accSolidTides;
            this.accThirdBodies = src.accThirdBodies;
            this.accRadiationPressure = src.accRadiationPressure;
            this.accThrust = src.accThrust;
            this.stationState = src.stationState;
        }
    }

    public static class Measurement {
        public String time;
        public String station;
        public double azimuth;
        public double elevation;
        public double range;
        public double rangeRate;
        public double rightAscension;
        public double declination;
        public double[] position;
        public double[] positionVelocity;

        public Measurement() {
        }

        public Measurement(Measurement src) {
            this.time = src.time;
            this.station = src.station;
            this.azimuth = src.azimuth;
            this.elevation = src.elevation;
            this.range = src.range;
            this.rangeRate = src.rangeRate;
            this.rightAscension = src.rightAscension;
            this.declination = src.declination;
            this.position = src.position;
            this.positionVelocity = src.positionVelocity;
        }
    }

    public static class State {
        public double[] cartesian;
        public KeplerianElements keplerian;
        public EquinoctialElements equinoctial;
    }

    public static class EquinoctialElements {
        public double sma;
        public double ex;
        public double ey;
        public double hx;
        public double hy;
        public double lm;

        public EquinoctialElements() {
        }

        public EquinoctialElements(double a, double ex, double ey, double hx, double hy, double lm) {
            this.sma = a;
            this.ex = ex;
            this.ey = ey;
            this.hx = hx;
            this.hy = hy;
            this.lm = lm;
        }
    }

    public static class KeplerianElements {
        public double sma;
        public double ecc;
        public double inc;
        public double raan;
        public double argP;
        public double meanAnom;

        public KeplerianElements() {
        }

        public KeplerianElements(double a, double e, double i, double W, double o, double M) {
            this.sma = a;
            this.ecc = e;
            this.inc = i;
            this.raan = W;
            this.argP = o;
            this.meanAnom = M;
        }
    }
}

