/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.Arrays;
import org.astria.Estimation;
import org.astria.Settings;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.NumericalPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriversList;

public final class PropagatorBuilder
extends NumericalPropagatorBuilder {
    private final Settings odCfg;
    private final DMCEquations dmcEqns;
    private final OrekitFixedStepHandler stepHandler;
    protected boolean enableDMC;

    public PropagatorBuilder(Settings cfg, Orbit orb, ODEIntegratorBuilder ode, PositionAngle ang, double pos, OrekitFixedStepHandler handler, boolean enableDMC) {
        super(orb, ode, ang, pos);
        this.odCfg = cfg;
        this.dmcEqns = new DMCEquations();
        this.stepHandler = handler;
        this.enableDMC = enableDMC;
    }

    @Override
    public NumericalPropagator buildPropagator(double[] par) {
        NumericalPropagator prop = super.buildPropagator(par);
        if (this.stepHandler != null) {
            prop.setMasterMode(this.odCfg.propStep, this.stepHandler);
        }
        if (this.odCfg.estmDMCCorrTime > 0.0 && this.odCfg.estmDMCSigmaPert > 0.0) {
            prop.addAdditionalEquations(this.dmcEqns);
            ParameterDriversList plst = this.getPropagationParametersDrivers();
            prop.setInitialState(prop.getInitialState().addAdditionalState("DMCEstProp", plst.findByName(Estimation.DMC_ACC_ESTM[0]).getValue(), plst.findByName(Estimation.DMC_ACC_ESTM[1]).getValue(), plst.findByName(Estimation.DMC_ACC_ESTM[2]).getValue()));
        }
        this.odCfg.addEventHandlers(prop, prop.getInitialState());
        return prop;
    }

    class DMCEquations
    implements AdditionalEquations {
        private double[] accEci = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

        @Override
        public void init(SpacecraftState sta, AbsoluteDate tgt) {
        }

        @Override
        public String getName() {
            return "DMCEstProp";
        }

        @Override
        public double[] computeDerivatives(SpacecraftState sta, double[] pdot) {
            if (!PropagatorBuilder.this.enableDMC) {
                Arrays.fill(pdot, 0.0);
                Arrays.fill(this.accEci, 0.0);
                return this.accEci;
            }
            double[] acc = sta.getAdditionalState("DMCEstProp");
            for (int i = 0; i < 3; ++i) {
                this.accEci[i + 3] = acc[i];
                pdot[i] = -acc[i] / ((PropagatorBuilder)PropagatorBuilder.this).odCfg.estmDMCCorrTime;
            }
            return this.accEci;
        }
    }
}

