/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.astria.DataManager;
import org.astria.Estimation;
import org.astria.EventHandling;
import org.astria.MSISEInputs;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.BodyCenterPointing;
import org.orekit.attitudes.FixedRate;
import org.orekit.attitudes.NadirPointing;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.forces.BoxAndSolarArraySpacecraft;
import org.orekit.forces.ForceModel;
import org.orekit.forces.drag.DragForce;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.drag.IsotropicDrag;
import org.orekit.forces.gravity.HolmesFeatherstoneAttractionModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.forces.gravity.OceanTides;
import org.orekit.forces.gravity.SolidTides;
import org.orekit.forces.gravity.ThirdBodyAttraction;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.maneuvers.ConstantThrustManeuver;
import org.orekit.forces.radiation.IsotropicRadiationSingleCoefficient;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.forces.radiation.SolarRadiationPressure;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.LocalOrbitalFrame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.models.earth.atmosphere.NRLMSISE00;
import org.orekit.models.earth.atmosphere.SimpleExponentialAtmosphere;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.LongitudeCrossingDetector;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;

public final class Settings {
    public double rsoMass = 5.0;
    public double rsoArea = 0.01;
    public Facet[] rsoFacets;
    public double[] rsoSolarArrayAxis;
    public double rsoSolarArrayArea;
    public String rsoAttitudeProvider;
    public double[] rsoSpinVelocity;
    public double[] rsoSpinAcceleration;
    public int gravityDegree = 20;
    public int gravityOrder = 20;
    public int oceanTidesDegree = 20;
    public int oceanTidesOrder = 20;
    public boolean thirdBodySun = true;
    public boolean thirdBodyMoon = true;
    public boolean solidTidesSun = true;
    public boolean solidTidesMoon = true;
    public String dragModel = "MSISE";
    public Parameter dragCoefficient = new Parameter("Cd", 1.0, 3.0, 2.0, "Estimate");
    public int[][] dragMSISEFlags;
    public double dragExpRho0;
    public double dragExpH0;
    public double dragExpHscale;
    public boolean rpSun = true;
    public Parameter rpCoeffReflection = new Parameter("Cr", 1.0, 2.0, 1.5, "Estimate");
    public double rpCoeffAbsorption;
    public Maneuver[] cfgManeuvers;
    public String propStart;
    public String propEnd;
    public double propStep;
    public double[] propInitialState;
    public String[] propInitialTLE;
    public String propInertialFrame = "EME2000";
    public String propStepHandlerStartTime;
    public String propStepHandlerEndTime;
    public double integMinTimeStep = 0.001;
    public double integMaxTimeStep = 300.0;
    public double integAbsTolerance = 1.0E-14;
    public double integRelTolerance = 1.0E-12;
    public boolean simMeasurements = true;
    public boolean simSkipUnobservable = true;
    public boolean simIncludeExtras = false;
    public boolean simIncludeStationState = false;
    public Map<String, Station> cfgStations;
    public Map<String, Measurement> cfgMeasurements;
    public String estmFilter = "UKF";
    public double[] estmCovariance = new double[]{2.5E7, 2.5E7, 2.5E7, 0.01, 0.01, 0.01, 1.0, 0.25, 1.0E-6, 1.0E-6, 1.0E-6};
    public double[] estmProcessNoise;
    public double estmDMCCorrTime = 40.0;
    public double estmDMCSigmaPert = 5.0E-9;
    public Parameter estmDMCAcceleration = new Parameter("DMC", -0.001, 0.001, 0.0, "Estimate");
    public double estmOutlierSigma = 0.0;
    public int estmOutlierWarmup = 0;
    protected Atmosphere atmModel;
    protected HashMap<String, GroundStation> stations;
    protected ArrayList<ForceModel> forces;
    protected ArrayList<Parameter> parameters;
    protected RealMatrix parameterMatrix;
    protected Frame propFrame;

    public Settings build() {
        this.propFrame = DataManager.getFrame(this.propInertialFrame);
        this.loadGroundStations();
        this.loadForces();
        this.loadParameters();
        return this;
    }

    private void loadGroundStations() {
        this.stations = new HashMap();
        if (this.cfgStations == null) {
            return;
        }
        for (Map.Entry<String, Station> kv : this.cfgStations.entrySet()) {
            String k = kv.getKey();
            Station v = kv.getValue();
            GroundStation sta = new GroundStation(new TopocentricFrame(new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF")), new GeodeticPoint(v.latitude, v.longitude, v.altitude), k));
            sta.getPrimeMeridianOffsetDriver().setReferenceDate(AbsoluteDate.J2000_EPOCH);
            sta.getPolarOffsetXDriver().setReferenceDate(AbsoluteDate.J2000_EPOCH);
            sta.getPolarOffsetYDriver().setReferenceDate(AbsoluteDate.J2000_EPOCH);
            this.stations.put(k, sta);
        }
    }

    private void loadForces() {
        int i;
        this.forces = new ArrayList();
        NormalizedSphericalHarmonicsProvider grav = null;
        if (this.gravityDegree >= 2 && this.gravityOrder >= 0) {
            grav = GravityFieldFactory.getNormalizedProvider(this.gravityDegree, this.gravityOrder);
            this.forces.add(new HolmesFeatherstoneAttractionModel(DataManager.getFrame("ITRF"), grav));
        } else {
            this.forces.add(new NewtonianAttraction(3.986004415E14));
        }
        if (this.oceanTidesDegree >= 0 && this.oceanTidesOrder >= 0) {
            this.forces.add(new OceanTides(DataManager.getFrame("ITRF"), 6378137.0, 3.986004415E14, this.oceanTidesDegree, this.oceanTidesOrder, IERSConventions.IERS_2010, (UT1Scale)DataManager.getTimeScale("UT1")));
        }
        if ((this.solidTidesSun || this.solidTidesMoon) && grav != null) {
            this.forces.add(new SolidTides(DataManager.getFrame("ITRF"), 6378137.0, 3.986004415E14, grav.getTideSystem(), IERSConventions.IERS_2010, (UT1Scale)DataManager.getTimeScale("UT1"), CelestialBodyFactory.getSun(), CelestialBodyFactory.getMoon()));
        }
        if (this.thirdBodySun) {
            this.forces.add(new ThirdBodyAttraction(CelestialBodyFactory.getSun()));
        }
        if (this.thirdBodyMoon) {
            this.forces.add(new ThirdBodyAttraction(CelestialBodyFactory.getMoon()));
        }
        DragSensitive dragsc = null;
        RadiationSensitive radnsc = null;
        if (this.rsoFacets != null && this.rsoSolarArrayAxis != null && this.rsoSolarArrayArea > 0.0) {
            BoxAndSolarArraySpacecraft.Facet[] facets = new BoxAndSolarArraySpacecraft.Facet[this.rsoFacets.length];
            for (i = 0; i < this.rsoFacets.length; ++i) {
                facets[i] = new BoxAndSolarArraySpacecraft.Facet(new Vector3D(this.rsoFacets[i].normal), this.rsoFacets[i].area);
            }
            dragsc = new BoxAndSolarArraySpacecraft(facets, CelestialBodyFactory.getSun(), this.rsoSolarArrayArea, new Vector3D(this.rsoSolarArrayAxis), this.dragCoefficient.value, this.rpCoeffAbsorption, this.rpCoeffReflection.value);
            radnsc = new BoxAndSolarArraySpacecraft(facets, CelestialBodyFactory.getSun(), this.rsoSolarArrayArea, new Vector3D(this.rsoSolarArrayAxis), this.dragCoefficient.value, this.rpCoeffAbsorption, this.rpCoeffReflection.value);
        } else {
            dragsc = new IsotropicDrag(this.rsoArea, this.dragCoefficient.value);
            radnsc = new IsotropicRadiationSingleCoefficient(this.rsoArea, this.rpCoeffReflection.value, this.rpCoeffReflection.min, this.rpCoeffReflection.max);
        }
        if (this.dragModel.equalsIgnoreCase("Exponential")) {
            this.atmModel = new SimpleExponentialAtmosphere(new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF")), this.dragExpRho0, this.dragExpH0, this.dragExpHscale);
        } else if (this.dragModel.equalsIgnoreCase("MSISE")) {
            int apflag = 1;
            if (this.dragMSISEFlags != null) {
                for (i = 0; i < this.dragMSISEFlags.length; ++i) {
                    if (this.dragMSISEFlags[i][0] != 9) continue;
                    apflag = this.dragMSISEFlags[i][1];
                }
            }
            this.atmModel = new NRLMSISE00(new MSISEInputs(DataManager.msiseData.minDate, DataManager.msiseData.maxDate, DataManager.msiseData.data, apflag), CelestialBodyFactory.getSun(), new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF")));
            if (this.dragMSISEFlags != null) {
                for (i = 0; i < this.dragMSISEFlags.length; ++i) {
                    this.atmModel = ((NRLMSISE00)this.atmModel).withSwitch(this.dragMSISEFlags[i][0], this.dragMSISEFlags[i][1]);
                }
            }
        }
        if (this.atmModel != null) {
            this.forces.add(new DragForce(this.atmModel, dragsc));
        }
        if (this.rpSun) {
            this.forces.add(new SolarRadiationPressure(CelestialBodyFactory.getSun(), 6378137.0, radnsc));
        }
        if (this.cfgManeuvers == null) {
            return;
        }
        for (Maneuver m : this.cfgManeuvers) {
            if (!m.triggerEvent.equalsIgnoreCase("DateTime") || !m.maneuverType.equalsIgnoreCase("ConstantThrust")) continue;
            this.forces.add(new ConstantThrustManeuver(DataManager.parseDateTime(m.time), m.maneuverParams[3], m.maneuverParams[4], m.maneuverParams[5], new Vector3D(m.maneuverParams[0], m.maneuverParams[1], m.maneuverParams[2])));
        }
    }

    private void loadParameters() {
        int[] counts = new int[]{0, 0};
        String[] ops = new String[]{"Estimate", "Consider"};
        this.parameters = new ArrayList();
        for (int i = 0; i < ops.length; ++i) {
            if (this.dragCoefficient.estimation != null && this.dragCoefficient.estimation.equalsIgnoreCase(ops[i])) {
                int n = i;
                counts[n] = counts[n] + 1;
                this.parameters.add(new Parameter("drag coefficient", this.dragCoefficient.min, this.dragCoefficient.max, this.dragCoefficient.value, ops[i]));
            }
            if (this.rpCoeffReflection.estimation != null && this.rpCoeffReflection.estimation.equalsIgnoreCase(ops[i])) {
                int n = i;
                counts[n] = counts[n] + 1;
                this.parameters.add(new Parameter("reflection coefficient", this.rpCoeffReflection.min, this.rpCoeffReflection.max, this.rpCoeffReflection.value, ops[i]));
            }
            for (int j = 0; j < 3 && i == 0 && this.estmDMCCorrTime > 0.0 && this.estmDMCSigmaPert > 0.0; ++j) {
                counts[0] = counts[0] + 1;
                this.parameters.add(new Parameter(Estimation.DMC_ACC_ESTM[j], this.estmDMCAcceleration.min, this.estmDMCAcceleration.max, this.estmDMCAcceleration.value, ops[0]));
            }
            if (this.cfgStations == null || this.cfgMeasurements == null || !this.estmFilter.equalsIgnoreCase("UKF")) continue;
            for (Map.Entry<String, Station> skv : this.cfgStations.entrySet()) {
                Station sv = skv.getValue();
                if (sv.biasEstimation == null || !sv.biasEstimation.equalsIgnoreCase(ops[i])) continue;
                String sk = skv.getKey();
                for (String mk : this.cfgMeasurements.keySet()) {
                    double bias = 0.0;
                    if (mk.equalsIgnoreCase("Azimuth")) {
                        bias = sv.azimuthBias;
                    } else if (mk.equalsIgnoreCase("Elevation")) {
                        bias = sv.elevationBias;
                    } else if (mk.equalsIgnoreCase("Range")) {
                        bias = sv.rangeBias;
                    } else if (mk.equalsIgnoreCase("RangeRate")) {
                        bias = sv.rangeRateBias;
                    } else if (mk.equalsIgnoreCase("RightAscension")) {
                        bias = sv.rightAscensionBias;
                    } else {
                        if (!mk.equalsIgnoreCase("Declination")) continue;
                        bias = sv.declinationBias;
                    }
                    int n = i;
                    counts[n] = counts[n] + 1;
                    String name = sk + mk;
                    this.parameters.add(new Parameter(name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, bias, ops[i]));
                }
            }
        }
        this.parameterMatrix = MatrixUtils.createRealIdentityMatrix(counts[0] + counts[1] + 6);
        if (counts[1] > 0) {
            RealMatrix zeros = MatrixUtils.createRealMatrix(counts[1], counts[1]);
            this.parameterMatrix.setSubMatrix(zeros.getData(), counts[0] + 6, counts[0] + 6);
        }
    }

    public double[] getInitialState() {
        PVCoordinates topv;
        double[] state0 = this.propInitialState;
        if (state0 == null) {
            AbsoluteDate epoch;
            TLE parser = new TLE(this.propInitialTLE[0], this.propInitialTLE[1]);
            TLEPropagator prop = TLEPropagator.selectExtrapolator(parser);
            if (this.propStart != null) {
                epoch = DataManager.parseDateTime(this.propStart);
            } else {
                epoch = parser.getDate().shiftedBy(0.0);
                this.propStart = DataManager.getUTCString(epoch);
            }
            topv = prop.getPVCoordinates(epoch, this.propFrame);
        } else {
            topv = new PVCoordinates(new Vector3D(state0[0], state0[1], state0[2]), new Vector3D(state0[3], state0[4], state0[5]));
        }
        Vector3D p = topv.getPosition();
        Vector3D v = topv.getVelocity();
        state0 = new double[]{p.getX(), p.getY(), p.getZ(), v.getX(), v.getY(), v.getZ()};
        double[] X0 = new double[this.parameters.size() + 6];
        for (int i = 0; i < X0.length; ++i) {
            X0[i] = i < 6 ? state0[i] : this.parameters.get((int)(i - 6)).value;
        }
        return X0;
    }

    public AttitudeProvider getAttitudeProvider() {
        if (this.rsoAttitudeProvider == null) {
            return null;
        }
        AttitudeProvider attpro = null;
        OneAxisEllipsoid shape = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF"));
        if (this.rsoAttitudeProvider.equalsIgnoreCase("NadirPointing")) {
            attpro = new NadirPointing(this.propFrame, shape);
        }
        if (this.rsoAttitudeProvider.equalsIgnoreCase("BodyCenterPointing")) {
            attpro = new BodyCenterPointing(this.propFrame, shape);
        }
        if (this.rsoAttitudeProvider.equalsIgnoreCase("FixedRate") && this.rsoSpinVelocity != null && this.rsoSpinAcceleration != null) {
            double[] X0 = this.propInitialState;
            AbsoluteDate t0 = DataManager.parseDateTime(this.propStart);
            KeplerianPropagator prop = new KeplerianPropagator(new CartesianOrbit(new PVCoordinates(new Vector3D(X0[0], X0[1], X0[2]), new Vector3D(X0[3], X0[4], X0[5])), this.propFrame, t0, 3.986004415E14));
            LocalOrbitalFrame lof = new LocalOrbitalFrame(this.propFrame, LOFType.VVLH, prop, "");
            attpro = new FixedRate(new Attitude(t0, lof, Rotation.IDENTITY, new Vector3D(this.rsoSpinVelocity[0], this.rsoSpinVelocity[1], this.rsoSpinVelocity[2]), new Vector3D(this.rsoSpinAcceleration[0], this.rsoSpinAcceleration[1], this.rsoSpinAcceleration[2])));
        }
        return attpro;
    }

    public RealMatrix getProcessNoiseMatrix(double t) {
        int i;
        t = FastMath.abs(t);
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double[][] Q = new double[this.parameters.size() + 6][this.parameters.size() + 6];
        if (this.estmProcessNoise != null && this.estmProcessNoise.length == 6) {
            int i2;
            double[] P = this.estmProcessNoise;
            for (i2 = 0; i2 < 3; ++i2) {
                Q[i2][i2] = 0.25 * t4 * P[i2];
                Q[i2][i2 + 3] = 0.5 * t3 * P[i2];
            }
            for (i2 = 3; i2 < 6; ++i2) {
                Q[i2][i2] = t2 * P[i2];
                Q[i2][i2 - 3] = 0.5 * t3 * P[i2];
            }
            return new Array2DRowRealMatrix(Q);
        }
        int N = this.parameters.size() - 3;
        double b = 1.0 / this.estmDMCCorrTime;
        double b2 = b * b;
        double b3 = b2 * b;
        double b4 = b3 * b;
        double b5 = b4 * b;
        double et = FastMath.exp(-1.0 * b * t);
        double e2t = et * et;
        double s2 = this.estmDMCSigmaPert * this.estmDMCSigmaPert;
        double Q00 = s2 * (t3 / (3.0 * b2) - t2 / b3 + t * (1.0 - 2.0 * et) / b4 + 0.5 * (1.0 - e2t) / b5);
        double Q01 = s2 * (0.5 * t2 / b2 - t * (1.0 - et) / b3 + (1.0 - et) / b4 - 0.5 * (1.0 - e2t) / b4);
        double Q02 = s2 * (0.5 * (1.0 - e2t) / b3 - t * et / b2);
        double Q11 = s2 * (t / b2 - 2.0 * (1.0 - et) / b3 + 0.5 * (1.0 - e2t) / b3);
        double Q12 = s2 * (0.5 * (1.0 + e2t) / b2 - et / b2);
        double Q22 = 0.5 * s2 * (1.0 - e2t) / b;
        for (i = 0; i < 3; ++i) {
            Q[i][i] = Q00;
            Q[i][i + 3] = Q01;
            Q[i][i + N + 6] = Q02;
        }
        for (i = 3; i < 6; ++i) {
            Q[i][i] = Q11;
            Q[i][i - 3] = Q01;
            Q[i][i + N + 3] = Q12;
        }
        for (i = N + 6; i < N + 9; ++i) {
            Q[i][i] = Q22;
            Q[i][i - N - 6] = Q02;
            Q[i][i - N - 3] = Q12;
        }
        return new Array2DRowRealMatrix(Q);
    }

    public void addEventHandlers(NumericalPropagator prop, SpacecraftState state) {
        if (this.cfgManeuvers == null) {
            return;
        }
        for (Maneuver m : this.cfgManeuvers) {
            if (m.triggerEvent.equalsIgnoreCase("DateTime")) {
                if (m.maneuverType.equalsIgnoreCase("ConstantThrust")) continue;
                EventHandling handler = new EventHandling(m.triggerEvent, m.maneuverType, m.maneuverParams[0], (int)m.maneuverParams[2]);
                AbsoluteDate time = DataManager.parseDateTime(m.time);
                int i = 0;
                while ((double)i < m.maneuverParams[2]) {
                    prop.addEventDetector((EventDetector)new DateDetector(time).withHandler(handler));
                    time = new AbsoluteDate(time, m.maneuverParams[1]);
                    ++i;
                }
            }
            if (!m.triggerEvent.equalsIgnoreCase("LongitudeCrossing")) continue;
            OneAxisEllipsoid body = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF"));
            EventHandling handler = new EventHandling(m.triggerEvent, m.maneuverType, 0.0, 1);
            prop.addEventDetector((EventDetector)new LongitudeCrossingDetector(body, m.triggerParams[0]).withHandler(handler));
        }
    }

    public static class Measurement {
        public boolean twoWay;
        public double[] error;

        public Measurement() {
        }

        public Measurement(boolean twoWay, double[] error) {
            this.twoWay = twoWay;
            this.error = error;
        }
    }

    public static class Station {
        public double latitude;
        public double longitude;
        public double altitude;
        public double azimuthBias;
        public double elevationBias;
        public double rangeBias;
        public double rangeRateBias;
        public double rightAscensionBias;
        public double declinationBias;
        public double[] positionBias;
        public double[] positionVelocityBias;
        public String biasEstimation;

        public Station() {
        }

        public Station(double latitude, double longitude, double altitude, double azimuthBias, double elevationBias, double rangeBias, double rangeRateBias, double rightAscensionBias, double declinationBias, double[] positionBias, double[] positionVelocityBias, String biasEstimation) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.altitude = altitude;
            this.azimuthBias = azimuthBias;
            this.elevationBias = elevationBias;
            this.rangeBias = rangeBias;
            this.rangeRateBias = rangeRateBias;
            this.rightAscensionBias = rightAscensionBias;
            this.declinationBias = declinationBias;
            this.positionBias = positionBias;
            this.positionVelocityBias = positionVelocityBias;
            this.biasEstimation = biasEstimation;
        }
    }

    public static class Maneuver {
        public String time;
        public String triggerEvent;
        public double[] triggerParams;
        public String maneuverType;
        public double[] maneuverParams;

        public Maneuver() {
        }

        public Maneuver(String time, String triggerEvent, double[] triggerParams, String maneuverType, double[] maneuverParams) {
            this.time = time;
            this.triggerEvent = triggerEvent;
            this.triggerParams = triggerParams;
            this.maneuverType = maneuverType;
            this.maneuverParams = maneuverParams;
        }
    }

    public static class Facet {
        public double[] normal;
        public double area;

        public Facet() {
        }

        public Facet(double[] normal, double area) {
            this.normal = normal;
            this.area = area;
        }
    }

    public static class Parameter {
        public String name;
        public double value;
        public double min;
        public double max;
        public String estimation;

        public Parameter() {
        }

        public Parameter(String name, double min, double max, double value, String estimation) {
            this.name = name;
            this.min = min;
            this.max = max;
            this.value = value;
            this.estimation = estimation;
        }
    }
}

