/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.astria.DataManager;
import org.astria.Measurements;
import org.astria.Settings;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.AngularRaDec;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.Range;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public final class Simulation {
    private final Settings simCfg;

    public Simulation(Settings simCfg) {
        this.simCfg = simCfg;
    }

    public ArrayList<Measurements.SimulatedMeasurement> simulateMeasurements() {
        double dt;
        NumericalPropagator propagator = new NumericalPropagator(new DormandPrince853Integrator(this.simCfg.integMinTimeStep, this.simCfg.integMaxTimeStep, this.simCfg.integAbsTolerance, this.simCfg.integRelTolerance));
        for (ForceModel fm : this.simCfg.forces) {
            propagator.addForceModel(fm);
        }
        AttitudeProvider attpro = this.simCfg.getAttitudeProvider();
        if (attpro != null) {
            propagator.setAttitudeProvider(attpro);
        }
        double[] Xi = this.simCfg.getInitialState();
        AbsoluteDate tm = DataManager.parseDateTime(this.simCfg.propStart);
        AbsoluteDate prend = DataManager.parseDateTime(this.simCfg.propEnd);
        SpacecraftState sstate0 = new SpacecraftState((Orbit)new CartesianOrbit(new PVCoordinates(new Vector3D(Xi[0], Xi[1], Xi[2]), new Vector3D(Xi[3], Xi[4], Xi[5])), this.simCfg.propFrame, tm, 3.986004415E14), this.simCfg.rsoMass);
        propagator.setInitialState(sstate0);
        this.simCfg.addEventHandlers(propagator, sstate0);
        boolean evthandlers = propagator.getEventsDetectors().size() > 0;
        double[] zeros = new double[]{0.0, 0.0};
        double[] ones = new double[]{1.0, 1.0};
        Random rand = new Random(1L);
        ObservableSatellite obssat = new ObservableSatellite(0);
        ArrayList<Measurements.SimulatedMeasurement> mall = new ArrayList<Measurements.SimulatedMeasurement>((int)FastMath.abs(prend.durationFrom(tm) / this.simCfg.propStep) + 2);
        do {
            SpacecraftState[] sta = new SpacecraftState[]{propagator.propagate(tm)};
            Orbit orb = sta[0].getOrbit();
            KeplerianOrbit keporb = new KeplerianOrbit(orb);
            AbsoluteDate proptm = sta[0].getDate();
            TimeStampedPVCoordinates pvc = sta[0].getPVCoordinates();
            Vector3D pos = pvc.getPosition();
            Vector3D vel = pvc.getVelocity();
            Vector3D acc = pvc.getAcceleration();
            Measurements.SimulatedMeasurement json = new Measurements.SimulatedMeasurement();
            json.time = DataManager.getUTCString(proptm);
            json.trueState = new Measurements.State();
            json.trueState.cartesian = new double[]{pos.getX(), pos.getY(), pos.getZ(), vel.getX(), vel.getY(), vel.getZ(), acc.getX(), acc.getY(), acc.getZ()};
            json.trueState.keplerian = new Measurements.KeplerianElements(keporb.getA(), keporb.getE(), keporb.getI(), keporb.getRightAscensionOfAscendingNode(), keporb.getPerigeeArgument(), keporb.getMeanAnomaly());
            json.trueState.equinoctial = new Measurements.EquinoctialElements(orb.getA(), orb.getEquinoctialEx(), orb.getEquinoctialEy(), orb.getHx(), orb.getHy(), orb.getLM());
            if (this.simCfg.simIncludeExtras) {
                if (this.simCfg.atmModel != null) {
                    json.atmDensity = this.simCfg.atmModel.getDensity(proptm, pos, this.simCfg.propFrame);
                }
                for (ForceModel fmod : this.simCfg.forces) {
                    double[] facc = fmod.acceleration(sta[0], fmod.getParameters()).toArray();
                    String ftype = fmod.getClass().getSimpleName();
                    if (ftype.equals("HolmesFeatherstoneAttractionModel") || ftype.equals("NewtonianAttraction")) {
                        json.accGravity = facc;
                    }
                    if (ftype.equals("DragForce")) {
                        json.accDrag = facc;
                    }
                    if (ftype.equals("SolidTides")) {
                        json.accSolidTides = facc;
                    }
                    if (ftype.equals("OceanTides")) {
                        json.accOceanTides = facc;
                    }
                    if (ftype.equals("SolarRadiationPressure")) {
                        json.accRadiationPressure = facc;
                    }
                    if (ftype.equals("ConstantThrustManeuver")) {
                        json.accThrust = facc;
                    }
                    if (!ftype.equals("ThirdBodyAttraction")) continue;
                    if (json.accThirdBodies == null) {
                        json.accThirdBodies = facc;
                        continue;
                    }
                    for (int ii = 0; ii < 3; ++ii) {
                        int n = ii;
                        json.accThirdBodies[n] = json.accThirdBodies[n] + facc[ii];
                    }
                }
            }
            if (this.simCfg.simMeasurements) {
                boolean added = false;
                for (Map.Entry<String, GroundStation> kv : this.simCfg.stations.entrySet()) {
                    GroundStation gst = kv.getValue();
                    Settings.Station jsn = this.simCfg.cfgStations.get(kv.getKey());
                    double[] azel = new AngularAzEl(gst, proptm, zeros, zeros, ones, obssat).estimate(0, 0, sta).getEstimatedValue();
                    if (this.simCfg.simSkipUnobservable && azel[1] <= 5.0E-6) continue;
                    Measurements.SimulatedMeasurement clone = new Measurements.SimulatedMeasurement(json);
                    clone.station = kv.getKey();
                    if (this.simCfg.simIncludeStationState) {
                        pvc = gst.getBaseFrame().getPVCoordinates(proptm, this.simCfg.propFrame);
                        pos = pvc.getPosition();
                        vel = pvc.getVelocity();
                        acc = pvc.getAcceleration();
                        clone.stationState = new double[]{pos.getX(), pos.getY(), pos.getZ(), vel.getX(), vel.getY(), vel.getZ(), acc.getX(), acc.getY(), acc.getZ()};
                    }
                    for (Map.Entry<String, Settings.Measurement> nvp : this.simCfg.cfgMeasurements.entrySet()) {
                        int i;
                        double[] obs;
                        String name = nvp.getKey();
                        Settings.Measurement val = nvp.getValue();
                        if (name.equalsIgnoreCase("Range")) {
                            obs = new Range(gst, val.twoWay, proptm, 0.0, 0.0, 1.0, obssat).estimate(0, 0, sta).getEstimatedValue();
                            clone.range = obs[0] + rand.nextGaussian() * val.error[0] + jsn.rangeBias;
                            continue;
                        }
                        if (name.equalsIgnoreCase("RangeRate")) {
                            obs = new RangeRate(gst, proptm, 0.0, 0.0, 1.0, val.twoWay, obssat).estimate(0, 0, sta).getEstimatedValue();
                            clone.rangeRate = obs[0] + rand.nextGaussian() * val.error[0] + jsn.rangeRateBias;
                            continue;
                        }
                        if (name.equalsIgnoreCase("RightAscension") || name.equalsIgnoreCase("Declination") && clone.rightAscension == 0.0) {
                            obs = new AngularRaDec(gst, this.simCfg.propFrame, proptm, zeros, zeros, ones, obssat).estimate(0, 0, sta).getEstimatedValue();
                            clone.rightAscension = obs[0] + rand.nextGaussian() * val.error[0] + jsn.rightAscensionBias;
                            clone.declination = obs[1] + rand.nextGaussian() * val.error[0] + jsn.declinationBias;
                            continue;
                        }
                        if (name.equalsIgnoreCase("Azimuth") || name.equalsIgnoreCase("Elevation") && clone.azimuth == 0.0) {
                            clone.azimuth = azel[0] + rand.nextGaussian() * val.error[0] + jsn.azimuthBias;
                            clone.elevation = azel[1] + rand.nextGaussian() * val.error[0] + jsn.elevationBias;
                            continue;
                        }
                        if (name.equalsIgnoreCase("Position")) {
                            clone.position = new double[3];
                            for (i = 0; i < 3; ++i) {
                                clone.position[i] = clone.trueState.cartesian[i] + rand.nextGaussian() * val.error[i] + jsn.positionBias[i];
                            }
                            continue;
                        }
                        if (!name.equalsIgnoreCase("PositionVelocity")) continue;
                        clone.positionVelocity = new double[6];
                        for (i = 0; i < 6; ++i) {
                            clone.positionVelocity[i] = clone.trueState.cartesian[i] + rand.nextGaussian() * val.error[i] + jsn.positionVelocityBias[i];
                        }
                    }
                    added = true;
                    mall.add(clone);
                }
                if (!added) {
                    mall.add(json);
                }
            } else {
                mall.add(json);
            }
            dt = prend.durationFrom(proptm);
            if (evthandlers && !proptm.equals(tm)) break;
            if (this.simCfg.propStep >= 0.0) {
                tm = new AbsoluteDate(tm, FastMath.min(dt, this.simCfg.propStep));
                continue;
            }
            tm = new AbsoluteDate(tm, FastMath.max(dt, this.simCfg.propStep));
            dt = -dt;
        } while (!(dt <= 0.0));
        return mall;
    }
}

