/*
 * Decompiled with CFR 0.152.
 */
package org.astria;

import java.util.ArrayList;
import org.astria.DataManager;
import org.astria.Measurements;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.estimation.iod.IodGooding;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.files.ccsds.TDMFile;
import org.orekit.files.ccsds.TDMParser;
import org.orekit.frames.TopocentricFrame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.time.AbsoluteDate;

public final class Utilities {
    public static KeplerianOrbit iodGooding(double[] gslat, double[] gslon, double[] gsalt, String frame, String[] tmstr, double[] ra, double[] dec, double rho1init, double rho3init) {
        Vector3D[] los = new Vector3D[3];
        Vector3D[] gspos = new Vector3D[3];
        AbsoluteDate[] time = new AbsoluteDate[3];
        OneAxisEllipsoid oae = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, DataManager.getFrame("ITRF"));
        for (int i = 0; i < 3; ++i) {
            los[i] = new Vector3D(FastMath.cos(dec[i]) * FastMath.cos(ra[i]), FastMath.cos(dec[i]) * FastMath.sin(ra[i]), FastMath.sin(dec[i]));
            time[i] = DataManager.parseDateTime(tmstr[i]);
            GroundStation sta = new GroundStation(new TopocentricFrame(oae, new GeodeticPoint(gslat[i], gslon[i], gsalt[i]), Integer.toString(i)));
            gspos[i] = sta.getBaseFrame().getPVCoordinates(time[i], DataManager.getFrame(frame)).getPosition();
        }
        IodGooding good = new IodGooding(DataManager.getFrame(frame), 3.986004415E14);
        KeplerianOrbit orb = good.estimate(gspos[0], gspos[1], gspos[2], los[0], time[0], los[1], time[1], los[2], time[2], rho1init, rho3init);
        return orb;
    }

    public static ArrayList<ArrayList<Measurements.SimulatedMeasurement>> importTDM(String file_name, String file_format) {
        Measurements.SimulatedMeasurement obj = null;
        ArrayList<ArrayList<Measurements.SimulatedMeasurement>> output = new ArrayList<ArrayList<Measurements.SimulatedMeasurement>>();
        TDMFile tdm = new TDMParser().withFileFormat(TDMParser.TDMFileFormat.valueOf(file_format)).parse(file_name);
        for (TDMFile.ObservationsBlock blk : tdm.getObservationsBlocks()) {
            int i = 0;
            String atype = blk.getMetaData().getAngleType();
            ArrayList<Measurements.SimulatedMeasurement> mall = new ArrayList<Measurements.SimulatedMeasurement>();
            for (TDMFile.Observation obs : blk.getObservations()) {
                String keyw = obs.getKeyword();
                if (!keyw.equalsIgnoreCase("RANGE") && !keyw.equalsIgnoreCase("DOPPLER_INSTANTANEOUS") && !keyw.equalsIgnoreCase("ANGLE_1") && !keyw.equalsIgnoreCase("ANGLE_2")) continue;
                if (i == 0) {
                    obj = new Measurements.SimulatedMeasurement();
                }
                if (atype == null) {
                    if (keyw.equalsIgnoreCase("RANGE")) {
                        obj.range = obs.getMeasurement() * 1000.0;
                    } else if (keyw.equalsIgnoreCase("DOPPLER_INSTANTANEOUS")) {
                        obj.rangeRate = obs.getMeasurement() * 1000.0;
                    }
                } else if (atype.equalsIgnoreCase("RADEC")) {
                    if (keyw.equalsIgnoreCase("ANGLE_1")) {
                        obj.rightAscension = obs.getMeasurement() * Math.PI / 180.0;
                    } else if (keyw.equalsIgnoreCase("ANGLE_2")) {
                        obj.declination = obs.getMeasurement() * Math.PI / 180.0;
                    }
                } else if (atype.equalsIgnoreCase("AZEL")) {
                    if (keyw.equalsIgnoreCase("ANGLE_1")) {
                        obj.azimuth = obs.getMeasurement() * Math.PI / 180.0;
                    } else if (keyw.equalsIgnoreCase("ANGLE_2")) {
                        obj.elevation = obs.getMeasurement() * Math.PI / 180.0;
                    }
                }
                if (++i != 2) continue;
                i = 0;
                obj.time = DataManager.getUTCString(obs.getEpoch());
                mall.add(obj);
            }
            output.add(mall);
        }
        return output;
    }
}

