/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.astria.Conversion;
import org.astria.rpc.ConversionGrpc;
import org.astria.rpc.Messages;
import org.astria.rpc.Tools;

public final class ConversionService
extends ConversionGrpc.ConversionImplBase {
    @Override
    public void transformFrame(Messages.TransformFrameInput req, StreamObserver<Messages.DoubleArray> resp) {
        try {
            double[] pva = Conversion.transformFrame(req.getSrcFrame(), req.getTime(), req.getPvaList(), req.getDestFrame());
            Messages.DoubleArray.Builder builder = Messages.DoubleArray.newBuilder();
            for (int i = 0; i < pva.length; ++i) {
                builder = builder.addArray(pva[i]);
            }
            resp.onNext(builder.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }
}

