/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.astria.Estimation;
import org.astria.Measurements;
import org.astria.Settings;
import org.astria.rpc.EstimationGrpc;
import org.astria.rpc.Messages;
import org.astria.rpc.Tools;

public final class EstimationService
extends EstimationGrpc.EstimationImplBase {
    @Override
    public void determineOrbit(Messages.DetermineOrbitInput req, StreamObserver<Messages.EstimationOutputArray> resp) {
        try {
            Settings odCfg = Tools.buildSettingsFromRequest(req.getConfig());
            Measurements odObs = Tools.buildMeasurementsFromRequest(req.getMeasurementsList(), odCfg);
            ArrayList<Estimation.EstimationOutput> estOut = new Estimation(odCfg, odObs).determineOrbit();
            Messages.EstimationOutputArray.Builder builder = Messages.EstimationOutputArray.newBuilder().addAllArray(Tools.buildResponseFromOrbitDetermination(estOut));
            resp.onNext(builder.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }
}

