/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.astria.ParallelPropagation;
import org.astria.Settings;
import org.astria.rpc.Messages;
import org.astria.rpc.PropagationGrpc;
import org.astria.rpc.Tools;

public final class PropagationService
extends PropagationGrpc.PropagationImplBase {
    @Override
    public void propagate(Messages.SettingsArray req, StreamObserver<Messages.PropagationOutputArray> resp) {
        try {
            ArrayList<Settings> cfgObjs = new ArrayList<Settings>(req.getArrayCount());
            for (int i = 0; i < req.getArrayCount(); ++i) {
                cfgObjs.add(Tools.buildSettingsFromRequest(req.getArray(i)));
            }
            ArrayList<ParallelPropagation.PropagationOutput> propOut = new ParallelPropagation(cfgObjs).propagate();
            Messages.PropagationOutputArray.Builder builder = Messages.PropagationOutputArray.newBuilder().addAllArray(Tools.buildResponseFromPropagation(propOut));
            resp.onNext(builder.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }
}

