/*
 * Decompiled with CFR 0.152.
 */
package org.astria.rpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.astria.Measurements;
import org.astria.Utilities;
import org.astria.rpc.Messages;
import org.astria.rpc.Tools;
import org.astria.rpc.UtilitiesGrpc;

public final class UtilitiesService
extends UtilitiesGrpc.UtilitiesImplBase {
    @Override
    public void importTDM(Messages.ImportTDMInput req, StreamObserver<Messages.Measurement2DArray> resp) {
        try {
            ArrayList<ArrayList<Measurements.SimulatedMeasurement>> mlist = Utilities.importTDM(req.getFileName(), req.getFileFormat());
            Messages.Measurement2DArray.Builder builder = Messages.Measurement2DArray.newBuilder();
            for (ArrayList<Measurements.SimulatedMeasurement> m : mlist) {
                Messages.MeasurementArray.Builder nested = Messages.MeasurementArray.newBuilder();
                nested.addAllArray(Tools.buildResponseFromMeasurements(m));
                builder = builder.addArray(nested);
            }
            resp.onNext(builder.build());
            resp.onCompleted();
        }
        catch (Throwable exc) {
            resp.onError(new StatusRuntimeException(Status.INTERNAL.withDescription(Tools.getStackTrace(exc))));
        }
    }
}

