/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.function;

import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class Logit
implements UnivariateDifferentiableFunction {
    private final double lo;
    private final double hi;

    public Logit() {
        this(0.0, 1.0);
    }

    public Logit(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public double value(double x) throws MathIllegalArgumentException {
        return Logit.value(x, this.lo, this.hi);
    }

    private static double value(double x, double lo, double hi) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(x, lo, hi);
        return FastMath.log((x - lo) / (hi - x));
    }

    @Override
    public DerivativeStructure value(DerivativeStructure t) throws MathIllegalArgumentException {
        double x = t.getValue();
        MathUtils.checkRangeInclusive(x, this.lo, this.hi);
        double[] f = new double[t.getOrder() + 1];
        f[0] = FastMath.log((x - this.lo) / (this.hi - x));
        if (Double.isInfinite(f[0])) {
            if (f.length > 1) {
                f[1] = Double.POSITIVE_INFINITY;
            }
            for (int i = 2; i < f.length; ++i) {
                f[i] = f[i - 2];
            }
        } else {
            double invH;
            double invL;
            double xL = invL = 1.0 / (x - this.lo);
            double xH = invH = 1.0 / (this.hi - x);
            for (int i = 1; i < f.length; ++i) {
                f[i] = xL + xH;
                xL *= (double)(-i) * invL;
                xH *= (double)i * invH;
            }
        }
        return t.compose(f);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            return Logit.value(x, param[0], param[1]);
        }

        @Override
        public double[] gradient(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            double lo = param[0];
            double hi = param[1];
            return new double[]{1.0 / (lo - x), 1.0 / (hi - x)};
        }

        private void validateParameters(double[] param) throws MathIllegalArgumentException, NullArgumentException {
            MathUtils.checkNotNull(param);
            MathUtils.checkDimension(param.length, 2);
        }
    }
}

