/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathUtils;

public class ConstantRealDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double value;

    public ConstantRealDistribution(double value) {
        this.value = value;
    }

    @Override
    public double density(double x) {
        return x == this.value ? 1.0 : 0.0;
    }

    @Override
    public double cumulativeProbability(double x) {
        return x < this.value ? 0.0 : 1.0;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        return this.value;
    }

    @Override
    public double getNumericalMean() {
        return this.value;
    }

    @Override
    public double getNumericalVariance() {
        return 0.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.value;
    }

    @Override
    public double getSupportUpperBound() {
        return this.value;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

