/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.discrete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.distribution.EnumeratedDistribution;
import org.hipparchus.distribution.discrete.AbstractIntegerDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Pair;

public class EnumeratedIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20130308L;
    private final EnumeratedDistribution<Integer> innerDistribution;

    public EnumeratedIntegerDistribution(int[] singletons, double[] probabilities) throws MathIllegalArgumentException {
        this.innerDistribution = new EnumeratedDistribution(EnumeratedIntegerDistribution.createDistribution(singletons, probabilities));
    }

    public EnumeratedIntegerDistribution(int[] data) {
        HashMap<Integer, Integer> dataMap = new HashMap<Integer, Integer>();
        for (int value : data) {
            Integer count = (Integer)dataMap.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            dataMap.put(value, count);
        }
        int massPoints = dataMap.size();
        double denom = data.length;
        int[] values = new int[massPoints];
        double[] probabilities = new double[massPoints];
        int index = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            values[index] = (Integer)entry.getKey();
            probabilities[index] = (double)((Integer)entry.getValue()).intValue() / denom;
            ++index;
        }
        this.innerDistribution = new EnumeratedDistribution(EnumeratedIntegerDistribution.createDistribution(values, probabilities));
    }

    private static List<Pair<Integer, Double>> createDistribution(int[] singletons, double[] probabilities) {
        MathUtils.checkDimension(singletons.length, probabilities.length);
        ArrayList<Pair<Integer, Double>> samples = new ArrayList<Pair<Integer, Double>>(singletons.length);
        double[] normalizedProbabilities = EnumeratedDistribution.checkAndNormalize(probabilities);
        for (int i = 0; i < singletons.length; ++i) {
            samples.add(new Pair<Integer, Double>(singletons[i], normalizedProbabilities[i]));
        }
        return samples;
    }

    @Override
    public double probability(int x) {
        return this.innerDistribution.probability(x);
    }

    @Override
    public double cumulativeProbability(int x) {
        double probability = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getKey() > x) continue;
            probability += sample.getValue().doubleValue();
        }
        return probability;
    }

    @Override
    public double getNumericalMean() {
        double mean = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            mean += sample.getValue() * (double)sample.getKey().intValue();
        }
        return mean;
    }

    @Override
    public double getNumericalVariance() {
        double mean = 0.0;
        double meanOfSquares = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            mean += sample.getValue() * (double)sample.getKey().intValue();
            meanOfSquares += sample.getValue() * (double)sample.getKey().intValue() * (double)sample.getKey().intValue();
        }
        return meanOfSquares - mean * mean;
    }

    @Override
    public int getSupportLowerBound() {
        int min = Integer.MAX_VALUE;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getKey() >= min || !(sample.getValue() > 0.0)) continue;
            min = sample.getKey();
        }
        return min;
    }

    @Override
    public int getSupportUpperBound() {
        int max = Integer.MIN_VALUE;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getKey() <= max || !(sample.getValue() > 0.0)) continue;
            max = sample.getKey();
        }
        return max;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    public List<Pair<Integer, Double>> getPmf() {
        return this.innerDistribution.getPmf();
    }
}

