/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.filtering.kalman.linear;

import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.AbstractKalmanFilter;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.linear.LinearEvolution;
import org.hipparchus.filtering.kalman.linear.LinearProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;

public class LinearKalmanFilter<T extends Measurement>
extends AbstractKalmanFilter<T> {
    private final LinearProcess<T> process;

    public LinearKalmanFilter(MatrixDecomposer decomposer, LinearProcess<T> process, ProcessEstimate initialState) {
        super(decomposer, initialState);
        this.process = process;
    }

    @Override
    public ProcessEstimate estimationStep(T measurement) throws MathRuntimeException {
        LinearEvolution evolution = this.process.getEvolution(measurement);
        RealMatrix a = evolution.getStateTransitionMatrix();
        RealMatrix b = evolution.getControlMatrix();
        RealVector u = b == null ? null : evolution.getCommand();
        RealMatrix q = evolution.getProcessNoiseMatrix();
        RealVector predXk = a.operate(this.getCorrected().getState());
        if (b != null) {
            predXk = predXk.add(b.operate(u));
        }
        this.predict(measurement.getTime(), predXk, a, q);
        RealMatrix h = evolution.getMeasurementJacobian();
        RealMatrix s = this.computeInnovationCovarianceMatrix(measurement.getCovariance(), h);
        RealVector innovation = h == null ? null : measurement.getValue().subtract(h.operate(predXk));
        this.correct(measurement, a, innovation, h, s);
        return this.getCorrected();
    }
}

