/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod.hull;

import java.util.Collection;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.euclidean.twod.hull.ConvexHull2D;
import org.hipparchus.geometry.euclidean.twod.hull.ConvexHullGenerator2D;
import org.hipparchus.util.MathUtils;

abstract class AbstractConvexHullGenerator2D
implements ConvexHullGenerator2D {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private final double tolerance;
    private final boolean includeCollinearPoints;

    protected AbstractConvexHullGenerator2D(boolean includeCollinearPoints) {
        this(includeCollinearPoints, 1.0E-10);
    }

    protected AbstractConvexHullGenerator2D(boolean includeCollinearPoints, double tolerance) {
        this.includeCollinearPoints = includeCollinearPoints;
        this.tolerance = tolerance;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public boolean isIncludeCollinearPoints() {
        return this.includeCollinearPoints;
    }

    @Override
    public ConvexHull2D generate(Collection<Vector2D> points) throws MathIllegalStateException {
        MathUtils.checkNotNull(points);
        Collection<Vector2D> hullVertices = null;
        hullVertices = points.size() < 2 ? points : this.findHullVertices(points);
        try {
            return new ConvexHull2D(hullVertices.toArray(new Vector2D[0]), this.tolerance);
        }
        catch (MathIllegalArgumentException e) {
            throw new MathIllegalStateException(e, LocalizedCoreFormats.CONVERGENCE_FAILED, new Object[0]);
        }
    }

    protected abstract Collection<Vector2D> findHullVertices(Collection<Vector2D> var1);
}

