/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.TreeSet;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.ComplexComparator;
import org.hipparchus.linear.EigenDecomposition;
import org.hipparchus.linear.RealMatrix;

public class OrderedEigenDecomposition
extends EigenDecomposition {
    public OrderedEigenDecomposition(RealMatrix matrix) {
        super(matrix);
        int ij;
        RealMatrix D = this.getD();
        RealMatrix V = this.getV();
        TreeSet<Complex> eigenValues = new TreeSet<Complex>(new ComplexComparator());
        for (ij = 0; ij < matrix.getRowDimension(); ++ij) {
            eigenValues.add(new Complex(this.getRealEigenvalue(ij), this.getImagEigenvalue(ij)));
        }
        for (ij = 0; ij < matrix.getRowDimension() - 1; ++ij) {
            Complex eigValue = eigenValues.pollFirst();
            int currentIndex = -1;
            for (currentIndex = ij; currentIndex < matrix.getRowDimension(); ++currentIndex) {
                Complex compCurrent = null;
                compCurrent = currentIndex == 0 ? new Complex(D.getEntry(currentIndex, currentIndex), D.getEntry(currentIndex + 1, currentIndex)) : (currentIndex + 1 == matrix.getRowDimension() ? new Complex(D.getEntry(currentIndex, currentIndex), D.getEntry(currentIndex - 1, currentIndex)) : (D.getEntry(currentIndex - 1, currentIndex) != 0.0 ? new Complex(D.getEntry(currentIndex, currentIndex), D.getEntry(currentIndex - 1, currentIndex)) : new Complex(D.getEntry(currentIndex, currentIndex), D.getEntry(currentIndex + 1, currentIndex))));
                if (eigValue.equals(compCurrent)) break;
            }
            if (ij == currentIndex) continue;
            Complex previousValue = null;
            previousValue = ij == 0 ? new Complex(D.getEntry(ij, ij), D.getEntry(ij + 1, ij)) : (ij + 1 == matrix.getRowDimension() ? new Complex(D.getEntry(ij, ij), D.getEntry(ij - 1, ij)) : (D.getEntry(ij - 1, ij) != 0.0 ? new Complex(D.getEntry(ij, ij), D.getEntry(ij - 1, ij)) : new Complex(D.getEntry(ij, ij), D.getEntry(ij + 1, ij))));
            D.setEntry(ij, ij, eigValue.getReal());
            if (ij == 0) {
                D.setEntry(ij + 1, ij, eigValue.getImaginary());
            } else if (ij + 1 == matrix.getRowDimension()) {
                D.setEntry(ij - 1, ij, eigValue.getImaginary());
            } else if (eigValue.getImaginary() > 0.0) {
                D.setEntry(ij - 1, ij, eigValue.getImaginary());
                D.setEntry(ij + 1, ij, 0.0);
            } else {
                D.setEntry(ij + 1, ij, eigValue.getImaginary());
                D.setEntry(ij - 1, ij, 0.0);
            }
            D.setEntry(currentIndex, currentIndex, previousValue.getReal());
            if (currentIndex == 0) {
                D.setEntry(currentIndex + 1, currentIndex, previousValue.getImaginary());
            } else if (currentIndex + 1 == matrix.getRowDimension()) {
                D.setEntry(currentIndex - 1, currentIndex, previousValue.getImaginary());
            } else if (previousValue.getImaginary() > 0.0) {
                D.setEntry(currentIndex - 1, currentIndex, previousValue.getImaginary());
                D.setEntry(currentIndex + 1, currentIndex, 0.0);
            } else {
                D.setEntry(currentIndex + 1, currentIndex, previousValue.getImaginary());
                D.setEntry(currentIndex - 1, currentIndex, 0.0);
            }
            double[] previousColumnV = V.getColumn(ij);
            V.setColumn(ij, V.getColumn(currentIndex));
            V.setColumn(currentIndex, previousColumnV);
        }
    }

    @Override
    public RealMatrix getVT() {
        return this.getV().transpose();
    }
}

