/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;

public class QRDecomposer
implements MatrixDecomposer {
    private final double singularityThreshold;

    public QRDecomposer(double singularityThreshold) {
        this.singularityThreshold = singularityThreshold;
    }

    @Override
    public DecompositionSolver decompose(RealMatrix a) {
        return new QRDecomposition(a, this.singularityThreshold).getSolver();
    }
}

