/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;

public class FieldODEState<T extends RealFieldElement<T>> {
    private final T time;
    private final T[] primaryState;
    private final T[][] secondaryState;
    private final int completeDimension;

    public FieldODEState(T time, T[] primaryState) {
        this((RealFieldElement)time, (RealFieldElement[])primaryState, null);
    }

    public FieldODEState(T time, T[] primaryState, T[][] secondaryState) {
        this.time = time;
        this.primaryState = (RealFieldElement[])primaryState.clone();
        this.secondaryState = this.copy((RealFieldElement[][])secondaryState);
        int dimension = primaryState.length;
        if (secondaryState != null) {
            for (T[] secondary : secondaryState) {
                dimension += secondary.length;
            }
        }
        this.completeDimension = dimension;
    }

    protected T[][] copy(T[][] original) {
        if (original == null) {
            return null;
        }
        RealFieldElement[][] copied = (RealFieldElement[][])MathArrays.buildArray(this.time.getField(), original.length, -1);
        for (int i = 0; i < original.length; ++i) {
            copied[i] = (RealFieldElement[])original[i].clone();
        }
        return copied;
    }

    public T getTime() {
        return this.time;
    }

    @Deprecated
    public int getStateDimension() {
        return this.getPrimaryStateDimension();
    }

    public int getPrimaryStateDimension() {
        return this.primaryState.length;
    }

    @Deprecated
    public T[] getState() {
        return this.getPrimaryState();
    }

    public T[] getPrimaryState() {
        return (RealFieldElement[])this.primaryState.clone();
    }

    public int getNumberOfSecondaryStates() {
        return this.secondaryState == null ? 0 : this.secondaryState.length;
    }

    public int getSecondaryStateDimension(int index) {
        return index == 0 ? this.primaryState.length : this.secondaryState[index - 1].length;
    }

    public T[] getSecondaryState(int index) {
        return index == 0 ? (RealFieldElement[])this.primaryState.clone() : (RealFieldElement[])this.secondaryState[index - 1].clone();
    }

    public int getCompleteStateDimension() {
        return this.completeDimension;
    }

    public T[] getCompleteState() {
        RealFieldElement[] completeState = (RealFieldElement[])MathArrays.buildArray(this.time.getField(), this.getCompleteStateDimension());
        System.arraycopy(this.primaryState, 0, completeState, 0, this.primaryState.length);
        int offset = this.primaryState.length;
        if (this.secondaryState != null) {
            for (int index = 0; index < this.secondaryState.length; ++index) {
                System.arraycopy(this.secondaryState[index], 0, completeState, offset, this.secondaryState[index].length);
                offset += this.secondaryState[index].length;
            }
        }
        return completeState;
    }
}

