/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.SecondOrderODE;

public class FirstOrderConverter
implements OrdinaryDifferentialEquation {
    private final SecondOrderODE equations;
    private final int dimension;

    public FirstOrderConverter(SecondOrderODE equations) {
        this.equations = equations;
        this.dimension = equations.getDimension();
    }

    @Override
    public int getDimension() {
        return 2 * this.dimension;
    }

    @Override
    public double[] computeDerivatives(double t, double[] y) {
        double[] yDot = new double[y.length];
        double[] z = new double[this.dimension];
        double[] zDot = new double[this.dimension];
        System.arraycopy(y, 0, z, 0, this.dimension);
        System.arraycopy(y, this.dimension, zDot, 0, this.dimension);
        double[] zDDot = this.equations.computeSecondDerivatives(t, z, zDot);
        System.arraycopy(zDot, 0, yDot, 0, this.dimension);
        System.arraycopy(zDDot, 0, yDot, this.dimension, this.dimension);
        return yDot;
    }
}

