/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.util.FastMath;

public abstract class AdaptiveStepsizeIntegrator
extends AbstractIntegrator {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private double initialStep;
    private double minStep;
    private double maxStep;

    public AdaptiveStepsizeIntegrator(String name, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(name);
        this.setStepSizeControl(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.resetInternalState();
    }

    public AdaptiveStepsizeIntegrator(String name, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name);
        this.setStepSizeControl(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.resetInternalState();
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double absoluteTolerance, double relativeTolerance) {
        this.minStep = FastMath.abs(minimalStep);
        this.maxStep = FastMath.abs(maximalStep);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = absoluteTolerance;
        this.scalRelativeTolerance = relativeTolerance;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double[] absoluteTolerance, double[] relativeTolerance) {
        this.minStep = FastMath.abs(minimalStep);
        this.maxStep = FastMath.abs(maximalStep);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])absoluteTolerance.clone();
        this.vecRelativeTolerance = (double[])relativeTolerance.clone();
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStep = initialStepSize < this.minStep || initialStepSize > this.maxStep ? -1.0 : initialStepSize;
    }

    @Override
    protected void sanityChecks(ODEState initialState, double t) throws MathIllegalArgumentException {
        super.sanityChecks(initialState, t);
        this.mainSetDimension = initialState.getPrimaryStateDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public double initializeStep(boolean forward, int order, double[] scale, ODEStateAndDerivative state0, EquationsMapper mapper) throws MathIllegalArgumentException, MathIllegalStateException {
        double h;
        if (this.initialStep > 0.0) {
            return forward ? this.initialStep : -this.initialStep;
        }
        double[] y0 = state0.getCompleteState();
        double[] yDot0 = state0.getCompleteDerivative();
        double yOnScale2 = 0.0;
        double yDotOnScale2 = 0.0;
        for (int j = 0; j < scale.length; ++j) {
            double ratio = y0[j] / scale[j];
            yOnScale2 += ratio * ratio;
            double ratioDot = yDot0[j] / scale[j];
            yDotOnScale2 += ratioDot * ratioDot;
        }
        double d = h = yOnScale2 < 1.0E-10 || yDotOnScale2 < 1.0E-10 ? 1.0E-6 : 0.01 * FastMath.sqrt(yOnScale2 / yDotOnScale2);
        if (!forward) {
            h = -h;
        }
        double[] y1 = new double[y0.length];
        for (int j = 0; j < y0.length; ++j) {
            y1[j] = y0[j] + h * yDot0[j];
        }
        double[] yDot1 = this.computeDerivatives(state0.getTime() + h, y1);
        double yDDotOnScale = 0.0;
        for (int j = 0; j < scale.length; ++j) {
            double ratioDotDot = (yDot1[j] - yDot0[j]) / scale[j];
            yDDotOnScale += ratioDotDot * ratioDotDot;
        }
        yDDotOnScale = FastMath.sqrt(yDDotOnScale) / h;
        double maxInv2 = FastMath.max(FastMath.sqrt(yDotOnScale2), yDDotOnScale);
        double h1 = maxInv2 < 1.0E-15 ? FastMath.max(1.0E-6, 0.001 * FastMath.abs(h)) : FastMath.pow(0.01 / maxInv2, 1.0 / (double)order);
        h = FastMath.min(100.0 * FastMath.abs(h), h1);
        if ((h = FastMath.max(h, 1.0E-12 * FastMath.abs(state0.getTime()))) < this.getMinStep()) {
            h = this.getMinStep();
        }
        if (h > this.getMaxStep()) {
            h = this.getMaxStep();
        }
        if (!forward) {
            h = -h;
        }
        return h;
    }

    protected double filterStep(double h, boolean forward, boolean acceptSmall) throws MathIllegalArgumentException {
        double filteredH = h;
        if (FastMath.abs(h) < this.minStep) {
            if (acceptSmall) {
                filteredH = forward ? this.minStep : -this.minStep;
            } else {
                throw new MathIllegalArgumentException(LocalizedODEFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, FastMath.abs(h), this.minStep, true);
            }
        }
        if (filteredH > this.maxStep) {
            filteredH = this.maxStep;
        } else if (filteredH < -this.maxStep) {
            filteredH = -this.maxStep;
        }
        return filteredH;
    }

    protected void resetInternalState() {
        this.setStepStart(null);
        this.setStepSize(FastMath.sqrt(this.minStep * this.maxStep));
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }
}

