/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import org.hipparchus.ode.nonstiff.FieldButcherArrayProvider;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public abstract class EmbeddedRungeKuttaFieldIntegrator<T extends RealFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T>
implements FieldButcherArrayProvider<T> {
    private final int fsal;
    private final T[] c;
    private final T[][] a;
    private final T[] b;
    private final T exp;
    private T safety;
    private T minReduction;
    private T maxGrowth;

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String name, int fsal, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.fsal = fsal;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = (RealFieldElement)((RealFieldElement)field.getOne()).divide(-this.getOrder());
        this.setSafety((RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((RealFieldElement)((RealFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
    }

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String name, int fsal, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.fsal = fsal;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = (RealFieldElement)((RealFieldElement)field.getOne()).divide(-this.getOrder());
        this.setSafety((RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((RealFieldElement)((RealFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
    }

    protected T fraction(int p, int q) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(p)).divide(q));
    }

    protected T fraction(double p, double q) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(p)).divide(q));
    }

    protected abstract RungeKuttaFieldStateInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    public abstract int getOrder();

    public T getSafety() {
        return this.safety;
    }

    public void setSafety(T safety) {
        this.safety = safety;
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = ((RealFieldElement)finalTime.subtract(initialState.getTime())).getReal() > 0.0;
        int stages = this.c.length + 1;
        RealFieldElement[][] yDotK = (RealFieldElement[][])MathArrays.buildArray(this.getField(), stages, -1);
        RealFieldElement[] yTmp = (RealFieldElement[])MathArrays.buildArray(this.getField(), equations.getMapper().getTotalDimension());
        RealFieldElement hNew = (RealFieldElement)this.getField().getZero();
        boolean firstTime = true;
        this.setIsLastStep(false);
        do {
            boolean filteredNextIsLast;
            RealFieldElement error = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)error.subtract(1.0)).getReal() >= 0.0) {
                RealFieldElement[] y = this.getStepStart().getCompleteState();
                yDotK[0] = this.getStepStart().getCompleteDerivative();
                if (firstTime) {
                    int i;
                    RealFieldElement[] scale = (RealFieldElement[])MathArrays.buildArray(this.getField(), this.mainSetDimension);
                    if (this.vecAbsoluteTolerance == null) {
                        for (i = 0; i < scale.length; ++i) {
                            scale[i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)y[i].abs()).multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance);
                        }
                    } else {
                        for (i = 0; i < scale.length; ++i) {
                            scale[i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)y[i].abs()).multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]);
                        }
                    }
                    hNew = this.initializeStep(forward, this.getOrder(), scale, this.getStepStart(), equations.getMapper());
                    firstTime = false;
                }
                this.setStepSize(hNew);
                if (forward) {
                    if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(finalTime)).getReal() >= 0.0) {
                        this.setStepSize((RealFieldElement)finalTime.subtract(this.getStepStart().getTime()));
                    }
                } else if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(finalTime)).getReal() <= 0.0) {
                    this.setStepSize((RealFieldElement)finalTime.subtract(this.getStepStart().getTime()));
                }
                for (int k = 1; k < stages; ++k) {
                    for (int j = 0; j < y.length; ++j) {
                        RealFieldElement sum = (RealFieldElement)yDotK[0][j].multiply(this.a[k - 1][0]);
                        for (int l = 1; l < k; ++l) {
                            sum = (RealFieldElement)sum.add(yDotK[l][j].multiply(this.a[k - 1][l]));
                        }
                        yTmp[j] = y[j].add(this.getStepSize().multiply((RealFieldElement)sum));
                    }
                    yDotK[k] = this.computeDerivatives((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize().multiply(this.c[k - 1])), yTmp);
                }
                for (int j = 0; j < y.length; ++j) {
                    RealFieldElement sum = (RealFieldElement)yDotK[0][j].multiply(this.b[0]);
                    for (int l = 1; l < stages; ++l) {
                        sum = (RealFieldElement)sum.add(yDotK[l][j].multiply(this.b[l]));
                    }
                    yTmp[j] = y[j].add(this.getStepSize().multiply((RealFieldElement)sum));
                }
                error = this.estimateError(yDotK, y, yTmp, (RealFieldElement)this.getStepSize());
                if (!(((RealFieldElement)error.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement factor = MathUtils.min(this.maxGrowth, MathUtils.max(this.minReduction, (RealFieldElement)this.safety.multiply(error.pow(this.exp))));
                hNew = this.filterStep(this.getStepSize().multiply((RealFieldElement)factor), forward, false);
            }
            RealFieldElement stepEnd = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            RealFieldElement[] yDotTmp = this.fsal >= 0 ? yDotK[this.fsal] : this.computeDerivatives(stepEnd, yTmp);
            FieldODEStateAndDerivative stateTmp = equations.getMapper().mapStateAndDerivative(stepEnd, yTmp, yDotTmp);
            this.setStepStart(this.acceptStep(this.createInterpolator(forward, yDotK, this.getStepStart(), stateTmp, equations.getMapper()), finalTime));
            if (this.isLastStep()) continue;
            RealFieldElement factor = MathUtils.min(this.maxGrowth, MathUtils.max(this.minReduction, (RealFieldElement)this.safety.multiply(error.pow(this.exp))));
            RealFieldElement scaledH = this.getStepSize().multiply((RealFieldElement)factor);
            RealFieldElement nextT = this.getStepStart().getTime().add((RealFieldElement)scaledH);
            boolean nextIsLast = forward ? ((RealFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : ((RealFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0;
            hNew = this.filterStep(scaledH, forward, nextIsLast);
            RealFieldElement filteredNextT = this.getStepStart().getTime().add((RealFieldElement)hNew);
            boolean bl = forward ? ((RealFieldElement)filteredNextT.subtract(finalTime)).getReal() >= 0.0 : (filteredNextIsLast = ((RealFieldElement)filteredNextT.subtract(finalTime)).getReal() <= 0.0);
            if (!filteredNextIsLast) continue;
            hNew = (RealFieldElement)finalTime.subtract(this.getStepStart().getTime());
        } while (!this.isLastStep());
        FieldODEStateAndDerivative finalState = this.getStepStart();
        this.resetInternalState();
        return finalState;
    }

    public T getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(T minReduction) {
        this.minReduction = minReduction;
    }

    public T getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(T maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    protected abstract T estimateError(T[][] var1, T[] var2, T[] var3, T var4);
}

