/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.optim.BaseMultivariateOptimizer;
import org.hipparchus.optim.InitialGuess;
import org.hipparchus.optim.MaxEval;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.random.RandomVectorGenerator;

public abstract class BaseMultiStartMultivariateOptimizer<P>
extends BaseMultivariateOptimizer<P> {
    private final BaseMultivariateOptimizer<P> optimizer;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private OptimizationData[] optimData;
    private int maxEvalIndex = -1;
    private int initialGuessIndex = -1;

    public BaseMultiStartMultivariateOptimizer(BaseMultivariateOptimizer<P> optimizer, int starts, RandomVectorGenerator generator) {
        super(optimizer.getConvergenceChecker());
        if (starts < 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, starts, 1);
        }
        this.optimizer = optimizer;
        this.starts = starts;
        this.generator = generator;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public abstract P[] getOptima();

    @Override
    public P optimize(OptimizationData ... optData) {
        this.optimData = (OptimizationData[])optData.clone();
        return super.optimize(optData);
    }

    @Override
    protected P doOptimize() {
        for (int i = 0; i < this.optimData.length; ++i) {
            if (this.optimData[i] instanceof MaxEval) {
                this.optimData[i] = null;
                this.maxEvalIndex = i;
            }
            if (!(this.optimData[i] instanceof InitialGuess)) continue;
            this.optimData[i] = null;
            this.initialGuessIndex = i;
        }
        if (this.maxEvalIndex == -1) {
            throw new MathIllegalStateException(LocalizedCoreFormats.ILLEGAL_STATE, new Object[0]);
        }
        if (this.initialGuessIndex == -1) {
            throw new MathIllegalStateException(LocalizedCoreFormats.ILLEGAL_STATE, new Object[0]);
        }
        RuntimeException lastException = null;
        this.totalEvaluations = 0;
        this.clear();
        int maxEval = this.getMaxEvaluations();
        double[] min = this.getLowerBound();
        double[] max = this.getUpperBound();
        double[] startPoint = this.getStartPoint();
        for (int i = 0; i < this.starts; ++i) {
            try {
                this.optimData[this.maxEvalIndex] = new MaxEval(maxEval - this.totalEvaluations);
                double[] s = null;
                if (i == 0) {
                    s = startPoint;
                } else {
                    int attempts = 0;
                    while (s == null) {
                        if (attempts >= this.getMaxEvaluations()) {
                            throw new MathIllegalStateException(LocalizedCoreFormats.MAX_COUNT_EXCEEDED, this.getMaxEvaluations());
                        }
                        s = this.generator.nextVector();
                        for (int k = 0; s != null && k < s.length; ++k) {
                            if (!(min != null && s[k] < min[k]) && (max == null || !(s[k] > max[k]))) continue;
                            s = null;
                        }
                        ++attempts;
                    }
                }
                this.optimData[this.initialGuessIndex] = new InitialGuess(s);
                P result = this.optimizer.optimize(this.optimData);
                this.store(result);
            }
            catch (RuntimeException mue) {
                lastException = mue;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        P[] optima = this.getOptima();
        if (optima.length == 0) {
            throw lastException;
        }
        return optima[0];
    }

    protected abstract void store(P var1);

    protected abstract void clear();
}

