/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.optim.BaseOptimizer;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.InitialGuess;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.SimpleBounds;

public abstract class BaseMultivariateOptimizer<P>
extends BaseOptimizer<P> {
    private double[] start;
    private double[] lowerBound;
    private double[] upperBound;

    protected BaseMultivariateOptimizer(ConvergenceChecker<P> checker) {
        super(checker);
    }

    @Override
    public P optimize(OptimizationData ... optData) {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof InitialGuess) {
                this.start = ((InitialGuess)data).getInitialGuess();
                continue;
            }
            if (!(data instanceof SimpleBounds)) continue;
            SimpleBounds bounds = (SimpleBounds)data;
            this.lowerBound = bounds.getLower();
            this.upperBound = bounds.getUpper();
        }
        this.checkParameters();
    }

    public double[] getStartPoint() {
        return this.start == null ? null : (double[])this.start.clone();
    }

    public double[] getLowerBound() {
        return this.lowerBound == null ? null : (double[])this.lowerBound.clone();
    }

    public double[] getUpperBound() {
        return this.upperBound == null ? null : (double[])this.upperBound.clone();
    }

    private void checkParameters() {
        if (this.start != null) {
            double v;
            int i;
            int dim = this.start.length;
            if (this.lowerBound != null) {
                if (this.lowerBound.length != dim) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, this.lowerBound.length, dim);
                }
                for (i = 0; i < dim; ++i) {
                    v = this.start[i];
                    double lo = this.lowerBound[i];
                    if (!(v < lo)) continue;
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, v, lo);
                }
            }
            if (this.upperBound != null) {
                if (this.upperBound.length != dim) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, this.upperBound.length, dim);
                }
                for (i = 0; i < dim; ++i) {
                    v = this.start[i];
                    double hi = this.upperBound[i];
                    if (!(v > hi)) continue;
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, v, hi);
                }
            }
        }
    }
}

