/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import java.util.Random;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.util.MathUtils;

public class RandomAdaptor
extends Random
implements RandomGenerator {
    private static final long serialVersionUID = 20160529L;
    private final RandomGenerator randomGenerator;

    public RandomAdaptor(RandomGenerator randomGenerator) {
        MathUtils.checkNotNull(randomGenerator);
        this.randomGenerator = randomGenerator;
    }

    public static Random of(RandomGenerator randomGenerator) {
        return new RandomAdaptor(randomGenerator);
    }

    @Override
    public boolean nextBoolean() {
        return this.randomGenerator.nextBoolean();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.randomGenerator.nextBytes(bytes);
    }

    @Override
    public void nextBytes(byte[] bytes, int offset, int len) {
        this.randomGenerator.nextBytes(bytes, offset, len);
    }

    @Override
    public double nextDouble() {
        return this.randomGenerator.nextDouble();
    }

    @Override
    public float nextFloat() {
        return this.randomGenerator.nextFloat();
    }

    @Override
    public double nextGaussian() {
        return this.randomGenerator.nextGaussian();
    }

    @Override
    public int nextInt() {
        return this.randomGenerator.nextInt();
    }

    @Override
    public int nextInt(int n) {
        return this.randomGenerator.nextInt(n);
    }

    @Override
    public long nextLong() {
        return this.randomGenerator.nextLong();
    }

    @Override
    public long nextLong(long n) {
        return this.randomGenerator.nextLong(n);
    }

    @Override
    public void setSeed(int seed) {
        if (this.randomGenerator != null) {
            this.randomGenerator.setSeed(seed);
        }
    }

    @Override
    public void setSeed(int[] seed) {
        if (this.randomGenerator != null) {
            this.randomGenerator.setSeed(seed);
        }
    }

    @Override
    public void setSeed(long seed) {
        if (this.randomGenerator != null) {
            this.randomGenerator.setSeed(seed);
        }
    }
}

