/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.function.DoubleConsumer;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.UnivariateStatistic;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public interface StorelessUnivariateStatistic
extends UnivariateStatistic,
DoubleConsumer {
    @Override
    default public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(values, begin, length)) {
            StorelessUnivariateStatistic stat = this.copy();
            stat.clear();
            stat.incrementAll(values, begin, length);
            return stat.getResult();
        }
        return Double.NaN;
    }

    public void increment(double var1);

    @Override
    default public void accept(double value) {
        this.increment(value);
    }

    default public void incrementAll(double[] values) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(values, LocalizedCoreFormats.INPUT_ARRAY, new Object[0]);
        this.incrementAll(values, 0, values.length);
    }

    default public void incrementAll(double[] values, int start, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(values, start, length)) {
            int k = start + length;
            for (int i = start; i < k; ++i) {
                this.increment(values[i]);
            }
        }
    }

    public double getResult();

    public long getN();

    public void clear();

    @Override
    public StorelessUnivariateStatistic copy();
}

