/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.ThirdMoment;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    protected final ThirdMoment moment;
    protected final boolean incMoment;

    public Skewness() {
        this.moment = new ThirdMoment();
        this.incMoment = true;
    }

    public Skewness(ThirdMoment m3) {
        this.moment = m3;
        this.incMoment = false;
    }

    public Skewness(Skewness original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.moment = original.moment.copy();
        this.incMoment = original.incMoment;
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public double getResult() {
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double variance = this.moment.m2 / (double)(this.moment.n - 1L);
        if (variance < 1.0E-19) {
            return 0.0;
        }
        double n0 = this.moment.getN();
        return n0 * this.moment.m3 / ((n0 - 1.0) * (n0 - 2.0) * FastMath.sqrt(variance) * variance);
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double skew = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length) && length > 2) {
            Mean mean = new Mean();
            double m = mean.evaluate(values, begin, length);
            double accum = 0.0;
            double accum2 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                double d = values[i] - m;
                accum += d * d;
                accum2 += d;
            }
            double variance = (accum - accum2 * accum2 / (double)length) / (double)(length - 1);
            double accum3 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                double d = values[i] - m;
                accum3 += d * d * d;
            }
            double n0 = length;
            skew = n0 / ((n0 - 1.0) * (n0 - 2.0)) * (accum3 /= variance * FastMath.sqrt(variance));
        }
        return skew;
    }

    @Override
    public Skewness copy() {
        return new Skewness(this);
    }
}

