/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Max
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<Max>,
Serializable {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public Max() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Max(Max original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.n = original.n;
        this.value = original.value;
    }

    @Override
    public void increment(double d) {
        if (d > this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void aggregate(Max other) {
        MathUtils.checkNotNull(other);
        if (other.n > 0L) {
            if (other.value > this.value || Double.isNaN(this.value)) {
                this.value = other.value;
            }
            this.n += other.n;
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double max = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length)) {
            max = values[begin];
            for (int i = begin; i < begin + length; ++i) {
                if (Double.isNaN(values[i])) continue;
                max = max > values[i] ? max : values[i];
            }
        }
        return max;
    }

    @Override
    public Max copy() {
        return new Max(this);
    }
}

